/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.EventObject;
import org.openide.TopManager;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.BrokenDataShadow;
import org.openide.loaders.DataShadow;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;

class ShadowChangeAdapter
implements RepositoryListener,
OperationListener {
    ShadowChangeAdapter() {
        TopManager.getDefault().getRepository().addRepositoryListener(this);
        TopManager.getDefault().getLoaderPool().addOperationListener(this);
    }

    static void checkBrokenDataShadows(EventObject eventObject) {
        BrokenDataShadow.checkValidity(eventObject);
    }

    static void checkDataShadows(EventObject eventObject) {
        DataShadow.checkValidity(eventObject);
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        ShadowChangeAdapter.checkBrokenDataShadows(repositoryEvent);
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        ShadowChangeAdapter.checkDataShadows(repositoryEvent);
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
    }

    public void operationPostCreate(OperationEvent operationEvent) {
        ShadowChangeAdapter.checkBrokenDataShadows(operationEvent);
    }

    public void operationCopy(OperationEvent.Copy copy) {
    }

    public void operationMove(OperationEvent.Move move) {
        ShadowChangeAdapter.checkDataShadows(move);
        ShadowChangeAdapter.checkBrokenDataShadows(move);
    }

    public void operationDelete(OperationEvent operationEvent) {
        ShadowChangeAdapter.checkDataShadows(operationEvent);
    }

    public void operationRename(OperationEvent.Rename rename) {
        ShadowChangeAdapter.checkDataShadows(rename);
        ShadowChangeAdapter.checkBrokenDataShadows(rename);
    }

    public void operationCreateShadow(OperationEvent.Copy copy) {
    }

    public void operationCreateFromTemplate(OperationEvent.Copy copy) {
        ShadowChangeAdapter.checkBrokenDataShadows(copy);
    }
}

