/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.cookies.ArgumentsCookie;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.Executor;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class ProcessExecutor
extends Executor {
    static final long serialVersionUID = 1440216248312461457L;
    protected NbProcessDescriptor externalExecutor;
    private NbClassPath classPath;
    private NbClassPath bootClassPath;
    private String[] envp = null;
    private boolean addEnvs = false;
    private File cwd = null;
    static /* synthetic */ Class class$org$openide$execution$ProcessExecutor;

    public synchronized void setExternalExecutor(NbProcessDescriptor nbProcessDescriptor) {
        NbProcessDescriptor nbProcessDescriptor2 = this.externalExecutor;
        this.externalExecutor = nbProcessDescriptor;
        this.firePropertyChange("externalExecutor", nbProcessDescriptor2, nbProcessDescriptor);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$execution$ProcessExecutor == null ? (class$org$openide$execution$ProcessExecutor = ProcessExecutor.class$("org.openide.execution.ProcessExecutor")) : class$org$openide$execution$ProcessExecutor);
    }

    public synchronized NbProcessDescriptor getExternalExecutor() {
        if (this.externalExecutor == null) {
            this.externalExecutor = new NbProcessDescriptor("{java.home}{/}bin{/}java", "-cp {filesystems}{:}{classpath}{:}{library} {classname} {arguments}", NbBundle.getBundle(class$org$openide$execution$ProcessExecutor == null ? (class$org$openide$execution$ProcessExecutor = ProcessExecutor.class$("org.openide.execution.ProcessExecutor")) : class$org$openide$execution$ProcessExecutor).getString("MSG_ExecutorHint"));
        }
        return this.externalExecutor;
    }

    public NbClassPath getClassPath() {
        return this.classPath == null ? NbClassPath.createClassPath() : this.classPath;
    }

    public synchronized void setClassPath(NbClassPath nbClassPath) {
        NbClassPath nbClassPath2 = this.classPath;
        this.classPath = nbClassPath;
        this.firePropertyChange("classPath", nbClassPath2, nbClassPath);
    }

    public NbClassPath getBootClassPath() {
        return this.bootClassPath == null ? NbClassPath.createBootClassPath() : this.bootClassPath;
    }

    public synchronized void setBootClassPath(NbClassPath nbClassPath) {
        NbClassPath nbClassPath2 = this.bootClassPath;
        this.bootClassPath = nbClassPath;
        this.firePropertyChange("bootClassPath", nbClassPath2, nbClassPath);
    }

    public NbClassPath getRepositoryPath() {
        return NbClassPath.createRepositoryPath(FileSystemCapability.EXECUTE);
    }

    public NbClassPath getLibraryPath() {
        return NbClassPath.createLibraryPath();
    }

    public String[] getEnvironmentVariables() {
        return this.envp;
    }

    public synchronized void setEnvironmentVariables(String[] stringArray) {
        String[] stringArray2 = this.envp;
        this.envp = stringArray;
        this.firePropertyChange("environmentVariables", stringArray2, stringArray);
    }

    public boolean getAppendEnvironmentVariables() {
        return this.addEnvs;
    }

    public synchronized void setAppendEnvironmentVariables(boolean bl) {
        boolean bl2 = this.addEnvs;
        this.addEnvs = bl;
        this.firePropertyChange("appendEnvironmentVariables", new Boolean(bl2), new Boolean(bl));
    }

    public File getWorkingDirectory() {
        return this.cwd;
    }

    public synchronized void setWorkingDirectory(File file) {
        File file2 = this.cwd;
        this.cwd = file;
        this.firePropertyChange("workingDirectory", file2, file);
    }

    protected Process createProcess(ExecInfo execInfo) throws IOException {
        return this.getExternalExecutor().exec(new Format(execInfo, this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath()), this.envp, this.addEnvs, this.cwd);
    }

    private final Class getKlass(String string) {
        try {
            return Class.forName(string, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getLocalizedMessage());
        }
    }

    protected Process createProcess(DataObject dataObject) throws IOException {
        ArgumentsCookie argumentsCookie = (ArgumentsCookie)dataObject.getCookie(this.getKlass("org.openide.cookies.ArgumentsCookie"));
        String[] stringArray = argumentsCookie != null ? argumentsCookie.getArguments() : new String[]{};
        return this.createProcess(new ExecInfo(dataObject.getPrimaryFile().getPackageName('.'), stringArray));
    }

    public ExecutorTask execute(ExecInfo execInfo) throws IOException {
        PERunnable pERunnable = new PERunnable(execInfo);
        return this.handleExec(pERunnable, execInfo.getClassName());
    }

    public ExecutorTask execute(DataObject dataObject) throws IOException {
        PERunnable pERunnable = new PERunnable(dataObject);
        return this.handleExec(pERunnable, dataObject.getName());
    }

    private ExecutorTask handleExec(PERunnable pERunnable, String string) throws IOException {
        PERunnable pERunnable2 = pERunnable;
        synchronized (pERunnable2) {
            InputOutput inputOutput = this.needsIO() ? null : InputOutput.NULL;
            ExecutorTask executorTask = ExecutionEngine.getDefault().execute(string, pERunnable, inputOutput);
            pERunnable.setExecutorTask(executorTask);
            try {
                pERunnable.wait();
                Throwable throwable = pERunnable.getException();
                if (throwable != null) {
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    IOException iOException = new IOException(throwable.getMessage());
                    ErrorManager.getDefault().copyAnnotation(iOException, throwable);
                    throw iOException;
                }
                ExecutorTask executorTask2 = pERunnable.getExecutorTask();
                return executorTask2;
            }
            catch (InterruptedException interruptedException) {
                IOException iOException = new IOException(interruptedException.getMessage());
                ErrorManager.getDefault().copyAnnotation(iOException, interruptedException);
                throw iOException;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ExternalExecutorTask
    extends ExecutorTask {
        Process proc;
        Thread[] copyMakers;
        ExecutorTask foreign;

        ExternalExecutorTask(Runnable runnable, ExecutorTask executorTask, Process process, Thread[] threadArray) {
            super(runnable);
            this.proc = process;
            this.copyMakers = threadArray;
            this.foreign = executorTask;
            TaskListener taskListener = new TaskListener(this){
                private final /* synthetic */ ExternalExecutorTask this$0;
                {
                    this.this$0 = externalExecutorTask;
                }

                public void taskFinished(Task task) {
                    this.this$0.stop();
                }
            };
            executorTask.addTaskListener(taskListener);
            new Thread(this){
                private final /* synthetic */ ExternalExecutorTask this$0;
                {
                    this.this$0 = externalExecutorTask;
                }

                public void run() {
                    this.this$0.result();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                this.copyMakers[0].interrupt();
                this.copyMakers[1].interrupt();
                this.copyMakers[2].interrupt();
                Object var2_1 = null;
                this.proc.destroy();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.proc.destroy();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int result() {
            int n;
            try {
                try {
                    int n2 = this.proc.waitFor();
                    Thread.sleep(2000L);
                    n = n2;
                    Object var4_5 = null;
                    this.stop();
                }
                catch (InterruptedException interruptedException) {
                    int n3 = 1;
                    Object var4_6 = null;
                    this.stop();
                    this.notifyFinished();
                    return n3;
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.stop();
                this.notifyFinished();
                throw throwable;
            }
            this.notifyFinished();
            return n;
        }

        public InputOutput getInputOutput() {
            return this.foreign.getInputOutput();
        }

        public void run() {
        }
    }

    private static class CopyMaker
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        final String permName;
        private boolean done = false;

        CopyMaker(Reader reader, Writer writer, boolean bl, String string) {
            this.os = writer;
            this.is = reader;
            this.autoflush = bl;
            this.permName = string;
        }

        public void run() {
            char[] cArray = new char[256];
            try {
                int n;
                while ((n = this.read(this.is, cArray, 0, 256)) > 0) {
                    this.os.write(cArray, 0, n);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader reader, char[] cArray, int n, int n2) throws InterruptedException, IOException {
            if (Utilities.getOperatingSystem() != 1024) {
                while (!reader.ready() && !this.done) {
                    Thread.sleep(100L);
                }
            }
            return reader.read(cArray, n, n2);
        }
    }

    public static class Format
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_CLASSNAME = "classname";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        static final long serialVersionUID = 1105067849363827986L;

        public Format(ExecInfo execInfo) {
            this(execInfo, NbClassPath.createClassPath(), NbClassPath.createBootClassPath(), NbClassPath.createRepositoryPath(FileSystemCapability.EXECUTE), NbClassPath.createLibraryPath());
        }

        public Format(ExecInfo execInfo, NbClassPath nbClassPath, NbClassPath nbClassPath2, NbClassPath nbClassPath3, NbClassPath nbClassPath4) {
            super(new HashMap(7));
            Map map = this.getMap();
            map.put(TAG_CLASSPATH, nbClassPath.getClassPath());
            map.put(TAG_BOOTCLASSPATH, nbClassPath2.getClassPath());
            map.put(TAG_REPOSITORY, nbClassPath3.getClassPath());
            map.put(TAG_LIBRARY, nbClassPath4.getClassPath());
            map.put(TAG_CLASSNAME, execInfo.getClassName());
            map.put(TAG_JAVAHOME, System.getProperty(TAG_JAVAHOME));
            map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            map.put(TAG_SEPARATOR, File.separator);
            map.put(TAG_PATHSEPARATOR, File.pathSeparator);
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = execInfo.getArguments();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append('\"');
                stringBuffer.append(stringArray[n]);
                stringBuffer.append('\"');
                stringBuffer.append(' ');
                ++n;
            }
            map.put(TAG_ARGUMENTS, stringBuffer.toString());
        }
    }

    private class PERunnable
    implements Runnable,
    TaskListener {
        private DataObject obj;
        private ExecInfo info;
        private ExecutorTask fromEngine;
        ExecutorTask fromMe;
        private Throwable t;

        PERunnable(ExecInfo execInfo) {
            this.info = execInfo;
        }

        PERunnable(DataObject dataObject) {
            this.obj = dataObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                try {
                    Process process;
                    String string;
                    if (this.info != null) {
                        string = this.info.getClassName();
                        process = ProcessExecutor.this.createProcess(this.info);
                    } else {
                        string = this.obj.getName();
                        process = ProcessExecutor.this.createProcess(this.obj);
                    }
                    Thread[] threadArray = new Thread[3];
                    threadArray[0] = new CopyMaker(this.fromEngine.getInputOutput().getIn(), new OutputStreamWriter(process.getOutputStream()), true, string);
                    threadArray[0].start();
                    threadArray[1] = new CopyMaker(new InputStreamReader(process.getInputStream()), this.fromEngine.getInputOutput().getOut(), false, string);
                    threadArray[1].start();
                    threadArray[2] = new CopyMaker(new InputStreamReader(process.getErrorStream()), this.fromEngine.getInputOutput().getErr(), false, string);
                    threadArray[2].start();
                    this.fromMe = new ExternalExecutorTask(this, this.fromEngine, process, threadArray);
                }
                catch (Exception exception) {
                    this.t = exception;
                    Object var5_6 = null;
                    this.notifyAll();
                }
                Object var5_5 = null;
                this.notifyAll();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.notifyAll();
                throw throwable;
            }
        }

        public void setExecutorTask(ExecutorTask executorTask) {
            this.fromEngine = executorTask;
            executorTask.addTaskListener(this);
        }

        public ExecutorTask getExecutorTask() {
            return this.fromMe;
        }

        public Throwable getException() {
            return this.t;
        }

        public void taskFinished(Task task) {
            if (this.fromMe != null) {
                this.fromMe.stop();
            }
        }
    }
}

