/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class Row
implements BIFFRecord {
    private byte[] rw = new byte[2];
    private byte[] miyRw = new byte[2];
    private byte[] grbit = new byte[2];
    private byte[] ixfe = new byte[2];
    private float scale = 1.0f;

    public Row(int n, int n2, boolean bl) {
        this.rw = EndianConverter.writeShort((short)((short)n));
        n2 = (int)((float)n2 * this.scale);
        this.miyRw = EndianConverter.writeShort((short)((short)n2));
        this.grbit = bl ? EndianConverter.writeShort((short)2) : EndianConverter.writeShort((short)0);
        this.ixfe = EndianConverter.writeShort((short)0);
    }

    public Row(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public short getBiffType() {
        return 8;
    }

    public short getRowHeight() {
        return EndianConverter.readShort((byte[])this.miyRw);
    }

    public short getRowNumber() {
        return EndianConverter.readShort((byte[])this.rw);
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.rw);
        n += inputStream.read(this.miyRw);
        short s = (short)((float)EndianConverter.readShort((byte[])this.miyRw) / this.scale);
        this.miyRw = EndianConverter.writeShort((short)s);
        n += inputStream.read(this.grbit);
        Debug.log((int)4, (String)("\trw : " + EndianConverter.readShort((byte[])this.rw) + " miyRw : " + EndianConverter.readShort((byte[])this.miyRw) + " grbit : " + EndianConverter.readShort((byte[])this.grbit) + " ixfe : " + EndianConverter.readShort((byte[])this.ixfe)));
        return n += inputStream.read(this.ixfe);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.rw);
        outputStream.write(this.miyRw);
        outputStream.write(this.grbit);
        outputStream.write(this.ixfe);
        Debug.log((int)4, (String)"Writing Row record");
    }
}

