/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;

public class BoundSheet
implements BIFFRecord {
    private byte reserved;
    private byte cch;
    private byte[] sheetName;

    public BoundSheet(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public BoundSheet(String string) throws IOException {
        this.setSheetName(string);
        this.reserved = 0;
    }

    public short getBiffType() {
        return 133;
    }

    public String getSheetName() {
        String string;
        try {
            string = new String(this.sheetName, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "unknown";
        }
        return string;
    }

    public int read(InputStream inputStream) throws IOException {
        this.reserved = (byte)inputStream.read();
        this.cch = (byte)inputStream.read();
        int n = 2;
        int n2 = this.cch * 2;
        this.sheetName = new byte[n2];
        Debug.log((int)4, (String)("\tReserved : " + this.reserved + " cch : " + this.cch + " sheetName : " + new String(this.sheetName, "UTF-16LE")));
        return n += inputStream.read(this.sheetName, 0, n2);
    }

    void setSheetName(String string) throws IOException {
        this.cch = (byte)string.length();
        this.sheetName = new byte[this.cch * 2];
        this.sheetName = string.getBytes("UTF-16LE");
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.reserved);
        outputStream.write(this.cch);
        outputStream.write(this.sheetName);
        Debug.log((int)4, (String)"Writing BoundSheet record");
    }
}

