/*************************************************************************
 *
 *  $RCSfile: Factory.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dschulten $ $Date: 2002/10/22 08:37:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser cp General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package OfficeDev.samples.Filter;

import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.Type;

/*-************************************************************************
  @title        implements a filter to import pure ansi text files
  @description  This filter can use an existing In/OutputStream of given
                MediaDescriptor or use an existing URL instead of that
                to open the file directly. But for second case the local
                file system will be used only.
                There is no support for remote.
 ************************************************************************-*/

public class Factory extends WeakBase
                     implements com.sun.star.lang.XServiceInfo,
                                com.sun.star.lang.XSingleServiceFactory
{
    //______________________________
    // const
    private static final String SERVICENAME = "com.sun.star.comp.ansifilter.Factory";

    //______________________________
    // member
    private com.sun.star.lang.XMultiServiceFactory m_xSMGR;

    //______________________________
    // ctor
    /**
     * We need this sevice manager to be able to initialize
     * any new created filter instance (we are a factory!)
     * with this reference. Because may this filter need
     * it too, to create own services.
     */
    public Factory( com.sun.star.lang.XMultiServiceFactory xSMGR )
    {
        m_xSMGR = xSMGR;
    }

    //______________________________
    // interface XServiceInfo

    /**
     * This method returns an array of all supported service names.
     *
     * @return Array of supported service names.
     */
    public String[] getSupportedServiceNames()
    {
        String[] lNames = new String[1];
        lNames[0] = SERVICENAME;
        return lNames;
    }

    /**
     * This method returns true, if the given service will be
     * supported by this component.
     *
     * @param sService
     *  the requested service name
     *
     * @return True, if the given service name will be supported;
     *         False otherwhise.
     */
    public boolean supportsService( String sService )
    {
        return ( sService.equals( SERVICENAME ) );
    }

    /**
        * Return the real class name of the component
        *
        * @return Class name of the component.
        */
    public String getImplementationName()
    {
        return Factory.class.getName();
    }

    //______________________________
    // interface XSingleServiceFactory

    /**
     * We are invite to create a new filter instance.
     *
     * @return a valid filter object
     */
    public java.lang.Object createInstance() throws com.sun.star.uno.Exception
    {
        return createInstanceWithArguments( new Object[0] );
    }

    /**
     * We are invite to create a new filter instance.
     * And we must initialize it with given arguments too.
     *
     * @param lArguments
     *          list of optional arguments to initialize the new created filter
     *
     * @return a valid and right initialized filter object
     */
    public java.lang.Object createInstanceWithArguments( Object[] lArguments ) throws com.sun.star.uno.Exception
    {
        AsciiReplaceFilter aFilter = null;
        synchronized(this)
        {
            aFilter = new AsciiReplaceFilter(m_xSMGR);
        }
        com.sun.star.lang.XInitialization xInit = (com.sun.star.lang.XInitialization)UnoRuntime.queryInterface(
            com.sun.star.lang.XInitialization.class,
            aFilter);
        xInit.initialize(lArguments);
        return aFilter;
    }

    //______________________________
    // component helper

    /**
     * Gives a factory for creating the service.
     * This method is called by the <code>JavaLoader</code>
     *
     * @param sImplementationName
     *  The implementation name of the component.
     *
     * @param xSMGR
     *  The service manager, who gives access to every
     *  known service.
     *
     * @param xRegistryKey
     *  Makes structural information (except regarding tree
     *  structures) of a single registry key accessible.
     *
     * @return Returns a <code>XSingleServiceFactory</code> for
     *         creating the component.
     *
     * @see com.sun.star.comp.loader.JavaLoader
     */
    public static com.sun.star.lang.XSingleServiceFactory __getServiceFactory( String                                 sImplementationName ,
                                                                               com.sun.star.lang.XMultiServiceFactory xSMGR               ,
                                                                               com.sun.star.registry.XRegistryKey     xRegistryKey        )
    {
        com.sun.star.lang.XSingleServiceFactory xSingleFactory = null;
        if (sImplementationName.equals(AsciiReplaceFilter.class.getName()))
            xSingleFactory = new Factory(xSMGR);
        return xSingleFactory;
    }

    /**
     * Writes the service information into the given registry key.
     * This method is called by the <code>JavaLoader</code>.
     *
     * @param xRegistryKey
     *  Makes structural information (except regarding tree
     *  structures) of a single registry key accessible.
     *
     * @return returns true if the operation succeeded
     *
     * @see com.sun.star.comp.loader.JavaLoader
     */
    public static boolean __writeRegistryServiceInfo( com.sun.star.registry.XRegistryKey xRootKey )
    {
        boolean bRegistered = false;
        try
        {
            com.sun.star.registry.XRegistryKey xNewKey = xRootKey.createKey("/" + AsciiReplaceFilter.class.getName() + "/UNO/SERVICES");
            xNewKey.createKey(AsciiReplaceFilter.SERVICENAME_IMPORTFILTER);
            xNewKey.createKey(AsciiReplaceFilter.SERVICENAME_EXPORTFILTER);
            bRegistered = true;
  	    }
        catch (Exception ex)
        {
  	    }
        return bRegistered;
    }
}
