/*************************************************************************
 *
 *  $RCSfile: DocViewer.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dschulten $ $Date: 2002/10/25 12:37:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.File;

import com.sun.star.beans.LocalOfficeConnection;

public class DocViewer
{
	private Frame frame = null;
	private JTextField currentSelection = null;
	private OfficeWriter mOfficeWriter = null;

	private void initBean()
	{
		if (mOfficeWriter == null)
		{
			mOfficeWriter = new OfficeWriter();
			mOfficeWriter.setOfficeConnection(new LocalOfficeConnection());
			mOfficeWriter.addSelectionChangeListener(new DocViewerChangeListener());
			frame.add(mOfficeWriter, BorderLayout.CENTER);
		}
	}

	private void initUI()
	{
		frame = new Frame();
		frame.setLayout(new BorderLayout());

		JButton newDocButton = new JButton("New");
		newDocButton.setPreferredSize(new Dimension(100, 30));
		newDocButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				createDocument(evt);
			}
		});

		JButton loadDocButton = new JButton("Open");
		loadDocButton.setPreferredSize(new Dimension(100, 30));
		loadDocButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				loadDocument(evt);
			}
		});

		currentSelection = new JTextField();
		currentSelection.setPreferredSize(new Dimension(200, 30));
		currentSelection.setEditable(false);

		Panel p = new Panel();
		p.add(newDocButton);
		p.add(loadDocButton);
		p.add(currentSelection);

		frame.add(p, BorderLayout.SOUTH);
		frame.addWindowListener(new ExitListener());
		frame.setSize(500, 500);
		frame.show();
	}

	private void createDocument(ActionEvent evt)
	{
		initBean();

		try {
			mOfficeWriter.load(OfficeWriter.NEW_DOCUMENT);
		}
		catch (Exception e) {
			e.printStackTrace(System.err);
		}
		mOfficeWriter.setObjectBarVisible(false);
	}

	private JFileChooser fc = null;

	private void loadDocument(ActionEvent evt)
	{
		if (fc == null)
			fc = new JFileChooser();

		int returnVal = fc.showOpenDialog((Component)evt.getSource());
		if (returnVal == JFileChooser.APPROVE_OPTION)
		{
			initBean();

			File file = fc.getSelectedFile();

			try {
				if (file.exists())
					mOfficeWriter.load("file:///" + file.getAbsolutePath());
				else
					mOfficeWriter.load(OfficeWriter.NEW_DOCUMENT);
			}
			catch (Exception e) {
				e.printStackTrace(System.err);
			}
			mOfficeWriter.setObjectBarVisible(false);
		}
	}

	public static void main(String[] args)
	{
		DocViewer dv = new DocViewer();
		dv.initUI();
	}

	class ExitListener extends WindowAdapter
	{
		public void windowClosed(WindowEvent e)
		{
			if (mOfficeWriter != null)
				mOfficeWriter.closeConnection();
			System.exit(0);
		}

		public void windowClosing(WindowEvent e)
		{
			((Window)e.getSource()).dispose();
		}
	}

	class DocViewerChangeListener implements ChangeListener
	{
		public void stateChanged(ChangeEvent event)
		{
			String s = mOfficeWriter.getSelection();
			currentSelection.setText(s);
		}
	}
}
