// __________ Imports __________

// base classes
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;

// property access
import com.sun.star.beans.*;

// name access
import com.sun.star.container.*;

// text
import com.sun.star.text.*;
import com.sun.star.style.*;


// application specific classes
import com.sun.star.drawing.*;

// presentation specific classes
import com.sun.star.presentation.*;

// Point, Size, ..
import com.sun.star.awt.*;
import java.io.File;


// __________ Implementation __________

/** ChangeOrderDemo
    @author Sven Jacobi
 */

public class ChangeOrderDemo
{
    public static void main( String args[] )
    {
		XComponent xDrawDoc = null;
		try
		{
			String sConnection;
			if ( args.length >= 1 )
				sConnection = args[ 1 ];
			else
				sConnection = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
			XMultiServiceFactory xServiceFactory =
				Helper.connect( sConnection );

			// suppress Presentation Autopilot when opening the document
			// properties are the same as described for com.sun.star.document.MediaDescriptor
			PropertyValue[] pPropValues = new PropertyValue[ 1 ];
			pPropValues[ 0 ] = new PropertyValue();
			pPropValues[ 0 ].Name = "Silent";
			pPropValues[ 0 ].Value = new Boolean( true );

			xDrawDoc = Helper.createDocument( xServiceFactory,
				"private:factory/sdraw", "_blank", 0, pPropValues );

			// create two rectangles
			XDrawPage xPage = PageHelper.getDrawPageByIndex( xDrawDoc, 0 );
			XShapes xShapes = (XShapes)
					UnoRuntime.queryInterface( XShapes.class, xPage );

			XShape xShape1 = ShapeHelper.createShape( xDrawDoc,
				new Point( 1000, 1000 ), new Size( 5000, 5000 ),
					"com.sun.star.drawing.RectangleShape" );

			XShape xShape2 = ShapeHelper.createShape( xDrawDoc,
				new Point( 2000, 2000 ), new Size( 5000, 5000 ),
					"com.sun.star.drawing.EllipseShape" );
            
			xShapes.add( xShape1 );
			ShapeHelper.addPortion( xShape1, "     this shape was inserted first", false );
			ShapeHelper.addPortion( xShape1, "by changing the ZOrder it lie now on top", true );
			xShapes.add( xShape2 );
	
			XPropertySet xPropSet1 = (XPropertySet)
					UnoRuntime.queryInterface( XPropertySet.class, xShape1 );
			XPropertySet xPropSet2 = (XPropertySet)
					UnoRuntime.queryInterface( XPropertySet.class, xShape2 );

			int nOrderOfShape1 = ((Integer)xPropSet1.getPropertyValue( "ZOrder" )).intValue();
			int nOrderOfShape2 = ((Integer)xPropSet2.getPropertyValue( "ZOrder" )).intValue();
			
			xPropSet1.setPropertyValue( "ZOrder", new Integer( nOrderOfShape2 ) );
			xPropSet2.setPropertyValue( "ZOrder", new Integer( nOrderOfShape1 ) );
		}
		catch( Exception ex )
		{
            System.out.println( ex );
		}
		System.exit( 0 );
    }
}
