*** orig/dmake/tempnam.c	Sat Sep  9 18:36:53 2000
--- modified/dmake/tempnam.c	Sat Sep  9 18:36:53 2000
***************
*** 1,103 ****
! /* RCS  $Id: tempnam.c,v 1.1.1.1 1997/07/15 16:02:36 dvadura Exp $
! --
! -- SYNOPSIS
! --      tempnam
! --
! -- DESCRIPTION
! --      temp file name generation routines.
! --
! -- AUTHOR
! --      Dennis Vadura, dvadura@dmake.wticorp.com
! --
! -- WWW
! --      http://dmake.wticorp.com/
! --
! -- COPYRIGHT
! --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
! -- 
! --      This program is NOT free software; you can redistribute it and/or
! --      modify it under the terms of the Software License Agreement Provided
! --      in the file <distribution-root>/readme/license.txt.
! --
! -- LOG
! --      Use cvs log to obtain detailed change logs.
! */
! 
! /*LINTLIBRARY*/
  #include <stdio.h>
- #include <string.h>
  #include <stdlib.h>
  
! #define max(A,B) (((A)<(B))?(B):(A))
! 
! extern char *mktemp();
! extern int access();
! 
! static char *cpdir();
! static char  seed[4]="AAA";
! 
! /* BSD stdio.h doesn't define P_tmpdir, so let's do it here */
! #ifndef P_tmpdir
! static char *P_tmpdir = "/tmp";
  #endif
  
! char *
! tempnam(dir, prefix)
! const char *dir;		/* use this directory please (if non-NULL) */
! const char *prefix;		/* use this (if non-NULL) as filename prefix */
! {
!    register char *p, *q, *tmpdir;
!    int            tl=0, dl=0, pl;
! 
!    pl = strlen(P_tmpdir);
  
!    if( (tmpdir = getenv("TMPDIR")) != NULL ) tl = strlen(tmpdir);
!    if( dir != NULL ) dl = strlen(dir);
! 
!    if( (p = malloc((unsigned)(max(max(dl,tl),pl)+16))) == NULL )
!      return(NULL);
! 
!    *p = '\0';
! 
!    if( (tl == 0) || (access( cpdir(p, tmpdir), 3) != 0) )
!      if( (dl == 0) || (access( cpdir(p, dir), 3) != 0) )
! 	if( access( cpdir(p, P_tmpdir),   3) != 0 )
! 	   if( access( cpdir(p, "/tmp"),  3) != 0 )
! 	      return(NULL);
! 
!    (void) strcat(p, "/");
!    if(prefix)
!    {
!       *(p+strlen(p)+5) = '\0';
!       (void)strncat(p, prefix, 5);
!    }
  
!    (void)strcat(p, seed);
!    (void)strcat(p, "XXXXXX");
  
!    q = seed;
!    while(*q == 'Z') *q++ = 'A';
!    ++*q;
  
!    if(*mktemp(p) == '\0') return(NULL);
!    return(p);
  }
  
  
- 
- static char *
- cpdir(buf, str)
- char *buf;
- char *str;
- {
-    char *p;
- 
-    if(str != NULL)
-    {
-       (void) strcpy(buf, str);
-       p = buf - 1 + strlen(buf);
-       if(*p == '/') *p = '\0';
-    }
- 
-    return(buf);
- }
--- 1,137 ----
! #include <ctype.h>
! #include <fcntl.h>
! #include <sys/stat.h>
  #include <stdio.h>
  #include <stdlib.h>
  
! /**/
! #ifdef __IBMC__ 
! #define _O_CREAT	O_CREAT			
! #define _O_EXCL		O_EXCL			
! #define _S_IWRITE	S_IWRITE			
! #define _S_IREAD	S_IREAD			
  #endif
  
! #define DirEntryKind	int
! #define _MAX_PATH 1024
! #define WNT
  
! char* dtempnam( char* nix, char* prefix )
! {
! /*    char *ret_val;*/
!     size_t i;
  
! /*    // dertermine Directory, Prefix and Extension*/
!     char pfx[6] = "";
!     char ext[5] = "";
!     char dir[2000] = "";
! 	char sBuf[_MAX_PATH];
! 
! 	char ret_val[_MAX_PATH];
! 	static unsigned long u;
! 	unsigned long nOld;
! 	unsigned nTemp;
! 	FILE *pFile;
! 	int nhandle;
! 	char* pRet = 0L;
! 	int n = 0;
! 
! 	const int TempVarianten = 2;		
! 	char *TempPath[] = { "tmp", "temp" };
! 	
! /*    const char *dir;*/
! 
! /*    aDirName = GetFull();*/
!     strcpy( pfx, prefix );
! /*    strcpy( ext, ".tmp" );*/
!     if ( nix )
! 		strcpy( dir, nix );
! 
! /* wurde kein Dir angegeben, dann nehmen wir ein passendes TEMP-Verz. */
! 
! 
! /*    if ( eFlag == FSYS_FLAG_CURRENT || ( !pParent && pWild ) )*/
! /*        dir = TempDirImpl(sBuf);*/
! 	
! 	while ( dir[0] == '\0' && n < TempVarianten)
! 	{
! 		strcpy(dir, getenv(TempPath[n]));
! 		n++;
! 	}
! 	if ( dir[0] == '\0' )
! #if defined(UNX)
! 		strcpy( dir, "/tmp" );
! #else
! 		strcpy( dir, "c:\\tmp" );
! #endif
! 	
! /*    // ab hier leicht modifizierter Code von VB*/
!     i = strlen(dir);
! /*    ret_val = new char[i+2 /* '\0' & '\\' *//* + 8 /*root*//* + 4 /*.ext*//*];*/
!     if (ret_val)
!     {
!         strcpy(ret_val,dir);
! 
!         /* Make sure directory ends with a separator    */
! #if defined(DOS) || defined(PM2) || defined(WIN) || defined(WNT)
!         if ( i>0 && ret_val[i-1] != '\\' && ret_val[i-1] != '/' &&
!              ret_val[i-1] != ':')
!             ret_val[i++] = '\\';
! #elif (UNX)
!         if (i>0 && ret_val[i-1] != '/')
!             ret_val[i++] = '/';
! #elif (MAC)
!         if (i>0 && ret_val[i-1] != ':')
!             ret_val[i++] = ':';
! #else
! #error unknown operating system
! #endif
  
!         strncpy(ret_val + i, pfx, 5);
!         ret_val[i + 5] = '\0';      /* strncpy doesn't put a 0 if more  */
!         i = strlen(ret_val);        /* than 'n' chars.          */
! 
!         /* Prefix can have 5 chars, leaving 3 for numbers.
!            26 ** 3 == 17576
!          */
! #if (defined (MSC) || defined (BLC) || defined(ICC) ) && ( defined (WIN) || defined (WNT))
!     	u = GetTickCount();
! #else
! 		u = clock();
! #endif
  
!         for ( nOld = u; ++u != nOld; )
!         {
!              u %= (26*26*26);
!              nTemp = (unsigned)u;
! #if defined(OS2) || defined(WIN) || defined(WNT) || defined(DOS)
!             itoa(nTemp,ret_val + i,26);
! #else
!             sprintf(ret_val+i, "%03u", nTemp);
! #endif
!             strcat(ret_val,ext);
! 			nhandle = _open( ret_val, _O_CREAT | _O_EXCL, _S_IWRITE | _S_IREAD );
! 			if ( nhandle != -1 )
! 			{
! 				_lseek( nhandle, 0, SEEK_END);
! 				if ( 0 == _tell( nhandle ) )
! 				{
! 					_close( nhandle );
! 					pRet = malloc( strlen( ret_val ) );
! 					strcpy(pRet, ret_val );
! 					break;
! 				}
! 				_close( nhandle );
! 			}
!         }
!     }
! 	if ( pRet == 0L )
! 		fprintf(stderr,"ERROR - could not open tempfile\n");
! #if FALSE
! 	else
! 		fprintf(stderr,"tempfile name %s\n",pRet);
! #endif
! 	return pRet;
  }
  
  
