*** orig/dmake/dmake.c	Sat Sep  9 18:36:52 2000
--- modified/dmake/dmake.c	Sat Sep  9 18:36:52 2000
***************
*** 1,26 ****
! /* RCS  $Id: dmake.c,v 1.1.1.1.2.1 1997/08/24 07:39:01 dvadura Exp $
  --
  -- SYNOPSIS
  --      The main program.
  -- 
  -- DESCRIPTION
  -- 
  -- 	dmake [-#dbug_string] [ options ]
  -- 			[ macro definitions ] [ target ... ]
  -- 
  -- 	This file contains the main command line parser for the
  -- 	make utility.  The valid flags recognized are as follows:
  -- 
  -- 	-f file         - use file as the makefile
  --	-C file		- duplicate console output to file (MSDOS only)
  --	-K file		- .KEEP_STATE file
  -- 	-#dbug_string   - dump out debugging info, see below
  -- 	-v{dfimt}	- verbose, print what we are doing, as we do it.
  -- 
  -- 	 options: (can be catenated, ie -irn == -i -r -n)
  -- 
  --	-A		- enable AUGMAKE special target mapping
  --	-B		- enable non-use of TABS to start recipe lines
  --	-c		- use non-standard comment scanning
  --      -d              - do not use directory cache
  -- 	-i              - ignore errors
--- 1,26 ----
! /* RCS  $Id: dmake.c,v 1.3 2000/02/15 12:32:21 mh Exp $
  --
  -- SYNOPSIS
  --      The main program.
  -- 
  -- DESCRIPTION
  -- 
  -- 	dmake [-#dbug_string] [ options ]
  -- 			[ macro definitions ] [ target ... ]
  -- 
  -- 	This file contains the main command line parser for the
  -- 	make utility.  The valid flags recognized are as follows:
  -- 
  -- 	-f file         - use file as the makefile
  --	-C file		- duplicate console output to file (MSDOS only)
  --	-K file		- .KEEP_STATE file
  -- 	-#dbug_string   - dump out debugging info, see below
  -- 	-v{dfimt}	- verbose, print what we are doing, as we do it.
  -- 
  -- 	 options: (can be catenated, ie -irn == -i -r -n)
  -- 
  --	-A		- enable AUGMAKE special target mapping
  --	-B		- enable non-use of TABS to start recipe lines
  --	-c		- use non-standard comment scanning
  --      -d              - do not use directory cache
  -- 	-i              - ignore errors
***************
*** 461,511 ****
  static void
  _set_inc_depth()
  {
     char buf[10];
     sprintf( buf, "%d", next_file_slot );
     Def_macro( "INCDEPTH", buf, M_MULTI|M_NOEXPORT );
     Def_macro( "INCFILENAME",
                next_file_slot ? ftab[next_file_slot-1].name : "",
                M_MULTI|M_NOEXPORT );
  }
  
  
  PUBLIC FILE *
  Openfile(name, mode, err)/*
  ===========================
     This routine opens a file for input or output depending on mode.
     If the file name is `-' then it returns standard input.
     The file is pushed onto the open file stack.  */
  char *name;
  int  mode;
  int  err;
  {
     FILE *fil;
  
     DB_ENTER("Openfile");
! 
     if( name == NIL(char) || !*name )
        if( !err )
           DB_RETURN(NIL(FILE));
        else
           Fatal( "Openfile:  NIL filename" );
     
     if( next_file_slot == MAX_INC_DEPTH )
        Fatal( "Too many open files. Max nesting level is %d.", MAX_INC_DEPTH);
  
     DB_PRINT( "io", ("Opening file [%s], in slot %d", name, next_file_slot) );
  
     if( strcmp("-", name) == 0 ) {
        name = "stdin";
        fil = stdin;
     }
     else
        fil = fopen( name, mode ? "w":"r" );
  
     if( Verbose & V_FILE_IO )
        printf( "%s:  Openning [%s] for %s", Pname, name, mode?"write":"read" );
  
     if( fil == NIL(FILE) ) {
        if( Verbose & V_FILE_IO ) printf( " (fail)\n" );
        if( err )
           Fatal( mode ? "Cannot open file %s for write" : "File %s not found",
--- 461,511 ----
  static void
  _set_inc_depth()
  {
     char buf[10];
     sprintf( buf, "%d", next_file_slot );
     Def_macro( "INCDEPTH", buf, M_MULTI|M_NOEXPORT );
     Def_macro( "INCFILENAME",
                next_file_slot ? ftab[next_file_slot-1].name : "",
                M_MULTI|M_NOEXPORT );
  }
  
  
  PUBLIC FILE *
  Openfile(name, mode, err)/*
  ===========================
     This routine opens a file for input or output depending on mode.
     If the file name is `-' then it returns standard input.
     The file is pushed onto the open file stack.  */
  char *name;
  int  mode;
  int  err;
  {
     FILE *fil;
  
     DB_ENTER("Openfile");
!    
     if( name == NIL(char) || !*name )
        if( !err )
           DB_RETURN(NIL(FILE));
        else
           Fatal( "Openfile:  NIL filename" );
     
     if( next_file_slot == MAX_INC_DEPTH )
        Fatal( "Too many open files. Max nesting level is %d.", MAX_INC_DEPTH);
  
     DB_PRINT( "io", ("Opening file [%s], in slot %d", name, next_file_slot) );
  
     if( strcmp("-", name) == 0 ) {
        name = "stdin";
        fil = stdin;
     }
     else
        fil = fopen( name, mode ? "w":"r" );
  
     if( Verbose & V_FILE_IO )
        printf( "%s:  Openning [%s] for %s", Pname, name, mode?"write":"read" );
  
     if( fil == NIL(FILE) ) {
        if( Verbose & V_FILE_IO ) printf( " (fail)\n" );
        if( err )
           Fatal( mode ? "Cannot open file %s for write" : "File %s not found",
***************
*** 665,747 ****
--- 665,759 ----
  {
     int warn = _warn && warnflg && !(Glob_attr & A_SILENT);
  
     if( errflg || warn ) {
        char *f = Filename();
  
        fprintf( stderr, "%s:  ", Pname );
        if( f != NIL(char) ) fprintf(stderr, "%s:  line %d:  ", f, Line_number);
  
        if( errflg )
           fprintf(stderr, "Error -- ");
        else if( warn )
           fprintf(stderr, "Warning -- ");
  
        vfprintf( stderr, fmt, args );
        putc( '\n', stderr );
        if( errflg && !Continue ) Quit( NIL(CELL) );
     }
  }
  
  
  /*
  ** Print error message and abort
  */
  PUBLIC void
+ #ifndef __MWERKS__
  Fatal(ARG(char *,fmt), ARG(va_alist_type,va_alist))
+ #else
+ Fatal(char * fmt, ...)
+ #endif
  DARG(char *,fmt)
  DARG(va_alist_type,va_alist)
  {
     va_list args;
  
     va_start(args, fmt);
     Continue = FALSE;
     errargs(fmt, args);
     va_end(args);
  }
  
  /*
  ** error message and exit (unless -k)
  */
  PUBLIC void
+ #ifndef __MWERKS__
  Error(ARG(char *,fmt), ARG(va_alist_type,va_alist))
+ #else
+ Error(char * fmt, ...)
+ #endif
  DARG(char *,fmt)
  DARG(va_alist_type,va_alist)
  {
     va_list args;
  
     va_start(args, fmt);
     errargs(fmt, args);
     va_end(args);
  }
  
  
  /*
  ** non-fatal message
  */
  PUBLIC void
+ #ifndef __MWERKS__
  Warning(ARG(char *,fmt), ARG(va_alist_type,va_alist))
+ #else
+ Warning(char * fmt , ...)
+ #endif
  DARG(char *,fmt)
  DARG(va_alist_type,va_alist)
  {
     va_list args;
  
     va_start(args, fmt);
     warnflg = TRUE;
     errflg = FALSE;
     errargs(fmt, args);
     errflg = TRUE;
     warnflg = FALSE;
     va_end(args);
  }
  
  
  PUBLIC void
  No_ram()
  {
     Fatal( "No more memory" );
  }
  
  
  PUBLIC void
  Usage( eflag )
  int eflag;
***************
*** 798,831 ****
     puts("    -T   - do not apply transitive closure on inference rules");
     puts("    -u   - force unconditional update of target");
     puts("    -V   - print out version number");
     puts("    -x   - export macro values to environment");
     puts("    -X   - ignore #! lines at start of makefile");
     }
  
     Quit(NIL(CELL));
  }
  
  
  PUBLIC void
  Version()
  {
     extern char **Rule_tab;
     char **p;
     
     printf("%s - %s, ", Pname, sccid);
     printf("Version %s, PL %d\n\n", VERSION, PATCHLEVEL);
  
     puts("Default Configuration:");
     for (p=Rule_tab;  *p != NIL(char);  p++)
        printf("\t%s\n", *p);
  
     printf("\n");
! printf("Please read the file readme/release.txt for the latest release notes.\n");
  #if 0
  printf("\n");
  printf("Please support the DMAKE Reference Manual project.  See the file\n");
  printf("readme/release for additional information on where to send contributions.\n");
  printf("Or, send mail to dvadura@plg.uwaterloo.ca for additional information if the\n");
  printf("above file is not readily available.\n");
  #endif
  }
--- 810,843 ----
     puts("    -T   - do not apply transitive closure on inference rules");
     puts("    -u   - force unconditional update of target");
     puts("    -V   - print out version number");
     puts("    -x   - export macro values to environment");
     puts("    -X   - ignore #! lines at start of makefile");
     }
  
     Quit(NIL(CELL));
  }
  
  
  PUBLIC void
  Version()
  {
     extern char **Rule_tab;
     char **p;
     
     printf("%s - %s, ", Pname, sccid);
     printf("Version %s, PL %d\n\n", VERSION, PATCHLEVEL);
  
     puts("Default Configuration:");
     for (p=Rule_tab;  *p != NIL(char);  p++)
        printf("\t%s\n", *p);
  
     printf("\n");
! printf("Please read the file readme/release for the latest release notes.\n");
  #if 0
  printf("\n");
  printf("Please support the DMAKE Reference Manual project.  See the file\n");
  printf("readme/release for additional information on where to send contributions.\n");
  printf("Or, send mail to dvadura@plg.uwaterloo.ca for additional information if the\n");
  printf("above file is not readily available.\n");
  #endif
  }
