/*************************************************************************
 *
 *  $RCSfile: lst_dlst.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CPV_LST_TAGT_H
#define CPV_LST_TAGT_H

#include "lst_tdat.h"


typedef struct LDLElem
{
	ListTagData *	  	pData;
	struct LDLElem *	pNext;
} LDLElem;


typedef struct LDLIterator
{
	LDLElem *       	pElement;
} LDLIterator;


typedef struct ListDataList
{
	LDLElem *			dpStart;
	LDLElem *			pEnd;
	Bool				bAutoDeleteData;
} ListDataList;


#define ListDataList_THIS 			ListDataList * pThis
#define LDLIterator_THIS	 	    LDLIterator * pThis
#define LDLElem_THIS		        LDLElem * pThis





void				ListDataList_CTOR( ListDataList_THIS,
						Bool		   i_bAutoDeleteData );
void				ListDataList_DTOR( ListDataList_THIS );

void				LDL_Add( ListDataList_THIS,
						ListTagData *		i_pData );
void				LDL_Empty( ListDataList_THIS,
						Bool				i_bDeleteData );

LDLIterator			LDL_Begin( ListDataList_THIS );


void				LDLIterator_CTOR( LDLIterator_THIS,
						LDLElem * 			i_pStart );
void				LDLI_opp( LDLIterator_THIS );  	/** operator++() */

Bool				LDLI_obool( LDLIterator_THIS );
ListTagData *		LDLI_optr( LDLIterator_THIS );  	/** operator->() */


void				LDLElem_CTOR( LDLElem_THIS,
						ListTagData *		i_pData );
void				LDLElem_DTOR( LDLElem_THIS );

ListTagData *		LDLE_Data( LDLElem_THIS );
LDLElem *			LDLE_Next( LDLElem_THIS );

void				LDLE_SetNext( LDLElem_THIS,
						LDLElem *			i_pNext );
void				LDLE_DeleteData( LDLElem_THIS );


#endif



