/*************************************************************************
 *
 *  $RCSfile: lst_desc.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "precomp.h"
#include "lst_desc.h"


#include "new_del.h"




/*** List ***/

void
ListComponentDescription_CTOR( ListComponentDescription * pThis )
{
	pThis->dpStart = 0;
	pThis->pEnd = 0;
}

void
ListComponentDescription_DTOR( ListComponentDescription * pThis )
{
	LCD_Empty(pThis);
}

void
LCD_Add( ListComponentDescription * pThis,
		 ComponentDescription *	   i_pData )
{
	LCDElem * dpNewElem = 0;
	ASSIGN_NEW1(dpNewElem,LCDElem,i_pData);

	if (pThis->dpStart != 0)
	{
		LCDE_SetNext(pThis->pEnd,dpNewElem);
		pThis->pEnd = dpNewElem;
	}
	else
	{
		pThis->dpStart = dpNewElem;
		pThis->pEnd = pThis->dpStart;
	}
}

void
LCD_Empty( ListComponentDescription * pThis )
{
	LCDElem * pIter = 0;
	LCDElem * pDel =  0;

	if (pThis->dpStart == 0)
		return;

	pIter = LCDE_Next(pThis->dpStart);
	pDel =  pThis->dpStart;
	DELETE( pDel, LCDElem );


	while( pIter != 0 )
	{
		pDel = pIter;
		pIter = LCDE_Next(pIter);
		DELETE( pDel, LCDElem );
	}	/* end while */

	pThis->dpStart = 0;
	pThis->pEnd = 0;
}

LCDIterator
LCD_Begin( ListComponentDescription * pThis )
{
	LCDIterator ret;
	LCDIterator_CTOR( &ret, pThis->dpStart );
	return ret;
}


/*** ListIterator ***/

void
LCDIterator_CTOR( LCDIterator * pThis,
				  LCDElem *     i_pElement )
{
	pThis->pElement = i_pElement;
}

void
LCDI_opp( LCDIterator * pThis )
{
	if (pThis->pElement != 0)
		pThis->pElement = LCDE_Next(pThis->pElement);
}


Bool
LCDI_obool( LCDIterator * pThis )
{
	return pThis->pElement != 0;
}

ComponentDescription *
LCDI_optr( LCDIterator * pThis )
{
	return pThis->pElement != 0
			? LCDE_Data(pThis->pElement)
			: 0;
}


/*** ListElement ***/

void
LCDElem_CTOR( LCDElem * pThis,
			  ComponentDescription *	i_pData )
{
	pThis->pData = i_pData;
	pThis->pNext = 0;
}

void
LCDElem_DTOR( LCDElem * pThis )
{
}

ComponentDescription *
LCDE_Data( LCDElem * pThis )
{
	return pThis->pData;
}

LCDElem *
LCDE_Next( LCDElem * pThis )
{
	return pThis->pNext;
}

void
LCDE_SetNext( LCDElem * pThis,
			  LCDElem *	i_pNext )
{
	pThis->pNext = i_pNext;
}


