/*************************************************************************
 *
 *  $RCSfile: cmp_xml.c,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: np $ $Date: 2001/03/13 11:39:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "precomp.h"
#include <stdio.h>

#include <string.h>
#include "cmdline.h"
#include "sfldata.h"
#include "lst_tagt.h"
#include "cr_metho.h"
#include "cr_html.h"
#include "dtd.h"
#include "indexdat.h"
#include "new_del.h"
#include "indexdat.h"


#ifdef WNT
#include <io.h>
#elif defined(UNX)
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#else
#error Must run under unix or windows, please define UNX or WNT.
#endif




int      				Do_IndexCommandLine(
							CommandLine *			i_pCommandLine );
int      				Do_SingleFileCommandLine(
							CommandLine *			i_pCommandLine );
void					GatherFileNames(
							ListCstring *			o_sFiles,
							char *					i_sSrcDirectory );
void					GatherSubDirectories(
							ListCstring *			o_sSubDirectories,
							char *					i_sParentdDirectory );
void					Create_TypeInfoFile(
							char *					o_sOutputFile,
							SrcFileData *			i_pData );


int
#ifdef WNT
_cdecl
#endif
main( int 		argc,
	  char *    argv[] )
{
	/* Variables */
	CommandLine				aCommandLine;
	int ret = 0;

	CommandLine_CTOR( &aCommandLine, argc, argv );
#define main_RETURN \
	CommandLine_DTOR( &aCommandLine ); \
	return

	if (NOT CL_IsOk(&aCommandLine))
	{
		fprintf( stderr, CL_ErrorText(&aCommandLine) );
		main_RETURN 1;
	}

	if ( CL_IsIndexCommand(&aCommandLine) )
	{
		ret = Do_IndexCommandLine(&aCommandLine);
	}
	else
	{
		ret = Do_SingleFileCommandLine(&aCommandLine);
	}	/* endif CL_IsIndexCommand(&aCommandLine) */

	main_RETURN ret;
}


int
Do_SingleFileCommandLine(CommandLine * i_pCommandLine)
{
	/* Variables */
	SrcFileData 			aDescr;
	CreatorAccessMethod	    aCreatorAccessMethod;
	CreatorHtml			    aCreatorHtml;
	Bool                    bParseResult = False;

	/* Init local variables */
	SrcFileData_CTOR( &aDescr,
					  C_sTagDescription,
					  C_sSubTags,
					  C_nNrOfSubTags );
#define SingleFileCommandLine_RETURN \
	SrcFileData_DTOR( &aDescr ); \
	return


	/* Parse */
	bParseResult = SFD_Parse( &aDescr, CL_XmlSrcFile(i_pCommandLine) );
	if (NOT bParseResult)
	{
		fprintf( stderr, "Error: File %s could not be parsed.", CL_XmlSrcFile(i_pCommandLine) );
		SingleFileCommandLine_RETURN 1;
	}

	/* Produce output */
	if (strlen( CL_FuncFile(i_pCommandLine) ) > 0)
	{
		CreatorAccessMethod_CTOR( &aCreatorAccessMethod );
		CAM_Create( &aCreatorAccessMethod, CL_FuncFile(i_pCommandLine), &aDescr );
		CreatorAccessMethod_DTOR( &aCreatorAccessMethod );
	}
	if (strlen( CL_HtmlFile(i_pCommandLine) ) > 0)
	{
		CreatorHtml_CTOR( &aCreatorHtml );
		CH_Create( &aCreatorHtml, CL_HtmlFile(i_pCommandLine), &aDescr );
		CreatorHtml_DTOR( &aCreatorHtml );
	}

	if (strlen( CL_TypeInfoFile(i_pCommandLine) ) > 0)
	{
		Create_TypeInfoFile( CL_TypeInfoFile(i_pCommandLine),
							 &aDescr );
	}


	SingleFileCommandLine_RETURN 0;
};

int
Do_IndexCommandLine(CommandLine * i_pCommandLine)
{
	/* files parsen into */
	ListCstring	aFiles;
	IndexData	aIndex;

	fprintf(stdout,"Gather xml-files ...\n");

	ListCstring_CTOR( &aFiles, True );
	IndexData_CTOR( &aIndex, CL_IndexedTags(i_pCommandLine), CL_OutputDirectory(i_pCommandLine) );
	GatherFileNames( &aFiles, CL_XmlSrcDirectory(i_pCommandLine) );

	fprintf(stdout,"\nCreate output ...\n");

	IDXD_GatherData( &aIndex, &aFiles );
	IDXD_WriteOutput( &aIndex, CL_IndexOutputFile(i_pCommandLine) );

	IndexData_DTOR( &aIndex );
	ListCstring_DTOR( &aFiles );

	fprintf(stdout,"... done.\n");

	return 0;
};

#define C_sXML_END "\\*.xml"

#ifdef WNT
#define C_sSLASH  "\\"
#elif defined(UNX)
#define C_sSLASH  "/"
#else
#error Must run under unix or windows, please define UNX or WNT.
#endif


void
GatherFileNames( ListCstring * o_sFiles,
				 char *		   i_sSrcDirectory )
{
	static int 	 nAliveCounter = 0;

	ListCstring  aSubDirectories;
	LSIterator 	 aSubDirsIter;
	char * 		 sNextDir = 0;
#ifdef WNT
	struct _finddata_t aEntry;
	Cstring * pNew = 0;
	long hFile = 0;
	int bFindMore = 0;
	char * sFilter = New(strlen(i_sSrcDirectory) + sizeof C_sXML_END);

	/* Stayingalive sign */
	if (++nAliveCounter % 100 == 1)
		fprintf(stdout,".");

	strcpy(sFilter, i_sSrcDirectory);
	strcat(sFilter,C_sXML_END);

	hFile = _findfirst( sFilter, &aEntry );
	for ( bFindMore = hFile == -1;
		  bFindMore == 0;
		  bFindMore = _findnext( hFile, &aEntry ) )
	{
		ASSIGN_NEW1( pNew, Cstring, i_sSrcDirectory );
		Cs_Add(pNew,"\\");
		Cs_Add(pNew,aEntry.name);
		LS_Add( o_sFiles, pNew );
	}
	_findclose(hFile);
	Delete(sFilter);
#elif defined(UNX)
	struct DIR * pDir = opendir( i_sSrcDirectory );
	struct dirent * pEntry = 0;
	char * sEnding;
	Cstring * pNew = 0;

	while ( (pEntry = readdir(pDir)) != 0 )
	{
		sEnding = strrchr(pEntry->d_name,'.');
		if (sEnding != 0 ? stricmp(sEnding,".xml") == 0 : False )
		{
			ASSIGN_NEW1( pNew, Cstring, i_sSrcDirectory );
			Cs_Add(pNew,"/");
			Cs_Add(pNew,pEntry->d_name);
			LS_Add( o_sFiles, pNew );
		}
	}
	closedir( pDir );
#else
#error Must run on unix or windows, please define UNX or WNT.
#endif

	/*  gathering from subdirectories: */
	ListCstring_CTOR(&aSubDirectories,True);

	GatherSubDirectories(&aSubDirectories,i_sSrcDirectory);
	for ( aSubDirsIter = LS_Begin(&aSubDirectories);
		  LSI_obool(&aSubDirsIter);
		  LSI_opp(&aSubDirsIter) )
	{
		sNextDir = New(strlen(i_sSrcDirectory) + 2 + Cs_Length(LSI_optr(&aSubDirsIter)));

		strcpy(sNextDir, i_sSrcDirectory);
		strcat(sNextDir, C_sSLASH);
		strcat(sNextDir, Cs_Str(LSI_optr(&aSubDirsIter)) );
		GatherFileNames(o_sFiles, sNextDir);

		Delete(sNextDir);
	}

	ListCstring_DTOR(&aSubDirectories);
}


#define C_sANYDIR "\\*.*"

void
GatherSubDirectories( ListCstring *	o_sSubDirectories,
					  char *	  	i_sParentdDirectory )
{
#ifdef WNT
	struct _finddata_t aEntry;
	Cstring * pNew = 0;
	long hFile = 0;
	int bFindMore = 0;
	char * sFilter = New(strlen(i_sParentdDirectory) + sizeof C_sANYDIR);

	strcpy(sFilter, i_sParentdDirectory);
	strcat(sFilter,C_sANYDIR);

	hFile = _findfirst( sFilter, &aEntry );
	for ( bFindMore = hFile == -1;
		  bFindMore == 0;
		  bFindMore = _findnext( hFile, &aEntry ) )
	{
		if (aEntry.attrib == _A_SUBDIR)
		{
			/* Do not gather . .. and outputtree directories */
			if ( strchr(aEntry.name,'.') == 0
				 AND strncmp(aEntry.name, "wnt", 3) != 0
				 AND strncmp(aEntry.name, "unx", 3) != 0 )
			{
				ASSIGN_NEW1( pNew, Cstring, aEntry.name );
				LS_Add( o_sSubDirectories, pNew );
			}
		}   /* endif (aEntry.attrib == _A_SUBDIR) */
	}   /* end for */
	_findclose(hFile);
	Delete(sFilter);
#elif defined(UNX)
	struct DIR * pDir = opendir( i_sParentdDirectory );
	struct dirent * pEntry = 0;
	struct stat 	aEntryStatus;
	char * sEnding;
	Cstring * pNew = 0;

	while ( (pEntry = readdir(pDir)) != 0 )
	{
		stat(pEntry->d_name, &aEntryStatus);
		if ( ( aEntryStatus.st_mode & S_IFDIR ) == S_IFDIR )
		{
			/* Do not gather . .. and outputtree directories */
			if ( strchr(pEntry->d_name,'.') == 0
				 AND strncmp(pEntry->d_name, "wnt", 3) != 0
				 AND strncmp(pEntry->d_name, "unx", 3) != 0 )
			{
				ASSIGN_NEW1( pNew, Cstring, pEntry->d_name );
				LS_Add( o_sSubDirectories, pNew );
			}
		}   /* endif (aEntry.attrib == _A_SUBDIR) */
	}	/* end while */
	closedir( pDir );
#else
#error Must run on unix or windows, please define UNX or WNT.
#endif
}



void
Create_TypeInfoFile( char *		   o_sOutputFile,
					 SrcFileData * i_pData )
{
	TextFile 					aOut;
	IndexHeap                   aTypesHeap;
	ListComponentDescription *  pListDescriptions = 0;
	LCDIterator                 aDescrIter;
	ListDataList *              pDataLists = 0;
	LDLIterator					aTagIter;
	LTDIterator                 aDataIter;
	IndexValue *                pLastHeapTop = 0;
	IndexValue *                pHeapTop = 0;
	int                         i = 0;
    Cstring					    sLibPrefix;


	TextFile_CTOR(&aOut, o_sOutputFile);
	IndexHeap_CTOR(&aTypesHeap);
	Cstring_CTOR(&sLibPrefix, "");

	if (NOT TF_Create(&aOut) )
	{
		fprintf(stderr, "Error: Outputfile %s could not be created.", o_sOutputFile);
		return;
	}

	/* Gather types: */
	pListDescriptions = SFD_Descriptions(i_pData);
	for ( aDescrIter = LCD_Begin(pListDescriptions);
		  LCDI_obool(&aDescrIter);
		  LCDI_opp(&aDescrIter) )
	{   /*  loop descriptions */
		pDataLists = CD_ListOfDataLists(LCDI_optr(&aDescrIter));
		i = 0;
		for ( aTagIter = LDL_Begin(pDataLists);
			  LDLI_obool(&aTagIter);
			  LDLI_opp(&aTagIter), i++ )
		{   /*  loop tags */
				if (i == 2 AND Cs_Length(&sLibPrefix) == 0)  	/* Module name */
				{
					aDataIter = LTD_Begin(LDLI_optr(&aTagIter));
					Cs_Assign( &sLibPrefix, TD_Data(LTDI_optr(&aDataIter)) );
				}
				if (i == 10)   /* Types */
				{
					/* Fill Service-Module-Heaps*/
					for ( aDataIter = LTD_Begin(LDLI_optr(&aTagIter));
						  LTDI_obool(&aDataIter);
						  LTDI_opp(&aDataIter)     )
					{   /* Loop Services */
						IXH_InsertValueExplicit( &aTypesHeap,
												 TD_Data(LTDI_optr(&aDataIter)),
												 "",
												 False );
					}	/* end for aDataIter */
					break;
				}	/* endif (i == 10) */
			} 	/* end for (aTagIter) */
		}	/* end for (aDescrIter) */

	/* Write types: */
/*	Cs_ToUpper(&sLibPrefix);	*/

	TF_WriteStr(&aOut, Cs_Str(&sLibPrefix));
	TF_WriteStr(&aOut, "_XML2CMPTYPES= ");
	for ( pHeapTop = IXH_RemoveTop(&aTypesHeap);
		  pHeapTop != 0;
		  pHeapTop = IXH_RemoveTop(&aTypesHeap) )
	{
		if (pLastHeapTop != 0)
		{
			if ( 0 == strcmp(IXV_Value(pHeapTop), IXV_Value(pLastHeapTop)) )
				continue;
			DELETE(pLastHeapTop,IndexValue);
		}
		pLastHeapTop = pHeapTop;

		TF_WriteStr(&aOut, "\t\\\r\n\t\t");
		TF_WriteStr(&aOut, IXV_Value(pHeapTop));
	}	/* end for */

	if (pLastHeapTop != 0)
		DELETE(pLastHeapTop,IndexValue);

	TF_Close(&aOut);
	Cstring_DTOR(&sLibPrefix);
	IndexHeap_DTOR(&aTypesHeap);
	TextFile_DTOR(&aOut);
}

