/*************************************************************************
 *
 *  $RCSfile: cmdline.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CPV_CMDLINE_H
#define CPV_CMDLINE_H

#include "str.h"
#include "lst_str.h"


typedef struct CommandLine
{
	Cstring				sXmlSourceFile;
	Cstring				sFuncFile;
	Cstring				sHtmlFile;
	Cstring				sTypeInfoFile;
	Cstring				sDependencyFile;

	Cstring				sXmlSourceDirectory;
	Cstring				sIndexFile;
	Cstring				sOutputDirectory;
	ListCstring			aTagsInIndex;

	Bool				bIsOk;
} CommandLine;

#define CommandLine_THIS 		CommandLine * pThis


void				CommandLine_CTOR( CommandLine_THIS,
						int				 	i_argc,
						char *				i_argv[] );
void				CommandLine_DTOR( CommandLine_THIS );

Bool				CL_IsOk( CommandLine_THIS );
char *				CL_ErrorText( CommandLine_THIS );

char *				CL_XmlSrcFile( CommandLine_THIS );
char *				CL_FuncFile( CommandLine_THIS );
char *				CL_HtmlFile( CommandLine_THIS );
char *				CL_TypeInfoFile( CommandLine_THIS );

Bool				CL_IsIndexCommand( CommandLine_THIS );
char *				CL_XmlSrcDirectory( CommandLine_THIS );
char *				CL_IndexOutputFile( CommandLine_THIS );
char *				CL_OutputDirectory( CommandLine_THIS );
ListCstring *		CL_IndexedTags( CommandLine_THIS );

#endif

