/*************************************************************************
 *
 *  $RCSfile: str.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "precomp.h"
#include "str.h"

#include <string.h>
#include <ctype.h>
#include "new_del.h"

void
Cstring_CTOR( Cstring_THIS,
			  char *	i_pText )
{
	if ( i_pText != 0 )
	{
		pThis->nLength = strlen(i_pText);
		pThis->dpText = New( pThis->nLength + 1 );
		strcpy(pThis->dpText,i_pText);
	}
	else
	{
		pThis->nLength = strlen(i_pText);
		pThis->dpText = New( 1 );
		*pThis->dpText = '\0';
	}
}

void
Cstring_DTOR( Cstring_THIS )
{
	Delete(pThis->dpText);
}

void
Cs_Assign( Cstring_THIS,
		   char * 	 i_pNewText )
{
	if (i_pNewText == pThis->dpText)
		return;
	Delete(pThis->dpText);
	Cstring_CTOR(pThis,i_pNewText);
}

void
Cs_AssignPart( Cstring_THIS,
			   char * 	 i_pNewText,
			   intt		 i_nLength	 )
{
	if (i_pNewText == pThis->dpText)
		return;
	Delete(pThis->dpText);

	if ( i_pNewText != 0 )
	{
		pThis->nLength = ((intt)strlen(i_pNewText)) > i_nLength ? i_nLength : strlen(i_pNewText);
		pThis->dpText = New( pThis->nLength + 1 );
		strncpy(pThis->dpText,i_pNewText,pThis->nLength);
		pThis->dpText[pThis->nLength] = '\0';
	}
	else
	{
		pThis->nLength = strlen(i_pNewText);
		pThis->dpText = New( 1 );
		*pThis->dpText = '\0';
	}

}

void
Cs_AddCs( Cstring_THIS,
		  Cstring * i_sAddedText )
{
	Cs_Add(THIS_, Cs_Str(i_sAddedText));
}

void
Cs_Add( Cstring_THIS,
		char * i_sAddedText )
{
	char * dpOld = THIS_->dpText;
	THIS_->nLength += strlen(i_sAddedText) + 1;
	THIS_->dpText = New(THIS_->nLength);
	strcpy(THIS_->dpText, dpOld);
	strcat(THIS_->dpText, i_sAddedText);
	Delete(dpOld);
}

char *
Cs_Str( Cstring_THIS )
{
	return pThis->dpText;
}

intt
Cs_Length( Cstring_THIS )
{
	return pThis->nLength;
}

void
Cs_ToUpper( Cstring_THIS )
{
	char * p = 0;
	for ( p = THIS_->dpText; *p != 0; ++p )
    {
     	*p = toupper(*p);
	}
}


