/*************************************************************************
 *
 *  $RCSfile: protocol.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: pl $ $Date: 2001/05/11 19:33:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef __STL_USE_NEWALLOC
#define __STL_USE_NEWALLOC 1
#endif
#ifndef __UTILITY__
#include <utility>
#endif
#ifndef __HASH_MAP__
#include <hash_map>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MACROS_HXX_
#include <vos/macros.hxx>
#endif

#ifndef _PROTOCOL_HXX_
#include "protocol.hxx"
#endif

using namespace com::sun::star::proxy;
using namespace rtl;

/*========================================================================
 *
 * OProtocolHandlerRegistry internals.
 *
 *======================================================================*/
#ifndef COPYCTOR_API
#define COPYCTOR_API(C) C (const C&); C& operator= (const C&)
#endif

typedef OUString                 map_key;
typedef IProtocolHandlerFactory* map_val;

struct key_hash :
	public NAMESPACE_STD(unary_function)<map_key, sal_Int32>
{
	sal_Int32 operator() (const map_key& k) const
	{
		return k.hashCode();
	}
};

struct key_cmp :
	public NAMESPACE_STD(binary_function)<map_key, map_key, sal_Bool>
{
	sal_Bool operator() (const map_key& k1, const map_key& k2) const
	{
		return k1.equalsIgnoreAsciiCase (k2);
	}
};

typedef NAMESPACE_STD(hash_map)<map_key, map_val, key_hash, key_cmp> map_type;
typedef NAMESPACE_STD(pair)<const map_key, map_val> map_entry;

/*========================================================================
 *
 * OProtocolHandlerRegistry_Impl interface.
 *
 *======================================================================*/
class OProtocolHandlerRegistry_Impl : public OProtocolHandlerRegistry
{
public:
	OProtocolHandlerRegistry_Impl (void);

protected:
	virtual ~OProtocolHandlerRegistry_Impl (void);

	virtual sal_Bool queryFactory_Impl (
		const OUString           &rProtocol,
		IProtocolHandlerFactory *&rpFactory);

	virtual sal_Bool registerFactory_Impl (
		const OUString          &rProtocol,
		IProtocolHandlerFactory *pFactory);

	virtual sal_Bool deregisterFactory_Impl (
		const OUString          &rProtocol,
		IProtocolHandlerFactory *pFactory);

private:
	/** Representation.
	 */
	map_type m_aMap;

	/** Not implemented.
	 */
	COPYCTOR_API (OProtocolHandlerRegistry_Impl);
};

/*========================================================================
 *
 * OProtocolHandlerRegistry_Impl implementation.
 *
 *======================================================================*/
/*
 * OProtocolHandlerRegistry_Impl.
 */
OProtocolHandlerRegistry_Impl::OProtocolHandlerRegistry_Impl (void)
{
}

/*
 * ~OProtocolHandlerRegistry_Impl.
 */
OProtocolHandlerRegistry_Impl::~OProtocolHandlerRegistry_Impl (void)
{
}

/*
 * queryFactory_Impl.
 */
sal_Bool OProtocolHandlerRegistry_Impl::queryFactory_Impl (
	const OUString           &rProtocol,
	IProtocolHandlerFactory *&rpFactory)
{
	map_type::iterator it = m_aMap.find (rProtocol);
	if (it != m_aMap.end())
		rpFactory = (*it).second;
	else
		rpFactory = NULL;
	return (!!rpFactory);
}

/*
 * registerFactory_Impl.
 */
sal_Bool OProtocolHandlerRegistry_Impl::registerFactory_Impl (
	const OUString          &rProtocol,
	IProtocolHandlerFactory *pFactory)
{
	typedef NAMESPACE_STD(pair)<map_type::iterator, bool> result_type;

	result_type result = m_aMap.insert (map_entry (rProtocol, pFactory));
	if (result.second)
		return sal_True;
	else
		return sal_False;
}

/*
 * deregisterFactory_Impl.
 */
sal_Bool OProtocolHandlerRegistry_Impl::deregisterFactory_Impl (
	const OUString          &rProtocol,
	IProtocolHandlerFactory *pFactory)
{
	map_type::iterator it = m_aMap.find (rProtocol);
	if ((it != m_aMap.end()) && ((*it).second == pFactory))
	{
		m_aMap.erase (it);
		return sal_True;
	}
	return sal_False;
}

/*========================================================================
 *
 * OProtocolHandlerRegistry implementation.
 *
 *======================================================================*/
/*
 * The single instance.
 */
com::sun::star::proxy::OProtocolHandlerRegistry*
com::sun::star::proxy::OProtocolHandlerRegistry::m_pThis = NULL;

/*
 * OProtocolHandlerRegistry.
 */
OProtocolHandlerRegistry::OProtocolHandlerRegistry (void)
{
	m_pThis = this;
}

/*
 * ~OProtocolHandlerRegistry.
 */
OProtocolHandlerRegistry::~OProtocolHandlerRegistry (void)
{
	m_pThis = NULL;
}

/*
 * queryFactory.
 */
sal_Bool OProtocolHandlerRegistry::queryFactory (
	const OUString           &rProtocol,
	IProtocolHandlerFactory *&rpFactory)
{
	rpFactory = NULL;
	if (m_pThis)
		return m_pThis->queryFactory_Impl (rProtocol, rpFactory);
	else
		return sal_False;
}

/*
 * registerFactory.
 */
sal_Bool OProtocolHandlerRegistry::registerFactory (
	const OUString          &rProtocol,
	IProtocolHandlerFactory *pFactory)
{
	if (!m_pThis)
		new OProtocolHandlerRegistry_Impl();
	return m_pThis->registerFactory_Impl (rProtocol, pFactory);
}

/*
 * deregisterFactory.
 */
sal_Bool OProtocolHandlerRegistry::deregisterFactory (
	const OUString          &rProtocol,
	IProtocolHandlerFactory *pFactory)
{
	if (!m_pThis)
		new OProtocolHandlerRegistry_Impl();
	return m_pThis->deregisterFactory_Impl (rProtocol, pFactory);
}

