/*************************************************************************
 *
 *  $RCSfile: event.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef GCC   
#define __PUT_STATIC_DATA_MEMBERS_HERE
#endif

#include <iostream.h>
#include <string.h>
#include <errno.h>


#include <vos/evtque.hxx>
#include <vos/string.hxx>
#include <vos/thread.hxx>

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

class MyCommand : public OReference
{
public:
	MyCommand(cStr text, Boolean ret) : m_text(text), m_ret(ret) {}

	Boolean operator () (Long param)
	{
		cout << (cStr) m_text << " <param = " << param << ">" << endl;
		return(m_ret);
	}

private:

	OString 	m_text;
	Boolean 	m_ret;
};

class MyHandler : public IEventHandler
{
public:

	MyHandler(cStr text) : m_text(text) {}

	virtual Boolean handleEvent(EventId id, Long param, IReference* pObject)
	{
		Boolean ret = True;
		
		cout << (cStr) m_text << param << endl;

		return(ret);
	}

private:

	OString m_text;
};

class CommandHandler : public IEventHandler
{
public:

	virtual Boolean handleEvent(EventId id, Long param, IReference* pObject)
	{
		Boolean ret = True;
		
		if (pObject)
		{
			cout << "CommandHandler called with object." << endl;
			ret = (*(MyCommand*) pObject)(param);
		}
		else
		{
			cout << "CommandHandler called without object."  << endl;
		}

		return(ret);
	}

private:

	OString m_text;
};

class EventCounter : public IEventQueueListener
{
public:
	EventCounter() : count(0) {}

	uLong getCount() {return count;}

	void eventPosted(OEventQueue* pQueue) {	count++; }
		
	
protected:
	uLong count;
};

#ifdef UNX
int main()
#else
int _cdecl main()
#endif
{
	uLong i;
	EventCounter 	eventCounter;
	MyHandler 		handler1("handler1 : ");
	CommandHandler 	handler2;

	OEventQueue::getGlobalEventQueue()->registerListener(&eventCounter);
	OEventQueue::getGlobalEventQueue()->registerHandler(1, &handler1);
	OEventQueue::getGlobalEventQueue()->registerHandler(2, &handler2);

	EventHandle hEvent = NULL;

	for (i = 0; i < 10; i++)
	{
		if (i == 7)
			hEvent = OEventQueue::getGlobalEventQueue()->postEvent(1, i, NULL);
		else
			OEventQueue::getGlobalEventQueue()->postEvent(1, i, NULL);

		OEventQueue::getGlobalEventQueue()->postEvent(2, i, new MyCommand("my command object", True));
	}

	OEventQueue::getGlobalEventQueue()->removeEvent(hEvent);
		
	while (OEventQueue::getGlobalEventQueue()->dispatchEvent(0))
	{
	}

	OEventQueue::getGlobalEventQueue()->deregisterHandler(1, &handler1);
	OEventQueue::getGlobalEventQueue()->deregisterHandler(2, &handler2);

	cout << endl << "Summary: " << eventCounter.getCount() << " events posted." << endl;
	return 0;
}



