/*************************************************************************
 *
 *  $RCSfile: channtst.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/16 15:25:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef GCC   
#define __PUT_STATIC_DATA_MEMBERS_HERE
#endif

#include <iostream.h>
#include <string.h>
#include <errno.h>

#include <rtl/string.hxx>

#include <osl/channel.h>

#include <vos/timer.hxx>
#include <vos/acceptor.hxx>
#include <vos/process.hxx>
#include <vos/channel.hxx>
#include <vos/thread.hxx>
#include <vos/socket.hxx>

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
using namespace rtl;
#endif

#define NUM_OF_TEST_PROCS 10

class OAuthCheck : public IAuthenticationCheck
{
public:
	sal_Bool check
	(
		const ::rtl::OString& userIdent,
		const ::rtl::OString& password
	);
};


sal_Bool OAuthCheck::check
(
	const ::rtl::OString& userIdent,
	const ::rtl::OString& password
)
{
	return (userIdent == "ts") && (password == "test");	
}	

class OAcceptHandler : public NAMESPACE_VOS(IAcceptHandler)
{
public:
	OAcceptHandler(ORef<OChannelBroker>& rBroker) : m_rBroker(rBroker) {}

	Boolean onConnection( NAMESPACE_VOS(OStreamSocket) &Socket,
						  NAMESPACE_VOS(OSocketAddr)   &addr);

protected:

	ORef<OChannelBroker> m_rBroker;
};

Boolean OAcceptHandler::onConnection(NAMESPACE_VOS(OStreamSocket) &rSocket,
									 NAMESPACE_VOS(OSocketAddr) &rAddr)
{
	int i;
			
	VOS_ASSERT(rSocket.read(&i, sizeof(i)) == sizeof(i));
	
	ORef<OChannel> channel = OChannel::createChannel(rSocket);
	char resource[512];
	
	sprintf(resource, "test_channel_broker_%i", i);

	cout << "accepted: " << i << "\n";
	cout << flush;
	
	OString sName(resource);
	
	if (i % 2)
	{
		VOS_ASSERT(m_rBroker->provide(channel, sName) == OChannelBroker::NoError);
	}
	else
	{
		OString user("ts");
		OString password("test");
		VOS_ASSERT(m_rBroker->provide(channel, sName, user, password) == OChannelBroker::NoError);
	}

	cout << "provided: " << i << "\n";
	cout << flush;

	// always destroy our handler
	return (False);
}
/////////////////////////////////////////////////////////////////////////////
// OAcceptHandlerFactORy

class OAcceptHandlerFactory : public NAMESPACE_VOS(IAcceptHandlerFactory)
{
	
public:

	OAcceptHandlerFactory(ORef<OChannelBroker>& rBroker) : m_rBroker(rBroker) {}

	virtual NAMESPACE_VOS(IAcceptHandler) *createHandler();
	virtual void destroyHandler(NAMESPACE_VOS(IAcceptHandler) *pHdl);

protected:

	ORef<OChannelBroker> m_rBroker;
};

NAMESPACE_VOS(IAcceptHandler) *OAcceptHandlerFactory::createHandler()
{
	return (new OAcceptHandler(m_rBroker));
}

void OAcceptHandlerFactory::destroyHandler(NAMESPACE_VOS(IAcceptHandler) *pHdl)
{
	delete pHdl;
};


static void testSocketSource(int i)
{
	cout << "source: " << i << " begin\n";
	cout << flush;

	OConnectorSocket clientSocket;
	NAMESPACE_VOS(OInetSocketAddr)  Addr("localhost", 4444);


	int buffer;		
	VOS_ASSERT(clientSocket.connect(Addr) == OSocket::E_None);
	VOS_ASSERT(clientSocket.write(&i, sizeof(i)) == sizeof(buffer));
	VOS_ASSERT(clientSocket.write(&i, sizeof(i)) == sizeof(i));
	VOS_ASSERT(clientSocket.read(&buffer, sizeof(buffer)) == sizeof(buffer));

	cout << "source: " << i << " read: " << buffer << "\n";
	cout << flush;
	
	VOS_ASSERT(buffer == i);
	
	cout << "source: " << i << " end\n";
	cout << flush;
}	

static void testSocketSink(int i)
{
	char resource[512];
	
	sprintf(resource, "test_channel_broker_%i", i);

	OString sName(resource);
	
	cout << "sink: " << i << " begin\n";
	cout << flush;
	
	ORef<OChannelBroker> rBroker = OChannelBroker::getGlobalChannelBroker();
	ORef<OChannel>		rChannel;

	if (rBroker.isValid())
	{
		OAuthCheck check;
		
		if (i % 2)
		{
			VOS_ASSERT(rBroker->accept(rChannel, sName, NULL) == OChannelBroker::NoError);
		}
		else
		{
			VOS_ASSERT(rBroker->accept(rChannel, sName, &check) == OChannelBroker::NoError);
		}

		if (rChannel.isValid())
		{
		cout << "sink: " << i << " accepted\n";
		cout << flush;
			int buffer;
			
			IStream* iStream = rChannel->getStream();
			
			VOS_ASSERT(iStream->read(&buffer, sizeof(buffer)) == sizeof(buffer));

			cout << "sink: " << i << " read: " << buffer << "\n";
			cout << flush;
			
			VOS_ASSERT(iStream->write(&buffer, sizeof(buffer)) == sizeof(buffer));

			VOS_ASSERT(buffer == i);
		}
	}
	else
		VOS_ASSERT(sal_False);
	cout << "sink: " << i << " end\n";
	cout << flush;
}	


#ifdef UNX
int main( int argc, char * argv[] )
#else
#ifdef OS2
int main( int argc, char * argv[] )
#else
#ifdef WIN
LRESULT CALLBACK TwainWndProc( HWND hWnd,UINT nMsg, WPARAM nPar1, LPARAM nPar2 )
{
	return DefWindowProc( hWnd, nMsg, nPar1, nPar2 );
}
int PASCAL WinMain(HINSTANCE hinstCurrent, HINSTANCE hinstPrevious,
    LPSTR lpszCmdLine, int nCmdShow)
#else
int _cdecl main( int argc, char * argv[] )
#endif
#endif
#endif
{
	if (argc >= 3)
	{
		if (strcmp(argv[1], "source") == 0)
		{
			int i = atoi(argv[2]);
			
			testSocketSource(i);
		}
		else if (strcmp(argv[1], "sink") == 0)
		{
			int i = atoi(argv[2]);
			
			testSocketSink(i);
		}
	}
	else
	{
		OStartupInfo info;
		char exename[512];
		char iBuffer[512];
		int i;
				
		info.getExecutableFile(exename, 512);

		cout << "starting channel manager...\n";
		cout << flush;
		
		VOS_ASSERT(osl_startChannelBroker());

		ORef<OChannelBroker> rBroker = OChannelBroker::getGlobalChannelBroker();
		OAcceptHandlerFactory acceptHandlerFactory(rBroker);
		OInetSocketAddr Addr;

		Addr.setPort(4444);

		OAcceptor Acc(acceptHandlerFactory, Addr,
						ISocketTypes::TProtocol_Ip,
						ISocketTypes::TType_Stream,
						True);

		VOS_ASSERT(Acc.acceptConnections());

		OThread::wait(TTimeValue(1,0));
		
		if ((argc < 2) || (strcmp(argv[1], "standalone") != 0))
		{
			OProcess* pSourceProcs[NUM_OF_TEST_PROCS];
			OProcess* pSinkProcs[NUM_OF_TEST_PROCS];

			for (i = 0; i < NUM_OF_TEST_PROCS; i++)
			{
				sprintf(iBuffer, "%i", i);
				pSourceProcs[i] = new OProcess(exename, "source", iBuffer, NULL);
				
				sprintf(iBuffer, "%i", NUM_OF_TEST_PROCS - (i+1));
				pSinkProcs[i] = new OProcess(exename, "sink", iBuffer, NULL);
				
				pSourceProcs[i]->execute(OProcess::TOption_Normal);
				pSinkProcs[i]->execute(OProcess::TOption_Normal);
			}

			for (i = 0; i < NUM_OF_TEST_PROCS; i++)
			{
				pSourceProcs[i]->join();
				pSinkProcs[i]->join();
				
				delete pSourceProcs[i];
				delete pSinkProcs[i];
			}
		}
		else
		{
			TTimeValue s(1,0);
			sal_Bool bReady = sal_False;
			
			while (!bReady)
			{
				OThread::wait(s);
			}
									
		}
		
		VOS_ASSERT(osl_stopChannelBroker());

		cout << "... channel manager stopped\n";
		cout << flush;
	}
			
	return 0;
}



