/*************************************************************************
 *
 *  $RCSfile: salsound.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ka $ $Date: 2000/11/15 11:48:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SV_SALSOUND_CXX

#define INCLUDE_MMSYSTEM

// ------------
// - Includes -
// ------------

#ifndef _SVWIN_H
#include <tools/svwin.h>
#endif

#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif
#ifndef _SV_SALINST_HXX
#include <salinst.hxx>
#endif
#ifndef _SV_SALSOUND_HXX
#include <salsound.hxx>
#endif

// ---------
// - Names -
// ---------

#define SOUND_LIBNAMEA		"WINMM.DLL"
#define SOUND_LIBNAMEW		L"WINMM.DLL"
#define SOUND_PROCNAMEA 	"mciSendCommandA"
#define SOUND_PROCNAMEW 	"mciSendCommandW"
#define SOUND_WINDOWCLASSA	"SALSOUNDWND"
#define SOUND_WINDOWCLASSW	L"SALSOUNDWND"

// ------------
// - Fnc cast -
// ------------

#ifdef WIN
#define __MCI_CALL _far _pascal
#else
#define __MCI_CALL __stdcall
#endif

#define MCIFNC ((DWORD( __MCI_CALL * )( UINT, UINT, DWORD, DWORD )) SalSound::mpMCIFnc)

// -----------------
// - Statics init. -
// -----------------

HINSTANCE	SalSound::mhMCILib = 0;
ULONG		SalSound::mnSoundState = SOUND_STATE_UNLOADED;
void*		SalSound::mpMCIFnc = NULL;

// -------------------
// - Window-Callback -
// -------------------

void ImplSalHandleMCINotify( HWND hWnd, WPARAM nPar1, LPARAM nPar2 )
{
	SoundNotification	eNotification;
	BOOL				bNotify = TRUE;

	switch ( nPar1 )
	{
		case( MCI_NOTIFY_SUCCESSFUL ):
			eNotification = SOUND_NOTIFY_SUCCESS;
			break;

		case( MCI_NOTIFY_ABORTED ):
			eNotification = SOUND_NOTIFY_ABORTED;
			break;

		case( MCI_NOTIFY_FAILURE ):
			eNotification = SOUND_NOTIFY_ERROR;
			break;

		default:
			bNotify = FALSE;
	}

	if ( bNotify )
		((SalSound*)GetWindowLong( hWnd, 0 ) )->ImplNotify( eNotification, 0 );
}

LRESULT CALLBACK SalSoundWndProcA( HWND hWnd, UINT nMsg, WPARAM nPar1, LPARAM nPar2 )
{
	if ( MM_MCINOTIFY == nMsg )
		ImplSalHandleMCINotify( hWnd, nPar1, nPar2 );
	return DefWindowProcA( hWnd, nMsg, nPar1, nPar2 );
}

LRESULT CALLBACK SalSoundWndProcW( HWND hWnd, UINT nMsg, WPARAM nPar1, LPARAM nPar2 )
{
	if ( MM_MCINOTIFY == nMsg )
		ImplSalHandleMCINotify( hWnd, nPar1, nPar2 );
	return DefWindowProcW( hWnd, nMsg, nPar1, nPar2 );
}

// ------------
// - SalSound -
// ------------

SalSound::SalSound() :
	mpProc			( NULL ),
	mhSoundWnd		( 0 ),
	mnDeviceId		( 0 ),
	mbLoop			( FALSE ),
	mbPaused		( FALSE )
{
}

// ------------------------------------------------------------------------

SalSound::~SalSound()
{
	Stop();

	if ( mnDeviceId )
	{
		// close device
		MCI_GENERIC_PARMS aGenericParams;
		aGenericParams.dwCallback = (DWORD) mhSoundWnd;
		MCIFNC( mnDeviceId, MCI_CLOSE, MCI_WAIT, (DWORD)&aGenericParams );
	}

	// Call Destroy in the main thread, because Create is also called in
	// the main thread and if we don't call this also in the main thread
	// windows doesn't destroy the window
	SalInstance* pInst = GetSalData()->mpFirstInstance;
	if ( pInst )
	{
		ImplSendMessage( pInst->maInstData.mhComWnd, SAL_MSG_DESTROYSOUND,
						 0, (LPARAM)this );
	}
	else
		ImplDestroy();
}

// ------------------------------------------------------------------------

void SalSound::ImplSetError( DWORD nMciErr )
{
	struct aMapper { DWORD nMci; ULONG nSv; };

	ULONG			nError = SOUNDERR_GENERAL_ERROR;
	static aMapper	aErrArr[] =
	{
		{ 0, SOUNDERR_SUCCESS },
		{ MCIERR_CANNOT_LOAD_DRIVER, SOUNDERR_CANNOT_LOAD_DRIVER },
		{ MCIERR_DEVICE_LOCKED, SOUNDERR_DEVICE_LOCKED },
		{ MCIERR_DEVICE_NOT_INSTALLED, SOUNDERR_DEVICE_NOT_FOUND },
		{ MCIERR_DEVICE_NOT_READY, SOUNDERR_DEVICE_NOT_READY },
		{ MCIERR_DEVICE_TYPE_REQUIRED, SOUNDERR_DEVICE_NOT_FOUND },
		{ MCIERR_DRIVER, SOUNDERR_CANNOT_LOAD_DRIVER },
		{ MCIERR_DRIVER_INTERNAL, SOUNDERR_CANNOT_LOAD_DRIVER  },
		{ MCIERR_EXTENSION_NOT_FOUND, SOUNDERR_SOUND_NOT_FOUND },
		{ MCIERR_FILE_NOT_FOUND, SOUNDERR_SOUND_NOT_FOUND },
		{ MCIERR_FILE_READ, SOUNDERR_CANNOT_READ_SOUND },
		{ MCIERR_FILENAME_REQUIRED, SOUNDERR_SOUND_NOT_FOUND },
		{ MCIERR_HARDWARE, SOUNDERR_HARDWARE_ERROR },
		{ MCIERR_INVALID_DEVICE_NAME, SOUNDERR_DEVICE_NOT_FOUND },
		{ MCIERR_INVALID_FILE, SOUNDERR_INVALID_FILE },
		{ MCIERR_OUT_OF_MEMORY, SOUNDERR_OUT_OF_MEMORY },
		{ MCIERR_UNSUPPORTED_FUNCTION, SOUNDERR_UNSUPPORTED_FUNCTION }
	};

	for ( USHORT n=0; n < (sizeof( aErrArr ) / sizeof( aMapper ) ); n++ )
	{
		if ( aErrArr[ n ].nMci == nMciErr )
		{
			nError = aErrArr[ n ].nSv;
			break;
		}
	}

	if ( nError )
		ImplNotify( SOUND_NOTIFY_ERROR, nError );
}

// ------------------------------------------------------------------------

void SalSound::ImplNotify( SoundNotification eNotification, ULONG nError )
{
	if ( mbLoop && (SOUND_NOTIFY_SUCCESS == eNotification) && !nError )
		Play( mnStartTime, mnPlayLen, TRUE );

	if ( mpProc && mpInst )
		mpProc( mpInst, eNotification, nError );
}

// ------------------------------------------------------------------------

BOOL SalSound::ImplCreate()
{
	SalData*	pData = GetSalData();
	BOOL		bRet = FALSE;

	if ( SOUND_STATE_UNLOADED == SalSound::mnSoundState )
	{
		// load library and init fncpointer
		if ( aSalShlData.mbWNT )
		{
			if ( (SalSound::mhMCILib = LoadLibraryW( SOUND_LIBNAMEW )) != 0 &&
				 (SalSound::mpMCIFnc = (void*)GetProcAddress( SalSound::mhMCILib, SOUND_PROCNAMEW )) != 0 )
			{
				WNDCLASSEXW aWndClass;

				memset( &aWndClass, 0, sizeof( aWndClass ) );
				aWndClass.cbSize		= sizeof( aWndClass );
				aWndClass.lpfnWndProc	= SalSoundWndProcW;
				aWndClass.cbWndExtra	= sizeof( SalSound* );
				aWndClass.hInstance 	= pData->mhInst;
				aWndClass.lpszClassName = SOUND_WINDOWCLASSW;
				if ( RegisterClassExW( &aWndClass ) )
				{
					SalSound::mnSoundState = SOUND_STATE_VALID;
					bRet = TRUE;
				}
			}
		}
		else
		{
			if ( (SalSound::mhMCILib = LoadLibraryA( SOUND_LIBNAMEA )) != 0 &&
				 (SalSound::mpMCIFnc = (void*)GetProcAddress( SalSound::mhMCILib, SOUND_PROCNAMEA )) != 0 )
			{
				WNDCLASSEXA aWndClass;

				memset( &aWndClass, 0, sizeof( aWndClass ) );
				aWndClass.cbSize		= sizeof( aWndClass );
				aWndClass.lpfnWndProc	= SalSoundWndProcA;
				aWndClass.cbWndExtra	= sizeof( SalSound* );
				aWndClass.hInstance 	= pData->mhInst;
				aWndClass.lpszClassName = SOUND_WINDOWCLASSA;
				if ( RegisterClassExA( &aWndClass ) )
				{
					SalSound::mnSoundState = SOUND_STATE_VALID;
					bRet = TRUE;
				}
			}
		}

		if ( !bRet )
		{
			if ( SalSound::mhMCILib )
				FreeLibrary( SalSound::mhMCILib );

			SalSound::mnSoundState = SOUND_STATE_INVALID;
			ImplNotify( SOUND_NOTIFY_ERROR, SOUNDERR_CANNOT_LOAD_DRIVER );
		}
	}
	else if ( SOUND_STATE_VALID == SalSound::mnSoundState )
		bRet = TRUE;

	if ( bRet )
	{
		// Create message window
		if ( aSalShlData.mbWNT )
		{
			mhSoundWnd = CreateWindowExW( 0, SOUND_WINDOWCLASSW, L"", 0, 0, 0, 0, 0,
										  HWND_DESKTOP, NULL, pData->mhInst, 0 );
		}
		else
		{
			mhSoundWnd = CreateWindowExA( 0, SOUND_WINDOWCLASSA, "", 0, 0, 0, 0, 0,
										  HWND_DESKTOP, NULL, pData->mhInst, 0 );
		}
		SetWindowLong( mhSoundWnd, 0, (LONG)this );
	}
	else
		mhSoundWnd = 0;

	return bRet;
}

// ------------------------------------------------------------------------

BOOL SalSound::Create()
{
	// Call Create in the main thread, because in the other case the
	// Sound stop, if the calling thread dies.
	SalInstance* pInst = GetSalData()->mpFirstInstance;
	if ( pInst )
	{
		return (BOOL)ImplSendMessage( pInst->maInstData.mhComWnd, SAL_MSG_CREATESOUND,
									  0, (LPARAM)this );
	}
	else
		return ImplCreate();
}

// ------------------------------------------------------------------------

void SalSound::ImplDestroy()
{
	if ( mhSoundWnd )
		DestroyWindow( mhSoundWnd );
	mhSoundWnd = 0;
}

// ------------------------------------------------------------------------

void SalSound::Release()
{
	// free library
	if ( SalSound::mhMCILib )
		FreeLibrary( SalSound::mhMCILib );

	SalSound::mnSoundState = SOUND_STATE_UNLOADED;
}

// ------------------------------------------------------------------------

BOOL SalSound::Init( SalFrame* pFrame, const XubString& rSoundName, ULONG& rSoundLen )
{
	DWORD nMciErr = 0;
	rSoundLen = 0;

	// clear old device
	if ( mnDeviceId )
	{
		Stop();

		MCI_GENERIC_PARMS aGenericParams;
		aGenericParams.dwCallback = (DWORD) mhSoundWnd;
		nMciErr = MCIFNC( mnDeviceId, MCI_CLOSE, MCI_WAIT, (DWORD) &aGenericParams );
		mnDeviceId = 0;
	}

	if ( rSoundName.Len() )
	{
		WORD nDeviceId;
		if ( aSalShlData.mbWNT )
		{
			MCI_OPEN_PARMSW aOpenParams;
			aOpenParams.dwCallback = (DWORD)mhSoundWnd;
			aOpenParams.lpstrElementName = rSoundName.GetBuffer();
			aOpenParams.wDeviceID = 0;
			aOpenParams.lpstrDeviceType = 0;
			aOpenParams.lpstrAlias = 0;
			nMciErr = MCIFNC( 0, MCI_OPEN, MCI_WAIT | MCI_OPEN_ELEMENT, (DWORD)&aOpenParams );
			nDeviceId = aOpenParams.wDeviceID;
		}
		else
		{
			ByteString aSoundName( ImplSalGetWinAnsiString( rSoundName, TRUE ) );
			MCI_OPEN_PARMSA aOpenParams;
			aOpenParams.dwCallback = (DWORD)mhSoundWnd;
			aOpenParams.lpstrElementName = aSoundName.GetBuffer();
			aOpenParams.wDeviceID = 0;
			aOpenParams.lpstrDeviceType = 0;
			aOpenParams.lpstrAlias = 0;
			nMciErr = MCIFNC( 0, MCI_OPEN, MCI_WAIT | MCI_OPEN_ELEMENT, (DWORD)&aOpenParams );
			nDeviceId = aOpenParams.wDeviceID;
		}

		if ( !nMciErr )
		{
			// set time format
			MCI_SET_PARMS aSetParams;
			mnDeviceId = nDeviceId;
			aSetParams.dwTimeFormat = MCI_FORMAT_MILLISECONDS;
			nMciErr = MCIFNC( mnDeviceId, MCI_SET, MCI_WAIT | MCI_SET_TIME_FORMAT, (DWORD)&aSetParams );

			if ( !nMciErr )
			{
				// get length of sound
				MCI_STATUS_PARMS aStatus;
				aStatus.dwItem = MCI_STATUS_LENGTH;
				nMciErr = MCIFNC( mnDeviceId, MCI_STATUS, MCI_WAIT | MCI_STATUS_ITEM, (DWORD)&aStatus );

				if ( !nMciErr )
					rSoundLen = (ULONG)aStatus.dwReturn;
			}
		}
	}

	if ( nMciErr )
		ImplSetError( nMciErr );

	return (nMciErr ? FALSE : TRUE);
}

// ------------------------------------------------------------------------

BOOL SalSound::Init( SalFrame* pFrame, const BYTE* pSound, ULONG nDataLen, ULONG& rSoundLen )
{
	rSoundLen = 0UL;
	ImplSetError( MCIERR_FILE_NOT_FOUND );

	return FALSE;
}

// ------------------------------------------------------------------------

void SalSound::Play( ULONG nStartTime, ULONG nPlayLen, BOOL bLoop )
{
	if ( mnDeviceId )
	{
		DWORD nMciErr = 0;

		if ( !mbPaused )
		{
			MCI_SEEK_PARMS aSeekParams;
			aSeekParams.dwCallback = (DWORD) mhSoundWnd;
			aSeekParams.dwTo = 0;
			nMciErr = MCIFNC( mnDeviceId, MCI_SEEK,MCI_WAIT | MCI_TO, (DWORD) &aSeekParams );
		}

		mnStartTime = nStartTime;
		mnPlayLen = nPlayLen;
		mbLoop = bLoop;
		mbPaused = FALSE;

		if( !nMciErr )
		{
			MCI_PLAY_PARMS	aPlayParams;
			DWORD			nFlags = MCI_NOTIFY;

			aPlayParams.dwCallback = (DWORD)mhSoundWnd;

			if ( nStartTime )
			{
				aPlayParams.dwFrom = nStartTime;
				nFlags |= MCI_FROM;
			}

			if ( nPlayLen != SOUND_PLAYALL )
			{
				aPlayParams.dwTo = nStartTime + nPlayLen;
				nFlags |= MCI_TO;
			}

			nMciErr = MCIFNC( mnDeviceId, MCI_PLAY, nFlags, (DWORD) &aPlayParams );

			if ( !nMciErr )
				mbPaused = FALSE;
		}

		if ( nMciErr )
			ImplSetError( nMciErr );
	}
	else
		ImplSetError( MCIERR_INVALID_FILE );
}

// ------------------------------------------------------------------------

void SalSound::Stop()
{
	if ( mnDeviceId )
	{
		MCI_GENERIC_PARMS aGenericParams;
		aGenericParams.dwCallback = (DWORD)mhSoundWnd;
		mbLoop = mbPaused = FALSE;
		MCIFNC( mnDeviceId, MCI_STOP, MCI_WAIT, (DWORD) &aGenericParams );
	}
}

// ------------------------------------------------------------------------

void SalSound::Pause()
{
	if ( mnDeviceId )
	{
		MCI_GENERIC_PARMS aGenericParams;
		aGenericParams.dwCallback = (DWORD)mhSoundWnd;
		mbPaused = TRUE;
		MCIFNC( mnDeviceId, MCI_PAUSE, MCI_WAIT, (DWORD) &aGenericParams );
	}
}
