/*************************************************************************
 *
 *  $RCSfile: xevthdl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: ssa $ $Date: 2001/11/23 12:22:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <xevthdl.hxx>
#include <rmevents.hxx>
#include <rmwindow.hxx>
#include <event.hxx>
#include <vos/mutex.hxx>
#include <svapp.hxx>
#include <window.hxx>
#include <sot/exchange.hxx>
#include <svdata.hxx>
#include <tools/isolang.hxx>

// ----------------
// - XRmsEventHdl -
// ----------------

XRmsEventHdl::XRmsEventHdl( Window* pEventWindow )
{
	mpEventWindow = pEventWindow;
}

// -----------------------------------------------------------------------------

XRmsEventHdl::~XRmsEventHdl()
{
#ifdef DEBUG
	mpEventWindow = (Window*)NULL;
#endif
}

// -----------------------------------------------------------------------------

void XRmsEventHdl::setWindow(Window* pEventWindow)
{
	mpEventWindow = pEventWindow;
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::MouseButtonUp( sal_Int16 nX, sal_Int16 nY, sal_uInt16 nMode, sal_uInt16 nCode, sal_uInt32 nSysTime ) throw()
{
	if (mpEventWindow != NULL)
	{
		RmMouseEventData* pData = new RmMouseEventData( nX, nY, nMode, nCode, nSysTime );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_MOUSEBUTTONUP, mpEventWindow, pData );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::MouseButtonDown( sal_Int16 nX, sal_Int16 nY, sal_uInt16 nMode, sal_uInt16 nCode, sal_uInt32 nSysTime ) throw()
{
	if (mpEventWindow != NULL)
	{
		RmMouseEventData* pData = new RmMouseEventData( nX, nY, nMode, nCode, nSysTime );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_MOUSEBUTTONDOWN, mpEventWindow, pData );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::MouseMove( sal_Int16 nX, sal_Int16 nY, sal_uInt16 nMode, sal_uInt16 nCode, sal_uInt32 nSysTime ) throw()
{
	if (mpEventWindow != NULL)
	{
		RmMouseEventData* pData = new RmMouseEventData( nX, nY, nMode, nCode, nSysTime );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_MOUSEMOVE, mpEventWindow, pData );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::MouseWheel( sal_Int32 nX, sal_Int32 nY, sal_uInt16 nCode, sal_uInt32 nSysTime, sal_Int32 nDelta, sal_Int32 nNotchDelta, sal_uInt32 nScrollLines, sal_Bool bHorz ) throw()
{
	if (mpEventWindow != NULL)
	{
		RmMouseWheelEventData* pData = new RmMouseWheelEventData( nX, nY, nCode, nSysTime, nDelta, nNotchDelta, nScrollLines, bHorz);
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_MOUSEWHEEL, mpEventWindow, pData );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::KeyInput( sal_uInt16 nKeyCode, sal_uInt16 nChar, sal_uInt16 nCount ) throw()
{
	if (mpEventWindow != NULL)
	{
		RmKeyEventData* pData = new RmKeyEventData( nChar, nKeyCode, nCount );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_KEYINPUT, mpEventWindow, pData );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::KeyUp( sal_uInt16 nKeyCode, sal_uInt16 nChar ) throw()
{
	if (mpEventWindow != NULL)
	{
		RmKeyEventData* pData = new RmKeyEventData( nChar, nKeyCode, 0 );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_KEYUP, mpEventWindow, pData );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::Paint( sal_Int32 nX, sal_Int32 nY, sal_Int32 nWidth, sal_Int32 nHeight ) throw()
{
	if (mpEventWindow != NULL)
	{
		Rectangle* pRect = new Rectangle( Point( nX, nY ), Size( nWidth, nHeight ) );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_PAINT, mpEventWindow, pRect );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::Resize( sal_Int16 nWidth, sal_Int16 nHeight ) throw()
{
	if (mpEventWindow != NULL)
	{
		Size* pSize = new Size( nWidth, nHeight );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_RESIZE, mpEventWindow, pSize );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::GetFocus() throw()
{
	if (mpEventWindow != NULL)
	{
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_GETFOCUS, mpEventWindow, NULL );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::LoseFocus() throw()
{
	if (mpEventWindow != NULL)
	{
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_LOSEFOCUS, mpEventWindow, NULL );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

sal_Bool SAL_CALL XRmsEventHdl::QueryDropFile( NMSP_CLIENT::RmDropFileEvent& rDropFileEvent ) throw()
{
	return !Application::IsInModalMode( );
}

// -----------------------------------------------------------------------------

class ImplRmDropFileEventClass
{
  public:

	DECL_STATIC_LINK( ImplRmDropFileEventClass, CallEvent, void* pEvent );
};

IMPL_STATIC_LINK( ImplRmDropFileEventClass, CallEvent, void*, pEvent )
{
	::vos::OGuard		guard( Application::GetSolarMutex( ) );
	Application*		pApplication = GetpApp( );
	ApplicationEvent*	pAppEvent = ( ApplicationEvent* ) pEvent;

	pApplication -> AppEvent( *pAppEvent );
	delete pAppEvent;

	return 0;
}

// -----------------------------------------------------------------------------

sal_Bool SAL_CALL XRmsEventHdl::DropFile( const NMSP_CLIENT::RmDropFileEvent& rDropFileEvent ) throw()
{
	if( mpEventWindow != NULL )
	{
		const NMSP_CLIENT::FileNameSequence& 	rFileNameSequence = rDropFileEvent.aFileNameSequence;
		String									sEmptyString;
		ApplicationEvent*						pRmDropFileEvent = 0;

		// in OUnoSequence<...> the operator for [] will not be
		// recognized by the compiler (at least under WinNT)

		const OUSTRING* pFileNameSequence = rFileNameSequence.getConstArray();

		for( unsigned int i = 0; i < rFileNameSequence.getLength( ); i++ )
		{
			pRmDropFileEvent = new ApplicationEvent( sEmptyString, sEmptyString, APPEVENT_OPEN_STRING, pFileNameSequence[i] );
			Application::PostUserEvent( STATIC_LINK( NULL, ImplRmDropFileEventClass, CallEvent ), pRmDropFileEvent );
		}
	}

	return TRUE;
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::Close() throw()
{
	if (mpEventWindow != NULL)
	{
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_CLOSE, mpEventWindow, NULL );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::UserEvent( sal_uInt32 EventID, const ::com::sun::star::uno::Any& Parameter ) throw()
{
	if( mpEventWindow )
	{
		Link* pLink = mpEventWindow->ImplGetFrame()->maEvents.Remove( EventID );
		if( pLink )
		{
			pLink->Call( (void*)&Parameter );
			delete pLink;
		}
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::StartExtTextInput() throw()
{
	if (mpEventWindow != NULL)
	{
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_STARTEXTTEXTINPUT, mpEventWindow, NULL );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::ExtTextInput( const ::rtl::OUString& aText, 
                                          const ::com::sun::star::uno::Sequence< sal_uInt16 >& aAttributes,
                                          sal_uInt32 nCursorPos, sal_uInt16 nCursorFlags,
                                          sal_uInt32 nSysTime ) throw()
{
	if (mpEventWindow != NULL)
	{
		const int nCount = aAttributes.getLength();
        USHORT *pTextAttr = nCount ? new USHORT[nCount] : NULL;
		const USHORT*	pAttrSeq = aAttributes.getConstArray();
		for( int i = 0; i < nCount; i++ )
			pTextAttr[ i ] = pAttrSeq[i];

        RmExtTextInputData* pData = new RmExtTextInputData( aText, pTextAttr, nCursorPos, nCursorFlags, nSysTime );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_EXTTEXTINPUT, mpEventWindow, pData );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::EndExtTextInput() throw()
{
	if (mpEventWindow != NULL)
	{
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_ENDEXTTEXTINPUT, mpEventWindow, NULL );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::InputContextChange( const ::rtl::OUString& aLanguage ) throw()
{
	if (mpEventWindow != NULL)
	{
        LanguageType *pL = new LanguageType;
        *pL = ConvertIsoStringToLanguage( aLanguage );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_INPUTCONTEXTCHANGE, mpEventWindow, pL );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::GeometryChange( sal_Int16 nX, sal_Int16 nY, 
										   sal_uInt16 nWidth, sal_uInt16 nHeight )
	throw ()
{
	if (mpEventWindow != NULL)
	{
		Rectangle* pRect = new Rectangle( Point( nX, nY ), Size( nWidth, nHeight ) );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_GEOMETRYCHANGE, mpEventWindow, pRect );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

void SAL_CALL XRmsEventHdl::DecorationChange( sal_uInt16 nLeftDecoration, sal_uInt16 nTopDecoration,
											 sal_uInt16 nRightDecoration, sal_uInt16 nBottomDecoration )
	throw ()
{
	if (mpEventWindow != NULL)
	{
		Rectangle* pRect = new Rectangle( nLeftDecoration, nTopDecoration,
											nRightDecoration, nBottomDecoration );
		ExtRmEvent* pEvent = new ExtRmEvent( RMEVENT_DECORATIONCHANGE, mpEventWindow, pRect );
		ImplPostEvent( pEvent );
	}
}

// -----------------------------------------------------------------------------

