/*************************************************************************
 *
 *  $RCSfile: window.hxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: ssa $ $Date: 2001/10/30 08:27:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_WINDOW_HXX
#define _SV_WINDOW_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_OUTDEV_HXX
#include <outdev.hxx>
#endif
#ifndef _SV_RESID_HXX
#include <resid.hxx>
#endif
#ifndef _SV_POINTR_HXX
#include <pointr.hxx>
#endif
#ifndef _SV_WINTYPES_HXX
#include <wintypes.hxx>
#endif
#ifndef _SV_APPTYPES_HXX
#include <apptypes.hxx>
#endif
#ifndef _VCL_INPUTCTX_HXX
#include <inputctx.hxx>
#endif
// Only for compatibility - because many people outside haven't included event.hxx
#ifndef _VCL_EVENT_HXX
#include <event.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

#ifdef REMOTE_APPSERVER
#include "rvp.hxx"
#endif

class VirtualDevice;
struct ImplDelData;
struct ImplWinData;
struct ImplOverlapData;
struct ImplFrameData;
struct ImplCalcToTopData;
struct SystemEnvData;
struct SystemParentData;
class ImplBorderWindow;
class VirtualDevice;
class Timer;
class Cursor;
class ScrollBar;
class Bitmap;
class Image;
class MouseEvent;
class KeyEvent;
class CommandEvent;
class TrackingEvent;
class HelpEvent;
class DataChangedEvent;
class NotifyEvent;
class SystemWindow;
class SalFrame;
class SalObject;
class UNOWindowData;
// Nur fuer ExecuteDrag:
struct IDataObject;
class AccessObjectRef;
class RmFrameWindow;

class VCLXWindow;

namespace com {
namespace sun {
namespace star {
namespace awt {
    class XWindowPeer;
}
namespace uno {
    class Any;
    class XInterface;
}
namespace datatransfer {
namespace clipboard {
    class XClipboard;
}

namespace dnd {
    class XDragGestureRecognizer;
    class XDragSource;
    class XDropTarget;
} } } } }


// ---------------
// - WindowTypes -
// ---------------

// Type fuer GetWindow()
#define WINDOW_PARENT                   ((USHORT)0)
#define WINDOW_FIRSTCHILD               ((USHORT)1)
#define WINDOW_LASTCHILD                ((USHORT)2)
#define WINDOW_PREV                     ((USHORT)3)
#define WINDOW_NEXT                     ((USHORT)4)
#define WINDOW_FIRSTOVERLAP             ((USHORT)5)
#define WINDOW_LASTOVERLAP              ((USHORT)6)
#define WINDOW_OVERLAP                  ((USHORT)7)
#define WINDOW_PARENTOVERLAP            ((USHORT)8)
#define WINDOW_CLIENT                   ((USHORT)9)
#define WINDOW_REALPARENT               ((USHORT)10)
#define WINDOW_FRAME                    ((USHORT)11)
#define WINDOW_BORDER                   ((USHORT)12)

// Flags for SetPosSizePixel()
#define WINDOW_POSSIZE_X                ((USHORT)0x0001)
#define WINDOW_POSSIZE_Y                ((USHORT)0x0002)
#define WINDOW_POSSIZE_WIDTH            ((USHORT)0x0004)
#define WINDOW_POSSIZE_HEIGHT           ((USHORT)0x0008)
#define WINDOW_POSSIZE_POS              (WINDOW_POSSIZE_X | WINDOW_POSSIZE_Y)
#define WINDOW_POSSIZE_SIZE             (WINDOW_POSSIZE_WIDTH | WINDOW_POSSIZE_HEIGHT)
#define WINDOW_POSSIZE_POSSIZE          (WINDOW_POSSIZE_POS | WINDOW_POSSIZE_SIZE)
#define WINDOW_POSSIZE_ALL              (WINDOW_POSSIZE_POSSIZE)

// Flags for Show()
#define SHOW_NOPARENTUPDATE             ((USHORT)0x0001)
#define SHOW_NOFOCUSCHANGE              ((USHORT)0x0002)
#define SHOW_NOACTIVATE                 ((USHORT)0x0004)

// Flags for SetZOrder()
#define WINDOW_ZORDER_BEFOR             ((USHORT)0x0001)
#define WINDOW_ZORDER_BEHIND            ((USHORT)0x0002)
#define WINDOW_ZORDER_FIRST             ((USHORT)0x0004)
#define WINDOW_ZORDER_LAST              ((USHORT)0x0008)

// Activate-Flags
#define ACTIVATE_MODE_GRABFOCUS         ((USHORT)0x0001)

// ToTop-Flags
#define TOTOP_RESTOREWHENMIN            ((USHORT)0x0001)
#define TOTOP_FOREGROUNDTASK            ((USHORT)0x0002)
#define TOTOP_NOGRABFOCUS               ((USHORT)0x0004)

// Flags for Invalidate
#define INVALIDATE_CHILDREN             ((USHORT)0x0001)
#define INVALIDATE_NOCHILDREN           ((USHORT)0x0002)
#define INVALIDATE_NOERASE              ((USHORT)0x0004)
#define INVALIDATE_UPDATE               ((USHORT)0x0008)
#define INVALIDATE_TRANSPARENT          ((USHORT)0x0010)
#define INVALIDATE_NOTRANSPARENT        ((USHORT)0x0020)
#define INVALIDATE_NOCLIPCHILDREN       ((USHORT)0x4000)
// Temporaer fuer Kompatibilitaet
#define INVALIDATE_BACKGROUND           INVALIDATE_TRANSPARENT

// Flags for Validate
#define VALIDATE_CHILDREN               ((USHORT)0x0001)
#define VALIDATE_NOCHILDREN             ((USHORT)0x0002)

// Flags for Scroll
#define SCROLL_CLIP                     ((USHORT)0x0001)
#define SCROLL_CHILDREN                 ((USHORT)0x0002)
#define SCROLL_NOCHILDREN               ((USHORT)0x0004)
#define SCROLL_NOERASE                  ((USHORT)0x0008)
#define SCROLL_NOINVALIDATE             ((USHORT)0x0010)
#define SCROLL_NOWINDOWINVALIDATE       ((USHORT)0x0020)
#define SCROLL_USECLIPREGION            ((USHORT)0x0040)
#define SCROLL_UPDATE                   ((USHORT)0x0080)

// Flags for ParentClipMode
#define PARENTCLIPMODE_CLIP             ((USHORT)0x0001)
#define PARENTCLIPMODE_NOCLIP           ((USHORT)0x0002)

// Flags for Invert()
#define INVERT_HIGHLIGHT                ((USHORT)0x0001)
#define INVERT_50                       ((USHORT)0x0002)

// Flags for ShowTracking()
#define SHOWTRACK_SMALL                 ((USHORT)0x0001)
#define SHOWTRACK_BIG                   ((USHORT)0x0002)
#define SHOWTRACK_SPLIT                 ((USHORT)0x0003)
#define SHOWTRACK_OBJECT                ((USHORT)0x0004)
#define SHOWTRACK_WINDOW                ((USHORT)0x1000)
#define SHOWTRACK_CLIP                  ((USHORT)0x2000)
#define SHOWTRACK_STYLE                 ((USHORT)0x000F)

// Flags for StartTracking()
#define STARTTRACK_KEYINPUT             ((USHORT)0x0001)
#define STARTTRACK_KEYMOD               ((USHORT)0x0002)
#define STARTTRACK_NOKEYCANCEL          ((USHORT)0x0004)
#define STARTTRACK_SCROLLREPEAT         ((USHORT)0x0008)
#define STARTTRACK_BUTTONREPEAT         ((USHORT)0x0010)
#define STARTTRACK_MOUSEBUTTONDOWN      ((USHORT)0x0020)
#define STARTTRACK_FOCUSCANCEL          ((USHORT)0x0040)

// Flags for StartAutoScroll()
#define AUTOSCROLL_VERT                 ((USHORT)0x0001)
#define AUTOSCROLL_HORZ                 ((USHORT)0x0002)

// Flags for StateChanged()
typedef USHORT StateChangedType;
#define STATE_CHANGE_INITSHOW           ((StateChangedType)1)
#define STATE_CHANGE_VISIBLE            ((StateChangedType)2)
#define STATE_CHANGE_UPDATEMODE         ((StateChangedType)3)
#define STATE_CHANGE_ENABLE             ((StateChangedType)4)
#define STATE_CHANGE_TEXT               ((StateChangedType)5)
#define STATE_CHANGE_IMAGE              ((StateChangedType)6)
#define STATE_CHANGE_DATA               ((StateChangedType)7)
#define STATE_CHANGE_STATE              ((StateChangedType)8)
#define STATE_CHANGE_STYLE              ((StateChangedType)9)
#define STATE_CHANGE_ZOOM               ((StateChangedType)10)
#define STATE_CHANGE_BORDER             ((StateChangedType)11)
#define STATE_CHANGE_TRANSPARENT        ((StateChangedType)12)
#define STATE_CHANGE_CONTROLFONT        ((StateChangedType)13)
#define STATE_CHANGE_CONTROLFOREGROUND  ((StateChangedType)14)
#define STATE_CHANGE_CONTROLBACKGROUND  ((StateChangedType)15)
#define STATE_CHANGE_READONLY           ((StateChangedType)16)
#define STATE_CHANGE_FORMAT             ((StateChangedType)17)
#define STATE_CHANGE_EXTENDEDSTYLE      ((StateChangedType)18)
#define STATE_CHANGE_USER               ((StateChangedType)10000)

// GetFocusFlags
#define GETFOCUS_TAB                    ((USHORT)0x0001)
#define GETFOCUS_CURSOR                 ((USHORT)0x0002)
#define GETFOCUS_MNEMONIC               ((USHORT)0x0004)
#define GETFOCUS_FORWARD                ((USHORT)0x0010)
#define GETFOCUS_BACKWARD               ((USHORT)0x0020)
#define GETFOCUS_AROUND                 ((USHORT)0x0040)
#define GETFOCUS_UNIQUEMNEMONIC         ((USHORT)0x0100)
#define GETFOCUS_INIT                   ((USHORT)0x0200)

// Draw-Flags fuer Draw()
#define WINDOW_DRAW_MONO                ((ULONG)0x00000001)
#define WINDOW_DRAW_NOBORDER            ((ULONG)0x00000002)
#define WINDOW_DRAW_NOCONTROLS          ((ULONG)0x00000004)
#define WINDOW_DRAW_NODISABLE           ((ULONG)0x00000008)
#define WINDOW_DRAW_NOMNEMONIC          ((ULONG)0x00000010)
#define WINDOW_DRAW_NOSELECTION         ((ULONG)0x00000020)
#define WINDOW_DRAW_NOFOCUS             ((ULONG)0x00000040)
#define WINDOW_DRAW_NOBACKGROUND        ((ULONG)0x00000080)

// Border-Styles fuer SetBorder()
#define WINDOW_BORDER_NORMAL            ((USHORT)0x0001)
#define WINDOW_BORDER_MONO              ((USHORT)0x0002)
#define WINDOW_BORDER_ACTIVE            ((USHORT)0x0004)
#define WINDOW_BORDER_DOUBLEOUT         ((USHORT)0x0008)
#define WINDOW_BORDER_NOBORDER          ((USHORT)0x1000)

// DialogControl-Flags
#define WINDOW_DLGCTRL_RETURN           ((USHORT)0x0001)
#define WINDOW_DLGCTRL_WANTFOCUS        ((USHORT)0x0002)
#define WINDOW_DLGCTRL_MOD1TAB          ((USHORT)0x0004)

// GetWindowClipRegionPixel-Flags
#define WINDOW_GETCLIPREGION_NULL       ((USHORT)0x0001)
#define WINDOW_GETCLIPREGION_NOCHILDREN ((USHORT)0x0002)

// EndExtTextInput-Flags
#define EXTTEXTINPUT_END_COMPLETE       ((USHORT)0x0001)
#define EXTTEXTINPUT_END_CANCEL         ((USHORT)0x0002)

// ----------
// - Window -
// ----------

class Window : public OutputDevice
{
private:
    ImplWinData*        mpWinData;
    ImplOverlapData*    mpOverlapData;
    ImplFrameData*      mpFrameData;
#ifndef REMOTE_APPSERVER
    SalFrame*           mpFrame;
    SalObject*          mpSysObj;
    void*               mpRmEvents;
#else
    friend class ExtRmEvent;
    RmFrameWindow*      mpFrame;
    void*               mpSysObj;
    ExtRmEvent*         mpRmEvents;
#endif
    Window*             mpFrameWindow;
    Window*             mpOverlapWindow;
    Window*             mpBorderWindow;
    Window*             mpClientWindow;
    Window*             mpParent;
    Window*             mpRealParent;
    Window*             mpFirstChild;
    Window*             mpLastChild;
    Window*             mpFirstOverlap;
    Window*             mpLastOverlap;
    Window*             mpPrev;
    Window*             mpNext;
    Window*             mpNextOverlap;
    Window*             mpLastFocusWindow;
    Window*             mpDlgCtrlDownWindow;
    void*               mpDummy1;
    void*               mpDummy2;
    void*               mpDummy3;
    void*               mpDummy4;
    ImplDelData*        mpFirstDel;
    void*               mpUserData;
    Cursor*             mpCursor;
    Pointer             maPointer;
    Fraction            maZoom;
    XubString           maText;
    Font*               mpControlFont;
    Color               maControlForeground;
    Color               maControlBackground;
    long                mnLeftBorder;
    long                mnTopBorder;
    long                mnRightBorder;
    long                mnBottomBorder;
    long                mnX;
    long                mnY;
    long                mnDummy1;
    long                mnDummy2;
    Point               maPos;
    ULONG               mnHelpId;
    ULONG               mnUniqId;
    XubString           maHelpText;
    XubString           maQuickHelpText;
    InputContext        maInputContext;
    ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindowPeer > mxWindowPeer;
    VCLXWindow*         mpVCLXWindow;
    Region              maWinRegion;
    Region              maWinClipRegion;
    Region              maInvalidateRegion;
    Region*             mpChildClipRegion;
    Region*             mpPaintRegion;
    WinBits             mnStyle;
    WinBits             mnPrevStyle;
    WinBits             mnExtendedStyle;
    WinBits             mnPrevExtendedStyle;
    WindowType          mnType;
    LanguageType        meDummy1;
    CharSet             meDummy2;
    USHORT              mnWaitCount;
    USHORT              mnPaintFlags;
    USHORT              mnGetFocusFlags;
    USHORT              mnParentClipMode;
    USHORT              mnActivateMode;
    USHORT              mnDlgCtrlFlags;
    USHORT              mnLockCount;
    USHORT              mnDummy3;
    USHORT              mnDummy4;
    BOOL                mbFrame:1,
                        mbBorderWin:1,
                        mbOverlapWin:1,
                        mbSysWin:1,
                        mbDialog:1,
                        mbDockWin:1,
                        mbFloatWin:1,
                        mbPushButton:1,
                        mbVisible:1,
                        mbDisabled:1,
                        mbInputDisabled:1,
                        mbAlwaysEnableInput:1,
                        mbDropDisabled:1,
                        mbNoUpdate:1,
                        mbNoParentUpdate:1,
                        mbActive:1,
                        mbParentActive:1,
                        mbReallyVisible:1,
                        mbReallyShown:1,
                        mbInInitShow:1,
                        mbChildNotify:1,
                        mbChildPtrOverwrite:1,
                        mbNoPtrVisible:1,
                        mbPaintFrame:1,
                        mbInPaint:1,
                        mbMouseMove:1,
                        mbMouseButtonDown:1,
                        mbMouseButtonUp:1,
                        mbKeyInput:1,
                        mbKeyUp:1,
                        mbCommand:1,
                        mbDefPos:1,
                        mbDefSize:1,
                        mbCallMove:1,
                        mbCallResize:1,
                        mbWaitSystemResize:1,
                        mbInitWinClipRegion:1,
                        mbInitChildRegion:1,
                        mbWinRegion:1,
                        mbClipChildren:1,
                        mbClipSiblings:1,
                        mbChildTransparent:1,
                        mbPaintTransparent:1,
                        mbMouseTransparent:1,
                        mbDlgCtrlStart:1,
                        mbFocusVisible:1,
                        mbTrackVisible:1,
                        mbControlForeground:1,
                        mbControlBackground:1,
                        mbAlwaysOnTop:1,
                        mbCompoundControl:1,
                        mbCompoundControlHasFocus:1,
                        mbPaintDisabled:1,
                        mbAllResize:1,
                        mbInDtor:1,
                        mbExtTextInput:1,
                        mbInFocusHdl:1,
                        mbOverlapVisible:1,
                        mbCreatedWithToolkit:1,
                        mbDummy1:1,
                        mbDummy2:1,
                        mbDummy3:1,
                        mbDummy4:1,
                        mbDummy5:1;

    ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > mxDNDListenerContainer;

#if _SOLAR__PRIVATE
#include <window.imp>
#endif

protected:
                        Window( WindowType nType );
void                    SetCompoundControl( BOOL bCompound ) { mbCompoundControl = bCompound; }

            void        ImplCallResize();
            void        ImplCallMove();

public:
                        Window( Window* pParent, WinBits nStyle = 0 );
                        Window( Window* pParent, const ResId& rResId );
                        ~Window();

    virtual void        MouseMove( const MouseEvent& rMEvt );
    virtual void        MouseButtonDown( const MouseEvent& rMEvt );
    virtual void        MouseButtonUp( const MouseEvent& rMEvt );
    virtual void        KeyInput( const KeyEvent& rKEvt );
    virtual void        KeyUp( const KeyEvent& rKEvt );
    virtual void        Paint( const Rectangle& rRect );
    virtual void        Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );
    virtual void        Move();
    virtual void        Resize();
    virtual void        Activate();
    virtual void        Deactivate();
    virtual void        GetFocus();
    virtual void        LoseFocus();
    virtual void        RequestHelp( const HelpEvent& rHEvt );
    virtual void        Command( const CommandEvent& rCEvt );
    virtual void        Tracking( const TrackingEvent& rTEvt );
    virtual void        UserEvent( ULONG nEvent, void* pEventData );
    virtual void        StateChanged( StateChangedType nStateChange );
    virtual void        DataChanged( const DataChangedEvent& rDCEvt );
    virtual long        PreNotify( NotifyEvent& rNEvt );
    virtual long        Notify( NotifyEvent& rNEvt );

    ULONG               PostUserEvent( ULONG nEvent, void* pEventData = NULL );
    ULONG               PostUserEvent( const Link& rLink, void* pCaller = NULL );
    BOOL                PostUserEvent( ULONG& rEventId, ULONG nEvent, void* pEventData = NULL );
    BOOL                PostUserEvent( ULONG& rEventId, const Link& rLink, void* pCaller = NULL );
    void                RemoveUserEvent( ULONG nUserEvent );
    void                PostStateChanged( StateChangedType nState );

    void                IncrementLockCount() { mnLockCount++; }
    void                DecrementLockCount() { mnLockCount--; }
    BOOL                IsLocked( BOOL bChilds = FALSE ) const;
    BOOL                IsUICaptured( BOOL bChilds = FALSE ) const;
    BOOL                IsUserActive( USHORT nTest = USERACTIVE_ALL, BOOL bChilds = FALSE ) const;
    ULONG               GetLastInputInterval() const;

    void                SetStyle( WinBits nStyle );
    WinBits             GetStyle() const { return mnStyle; }
    WinBits             GetPrevStyle() const { return mnPrevStyle; }
    void                SetExtendedStyle( WinBits nExtendedStyle );
    WinBits             GetExtendedStyle() const { return mnExtendedStyle; }
    WinBits             GetPrevExtendedStyle() const { return mnExtendedStyle; }
    void                SetType( WindowType nType ) { mnType = nType; }
    WindowType          GetType() const { return mnType; }
    BOOL                IsSystemWindow() const { return mbSysWin; }
    BOOL                IsDialog() const { return mbDialog; }
    SystemWindow*       GetSystemWindow() const;

    void                EnableAllResize( BOOL bEnable = TRUE ) { mbAllResize = bEnable; }
    BOOL                IsAllResizeEnabled() const { return mbAllResize; }

    void                SetBorderStyle( USHORT nBorderStyle );
    USHORT              GetBorderStyle() const;
    void                GetBorder( long& rLeftBorder, long& rTopBorder,
                                   long& rRightBorder, long& rBottomBorder ) const;
    Size                CalcWindowSize( const Size& rOutSz ) const;
    Size                CalcOutputSize( const Size& rWinSz ) const;
    long                CalcTitleWidth() const;

    void                EnableClipSiblings( BOOL bClipSiblings = TRUE );
    BOOL                IsClipSiblingsEnabled() const { return mbClipSiblings; }

    void                EnableChildTransparentMode( BOOL bEnable = TRUE ) { mbChildTransparent = bEnable; }
    BOOL                IsChildTransparentModeEnabled() const  { return mbChildTransparent; }

    void                SetMouseTransparent( BOOL bTransparent );
    BOOL                IsMouseTransparent() const { return mbMouseTransparent; }
    void                SetPaintTransparent( BOOL bTransparent );
    BOOL                IsPaintTransparent() const { return mbPaintTransparent; }
    void                SetDialogControlStart( BOOL bStart ) { mbDlgCtrlStart = bStart; }
    BOOL                IsDialogControlStart() const { return mbDlgCtrlStart; }
    void                SetDialogControlFlags( USHORT nFlags ) { mnDlgCtrlFlags = nFlags; }
    USHORT              GetDialogControlFlags() const { return mnDlgCtrlFlags; }

    void                SetInputContext( const InputContext& rInputContext );
    const InputContext& GetInputContext() const { return maInputContext; }
    void                EndExtTextInput( USHORT nFlags );
    BOOL                IsExtTextInput() const { return mbExtTextInput; }
    void                SetCursorRect( const Rectangle* pRect = NULL, long nExtTextInputWidth = 0 );
    const Rectangle*    GetCursorRect() const;
    long                GetCursorExtTextInputWidth() const;

    void                EnableChildNotify( BOOL bEnable ) { mbChildNotify = bEnable; }
    BOOL                IsChildNotify() const { return mbChildNotify; }

    void                SetSettings( const AllSettings& rSettings, BOOL bChild = FALSE );
    void                UpdateSettings( const AllSettings& rSettings, BOOL bChild = FALSE );
    void                NotifyAllChilds( DataChangedEvent& rDCEvt );

    void                SetPointFont( const Font& rFont );
    Font                GetPointFont() const;
    void                SetZoomedPointFont( const Font& rFont );
    long                GetDrawPixel( OutputDevice* pDev, long nPixels ) const;
    Font                GetDrawPixelFont( OutputDevice* pDev ) const;
    void                GetFontResolution( long& nDPIX, long& nDPIY ) const;

    void                SetControlFont();
    void                SetControlFont( const Font& rFont );
    Font                GetControlFont() const;
    BOOL                IsControlFont() const { return (mpControlFont != 0); }
    void                SetControlForeground();
    void                SetControlForeground( const Color& rColor );
    Color               GetControlForeground() const { return maControlForeground; }
    BOOL                IsControlForeground() const { return mbControlForeground; }
    void                SetControlBackground();
    void                SetControlBackground( const Color& rColor );
    Color               GetControlBackground() const { return maControlBackground; }
    BOOL                IsControlBackground() const { return mbControlBackground; }

    void                SetParentClipMode( USHORT nMode = 0 );
    USHORT              GetParentClipMode() const;

    void                SetWindowRegionPixel();
    void                SetWindowRegionPixel( const Region& rRegion );
    const Region&       GetWindowRegionPixel() const;
    BOOL                IsWindowRegionPixel() const;
    Region              GetWindowClipRegionPixel( USHORT nFlags = 0 ) const;
    Region              GetPaintRegion() const;
    BOOL                IsInPaint() const { return mbInPaint; }

    void                SetParent( Window* pNewParent );
    Window*             GetParent() const { return mpRealParent; }

    void                Show( BOOL bVisible = TRUE, USHORT nFlags = 0 );
    void                Hide( USHORT nFlags = 0 ) { Show( FALSE, nFlags ); }
    BOOL                IsVisible() const { return mbVisible; }
    BOOL                IsReallyVisible() const { return mbReallyVisible; }
    // Do not use this function, use IsReallyVisible()
    BOOL                IsParentPathVisible() const { return mbReallyVisible; }
    BOOL                IsReallyShown() const { return mbReallyShown; }
    BOOL                IsInInitShow() const { return mbInInitShow; }

    void                Enable( BOOL bEnable = TRUE, BOOL bChild = TRUE );
    void                Disable( BOOL bChild = TRUE ) { Enable( FALSE, bChild ); }
    BOOL                IsEnabled() const { return !mbDisabled; }

    void                EnableInput( BOOL bEnable = TRUE, BOOL bChild = TRUE );
    void                EnableInput( BOOL bEnable, BOOL bChild, BOOL bSysWin,
                                     const Window* pExcludeWindow = NULL );
    BOOL                IsInputEnabled() const { return !mbInputDisabled; }
    void                AlwaysEnableInput( BOOL bAlways, BOOL bChild = TRUE );
    BOOL                IsAlwaysEnableInput() const { return mbAlwaysEnableInput; }

    void                SetActivateMode( USHORT nMode );
    USHORT              GetActivateMode() const { return mnActivateMode; }

    void                ToTop( USHORT nFlags = 0 );
    void                SetZOrder( Window* pRefWindow, USHORT nFlags );
    void                EnableAlwaysOnTop( BOOL bEnable = TRUE );
    BOOL                IsAlwaysOnTopEnabled() const { return mbAlwaysOnTop; }

    virtual void        SetPosSizePixel( long nX, long nY,
                                         long nWidth, long nHeight,
                                         USHORT nFlags = WINDOW_POSSIZE_ALL );
    void                SetPosPixel( const Point& rNewPos );
    Point               GetPosPixel() const { return maPos; }
    void                SetSizePixel( const Size& rNewSize );
    Size                GetSizePixel() const;
    void                SetPosSizePixel( const Point& rNewPos,
                                         const Size& rNewSize );
    void                SetOutputSizePixel( const Size& rNewSize );
    BOOL                IsDefaultPos() const { return mbDefPos; }
    BOOL                IsDefaultSize() const { return mbDefSize; }

    Point               OutputToScreenPixel( const Point& rPos ) const;
    Point               ScreenToOutputPixel( const Point& rPos ) const;
    Point               OutputToAbsoluteScreenPixel( const Point& rPos ) const;
    Point               AbsoluteScreenToOutputPixel( const Point& rPos ) const;
    Rectangle           GetDesktopRectPixel() const;
    Rectangle           GetWindowExtentsRelative( Window *pRelativeWindow );

    void                Scroll( long nHorzScroll, long nVertScroll,
                                USHORT nFlags = 0 );
    void                Scroll( long nHorzScroll, long nVertScroll,
                                const Rectangle& rRect, USHORT nFlags = 0 );
    void                Invalidate( USHORT nFlags = 0 );
    void                Invalidate( const Rectangle& rRect, USHORT nFlags = 0 );
    void                Invalidate( const Region& rRegion, USHORT nFlags = 0 );
    void                Validate( USHORT nFlags = 0 );
    void                Validate( const Rectangle& rRect, USHORT nFlags = 0 );
    void                Validate( const Region& rRegion, USHORT nFlags = 0 );
#ifndef NOOLDSV
    void                InvalidateForeground( USHORT nFlags = 0 )
                            { Invalidate( nFlags | INVALIDATE_NOERASE ); }
    void                InvalidateForeground( const Rectangle& rRect, USHORT nFlags = 0 )
                            { Invalidate( rRect, nFlags | INVALIDATE_NOERASE ); }
#endif
    BOOL                HasPaintEvent() const;
    void                Update();
    void                Flush();
    void                Sync();

    void                EnablePaint( BOOL bEnable ) { mbPaintDisabled = !bEnable; }
    BOOL                IsPaintEnabled() const { return !mbPaintDisabled; }
    void                SetUpdateMode( BOOL bUpdate );
    BOOL                IsUpdateMode() const { return !mbNoUpdate; }
#ifndef NOOLDSV
    BOOL                GetUpdateMode() const { return IsUpdateMode(); }
#endif
    void                SetParentUpdateMode( BOOL bUpdate ) { mbNoParentUpdate = !bUpdate; }
    BOOL                IsParentUpdateMode() const { return !mbNoParentUpdate; }

    void                GrabFocus();
    BOOL                HasFocus() const;
    BOOL                HasChildPathFocus( BOOL bSystemWindow = FALSE ) const;
    BOOL                IsActive() const { return mbActive; }
    USHORT              GetGetFocusFlags() const { return mnGetFocusFlags; }

    BOOL                IsCompoundControl() const { return mbCompoundControl; }
    BOOL                HasCompoundControlFocus() const { return mbCompoundControlHasFocus; }

    static ULONG        SaveFocus();
    static BOOL         EndSaveFocus( ULONG nSaveId, BOOL bRestore = TRUE );

    void                CaptureMouse();
    void                ReleaseMouse();
    BOOL                IsMouseCaptured() const;

    void                SetPointer( const Pointer& rPointer );
    const Pointer&      GetPointer() const { return maPointer; }
    void                EnableChildPointerOverwrite( BOOL bOverwrite = TRUE );
    BOOL                IsChildPointerOverwrite() const { return mbChildPtrOverwrite; }
    void                SetPointerPosPixel( const Point& rPos );
    Point               GetPointerPosPixel();
    void                ShowPointer( BOOL bVisible );
    BOOL                IsPointerVisible() const { return !mbNoPtrVisible; }
    void                EnterWait();
    void                LeaveWait();
    BOOL                IsWait() const { return (mnWaitCount != 0); }

    void                SetCursor( Cursor* pCursor );
    Cursor*             GetCursor() const { return mpCursor; }

    void                SetZoom( const Fraction& rZoom );
    const Fraction&     GetZoom() const { return maZoom; }
    BOOL                IsZoom() const { return maZoom.GetNumerator() != maZoom.GetDenominator(); }
    long                CalcZoom( long n ) const;

    virtual void        SetText( const XubString& rStr );
    virtual XubString   GetText() const;

    void                SetHelpText( const XubString& rHelpText ) { maHelpText = rHelpText; }
    const XubString&    GetHelpText() const;

    void                SetQuickHelpText( const XubString& rHelpText ) { maQuickHelpText = rHelpText; }
    const XubString&    GetQuickHelpText() const { return maQuickHelpText; }

    void                SetHelpId( ULONG nHelpId ) { mnHelpId = nHelpId; }
    ULONG               GetHelpId() const { return mnHelpId; }

    void                SetUniqueId( ULONG nUniqueId ) { mnUniqId = nUniqueId; }
    ULONG               GetUniqueId() const { return mnUniqId; }
    ULONG               GetUniqueOrHelpId() const { return ((mnUniqId) ? mnUniqId : mnHelpId); }

#ifndef NOOLDSV
    BOOL                IsSVLook() const { return TRUE; }
#endif

    Window*             FindWindow( const Point& rPos ) const;

    USHORT              GetChildCount() const;
    Window*             GetChild( USHORT nChild ) const;
    Window*             GetWindow( USHORT nType ) const;
    BOOL                IsChild( const Window* pWindow, BOOL bSystemWindow = FALSE ) const;
    BOOL                IsWindowOrChild( const Window* pWindow, BOOL bSystemWindow = FALSE  ) const;

    void                SetData( void* pNewData ) { mpUserData = pNewData; }
    void*               GetData() const { return mpUserData; }

    // Should be merged in the next top level build !!!
    Bitmap              SnapShot( BOOL bBorder ) const;
    Bitmap              SnapShot() const;

    void                ShowFocus( const Rectangle& rRect );
    void                HideFocus();

    void                Invert( const Rectangle& rRect, USHORT nFlags = 0 );
    void                Invert( const Polygon& rPoly, USHORT nFlags = 0 );

    void                ShowTracking( const Rectangle& rRect,
                                      USHORT nFlags = SHOWTRACK_SMALL );
    void                HideTracking();
    void                InvertTracking( const Rectangle& rRect,
                                        USHORT nFlags = SHOWTRACK_SMALL );
    void                InvertTracking( const Polygon& rPoly, USHORT nFlags = 0 );

    void                StartTracking( USHORT nFlags = 0 );
    void                EndTracking( USHORT nFlags = 0 );
    BOOL                IsTracking() const;

    void                StartAutoScroll( USHORT nFlags );
    void                EndAutoScroll();
    BOOL                IsAutoScroll() const;

    BOOL                HandleScrollCommand( const CommandEvent& rCmd,
                                             ScrollBar* pHScrl = NULL,
                                             ScrollBar* pVScrl = NULL );

    void                SaveBackground( const Point& rPos, const Size& rSize,
                                        const Point& rDestOff, VirtualDevice& rSaveDevice );

    const SystemEnvData*                      GetSystemData() const;
    ::com::sun::star::uno::Any                GetSystemDataAny() const;

    // API zum Setzen/Abfragen des Komponenteninterfaces
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindowPeer > GetComponentInterface( BOOL bCreate = TRUE );
    virtual void                    SetComponentInterface( ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindowPeer > xIFace );

    // Setzen und Abfragen fuer das Toolkit
    VCLXWindow*             GetWindowPeer() const { return mpVCLXWindow; }
    void                    SetWindowPeer( ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindowPeer > xPeer, VCLXWindow* pVCLXWindow );

    // Merken, ob vom Toolkit erzeugt
    BOOL                    IsCreatedWithToolkit() const { return mbCreatedWithToolkit; }
    void                    SetCreatedWithToolkit( BOOL b ) { mbCreatedWithToolkit = b; }

    void                GetAccessObject( AccessObjectRef& rAcc ) const;

    // Drag and Drop interfaces
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDropTarget > GetDropTarget();
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSource > GetDragSource();
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragGestureRecognizer > GetDragGestureRecognizer();
    // only for RVP transmission
    void GetDragSourceDropTarget(::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSource >& xDragSource,::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDropTarget > &xDropTarget );

    // Clipboard/Selection interfaces
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::clipboard::XClipboard > GetClipboard();
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::clipboard::XClipboard > GetSelection();
};

inline void Window::GetBorder( long& rLeftBorder, long& rTopBorder,
                               long& rRightBorder, long& rBottomBorder ) const
{
    rLeftBorder     = mnLeftBorder;
    rTopBorder      = mnTopBorder;
    rRightBorder    = mnRightBorder;
    rBottomBorder   = mnBottomBorder;
}

inline void Window::SetPosPixel( const Point& rNewPos )
{
    SetPosSizePixel( rNewPos.X(), rNewPos.Y(), 0, 0, WINDOW_POSSIZE_POS );
}

inline void Window::SetSizePixel( const Size& rNewSize )
{
    SetPosSizePixel( 0, 0, rNewSize.Width(), rNewSize.Height(),
                     WINDOW_POSSIZE_SIZE );
}

inline void Window::SetPosSizePixel( const Point& rNewPos, const Size& rNewSize )
{
    SetPosSizePixel( rNewPos.X(), rNewPos.Y(),
                     rNewSize.Width(), rNewSize.Height(),
                     WINDOW_POSSIZE_POSSIZE );
}

inline void Window::SetOutputSizePixel( const Size& rNewSize )
{
    SetSizePixel( Size( rNewSize.Width()+mnLeftBorder+mnRightBorder,
                        rNewSize.Height()+mnTopBorder+mnBottomBorder ) );
}

inline Size Window::GetSizePixel() const
{
    return Size( mnOutWidth+mnLeftBorder+mnRightBorder,
                 mnOutHeight+mnTopBorder+mnBottomBorder );
}


#ifndef NOOLDSV
#define GetSmallSizePixel           GetSizePixel
#define PreParentNotify             PreNotify
#define ParentNotify                Notify

#define CTRLTEXT_DRAW_DISABLE       (TEXT_DRAW_DISABLE | TEXT_DRAW_MNEMONIC)
#define CTRLTEXT_DRAW_3DLOOK        (TEXT_DRAW_MNEMONIC)
#define CTRLTEXT_DRAW_ENABLE        (TEXT_DRAW_MNEMONIC)
#endif

#endif // _SV_WINDOW_HXX
