/*************************************************************************
 *
 *  $RCSfile: toolbox.hxx,v $
 *
 *  $Revision: 1.3.10.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/24 14:10:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_TOOLBOX_HXX
#define _SV_TOOLBOX_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_DOCKWIN_HXX
#include <dockwin.hxx>
#endif
#ifndef _SV_IMAGE_HXX
#include <image.hxx>
#endif
#ifndef _SV_TIMER_HXX
#include <timer.hxx>
#endif
#ifndef _SV_VIRDEV_HXX
#include <virdev.hxx>
#endif

class AccessObjectRef;
class UserDrawEvent;

struct ImplToolItem;
struct ImplToolSize;
class  ImplToolItemList;
class  ImplTrackRect;

// -------------------------
// - ToolBoxCustomizeEvent -
// -------------------------

#define TOOLBOX_CUSTOMIZE_RESIZE        ((USHORT)0xFFFE)

class ToolBoxCustomizeEvent
{
private:
    ToolBox*    mpTargetBox;
    void*       mpData;
    USHORT      mnIdFrom;
    USHORT      mnPosTo;

public:
                ToolBoxCustomizeEvent();
                ToolBoxCustomizeEvent( ToolBox* pDropBox,
                                       USHORT nId, USHORT nPos = 0,
                                       void* pUserData = NULL );

    ToolBox*    GetTargetBox() const { return mpTargetBox; }
    USHORT      GetTargetPos() const { return mnPosTo; }
    USHORT      GetSourceId() const { return mnIdFrom; }
    void*       GetData() const { return mpData; }
    BOOL        IsResized() const;
};

inline ToolBoxCustomizeEvent::ToolBoxCustomizeEvent()
{
    mpTargetBox = NULL;
    mnIdFrom    = 0;
    mnPosTo     = 0;
    mpData      = NULL;
}

inline ToolBoxCustomizeEvent::ToolBoxCustomizeEvent( ToolBox* pDropBox,
                                                     USHORT nId, USHORT nPos,
                                                     void* pUserData )
{
    mpTargetBox = pDropBox;
    mnIdFrom    = nId;
    mnPosTo     = nPos;
    mpData      = pUserData;
}

inline BOOL ToolBoxCustomizeEvent::IsResized() const
{
    if ( mnPosTo == TOOLBOX_CUSTOMIZE_RESIZE )
        return TRUE;
    else
        return FALSE;
}

// -------------------
// - ToolBoxItemBits -
// -------------------

typedef USHORT ToolBoxItemBits;

// --------------------------
// - Bits fuer ToolBoxItems -
// --------------------------

// By changes you must also change: tools/vclrsc.hxx
#define TIB_CHECKABLE           ((ToolBoxItemBits)0x0001)
#define TIB_RADIOCHECK          ((ToolBoxItemBits)0x0002)
#define TIB_AUTOCHECK           ((ToolBoxItemBits)0x0004)
#define TIB_LEFT                ((ToolBoxItemBits)0x0008)
#define TIB_AUTOSIZE            ((ToolBoxItemBits)0x0010)
#define TIB_DROPDOWN            ((ToolBoxItemBits)0x0020)
#define TIB_REPEAT              ((ToolBoxItemBits)0x0040)

// -----------------
// - ToolBox-Types -
// -----------------

#define TOOLBOX_STYLE_OUTBUTTON     ((USHORT)0x0001)
#define TOOLBOX_STYLE_HANDPOINTER   ((USHORT)0x0002)
#define TOOLBOX_STYLE_FLAT          ((USHORT)0x0004)

#define TOOLBOX_APPEND              ((USHORT)0xFFFF)
#define TOOLBOX_ITEM_NOTFOUND       ((USHORT)0xFFFF)

// By changes you must also change: tools/vclrsc.hxx
enum ButtonType { BUTTON_SYMBOL, BUTTON_TEXT, BUTTON_SYMBOLTEXT };

// By changes you must also change: tools/vclrsc.hxx
enum ToolBoxItemType { TOOLBOXITEM_DONTKNOW, TOOLBOXITEM_BUTTON,
                       TOOLBOXITEM_SPACE, TOOLBOXITEM_SEPARATOR,
                       TOOLBOXITEM_BREAK };

// -----------
// - ToolBox -
// -----------

class ToolBox : public DockingWindow
{
    friend class FloatingWindow;
    friend class ImplTBDragMgr;

private:
    ImplToolItemList*   mpItemList;
    VirtualDevice*      mpBtnDev;
    ImplToolSize*       mpFloatSizeAry;
    XubString           maCvtStr;
    XubString           maNextToolBoxStr;
    ImageList           maImageList;
    Timer               maTimer;
    Rectangle           maUpperRect;
    Rectangle           maLowerRect;
    Rectangle           maNextToolRect;
    Rectangle           maOutDockRect;
    Rectangle           maInDockRect;
    Rectangle           maPaintRect;
    FloatingWindow*     mpFloatWin;
    ULONG               mnEventId;              // Dummy
    long                mnDX;
    long                mnDY;
    long                mnItemWidth;
    long                mnItemHeight;
    long                mnWinHeight;
    long                mnBorderX;
    long                mnBorderY;
    long                mnLeftBorder;
    long                mnTopBorder;
    long                mnRightBorder;
    long                mnBottomBorder;
    long                mnLastResizeDY;
    long                mnDummy1;
    USHORT              mnOutStyle;
    USHORT              mnHighItemId;
    USHORT              mnCurItemId;
    USHORT              mnDownItemId;
    USHORT              mnCurPos;
    USHORT              mnLines;
    USHORT              mnCurLine;
    USHORT              mnCurLines;
    USHORT              mnVisLines;
    USHORT              mnFloatLines;
    USHORT              mnDockLines;
    USHORT              mnConfigItem;
    USHORT              mnMouseClicks;
    USHORT              mnMouseModifier;
    unsigned int        mbDrag:1,
                        mbSelection:1,
                        mbCommandDrag:1,
                        mbUpper:1,
                        mbLower:1,
                        mbNextTool:1,
                        mbIn:1,
                        mbCalc:1,
                        mbFormat:1,
                        mbFullPaint:1,
                        mbHorz:1,
                        mbScroll:1,
                        mbLastFloatMode:1,
                        mbCustomize:1,
                        mbCustomizeMode:1,
                        mbDragging:1,
                        mbHideStatusText:1,
                        mbMenuStrings:1,
                        mbDummy1:1,
                        mbDummy2:1,
                        mbDummy3:1,
                        mbDummy4:1;
    WindowAlign         meAlign;
    WindowAlign         meDockAlign;
    ButtonType          meButtonType;
    PointerStyle        meLastStyle;
    WinBits             mnWinStyle;
    Link                maClickHdl;
    Link                maDoubleClickHdl;
    Link                maActivateHdl;
    Link                maDeactivateHdl;
    Link                maHighlightHdl;
    Link                maSelectHdl;
    Link                maNextToolBoxHdl;

#if _SOLAR__PRIVATE
#ifdef _SV_TOOLBOX_CXX
    void                ImplInit( Window* pParent, WinBits nStyle );
    void                ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );
    void                ImplLoadRes( const ResId& rResId );
    ImplToolItem*       ImplGetItem( USHORT nId ) const;
    BOOL                ImplCalcItem();
    USHORT              ImplCalcBreaks( long nWidth, long* pMaxLineWidth, BOOL bCalcHorz );
    void                ImplFormat( BOOL bResize = FALSE );
    void                ImplDrawSpin( BOOL bUpperIn, BOOL bLowerIn );
    void                ImplDrawNext( BOOL bIn );
    void                ImplDrawItem( USHORT nPos, BOOL bHighlight = FALSE, BOOL bPaint = FALSE );
    void                ImplInvalidate( BOOL bNewCalc = FALSE, BOOL bFullPaint = FALSE );
    void                ImplUpdateItem( USHORT nIndex = 0xFFFF );
    void                ImplStartCustomizeMode();
    void                ImplEndCustomizeMode();
    const XubString&    ImplConvertMenuString( const XubString& rStr );
    BOOL                ImplHandleMouseMove( const MouseEvent& rMEvt, BOOL bRepeat = FALSE );
    BOOL                ImplHandleMouseButtonUp( const MouseEvent& rMEvt, BOOL bCancel = FALSE );
                        DECL_LINK( ImplUpdateHdl, void* );
#endif
public:
    void                ImplFloatControl( BOOL bStart, FloatingWindow* pWindow = NULL );
#endif

public:
                        ToolBox( Window* pParent, WinBits nStyle = 0 );
                        ToolBox( Window* pParent, const ResId& rResId );
                        ~ToolBox();

    virtual void        Click();
    virtual void        DoubleClick();
    virtual void        Activate();
    virtual void        Deactivate();
    virtual void        Highlight();
    virtual void        Select();
    virtual void        NextToolBox();
    virtual void        Customize( const ToolBoxCustomizeEvent& rCEvt );
    virtual void        UserDraw( const UserDrawEvent& rUDEvt );

    virtual void        MouseButtonDown( const MouseEvent& rMEvt );
    virtual void        MouseButtonUp( const MouseEvent& rMEvt );
    virtual void        MouseMove( const MouseEvent& rMEvt );
    virtual void        Tracking( const TrackingEvent& rTEvt );
    virtual void        Paint( const Rectangle& rRect );
    virtual void        Move();
    virtual void        Resize();
    virtual void        RequestHelp( const HelpEvent& rHEvt );
    virtual long        Notify( NotifyEvent& rNEvt );
    virtual void        Command( const CommandEvent& rCEvt );
    virtual void        StateChanged( StateChangedType nType );
    virtual void        DataChanged( const DataChangedEvent& rDCEvt );

    virtual BOOL        PrepareToggleFloatingMode();
    virtual void        ToggleFloatingMode();
    virtual void        StartDocking();
    virtual BOOL        Docking( const Point& rPos, Rectangle& rRect );
    virtual void        EndDocking( const Rectangle& rRect, BOOL bFloatMode );
    virtual void        Resizing( Size& rSize );

    void                InsertItem( const ResId& rResId,
                                    USHORT nPos = TOOLBOX_APPEND );
    void                InsertItem( USHORT nItemId, const Image& rImage,
                                    ToolBoxItemBits nBits = 0,
                                    USHORT nPos = TOOLBOX_APPEND );
    void                InsertItem( USHORT nItemId, const Image& rImage,
                                    const XubString& rText,
                                    ToolBoxItemBits nBits = 0,
                                    USHORT nPos = TOOLBOX_APPEND );
    void                InsertItem( USHORT nItemId, const XubString& rText,
                                    ToolBoxItemBits nBits = 0,
                                    USHORT nPos = TOOLBOX_APPEND );
    void                InsertWindow( USHORT nItemId, Window* pWindow,
                                      ToolBoxItemBits nBits = 0,
                                      USHORT nPos = TOOLBOX_APPEND );
    void                InsertSpace( USHORT nPos = TOOLBOX_APPEND );
    void                InsertSeparator( USHORT nPos = TOOLBOX_APPEND,
                                         USHORT nPixSize = 0 );
    void                InsertBreak( USHORT nPos = TOOLBOX_APPEND );
    void                RemoveItem( USHORT nPos );
    void                MoveItem( USHORT nItemId, USHORT nNewPos = TOOLBOX_APPEND );
    void                CopyItem( const ToolBox& rToolBox, USHORT nItemId,
                                  USHORT nNewPos = TOOLBOX_APPEND );
    void                CopyItems( const ToolBox& rToolBox );
    void                Clear();
    void                RecalcItems();

    const ImageList&    GetImageList() const { return maImageList; }

    void                SetButtonType( ButtonType eNewType = BUTTON_SYMBOL );
    ButtonType          GetButtonType() const { return meButtonType; }

    void                SetAlign( WindowAlign eNewAlign = WINDOWALIGN_TOP );
    WindowAlign         GetAlign() const { return meAlign; }
    BOOL                IsHorizontal() const { return mbHorz; }

    void                SetLineCount( USHORT nNewLines );
    USHORT              GetLineCount() const { return mnLines; }
    USHORT              GetCurLine() const { return mnCurLine; }
    void                ShowLine( BOOL bNext );

    void                SetNextToolBox( const XubString& rStr );
    const XubString&    GetNextToolBox() const { return maNextToolBoxStr; }

    USHORT              GetItemCount() const;
    ToolBoxItemType     GetItemType( USHORT nPos ) const;
    USHORT              GetItemPos( USHORT nItemId ) const;
    USHORT              GetItemId( USHORT nPos ) const;
    USHORT              GetItemId( const Point& rPos ) const;
    Rectangle           GetItemRect( USHORT nItemId ) const;
    Rectangle           GetScrollRect() const;
    USHORT              GetCurItemId() const { return mnCurItemId; }
    USHORT              GetDownItemId() const { return mnDownItemId; }
    USHORT              GetClicks() const { return mnMouseClicks; }
    USHORT              GetModifier() const { return mnMouseModifier; }

    void                SetItemBits( USHORT nItemId, ToolBoxItemBits nBits );
    ToolBoxItemBits     GetItemBits( USHORT nItemId ) const;

    void                SetItemData( USHORT nItemId, void* pNewData );
    void*               GetItemData( USHORT nItemId ) const;
    void                SetItemImage( USHORT nItemId, const Image& rImage );
    Image               GetItemImage( USHORT nItemId ) const;
    void				SetItemImageAngle( USHORT nItemId, long nAngle10 );
    long				GetItemImageAngle( USHORT nItemId ) const;
    void				SetItemImageMirrorMode( USHORT nItemId, BOOL bMirror );
    BOOL				GetItemImageMirrorMode( USHORT ) const;
    void                SetItemHighImage( USHORT nItemId, const Image& rImage );
    Image               GetItemHighImage( USHORT nItemId ) const;
    void                SetItemText( USHORT nItemId, const XubString& rText );
    const XubString&    GetItemText( USHORT nItemId ) const;
    void                SetItemWindow( USHORT nItemId, Window* pNewWindow );
    Window*             GetItemWindow( USHORT nItemId ) const;

    void                StartSelection();
    void                EndSelection();

    void                SetItemDown( USHORT nItemId, BOOL bDown, BOOL bRelease = TRUE );
    BOOL                IsItemDown( USHORT nItemId ) const;

    void                SetItemState( USHORT nItemId, TriState eState );
    TriState            GetItemState( USHORT nItemId ) const;

    void                CheckItem( USHORT nItemId, BOOL bCheck = TRUE );
    BOOL                IsItemChecked( USHORT nItemId ) const;

    void                EnableItem( USHORT nItemId, BOOL bEnable = TRUE );
    BOOL                IsItemEnabled( USHORT nItemId ) const;

    void                ShowItem( USHORT nItemId, BOOL bVisible = TRUE );
    void                HideItem( USHORT nItemId ) { ShowItem( nItemId, FALSE ); }
    BOOL                IsItemVisible( USHORT nItemId ) const;

    void                SetItemCommand( USHORT nItemId, const XubString& rCommand );
    const XubString&    GetItemCommand( USHORT nItemId ) const;

    void                SetQuickHelpText( USHORT nItemId, const XubString& rText );
    const XubString&    GetQuickHelpText( USHORT nItemId ) const;

    void                SetHelpText( USHORT nItemId, const XubString& rText );
    const XubString&    GetHelpText( USHORT nItemId ) const;

    void                SetHelpId( USHORT nItemId, ULONG nHelpId );
    ULONG               GetHelpId( USHORT nItemId ) const;

    Size                CalcWindowSizePixel() const;
    Size                CalcWindowSizePixel( USHORT nCalcLines ) const;

    void                SetDockingRects( const Rectangle& rOutRect,
                                         const Rectangle& rInRect );
    void                SetFloatingLines( USHORT nFloatLines );
    USHORT              GetFloatingLines() const;

    void                SetBorder( long nX, long nY );
    long                GetBorderX() const { return mnBorderX; }
    long                GetBorderY() const { return mnBorderY; }

    void                SetStyle( WinBits nNewStyle ) { mnWinStyle = nNewStyle; }
    WinBits             GetStyle() const { return mnWinStyle; }

    void                EnableMenuStrings( BOOL bEnable = TRUE ) { mbMenuStrings = (bEnable != 0); }
    BOOL                IsMenuStringsEnabled() const { return mbMenuStrings; }

    void                SetOutStyle( USHORT nNewStyle );
    USHORT              GetOutStyle() const { return mnOutStyle; }

    void                EnableCustomize( BOOL bEnable = TRUE );
    BOOL                IsCustomize() { return mbCustomize; }
    void                StartCustomize( const Rectangle& rRect, void* pData = NULL );
    void                SetCustomizeMode( BOOL );
    BOOL                IsInCustomizeMode() const { return mbCustomizeMode; }

    static void         StartCustomizeMode();
    static void         EndCustomizeMode();
    static BOOL         IsCustomizeMode();

    void                SetHelpText( const XubString& rText )
                            { DockingWindow::SetHelpText( rText ); }
    const XubString&    GetHelpText() const
                            { return DockingWindow::GetHelpText(); }

    void                SetHelpId( ULONG nId )
                            { DockingWindow::SetHelpId( nId ); }
    ULONG               GetHelpId() const
                            { return DockingWindow::GetHelpId(); }

    void                SetClickHdl( const Link& rLink ) { maClickHdl = rLink; }
    const Link&         GetClickHdl() const { return maClickHdl; }
    void                SetDoubleClickHdl( const Link& rLink ) { maDoubleClickHdl = rLink; }
    const Link&         GetDoubleClickHdl() const { return maDoubleClickHdl; }
    void                SetActivateHdl( const Link& rLink ) { maActivateHdl = rLink; }
    const Link&         GetActivateHdl() const { return maActivateHdl; }
    void                SetDeactivateHdl( const Link& rLink ) { maDeactivateHdl = rLink; }
    const Link&         GetDeactivateHdl() const { return maDeactivateHdl; }
    void                SetHighlightHdl( const Link& rLink ) { maHighlightHdl = rLink; }
    const Link&         GetHighlightHdl() const { return maHighlightHdl; }
    void                SetSelectHdl( const Link& rLink ) { maSelectHdl = rLink; }
    const Link&         GetSelectHdl() const { return maSelectHdl; }
    void                SetNextToolBoxHdl( const Link& rLink ) { maNextToolBoxHdl = rLink; }
    const Link&         GetNextToolBoxHdl() const { return maNextToolBoxHdl; }

    void                GetAccessObject( AccessObjectRef& rAcc ) const;
};

inline void ToolBox::CheckItem( USHORT nItemId, BOOL bCheck )
{
    SetItemState( nItemId, (bCheck) ? STATE_CHECK : STATE_NOCHECK );
}

inline BOOL ToolBox::IsItemChecked( USHORT nItemId ) const
{
    return (GetItemState( nItemId ) == STATE_CHECK);
}

inline Size ToolBox::CalcWindowSizePixel() const
{
    return CalcWindowSizePixel( mnLines );
}

inline Rectangle ToolBox::GetScrollRect() const
{
    return maUpperRect.GetUnion( maLowerRect );
}

inline void ToolBox::SetDockingRects( const Rectangle& rOutRect,
                                      const Rectangle& rInRect )
{
    maOutDockRect = rOutRect;
    maInDockRect = rInRect;
}

inline void ToolBox::SetFloatingLines( USHORT nNewLines )
{
    mnFloatLines = nNewLines;
}

inline USHORT ToolBox::GetFloatingLines() const
{
    return mnFloatLines;
}

#endif  // _SV_TOOLBOX_HXX
