/*************************************************************************
 *
 *  $RCSfile: toolbox.h,v $
 *
 *  $Revision: 1.1.1.1.26.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/24 14:10:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_TOOLBOX_H
#define _SV_TOOLBOX_H

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_IMAGE_HXX
#include <image.hxx>
#endif

#ifndef _SV_TOOLBOX_HXX
#include <toolbox.hxx>
#endif

class Window;

// ----------------
// - ImplToolItem -
// ----------------

struct ImplToolItem
{
	Window* 			mpWindow;
	void*				mpUserData;
	Image				maImage;
	Image				maHighImage;
    long				mnImageAngle;
    bool				mbMirrorMode;
	XubString			maText;
	XubString			maQuickHelpText;
	XubString			maHelpText;
	String				maCommandStr;
	ULONG				mnHelpId;
	Rectangle			maRect;
	Rectangle			maCalcRect;
	long				mnNonStdSize;
	long				mnSepSize;
	ToolBoxItemType 	meType;
	ToolBoxItemBits 	mnBits;
	TriState			meState;
	USHORT				mnId;
	BOOL				mbEnabled:1,
						mbVisible:1,
						mbEmptyBtn:1,
						mbShowWindow:1,
						mbBreak:1;

						ImplToolItem();
						ImplToolItem( USHORT nItemId, const Image& rImage,
									  ToolBoxItemBits nItemBits );
						ImplToolItem( USHORT nItemId, const XubString& rTxt,
									  ToolBoxItemBits nItemBits );
						ImplToolItem( USHORT nItemId, const Image& rImage,
									  const XubString& rTxt,
									  ToolBoxItemBits nItemBits );
						~ImplToolItem();
};

DECLARE_LIST( ImplToolItemList, ImplToolItem* );

#endif	// _SV_TOOLBOX_H
