/*************************************************************************
 *
 *  $RCSfile: rmbitmap.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 10:23:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_RMBITMAP_HXX
#define _SV_RMBITMAP_HXX

#include "rvp.hxx"

// ------------
// - RMBitmap -
// ------------

class Bitmap;
class OutputDevice;
class Color;
class BitmapReadAccess;
class ZCodec;
class AlphaMask;

class RMBitmap
{
private:
	REF( NMSP_CLIENT::XRmBitmap )		mxRemoteBitmap;
	REF( NMSP_CLIENT::XRmJavaBitmap )	mxJavaRemoteBitmap;
	Bitmap* 							mpBmp;
	BitmapReadAccess*					mpReadAccess;
	ZCodec* 							mpCompressor;
	Size								maSize;
	USHORT								mnGetBitCount;
	BOOL								mbGetPrepared;

										RMBitmap();
										RMBitmap( const RMBitmap& ) {}
	RMBitmap&							operator=( const RMBitmap& ) { return *this; }

	void								ImplTransferRawData();
	void								ImplGetRawData( Bitmap& rBitmap );
	void								ImplInit();
	BOOL								CreateImpl();
	long								TransferLines( long nStartLine, BOOL bAll );

	BOOL								DrawImpl( OutputDevice* pOut,
												  const Point& rSrcPt, const Size& rSrcSz,
												  const Point& rDestPt, const Size& rDestSz );
	BOOL								DrawMaskImpl( OutputDevice* pOut,
													  const Point& rSrcPt, const Size& rSrcSz,
													  const Point& rDestPt, const Size& rDestSz,
													  const Color& rColor );
	BOOL								DrawExImpl( OutputDevice* pOut,
													const Point& rSrcPt, const Size& rSrcSz,
													const Point& rDestPt, const Size& rDestSz,
													const Bitmap& rMaskOrAlpha, BOOL bAlpha );

public:

										RMBitmap( Bitmap* pBmp );
										~RMBitmap();

	void								Create();
	void								CreateGet( OutputDevice* pOut, const Point& rPt, const Size& rSz );

	REF( NMSP_CLIENT::XRmBitmap )		GetRemoteInst() { return mxRemoteBitmap; }

	BOOL								IsGetPrepared() const { return mbGetPrepared; }
	const Size& 						GetSize() const { return maSize; }
	USHORT								GetBitCount() const { return mnGetBitCount; }

	void								Draw( OutputDevice* pOut,
											  const Point& rSrcPt, const Size& rSrcSz,
											  const Point& rDestPt, const Size& rDestSz );
	void								DrawEx( OutputDevice* pOut,
											  const Point& rSrcPt, const Size& rSrcSz,
											  const Point& rDestPt, const Size& rDestSz,
											  const Bitmap& rMask );
	void								DrawAlpha( OutputDevice* pOut,
											  const Point& rSrcPt, const Size& rSrcSz,
											  const Point& rDestPt, const Size& rDestSz,
											  const AlphaMask& rAlpha );
	void								DrawMask( OutputDevice* pOut,
											  const Point& rSrcPt, const Size& rSrcSz,
											  const Point& rDestPt, const Size& rDestSz,
											  const Color& rColor );
	void								Get( Bitmap& rBitmap );
};

#endif // _SV_RMBITMAP_HXX
