/*************************************************************************
 *
 *  $RCSfile: prntypes.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: pl $ $Date: 2000/09/29 10:00:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_PRNTYPES_HXX
#define _SV_PRNTYPES_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif

// ---------------
// - Orientation -
// ---------------

enum Orientation { ORIENTATION_PORTRAIT, ORIENTATION_LANDSCAPE };

// ---------
// - Paper -
// ---------

typedef USHORT Paper;
#define PAPER_A3					((Paper)0)
#define PAPER_A4					((Paper)1)
#define PAPER_A5					((Paper)2)
#define PAPER_B4					((Paper)3)
#define PAPER_B5					((Paper)4)
#define PAPER_LETTER				((Paper)5)
#define PAPER_LEGAL 				((Paper)6)
#define PAPER_TABLOID				((Paper)7)
#define PAPER_USER					((Paper)8)

// -------------------
// - QueueInfo-Types -
// -------------------

#define QUEUE_STATUS_READY				((ULONG)0x00000001)
#define QUEUE_STATUS_PAUSED 			((ULONG)0x00000002)
#define QUEUE_STATUS_PENDING_DELETION	((ULONG)0x00000004)
#define QUEUE_STATUS_BUSY				((ULONG)0x00000008)
#define QUEUE_STATUS_INITIALIZING		((ULONG)0x00000010)
#define QUEUE_STATUS_WAITING			((ULONG)0x00000020)
#define QUEUE_STATUS_WARMING_UP 		((ULONG)0x00000040)
#define QUEUE_STATUS_PROCESSING 		((ULONG)0x00000080)
#define QUEUE_STATUS_PRINTING			((ULONG)0x00000100)
#define QUEUE_STATUS_OFFLINE			((ULONG)0x00000200)
#define QUEUE_STATUS_ERROR				((ULONG)0x00000400)
#define QUEUE_STATUS_SERVER_UNKNOWN 	((ULONG)0x00000800)
#define QUEUE_STATUS_PAPER_JAM			((ULONG)0x00001000)
#define QUEUE_STATUS_PAPER_OUT			((ULONG)0x00002000)
#define QUEUE_STATUS_MANUAL_FEED		((ULONG)0x00004000)
#define QUEUE_STATUS_PAPER_PROBLEM		((ULONG)0x00008000)
#define QUEUE_STATUS_IO_ACTIVE			((ULONG)0x00010000)
#define QUEUE_STATUS_OUTPUT_BIN_FULL	((ULONG)0x00020000)
#define QUEUE_STATUS_TONER_LOW			((ULONG)0x00040000)
#define QUEUE_STATUS_NO_TONER			((ULONG)0x00080000)
#define QUEUE_STATUS_PAGE_PUNT			((ULONG)0x00100000)
#define QUEUE_STATUS_USER_INTERVENTION	((ULONG)0x00200000)
#define QUEUE_STATUS_OUT_OF_MEMORY		((ULONG)0x00400000)
#define QUEUE_STATUS_DOOR_OPEN			((ULONG)0x00800000)
#define QUEUE_STATUS_POWER_SAVE 		((ULONG)0x01000000)

#define QUEUE_JOBS_DONTKNOW 			((ULONG)0xFFFFFFFF)

// -----------------
// - Printer-Types -
// -----------------

#define PRINTER_CAPABILITIES_SUPPORTDIALOG		((USHORT)1)
#define PRINTER_CAPABILITIES_COPIES 				((USHORT)2)
#define PRINTER_CAPABILITIES_COLLATECOPIES		((USHORT)3)
#define PRINTER_CAPABILITIES_SETORIENTATION 		((USHORT)4)
#define PRINTER_CAPABILITIES_SETPAPERBIN			((USHORT)5)
#define PRINTER_CAPABILITIES_SETPAPERSIZE		((USHORT)6)
#define PRINTER_CAPABILITIES_SETPAPER			((USHORT)7)
#define PRINTER_CAPABILITIES_FAX					((USHORT)8)

#endif	// _SV_PRNTYPES_HXX
