/*************************************************************************
 *
 *  $RCSfile: print.hxx,v $
 *
 *  $Revision: 1.9.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/24 14:10:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_PRINT_HXX
#define _SV_PRINT_HXX

#ifndef _ERRCODE_HXX
#include <tools/errcode.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_OUTDEV_HXX
#include <outdev.hxx>
#endif
#ifndef _SV_PRNTYPES_HXX
#include <prntypes.hxx>
#endif
#ifndef _SV_JOBSET_HXX
#include <jobset.hxx>
#endif
#ifndef _SV_GDIMTF_HXX
#include <gdimtf.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#if defined REMOTE_APPSERVER
#include <vector>
#endif

struct SalPrinterInfoQueue;
class SalInfoPrinter;
class SalPrinter;
class VirtualDevice;
class Window;
class ImplQPrinter;
class RmPrinter;

namespace com { namespace sun { namespace star { namespace uno {
	class Any;
} } } }

#ifdef REMOTE_APPSERVER
namespace com { namespace sun { namespace star { namespace portal { namespace client { struct RmJobSetup; } } } } }
#endif

// -----------------
// - Printer-Types -
// -----------------

#define PAGEQUEUE_ALLPAGES	 0xFFFF

enum PrinterSupport { SUPPORT_SET_ORIENTATION, SUPPORT_SET_PAPERBIN,
					  SUPPORT_SET_PAPERSIZE, SUPPORT_SET_PAPER,
					  SUPPORT_COPY, SUPPORT_COLLATECOPY,
					  SUPPORT_SETUPDIALOG, SUPPORT_FAX };

// ---------------
// - PrinterPage -
// ---------------

class PrinterPage
{
    GDIMetaFile*    mpMtf;
    JobSetup        maJobSetup;
    UINT16          mbNewJobSetup;

public:

    PrinterPage() : mpMtf( new GDIMetaFile() ) {}
    PrinterPage( GDIMetaFile* pMtf, BOOL bNewJobSetup, const JobSetup& rSetup ) :
           mpMtf( pMtf ), mbNewJobSetup( bNewJobSetup ), maJobSetup( rSetup ) {}
    ~PrinterPage() { delete mpMtf; }

    GDIMetaFile*    GetGDIMetaFile() const { return mpMtf; }
    const JobSetup& GetJobSetup() const { return maJobSetup; }
    BOOL            IsNewJobSetup() const { return (mbNewJobSetup != 0); }

    friend SvStream& operator<<( SvStream& rOStm, const PrinterPage& rPage )
    { rOStm << rPage.mbNewJobSetup; rOStm << rPage.maJobSetup; rPage.mpMtf->Write( rOStm ); return rOStm; }
    friend SvStream& operator>>( SvStream& rIStm, PrinterPage& rPage )
    { return rIStm >> rPage.mbNewJobSetup >> rPage.maJobSetup >> *rPage.mpMtf; }
};


// -------------
// - QueueInfo -
// -------------

class QueueInfo
{
	friend class Printer;

private:
	XubString					maPrinterName;
	XubString					maDriver;
	XubString					maLocation;
	XubString					maComment;
	ULONG						mnStatus;
	ULONG						mnJobs;

public:
								QueueInfo();
								QueueInfo( const QueueInfo& rInfo );
								~QueueInfo();

	const XubString&			GetPrinterName() const { return maPrinterName; }
	const XubString&			GetDriver() const { return maDriver; }
	const XubString&			GetLocation() const { return maLocation; }
	const XubString&			GetComment() const { return maComment; }
	ULONG						GetStatus() const { return mnStatus; }
	ULONG						GetJobs() const { return mnJobs; }

	const QueueInfo&			operator==( const QueueInfo& rInfo );

	friend SvStream&			operator>>( SvStream& rIStream, QueueInfo& rInfo );
	friend SvStream&			operator<<( SvStream& rOStream, const QueueInfo& rInfo );
};

// ------------------
// - PrinterOptions -
// ------------------

enum PrinterTransparencyMode
{   
    PRINTER_TRANSPARENCY_AUTO = 0,
    PRINTER_TRANSPARENCY_NONE = 1
};

// -----------------------------------------------------------------------------

enum PrinterGradientMode
{   
    PRINTER_GRADIENT_STRIPES = 0,
    PRINTER_GRADIENT_COLOR = 1
};

// -----------------------------------------------------------------------------

enum PrinterBitmapMode
{   
    PRINTER_BITMAP_OPTIMAL = 0,
    PRINTER_BITMAP_NORMAL = 1,
    PRINTER_BITMAP_RESOLUTION = 2
};

// -----------------------------------------------------------------------------

class PrinterOptions
{
private:

    BOOL                        mbReduceTransparency;
    PrinterTransparencyMode     meReducedTransparencyMode;
    BOOL                        mbReduceGradients;
    PrinterGradientMode         meReducedGradientsMode;
    USHORT                      mnReducedGradientStepCount;
    BOOL                        mbReduceBitmaps;
    PrinterBitmapMode           meReducedBitmapMode;
    USHORT                      mnReducedBitmapResolution;
    BOOL                        mbReducedBitmapsIncludeTransparency;
    BOOL                        mbConvertToGreyscales;

public:
                                   
                                PrinterOptions();
                                ~PrinterOptions();

    BOOL                        IsReduceTransparency() const { return mbReduceTransparency; }
    void                        SetReduceTransparency( BOOL bSet ) { mbReduceTransparency = bSet; }
    
    PrinterTransparencyMode     GetReducedTransparencyMode() const { return meReducedTransparencyMode; }
    void                        SetReducedTransparencyMode( PrinterTransparencyMode eMode ) { meReducedTransparencyMode = eMode; }
    
    BOOL                        IsReduceGradients() const { return mbReduceGradients; }
    void                        SetReduceGradients( BOOL bSet ) { mbReduceGradients = bSet; }
    
    PrinterGradientMode         GetReducedGradientMode() const { return meReducedGradientsMode; }
    void                        SetReducedGradientMode( PrinterGradientMode eMode ) { meReducedGradientsMode = eMode; }

    USHORT                      GetReducedGradientStepCount() const { return mnReducedGradientStepCount; }
    void                        SetReducedGradientStepCount( USHORT nStepCount ) { mnReducedGradientStepCount = nStepCount; }
    
    BOOL                        IsReduceBitmaps() const { return mbReduceBitmaps; }
    void                        SetReduceBitmaps( BOOL bSet ) { mbReduceBitmaps = bSet; }
    
    PrinterBitmapMode           GetReducedBitmapMode() const { return meReducedBitmapMode; }
    void                        SetReducedBitmapMode( PrinterBitmapMode eMode ) { meReducedBitmapMode = eMode; }
    
    USHORT                      GetReducedBitmapResolution() const { return mnReducedBitmapResolution; }
    void                        SetReducedBitmapResolution( USHORT nResolution ) { mnReducedBitmapResolution = nResolution; }

    BOOL                        IsReducedBitmapIncludesTransparency() const { return mbReducedBitmapsIncludeTransparency; }
    void                        SetReducedBitmapIncludesTransparency( BOOL bSet ) { mbReducedBitmapsIncludeTransparency = bSet; }

    BOOL                        IsConvertToGreyscales() const { return mbConvertToGreyscales; }
    void                        SetConvertToGreyscales( BOOL bSet ) { mbConvertToGreyscales = bSet; }
};

// -----------
// - Printer -
// -----------

class Printer : public OutputDevice
{
	friend class OutputDevice;
	friend class ImplQPrinter;

private:
#ifndef REMOTE_APPSERVER
	SalInfoPrinter* 			mpInfoPrinter;
	SalPrinter* 				mpPrinter;
	Printer*					mpJobPrinter;
	SalGraphics*				mpJobGraphics;
#else
	RmPrinter*					mpInfoPrinter;
	RmPrinter*					mpPrinter;
	void*						mpJobPrinter;
	void*						mpJobGraphics;
#endif
	Printer*					mpPrev;
	Printer*					mpNext;
	VirtualDevice*				mpDisplayDev;
	ImplQPrinter*				mpQPrinter;
	GDIMetaFile*				mpQMtf;
    PrinterOptions*             mpPrinterOptions;
#ifndef REMOTE_APPSERVER
	void*						mpDummy2;
#else
    ::std::vector< PrinterPage* >* mpRemotePages;
#endif
	void*						mpDummy3;
	XubString					maPrinterName;
	XubString					maDriver;
	XubString					maPrintFile;
	XubString					maJobName;
	JobSetup					maJobSetup;
	Point						maPageOffset;
	Size						maPaperSize;
	ULONG						mnError;
	USHORT						mnCurPage;
	USHORT						mnCurPrintPage;
	USHORT						mnPageQueueSize;
	USHORT						mnCopyCount;
	BOOL						mbDefPrinter;
	BOOL						mbPrinting;
	BOOL						mbJobActive;
	BOOL						mbCollateCopy;
	BOOL						mbPrintFile;
	BOOL						mbInPrintPage;
	BOOL						mbNewJobSetup;
	BOOL						mbIsQueuePrinter;
	BOOL						mbUserSetupCompleted;
	BOOL						mbUserSetupResult;
	BOOL						mbDummy3;
	Link						maErrorHdl;
	Link						maStartPrintHdl;
	Link						maEndPrintHdl;
	Link						maPrintPageHdl;

#ifdef REMOTE_APPSERVER
	DECL_LINK( UserSetupCompleted, ::com::sun::star::uno::Any* );
#endif

#if _SOLAR__PRIVATE
#ifdef _SV_PRINT_CXX
	void						ImplInitData();
	void						ImplInit( SalPrinterQueueInfo* pInfo );
	void						ImplInitDisplay( const Window* pWindow );
	static SalPrinterQueueInfo* ImplGetQueueInfo( const XubString& rPrinterName,
												  const XubString* pDriver );
	void						ImplUpdatePageData();
	void						ImplUpdateFontList();
#endif // _SV_PRINT_CXX
#ifndef REMOTE_APPSERVER

								DECL_LINK( ImplDestroyPrinterAsync, void* );
public:

	void						ImplEndPrint();
#else
public:
    void PrintRemotePage( ULONG nPage );
    void GetRemotePageSetup( ULONG nPage, ::com::sun::star::portal::client::RmJobSetup& rSetup );
#endif // REMOTE_APPSERVER
#endif // __PRIVATE

#ifdef _SPOOLPRINTER_EXT
public:
	void						GetPreparedMetaFile( const GDIMetaFile& rInMtf, GDIMetaFile& rOutMtf, 
                                                     long nMaxBmpDPIX, long nMaxBmpDPIY );
    Bitmap                      GetPreparedBitmap( const Point& rDstPt, const Size& rDstSz, 
                                                   const Point& rSrcPt, const Size& rSrcSz,
                                                   const Bitmap& rBmp, long nMaxBmpDPIX, long nMaxBmpDPIY );
    BitmapEx                    GetPreparedBitmapEx( const Point& rDstPt, const Size& rDstSz,
                                                     const Point& rSrcPt, const Size& rSrcSz,
                                                     const BitmapEx& rBmpEx, long nMaxBmpDPIX, long nMaxBmpDPIY );
    void                        DrawGradientEx( OutputDevice* pOut, const Rectangle& rRect, const Gradient& rGradient );
    void                        DrawGradientEx( OutputDevice* pOut, const PolyPolygon& rPolyPoly, const Gradient& rGradient );

#endif // _SPOOLPRINTER_EXT

protected:

	void						SetSelfAsQueuePrinter( BOOL bQueuePrinter ) { mbIsQueuePrinter = bQueuePrinter; }
	BOOL						IsQueuePrinter() const { return mbIsQueuePrinter; }

public:
								Printer();
								Printer( const Window* pWindow );
								Printer( const JobSetup& rJobSetup );
								Printer( const QueueInfo& rQueueInfo );
								Printer( const XubString& rPrinterName );
	virtual 					~Printer();

	static USHORT				GetQueueCount();
	static const QueueInfo& 	GetQueueInfo( USHORT nQueue );
	static const QueueInfo& 	GetQueueInfo( USHORT nQueue, BOOL bStatus );
	static XubString			GetDefaultPrinterName();

	virtual void				Error();
	virtual void				StartPrint();
	virtual void				EndPrint();
	virtual void				PrintPage();

	const XubString&			GetName() const 			{ return maPrinterName; }
	const XubString&			GetDriverName() const		{ return maDriver; }
	BOOL						IsDefPrinter() const		{ return mbDefPrinter; }
	BOOL						IsDisplayPrinter() const	{ return mpDisplayDev != NULL; }
	BOOL						IsValid() const 			{ return !IsDisplayPrinter(); }

	ULONG						GetCapabilities( USHORT nType ) const;
	BOOL						HasSupport( PrinterSupport eFeature,
											BOOL bInJob = FALSE ) const;

	BOOL						SetJobSetup( const JobSetup& rSetup );
	const JobSetup& 			GetJobSetup() const { return maJobSetup; }
	String						GetJobValue( const String& rKey ) const { return maJobSetup.GetValue( rKey ); }
	void						SetJobValue( const String& rKey, const String& rValue ) { maJobSetup.SetValue( rKey, rValue ); }

	BOOL						Setup( Window* pWindow = NULL );
	BOOL						SetPrinterProps( const Printer* pPrinter );

    void                        SetPrinterOptions( const PrinterOptions& rOptions ) { *mpPrinterOptions = rOptions; }
    const PrinterOptions&       GetPrinterOptions() const { return( *mpPrinterOptions ); }

	BOOL						SetOrientation( Orientation eOrient );
	Orientation 				GetOrientation() const;
	BOOL						SetPaperBin( USHORT nPaperBin );
	USHORT						GetPaperBin() const;
	BOOL						SetPaper( Paper ePaper );
	BOOL						SetPaperSizeUser( const Size& rSize );
	Paper						GetPaper() const;

	USHORT						GetPaperBinCount() const;
	XubString					GetPaperBinName( USHORT nPaperBin ) const;

	const Size& 				GetPaperSizePixel() const { return maPaperSize; }
	Size						GetPaperSize() const { return PixelToLogic( maPaperSize ); }
	const Point&				GetPageOffsetPixel() const { return maPageOffset; }
	Point						GetPageOffset() const { return PixelToLogic( maPageOffset ); }

	BOOL						SetCopyCount( USHORT nCopy, BOOL bCollate = FALSE );
	USHORT						GetCopyCount() const { return mnCopyCount; }
	BOOL						IsCollateCopy() const { return mbCollateCopy; }

	USHORT						GetCurPrintPage() const { return mnCurPrintPage; }
	BOOL						IsPrinting() const { return mbPrinting; }

	void						SetPrintFile( const XubString& rFileName ) { maPrintFile = rFileName; }
	const XubString&			GetPrintFile() const { return maPrintFile; }
	void						EnablePrintFile( BOOL bEnable ) { mbPrintFile = bEnable; }
	BOOL						IsPrintFileEnabled() const { return mbPrintFile; }
	BOOL						StartJob( const XubString& rJobName );
	BOOL						EndJob();
	BOOL						AbortJob();
	const XubString&			GetCurJobName() const { return maJobName; }
	USHORT						GetCurPage() const { return mnCurPage; }
	BOOL						IsJobActive() const { return mbJobActive; }
	BOOL						StartPage();
	BOOL						EndPage();

	void						SetPageQueueSize( USHORT nPages ) { mnPageQueueSize = nPages; }
	USHORT						GetPageQueueSize() const { return mnPageQueueSize; }

	ULONG						GetError() const { return ERRCODE_TOERROR(mnError); }
	ULONG						GetErrorCode() const { return mnError; }

	void						SetErrorHdl( const Link& rLink ) { maErrorHdl = rLink; }
	const Link& 				GetErrorHdl() const { return maErrorHdl; }
	void						SetStartPrintHdl( const Link& rLink ) { maStartPrintHdl = rLink; }
	const Link& 				GetStartPrintHdl() const { return maStartPrintHdl; }
	void						SetEndPrintHdl( const Link& rLink ) { maEndPrintHdl = rLink; }
	const Link& 				GetEndPrintHdl() const	 { return maEndPrintHdl;   }
	void						SetPrintPageHdl( const Link& rLink ) { maPrintPageHdl = rLink; }
	const Link& 				GetPrintPageHdl() const  { return maPrintPageHdl;  }
};

#endif	// _SV_PRINT_HXX
