/*************************************************************************
 *
 *  $RCSfile: edit.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: mt $ $Date: 2001/11/30 13:26:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_EDIT_HXX
#define _SV_EDIT_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_TIMER_HXX
#include <timer.hxx>
#endif
#ifndef _SV_CTRL_HXX
#include <ctrl.hxx>
#endif
#ifndef _SV_MENU_HXX
#include <menu.hxx>
#endif

#ifndef _VCL_DNDHELP_HXX
#include <dndhelp.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif

namespace com {
namespace sun {
namespace star {
namespace i18n {
	class XBreakIterator;
}}}}

class ImplSubEdit;
struct DDInfo;
struct Impl_IMEInfos;

// --------------
// - Edit-Types -
// --------------

#define EDIT_NOLIMIT				STRING_LEN
#define EDIT_UPDATEDATA_TIMEOUT 	350

typedef XubString (*FncGetSpecialChars)( Window* pWin, const Font& rFont );

// --------
// - Edit -
// --------

enum AutocompleteAction{ AUTOCOMPLETE_KEYINPUT, AUTOCOMPLETE_TABFORWARD, AUTOCOMPLETE_TABBACKWARD };

class Edit : public Control, public vcl::unohelper::DragAndDropClient
{
private:
	Edit*				mpSubEdit;
	Timer*				mpUpdateDataTimer;
	DDInfo* 			mpDDInfo;
	Impl_IMEInfos*		mpIMEInfos;
	XubString			maText;
	XubString			maSaveValue;
	XubString			maUndoText;
	XubString			maRedoText;
	long				mnXOffset;
	Selection			maSelection;
	USHORT				mnAlign;
	xub_StrLen			mnMaxTextLen;
	AutocompleteAction	meAutocompleteAction;
	xub_Unicode 		mcEchoChar;
	BOOL				mbModified:1,
						mbInternModified:1,
						mbReadOnly:1,
						mbInsertMode:1,
						mbClickedInSelection:1,
						mbIsSubEdit:1,
						mbInMBDown:1,
						mbActivePopup:1;
	Link				maModifyHdl;
	Link				maUpdateDataHdl;
	Link				maAutocompleteHdl;

#if _SOLAR__PRIVATE
#ifdef _SV_EDIT_CXX
						DECL_LINK( ImplUpdateDataHdl, Timer* );

	void				ImplInitData();
	void				ImplModified();
	XubString			ImplGetText() const;
	void				ImplRepaint( xub_StrLen nStart = 0, xub_StrLen nEnd = STRING_LEN );
	void				ImplDelete( const Selection& rSelection, BYTE nDirection, BYTE nMode );
	void				ImplSetText( const XubString& rStr, const Selection* pNewSelection = 0 );
	void				ImplInsertText( const XubString& rStr, const Selection* pNewSelection = 0 );
    String              ImplGetValidString( const String& rString ) const;
	void				ImplClearBackground( long nXStart, long nXEnd );
	void				ImplShowCursor( BOOL bOnlyIfVisible = TRUE );
	void				ImplAlign();
	void				ImplAlignAndPaint( xub_StrLen nChangedFrom, long nOldWidth );
	xub_StrLen			ImplGetCharPos( const Point& rWindowPos );
	void				ImplSetCursorPos( xub_StrLen nChar, BOOL bSelect );
	void				ImplShowDDCursor();
	void				ImplHideDDCursor();
	BOOL				ImplHandleKeyEvent( const KeyEvent& rKEvt );
    void                ImplCopy( ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::clipboard::XClipboard >& rxClipboard );
    void                ImplPaste( ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::clipboard::XClipboard >& rxClipboard );
#endif
#endif

protected:
#if _SOLAR__PRIVATE
	void				ImplInit( Window* pParent, WinBits nStyle );
	WinBits 			ImplInitStyle( WinBits nStyle );
	void				ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );
	void				ImplLoadRes( const ResId& rResId );
	void				ImplSetSelection( const Selection& rSelection, BOOL bPaint = TRUE );
#endif

	::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSourceListener > mxDnDListener;

    // DragAndDropClient
    virtual void        dragGestureRecognized( const ::com::sun::star::datatransfer::dnd::DragGestureEvent& dge ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        dragDropEnd( const ::com::sun::star::datatransfer::dnd::DragSourceDropEvent& dsde ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        drop( const ::com::sun::star::datatransfer::dnd::DropTargetDropEvent& dtde ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        dragEnter( const ::com::sun::star::datatransfer::dnd::DropTargetDragEnterEvent& dtdee ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        dragExit( const ::com::sun::star::datatransfer::dnd::DropTargetEvent& dte ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        dragOver( const ::com::sun::star::datatransfer::dnd::DropTargetDragEvent& dtde ) throw (::com::sun::star::uno::RuntimeException);


						Edit( WindowType nType );

public:
						Edit( Window* pParent, WinBits nStyle = WB_BORDER );
						Edit( Window* pParent, const ResId& rResId );
						~Edit();

	virtual void		MouseButtonDown( const MouseEvent& rMEvt );
	virtual void		MouseButtonUp( const MouseEvent& rMEvt );
	virtual void		KeyInput( const KeyEvent& rKEvt );
	virtual void		Paint( const Rectangle& rRect );
	virtual void		Resize();
	virtual void		Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );
	virtual void		GetFocus();
	virtual void		LoseFocus();
	virtual void		Tracking( const TrackingEvent& rTEvt );
	virtual void		Command( const CommandEvent& rCEvt );
	virtual void		StateChanged( StateChangedType nType );
	virtual void		DataChanged( const DataChangedEvent& rDCEvt );

	virtual void		Modify();
	virtual void		UpdateData();

	static BOOL 		IsCharInput( const KeyEvent& rKEvt );

	void				SetModifyFlag();
	void				ClearModifyFlag();
	BOOL				IsModified() const { return mpSubEdit ? mpSubEdit->mbModified : mbModified; }

	void				EnableUpdateData( ULONG nTimeout = EDIT_UPDATEDATA_TIMEOUT );
	void				DisableUpdateData() { delete mpUpdateDataTimer; mpUpdateDataTimer = NULL; }
	ULONG				IsUpdateDataEnabled() const;

	void				SetEchoChar( xub_Unicode c );
	xub_Unicode 		GetEchoChar() const { return mcEchoChar; }

	void				SetReadOnly( BOOL bReadOnly = TRUE );
	BOOL				IsReadOnly() const { return mbReadOnly; }

	void				SetInsertMode( BOOL bInsert );
	BOOL				IsInsertMode() const;

	void				SetMaxTextLen( xub_StrLen nMaxLen = EDIT_NOLIMIT );
	xub_StrLen			GetMaxTextLen() const { return mnMaxTextLen; }

	void				SetSelection( const Selection& rSelection );
	const Selection&	GetSelection() const;

	void				ReplaceSelected( const XubString& rStr );
	void				DeleteSelected();
	XubString			GetSelected() const;

	void				Cut();
	void				Copy();
	void				Paste();
	void				Undo();

	virtual void		SetText( const XubString& rStr );
	virtual void		SetText( const XubString& rStr, const Selection& rNewSelection );
	virtual XubString	GetText() const;

	void				SaveValue() { maSaveValue = GetText(); }
	const XubString&	GetSavedValue() const { return maSaveValue; }

	void				SetModifyHdl( const Link& rLink ) { maModifyHdl = rLink; }
	const Link& 		GetModifyHdl() const { return maModifyHdl; }
	void				SetUpdateDataHdl( const Link& rLink ) { maUpdateDataHdl = rLink; }
	const Link& 		GetUpdateDataHdl() const { return maUpdateDataHdl; }

	void				SetSubEdit( Edit* pEdit );
	Edit*				GetSubEdit() const { return mpSubEdit; }

	void				SetAutocompleteHdl( const Link& rHdl );
	const Link& 		GetAutocompleteHdl() const { return maAutocompleteHdl; }
	AutocompleteAction	GetAutocompleteAction() const { return meAutocompleteAction; }

	Size				CalcMinimumSize() const;
	Size				CalcSize( USHORT nChars ) const;
	xub_StrLen			GetMaxVisChars() const;

	static void 				SetGetSpecialCharsFunction( FncGetSpecialChars fn );
	static FncGetSpecialChars	GetGetSpecialCharsFunction();

	static PopupMenu*	CreatePopupMenu();
	static void 		DeletePopupMenu( PopupMenu* pMenu );
};

inline ULONG Edit::IsUpdateDataEnabled() const
{
	if ( mpUpdateDataTimer )
		return mpUpdateDataTimer->GetTimeout();
	else
		return FALSE;
}

#endif	// _SV_EDIT_HXX
