/*************************************************************************
 *
 *  $RCSfile: certpage.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:04:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CERTPAGE_HXX
#define _CERTPAGE_HXX

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#include "certdlg.hxx"

// class CertificatePage -------------------------------------------------

class CertificatePage : public Window
{
private:
	CertAcceptDialog*	m_pCertDialog;

public:
	CertificatePage( CertAcceptDialog* pParent, const ResId& rResId ) :
		Window( pParent, rResId ), m_pCertDialog( pParent ) {}

	virtual void				SetServerName( FixedText* pTextToRepl );
	virtual FixedText*			GetTextToReplace();

	const INetCoreCertificate&	GetCertificate() const { return m_pCertDialog->GetCertificate(); }

	BYTE						GetAcceptState() const { return m_pCertDialog->GetAcceptState(); }
	void						SetAcceptState( BYTE nNew ) { m_pCertDialog->SetAcceptState( nNew ); }

	BOOL						GetWarningState() const { return m_pCertDialog->GetWarningState(); }
	void						SetWarningState( BOOL bNew ) { m_pCertDialog->SetWarningState( bNew ); }
};

// class OpenPage --------------------------------------------------------

class OpenPage : public CertificatePage
{
private:
	FixedText			m_aText1;
	FixedText			m_aText2;

public:
	OpenPage( CertAcceptDialog* pParent, ResMgr* pResMgr );

	virtual FixedText* GetTextToReplace();
};

// class ShowCertPage ----------------------------------------------------

class ShowCertPage : public CertificatePage
{
private:
	FixedText		m_aText1;
	FixedText		m_aText2;
	FixedText		m_aText3;
	FixedText		m_aText4;
	FixedText		m_aText5;
	FixedText		m_aFTCertOwner;
	FixedText		m_aFTCertAuthority;
	FixedText		m_aFTCertEncrypt;
	FixedLine		m_aLine1;
	FixedLine		m_aLine2;
	PushButton		m_aPBDetail;

	ResMgr*			m_pResMgr;

	DECL_LINK( ClickHdl, PushButton* );

public:
	ShowCertPage( CertAcceptDialog* pParent, ResMgr* pResMgr );

	virtual FixedText*	GetTextToReplace();
};

// class AcceptCertPage --------------------------------------------------

class AcceptCertPage : public CertificatePage
{
private:
	FixedText		m_aText1;
	FixedText		m_aText2;
	RadioButton		m_aRBOnce;
	RadioButton		m_aRBNone;
	RadioButton		m_aRBEver;

	DECL_LINK( ClickHdl, Control* );

public:
	AcceptCertPage( CertAcceptDialog* pParent, ResMgr* pResMgr );

	virtual FixedText*	GetTextToReplace();
};

// class WarnCertPage ----------------------------------------------------

class WarnCertPage : public CertificatePage
{
private:
	FixedText		m_aText1;
	FixedText		m_aText2;
	FixedText		m_aText3;
	CheckBox		m_aCBWarn;

	DECL_LINK( ClickHdl, Control* );

public:
	WarnCertPage( CertAcceptDialog* pParent, ResMgr* pResMgr );

	virtual FixedText*	GetTextToReplace();
};

// class ReadyCertPage ---------------------------------------------------

class ReadyCertPage : public CertificatePage
{
	FixedText		m_aText1;
	FixedText		m_aText2;
	FixedText		m_aText3;
	FixedText		m_aText4;
	String			m_aWarnOn;
	String			m_aWarnOff;

public:
	ReadyCertPage( CertAcceptDialog* pParent, ResMgr* pResMgr );
};


#endif /* _CERTPAGE_HXX */

