/*************************************************************************
 *
 *  $RCSfile: ucbconnector.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/26 09:54:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <cstdio>
#include <cstdlib>
#include <exception>
#include <new>

#ifndef _COM_SUN_STAR_BRIDGE_XUNOURLRESOLVER_HPP_
#include <com/sun/star/bridge/XUnoUrlResolver.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPARAMETERIZEDCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XParameterizedContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XNAMINGSERVICE_HPP_
#include <com/sun/star/uno/XNamingService.hpp>
#endif
#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif
#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif
#ifndef _RTL_TEXTENC_H_
#include <rtl/textenc.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _COMPHELPER_REGPATHHELPER_HXX_
#include <comphelper/regpathhelper.hxx>
#endif
#ifndef _VOS_DIAGONSE_H_
#include <vos/diagnose.hxx>
#endif

using namespace com::sun::star;

//============================================================================
//
//  ProgramException
//
//============================================================================

namespace {

class ProgramException: public std::exception
{
public:
	inline ProgramException(rtl::OString const & rWhat) throw ()
	{ try { m_aWhat = rWhat; } catch (...) {} }
		// 'try: m_aWhat(rWhat) {} catch (...) {}' won't work on MSVC++6

	inline ProgramException(ProgramException const & rOther) throw ()
	{ try { m_aWhat = rOther.m_aWhat; } catch (...) {} }
		// 'try: m_aWhat(rOther.m_aWhat) {} catch (...) {}' won't work on
		// MSVC++6

	virtual inline ~ProgramException() throw ()
	{} // 'try {} catch (...) {}' won't work on MSVC++6

	inline ProgramException &
	operator =(ProgramException const & rOther) throw ()
	{ try { m_aWhat = rOther.m_aWhat; } catch (...) {} return *this; }
		// 'try { m_aWhat = rOther.m_aWhat; return *this; } catch (...) {}'
		// won't work on MSVC++6

	virtual inline char const * what() const throw ()
	{ return m_aWhat.getStr(); }
		// 'try { return m_aWhat.getStr(); } catch (...) {}' won't work on
		// MSVC++6

private:
	rtl::OString m_aWhat;
};

}

//============================================================================
//
//  Resolver
//
//============================================================================

namespace {

class Resolver
{
public:
	Resolver()
		throw (ProgramException, uno::RuntimeException, std::bad_alloc);

	inline uno::Reference< bridge::XUnoUrlResolver > getResolver() const
		throw ()
	{ return m_xResolver; }

private:
	uno::Reference< bridge::XUnoUrlResolver > m_xResolver;
};

}

//============================================================================
Resolver::Resolver()
	throw (ProgramException, uno::RuntimeException, std::bad_alloc)
{
	uno::Reference< lang::XMultiServiceFactory > xLocalFactory;
	try
	{
		xLocalFactory = cppu::createRegistryServiceFactory(
			                comphelper::getPathToSystemRegistry(),
							comphelper::getPathToUserRegistry());
	}
	catch (uno::RuntimeException const &) { throw; }
	catch (uno::Exception const &) {}
	if (!xLocalFactory.is())
		throw ProgramException(
			      rtl::OString(
					  RTL_CONSTASCII_STRINGPARAM(
						  "bad createRegistryServiceFactory()")));

	try
	{
		m_xResolver
			= uno::Reference< bridge::XUnoUrlResolver >(
				  xLocalFactory->
				      createInstance(
						  rtl::OUString(
							  RTL_CONSTASCII_USTRINGPARAM(
								  "com.sun.star.bridge.UnoUrlResolver"))),
				  uno::UNO_QUERY);
	}
	catch (uno::RuntimeException const &) { throw; }
	catch (uno::Exception const &) {}
	if (!m_xResolver.is())
		throw ProgramException(
			      rtl::OString(
					  RTL_CONSTASCII_STRINGPARAM(
						  "no service, or service lacks interface")));
}

//============================================================================
//
//  Connector
//
//============================================================================

namespace {

class Connector
{
public:
	Connector(rtl::OUString const & rClientUrl,
			  rtl::OUString const & rServerUrl,
			  rtl::OUString const & rTemplate,
			  uno::Reference< bridge::XUnoUrlResolver > const & rResolver)
		throw (ProgramException, uno::RuntimeException, std::bad_alloc);

	~Connector()
		throw (ProgramException, uno::RuntimeException, std::bad_alloc);

private:
	Connector(Connector const &); // not implemented
	Connector & operator =(Connector const &); // not implemented

	static uno::Reference< lang::XMultiServiceFactory >
	getFactory(uno::Reference< bridge::XUnoUrlResolver > const & rResolver,
			   rtl::OUString const & rUrl)
		throw (ProgramException, uno::RuntimeException, std::bad_alloc);

	rtl::OUString m_aServerUrl;
	rtl::OUString m_aTemplate;
	uno::Reference< ucb::XContentProviderManager > m_xClientUcb;
	uno::Reference< ucb::XParameterizedContentProvider > m_xRemoteAccessUcp;
};

}

//============================================================================
// static
uno::Reference< lang::XMultiServiceFactory >
Connector::getFactory(
	uno::Reference< bridge::XUnoUrlResolver > const & rResolver,
	rtl::OUString const & rUrl)
	throw (ProgramException, uno::RuntimeException, std::bad_alloc)
{
	VOS_ENSURE(rResolver.is(), "Connector::getFactory(): Null resolver\n");

	uno::Reference< uno::XInterface > xResolved;
	try
	{
		xResolved = rResolver->resolve(rUrl);
	}
	catch (connection::NoConnectException const &)
	{
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "NoConnectException")));
	}
	catch (connection::ConnectionSetupException const &)
	{
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "ConnectionSetupException")));
	}
	catch (lang::IllegalArgumentException const &)
	{
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "IllegalArgumentException")));
	}
	if (!xResolved.is())
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "bad resolve()")));

	//@@@ Currently, the soffice program resolves a URL
	// "uno:<connection>;<protocol>;StarOffice.ServiceManager" to an
	// XNamingService, but the ucb program resolves a URL
	// "uno:<connection>;<protocol>;UCB.Factory" to an XMultiServiceFactory.
	// In the long run, both should resolve the URLs to
	// XMultiServiceFactories, and then the following hack can be removed.
	uno::Reference< uno::XNamingService >
		xResolvedNaming(xResolved, uno::UNO_QUERY);
	uno::Reference< lang::XMultiServiceFactory >
		xResolvedFactory(xResolved, uno::UNO_QUERY);
	VOS_ENSURE(!(xResolvedNaming.is() && xResolvedFactory.is()),
			   "Connector::getFactory(): Hack won't work");

	uno::Reference< lang::XMultiServiceFactory > xRemoteFactory;
	if (xResolvedNaming.is())
	{
		try
		{
			xRemoteFactory
				= uno::Reference< lang::XMultiServiceFactory >(
					  xResolvedNaming->
				          getRegisteredObject(
							  rtl::OUString(
								  RTL_CONSTASCII_USTRINGPARAM(
									  "StarOffice.ServiceManager"))),
					  uno::UNO_QUERY);
		}
		catch (uno::RuntimeException const &) { throw; }
		catch (uno::Exception const &) {}
	}
	else if (xResolvedFactory.is())
	{
		try
		{
			xRemoteFactory
				= uno::Reference< lang::XMultiServiceFactory >(
					  xResolvedFactory->
				          createInstance(
							  rtl::OUString(
								  RTL_CONSTASCII_USTRINGPARAM(
									  "com.sun.star.lang.ServiceManager"))),
					  uno::UNO_QUERY);
		}
		catch (uno::RuntimeException const &) { throw; }
		catch (uno::Exception const &) {}
	}
	return xRemoteFactory;
}

//============================================================================
Connector::Connector(
	rtl::OUString const & rClientUrl,
	rtl::OUString const & rServerUrl,
	rtl::OUString const & rTemplate,
	uno::Reference< bridge::XUnoUrlResolver > const & rResolver)
	throw (ProgramException, uno::RuntimeException, std::bad_alloc):
	m_aServerUrl(rServerUrl),
	m_aTemplate(rTemplate)
{
	VOS_ENSURE(rResolver.is(), "Connector::Connector(): Null resolver");

	uno::Reference< lang::XMultiServiceFactory >
		xClientFactory(getFactory(rResolver, rClientUrl));
	if (!xClientFactory.is())
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "bad getFactory()")));

	uno::Sequence< uno::Any > aArguments(1);
	aArguments[0] <<= sal_True;
	try
	{
		m_xClientUcb
			= uno::Reference< ucb::XContentProviderManager >(
				  xClientFactory->
				      createInstanceWithArguments(
						  rtl::OUString(
							  RTL_CONSTASCII_USTRINGPARAM(
								  "com.sun.star.ucb.UniversalContentBroker")),
						  aArguments),
				  uno::UNO_QUERY);
	}
	catch (uno::RuntimeException const &) { throw; }
	catch (uno::Exception const &) {}
	if (!m_xClientUcb.is())
		throw ProgramException(
			rtl::OString(
				RTL_CONSTASCII_STRINGPARAM(
					"no service, or service lacks interface")));

	try
	{
		m_xRemoteAccessUcp
			= uno::Reference< ucb::XParameterizedContentProvider >(
				  xClientFactory->
				      createInstance(
						  rtl::OUString::createFromAscii(
							  "com.sun.star.ucb."
							      "RemoteAccessContentProvider")),
				  uno::UNO_QUERY);
	}
	catch (uno::RuntimeException const &) { throw; }
	catch (uno::Exception const &) {}
	if (!m_xRemoteAccessUcp.is())
		throw ProgramException(
			      rtl::OString(
					  RTL_CONSTASCII_STRINGPARAM(
						  "no service, or service lacks interface")));

	uno::Reference< ucb::XContentProvider > xInstance;
	try
	{
		xInstance = m_xRemoteAccessUcp->registerInstance(m_aTemplate,
														 m_aServerUrl,
														 false);
	}
	catch (lang::IllegalArgumentException const &)
	{
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "IllegalArgumentException")));
	}
	if (!xInstance.is())
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "bad registerInstance()")));

	try
	{
		m_xClientUcb->registerContentProvider(xInstance, m_aTemplate, false);
	}
	catch (ucb::DuplicateProviderException const &)
	{
		try
		{
			m_xRemoteAccessUcp->deregisterInstance(m_aTemplate, m_aServerUrl);
		}
		catch (lang::IllegalArgumentException const &) {}
		throw ProgramException(rtl::OString(
			                       RTL_CONSTASCII_STRINGPARAM(
									   "bad registerContentProvider()")));
	}
	catch (uno::RuntimeException const &)
	{
		try
		{
			m_xRemoteAccessUcp->deregisterInstance(m_aTemplate, m_aServerUrl);
		}
		catch (lang::IllegalArgumentException const &) {}
		throw;
	}
}

//============================================================================
Connector::~Connector()
	throw (ProgramException, uno::RuntimeException, std::bad_alloc)
{
	uno::Reference< ucb::XContentProvider > xInstance;
	try
	{
		xInstance = m_xRemoteAccessUcp->deregisterInstance(m_aTemplate,
														   m_aServerUrl);
	}
	catch (lang::IllegalArgumentException const &)
	{
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "IllegalArgumentException")));
	}
	if (!xInstance.is())
		throw ProgramException(rtl::OString(RTL_CONSTASCII_STRINGPARAM(
			                                    "bad registerInstance()")));

	try
	{
		m_xClientUcb->deregisterContentProvider(xInstance, m_aTemplate);
	}
	catch (uno::RuntimeException const &)
	{
		//@@@ missing roll-back of deregisterInstance()
		throw;
	}
}

//============================================================================
//
//  main
//
//============================================================================

int main()
{
	try
	{
		puts("UCB Connector\n");
		puts("First, enter a UNO URL through which a service manager can be");
		puts("addressed that can instantiate a (client) UCB and a");
		puts("RemoteAccessUCP (typically running in an soffice program).");
		puts("Then, enter a UNO URL through which a service manager can be");
		puts("addressed that can instantiate a (server) UCB (typically");
		puts("running in a ucb program).  This program will make available");
		puts("the server UCB to the client UCB, using the given URL");
		puts("template (typically '.*').");

		Resolver aResolver;

		for (;;)
		{
			fputs("\nClient URL (empty to quit): ", stdout);
			sal_Char aClientUrl[1024];
			if (!gets(reinterpret_cast< char * >(aClientUrl))
				|| aClientUrl[0] == '\0')
				break;

			fputs("Server URL: ", stdout);
			sal_Char aServerUrl[1024];
			gets(reinterpret_cast< char * >(aServerUrl));

			fputs("Template: ", stdout);
			sal_Char aTemplate[1024];
			gets(reinterpret_cast< char * >(aTemplate));

			try
			{
				Connector
					aConnector(rtl::OUString::createFromAscii(aClientUrl),
							   rtl::OUString::createFromAscii(aServerUrl),
							   rtl::OUString::createFromAscii(aTemplate),
							   aResolver.getResolver());

				fputs("Connected... press return to disconnect:", stdout);
				char aLine[1024];
				gets(aLine);
			}
			catch (ProgramException const & rException)
			{
				fprintf(stderr, "Program exception: %s\n", rException.what());
			}
		}

		return EXIT_SUCCESS;
	}
	catch (uno::RuntimeException const & rException)
	{
		fprintf(stderr, "UNO runtime exception: %s\n",
				rtl::OString(rException.Message.getStr(),
							 rException.Message.getLength(),
							 RTL_TEXTENCODING_ISO_8859_1).
				    getStr());
	}
	catch (std::bad_alloc const & rException)
	{
		fprintf(stderr, "Bad allocation exception: %s\n", rException.what());
	}
	catch (uno::Exception const & rException)
	{
		fprintf(stderr, "Unexpected UNO exception: %s\n",
				rtl::OString(rException.Message.getStr(),
							 rException.Message.getLength(),
							 RTL_TEXTENCODING_ISO_8859_1).
				    getStr());
	}
	catch (std::exception const & rException)
	{
		fprintf(stderr, "Unexpected standard C++ exception: %s\n",
				rException.what());
	}
	catch (...)
	{
		fprintf(stderr, "Unexpected unknown exception: %s\n");
	}
	return EXIT_FAILURE;
}
