/*************************************************************************
 *
 *  $RCSfile: NeonPOSTFile.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: kso $ $Date: 2001/06/27 08:53:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _NEONPOSTFILE_HXX_
#define _NEONPOSTFILE_HXX_

#include <stdio.h> // Needed for FILE

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/reference.hxx>
#endif
#ifndef _DAVEXCEPTION_HXX_
#include "DAVException.hxx"
#endif

namespace com { namespace sun { namespace star { namespace io {
    class XOutputStream; class XInputStream;
} } } }

namespace webdav_ucp
{

// -------------------------------------------------------------------
// NeonPOSTFile
// This is specifically provided to generate the required FILE *
// input to the neon library http_post() function. htp_post() writes the
// response data from POST request to the file.
// -------------------------------------------------------------------
class NeonPOSTFile
{
	private:
		rtl::OString mFileName;
		FILE *	mFILE;

	public:
         NeonPOSTFile()
            throw ( DAVException );
        ~NeonPOSTFile();

        // Return the relevant FILE * for use with http_post()
		FILE *	GetFILE( void )	{ return mFILE; };

        // Write data to output stream.
        bool Write( com::sun::star::uno::Reference<
                        com::sun::star::io::XOutputStream > & xOutputStream );

        // Write data to input stream.
        bool Write( com::sun::star::uno::Reference<
                        com::sun::star::io::XInputStream > & xInputStream );

		// Delete the file pointed to by mFILE
        void    Remove();
};

}; // namespace webdav_ucp

#endif // _NEONPOSTFILE_HXX_

