/*************************************************************************
 *
 *  $RCSfile: NeonPOSTFile.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: cd $ $Date: 2001/10/17 06:02:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef WIN32
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#endif

#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _NEONINPUTSTREAM_HXX_
#include "NeonInputStream.hxx"
#endif
#ifndef _NEONPOSTTFILE_HXX_
#include "NeonPOSTFile.hxx"
#endif

using namespace com::sun::star;
using namespace webdav_ucp;

// -------------------------------------------------------------------
// Constructor
// -------------------------------------------------------------------
NeonPOSTFile::NeonPOSTFile()
    throw ( DAVException )
{
	mFileName = rtl::OString( tmpnam( NULL ) );

	// Neon expects the file to be open
#ifdef WIN32
    mFILE = fopen( mFileName.getStr(), "w+b" );
    if ( !mFILE )
        throw DAVException( DAVException::DAV_FILE_OPEN,
                            rtl::OStringToOUString( mFileName,
                                                    RTL_TEXTENCODING_UTF8 ) );
#else
    int theFD = open( mFileName.getStr(), O_RDWR | O_CREAT, S_IRUSR );
	if ( theFD == -1 )
        throw DAVException( DAVException::DAV_FILE_OPEN,
                            rtl::OStringToOUString( mFileName,
                                                    RTL_TEXTENCODING_UTF8 ) );
    mFILE = fdopen( theFD, "w+" );
    if ( !mFILE )
        throw DAVException( DAVException::DAV_FILE_OPEN,
                            rtl::OStringToOUString( mFileName,
                                                    RTL_TEXTENCODING_UTF8 ) );
#endif
}

// -------------------------------------------------------------------
// Destructor
// -------------------------------------------------------------------
NeonPOSTFile::~NeonPOSTFile()
{
    if ( mFILE )
        fclose( mFILE );
}

// -------------------------------------------------------------------
// Write data to output stream.
// -------------------------------------------------------------------

bool NeonPOSTFile::Write( uno::Reference< io::XOutputStream > & xOutputStream )
{
    if ( mFILE && xOutputStream.is() )
    {
		fseek( mFILE, 0, SEEK_SET );

        try
        {
            const sal_Int32 BUFFER_SIZE = 65536;
            sal_Int8 aBuffer[ BUFFER_SIZE ];

            sal_Int32 nRead = fread( aBuffer, 1, BUFFER_SIZE, mFILE );
            while ( nRead > 0 )
            {
                uno::Sequence< sal_Int8 > aSeq( aBuffer, nRead );
                xOutputStream->writeBytes( aSeq );

                nRead = fread( aBuffer, 1, BUFFER_SIZE, mFILE );
            }

            xOutputStream->closeOutput();
            return true;
        }
        catch ( io::NotConnectedException const & )
        {
            // writeBytes, closeOutput
        }
        catch ( io::BufferSizeExceededException const & )
        {
            // writeBytes, closeOutput
        }
        catch ( io::IOException const & )
        {
            // writeBytes, closeOutput
        }
    }
    return false;
}

// -------------------------------------------------------------------
// Write data to input stream.
// -------------------------------------------------------------------

bool NeonPOSTFile::Write( uno::Reference< io::XInputStream > & xInputStream )
{
	if ( mFILE )
    {
		fseek( mFILE, 0, SEEK_SET );

        rtl::Reference< NeonInputStream > xStream = new NeonInputStream;

        const sal_Int32 BUFFER_SIZE = 65536;
        char aBuffer[ BUFFER_SIZE ];

        sal_Int32 nRead = fread( aBuffer, 1, BUFFER_SIZE, mFILE );
        while ( nRead > 0 )
        {
            xStream->AddToStream( aBuffer, nRead );
            nRead = fread( aBuffer, 1, BUFFER_SIZE, mFILE );
        }

        xInputStream = xStream.get();
        return true;
    }
    return false;
}

// -------------------------------------------------------------------
// Remove
// -------------------------------------------------------------------
void NeonPOSTFile::Remove()
{
    if ( mFILE )
	{
		fclose( mFILE );
        mFILE = 0;
		remove( mFileName.getStr() );
	}
}

