/*************************************************************************
 *
 *  $RCSfile: rapcommandenvironment.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/07/27 13:50:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPCOMMANDENVIRONMENT_HXX
#define INCLUDED_UCB_RAPCOMMANDENVIRONMENT_HXX

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include "com/sun/star/task/XInteractionHandler.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDENVIRONMENT_HPP_
#include "com/sun/star/ucb/XCommandEnvironment.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include "cppuhelper/implbase2.hxx"
#endif
#ifndef _RTL_REF_HXX_
#include "rtl/ref.hxx"
#endif

namespace ucprmt { class Connection; }

namespace ucprmt {

class CommandEnvironment:
    public cppu::WeakImplHelper2< com::sun::star::ucb::XCommandEnvironment,
                                  com::sun::star::task::XInteractionHandler >
{
public:
    CommandEnvironment(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XCommandEnvironment > const &
            rEnvironment,
        rtl::Reference< ucprmt::Connection > const & rConnection)
        SAL_THROW(());

    virtual ~CommandEnvironment() SAL_THROW(());

    virtual
    com::sun::star::uno::Reference<
        com::sun::star::task::XInteractionHandler >
    SAL_CALL
    getInteractionHandler()
        throw (com::sun::star::uno::RuntimeException);

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XProgressHandler >
    SAL_CALL
    getProgressHandler()
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
    handle(com::sun::star::uno::Reference<
                   com::sun::star::task::XInteractionRequest > const &
               rRequest)
        throw (com::sun::star::uno::RuntimeException);

private:
    com::sun::star::uno::Reference< com::sun::star::ucb::XCommandEnvironment >
        m_xEnvironment;
    rtl::Reference< ucprmt::Connection > m_xConnection;

    CommandEnvironment(CommandEnvironment &); // not implemented
    void operator =(CommandEnvironment); // not implemented
};

}

#endif // INCLUDED_UCB_RAPCOMMANDENVIRONMENT_HXX
