/*************************************************************************
 *
 *  $RCSfile: fpxservices.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/08/02 16:03:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_FPXCONTENTPROVIDERSERVICE_HXX
#include "fpxcontentproviderservice.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include "com/sun/star/lang/XSingleServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_REGISTRY_INVALIDREGISTRYEXCEPTION_HPP_
#include "com/sun/star/registry/InvalidRegistryException.hpp"
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include "com/sun/star/registry/XRegistryKey.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include "com/sun/star/uno/RuntimeException.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _CPPU_MACROS_HXX_
#include "cppu/macros.hxx"
#endif
#ifndef _CPPUHELPER_FACTORY_HXX_
#include "cppuhelper/factory.hxx"
#endif
#ifndef _RTL_STRING_H_
#include "rtl/string.h"
#endif
#ifndef _RTL_USTRBUF_HXX_
#include "rtl/ustrbuf.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _UNO_MAPPING_HXX_
#include "uno/mapping.hxx"
#endif

using namespace com::sun;
using namespace ucb::fpx;

extern "C" void SAL_CALL
component_getImplementationEnvironment(sal_Char const ** pEnvTypeName,
                                       uno_Environment **)
    SAL_THROW(())
{
    if (pEnvTypeName)
        *pEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

namespace {

bool writeInfo(void * pRegistryKey,
               rtl::OUString const & rImplementationName,
               star::uno::Sequence< rtl::OUString > const & rServiceNames)
    SAL_THROW(())
{
    rtl::OUStringBuffer aKeyName;
    aKeyName.append(static_cast< sal_Unicode >('/'));
    aKeyName.append(rImplementationName);
    aKeyName.appendAscii(RTL_CONSTASCII_STRINGPARAM("/UNO/SERVICES"));

    star::uno::Reference< star::registry::XRegistryKey > xKey;
    try
    {
        xKey = static_cast< star::registry::XRegistryKey * >(pRegistryKey)->
                   createKey(aKeyName.makeStringAndClear());
    }
    catch (star::registry::InvalidRegistryException &)
    {}
    catch (star::uno::RuntimeException &)
    {}
    OSL_ENSURE(xKey.is(), "unexpected situation");
    if (!xKey.is())
        return false;

    bool bSuccess = true;
    for (sal_Int32 i = 0; i < rServiceNames.getLength(); ++i)
        try
        {
            xKey->createKey(rServiceNames[i]);
        }
        catch (star::registry::InvalidRegistryException &)
        {
            bSuccess = false;
            break;
        }
        catch (star::uno::RuntimeException &)
        {
            bSuccess = false;
            break;
        }
    OSL_ENSURE(bSuccess, "unexpected situation");
    return bSuccess;
}

}

extern "C" sal_Bool SAL_CALL component_writeInfo(void *, void * pRegistryKey)
    SAL_THROW(())
{
    return
        pRegistryKey
        && writeInfo(pRegistryKey,
                     ContentProviderService::getImplementationName(),
                     ContentProviderService::getSupportedServiceNames());
}

extern "C" void * SAL_CALL component_getFactory(sal_Char const * pImplName,
                                                void * pServiceManager,
                                                void *)
    SAL_THROW(())
{
    if (ContentProviderService::getImplementationName().
                compareToAscii(pImplName)
            == 0)
    {
        star::uno::Reference< star::lang::XSingleServiceFactory >
            xFactory(cppu::createOneInstanceFactory(
                         static_cast< star::lang::XMultiServiceFactory * >(
                             pServiceManager),
                         ContentProviderService::getImplementationName(),
                         &ContentProviderService::createInstance,
                         ContentProviderService::getSupportedServiceNames()));
        if (xFactory.is())
        {
            xFactory->acquire();
            return xFactory.get();
        }
    }
    return 0;
}
