/*************************************************************************
 *
 *  $RCSfile: ffparser.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "parser.hxx"

#define HINIBBLE(byte)		( (BYTE)(((byte) & 0xF0) >> 4) )
#define LONIBBLE(byte)		( (BYTE)(((byte) & 0x0F) >> 0) )
#define MAKEBYTE(low,high)	( (BYTE)( (((low) & 0x0F) << 0) | (((high) & 0x0F) << 4) ) )


inline char CreateCharFromNibble( int nibble )
{
	if ( nibble <= 0x09 )
		return '0' + nibble - 0x00;
	else if ( nibble  <= 0x0F )
		return 'A' + nibble - 0x0A;
	else
		return ' ';
}

inline int CreateNibbleFromChar( char c )
{
	if ( c >= '0' && c <= '9' )
		return 0x00 + c - '0';
	else if ( c >= 'a' && c <= 'f' )
		return 0x0a + c - 'a';
	else if ( c >= 'A' && c <= 'F' )
		return 0x0a + c - 'A';
	else
		return -1;
}

//----------------------------------------------------------------------------

String CreateStringFromData( const void *pData, ULONG nBytes )
{
	String	aHex;
	BYTE	*pBytes = (BYTE *)pData;

	while ( nBytes-- )
	{
		aHex += CreateCharFromNibble(HINIBBLE(*pBytes));
		aHex += CreateCharFromNibble(LONIBBLE(*pBytes));

		pBytes++;
	}

	return aHex;
}

//----------------------------------------------------------------------------

void * NewBinaryFromString( const String & rBinStr )
{
	BYTE		*pBytes = NULL;
	const char	*pszBinary = rBinStr;
	int			nChars = rBinStr.Len();

	if ( nChars & 0x01 )	// Number of characters is odd -> ERROR !!!
		return NULL;

	int nBytes = nChars / 2 + sizeof(USHORT);

	pBytes = new BYTE[nBytes];

	if ( pBytes )
	{
		BYTE	*pBytePtr = pBytes;

		while ( *pszBinary )
		{
			int aHighNibble = CreateNibbleFromChar( *pszBinary++ );
			int aLowNibble = CreateNibbleFromChar( *pszBinary++ );

			if ( aHighNibble >= 0 && aLowNibble >= 0 )
				*pBytePtr++ = MAKEBYTE( aLowNibble, aHighNibble );
			else // Invalid character
			{
				delete pBytes;
				return NULL;
			}
		}
		*(USHORT *)pBytePtr = 0;
	}

	return pBytes;
}

//----------------------------------------------------------------------------

String CreateStringFromItemIDList( const CItemIDList & rIDList )
{
	String		aURL;
	int nTokens	= rIDList.GetTokenCount();

	if ( rIDList.GetTokenCount() == 0 )
		return "{desktop}";

//	if ( rIDList == CItemIDList( CSIDL_DRIVES ) )
//		return "{system}";
//	else if ( rIDList == CItemIDList( CSIDL_NETWORK ) )
//		return "{network}";

	for ( int i = 0; i < nTokens; i++ )
	{
		if ( i )
			aURL += "/";

		if ( rIDList[i] == CItemIDList( CSIDL_DRIVES ) )
			aURL += String( "{system}" );
		else if ( rIDList[i] == CItemIDList( CSIDL_NETWORK ) )
			aURL += String( "{network}" );
		else if ( rIDList[i] == CItemIDList( CSIDL_CONTROLS )[1] )
			aURL += String( "{controls}" );
		else if ( rIDList[i] == CItemIDList( CSIDL_PRINTERS )[1] )
			aURL += String( "{printers}" );
		else
		{
			aURL += "{";
			aURL += CreateStringFromData( rIDList[i], WIN_SHGetIDListSize( rIDList[i] ) );
			aURL += "}";
		}
	}

	return aURL;
}

//----------------------------------------------------------------------------

String GetURLFromHostNotation( const String & rPath )
{
	USHORT	nIndex;
	USHORT	nLeadingSlashes;
	String  aPath = rPath;


	if ( aPath.Len() == 0 )
		return aPath;

	// Convert backslashes to slashes

	nIndex = 0;
	do
	{
		nIndex = aPath.SearchAndReplace( '\\', '/', nIndex );
	} while ( nIndex != STRING_NOTFOUND );

	// Convert colons to pipes

	nIndex = 0;
	do
	{
		nIndex = aPath.SearchAndReplace( ':', '|', nIndex );
	} while ( nIndex != STRING_NOTFOUND );

	// Count leading slashes

	nIndex = 0;
	nLeadingSlashes = 0;
	while ( aPath.GetChar(nIndex++) == '/' )
		nLeadingSlashes++;
	
	switch ( nLeadingSlashes )
	{
	case 0:
		aPath = String( "file:///" ) + aPath;
		break;
	case 1:
	case 2:
		aPath = String( "file://" ) + aPath;
		break;
	default:
		aPath.EraseLeadingChars( '/' );
		aPath = String( "file:///" ) + aPath;
		break;
	}

	return aPath;
}

//--------------------------------------------------------------------------

CItemIDList MakeIDFromToken( const CItemIDList &aParent, const String &rToken )
{
	String aToken = rToken;

	if ( aToken.GetChar(0) == '{' && aToken.GetChar(aToken.Len() - 1) == '}' )
	{
		aToken.EraseLeadingChars( '{' );
		aToken.EraseTrailingChars( '}' );

		if ( aToken.ICompare( "system" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_SYSTEM )[0];
		else if ( aToken.ICompare( "network" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_NETWORK )[0];
		else if ( aToken.ICompare( "desktop" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_DESKTOP )[0];
		else if ( aToken.ICompare( "controls" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_CONTROLS )[1];
		else if ( aToken.ICompare( "printers" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_PRINTERS )[1];
		else if ( aToken.ICompare( "programs" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_PROGRAMS );
		else if ( aToken.ICompare( "common-programs" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_COMMON_PROGRAMS );
		else if ( aToken.ICompare( "bookmarks" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_FAVORITES );
		else if ( aToken.ICompare( "documents" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_PERSONAL );
		else if ( aToken.ICompare( "workdir" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_PERSONAL );
		else if ( aToken.ICompare( "recent" ) == COMPARE_EQUAL )
			return CItemIDList( CSIDL_RECENT );

		LPITEMIDLIST	pidl = (LPITEMIDLIST)NewBinaryFromString( aToken );
		if ( pidl )
		{
			CItemIDList aIDList;
			USHORT nBinLen = aToken.Len() / 2;

			if ( pidl->mkid.cb + sizeof(USHORT) == nBinLen )
			{
				LPCITEMIDLIST	pidl2 = (LPCITEMIDLIST)((LPBYTE)pidl + pidl->mkid.cb );

				if ( pidl2->mkid.cb == 0 )
					aIDList = CItemIDList( pidl );
			}

			delete pidl;

			return aIDList;
		}
		else
			return CItemIDList();
	}
	else
	{
		CItemIDList	aItem;

		LPITEMIDLIST	pidl = NULL;
		String	aPath = aParent.GetFilePath();

		if ( aPath.Len() && aPath.GetChar(aPath.Len() - 1) != '\\' )
			aPath += "\\";

		aPath += rToken;

		if ( WIN_SHGetIDListFromPath( aPath, &pidl) )
		{
			LPITEMIDLIST	pidlChild = NULL;

			if ( WIN_SHSplitIDList( pidl, NULL, &pidlChild ) )
			{
				aItem = pidlChild;
				WIN_SHFree( pidlChild );
			}
			WIN_SHFree( pidl );
		}

		return aItem;
	}
}

CItemIDList MakeIDFromToken( const String &rToken )
{
	return MakeIDFromToken( CItemIDList( CSIDL_DESKTOP )[0], rToken );
}

//--------------------------------------------------------------------------

CItemIDList	ParseSpecialURL( const String & rURL )
{
	String		aSpecial = rURL;
	CItemIDList	aIDList;


	USHORT nIndex = 0;
	do
	{
		nIndex = aSpecial.SearchAndReplace( '\\', '/', nIndex );
	} while ( nIndex != STRING_NOTFOUND );

	nIndex = 0;
	do
	{
		String aToken = aSpecial.GetToken( 0, '/', nIndex );
		aIDList += MakeIDFromToken( aIDList, aToken );
	} while ( nIndex != STRING_NOTFOUND );

	return aIDList;
}

//--------------------------------------------------------------------------
String GetHostNotationFromURL( const String & rURL )
{
	BOOL	bIsProtocol = FALSE;
	int		nLeadingSlashes = 0;
	USHORT	nIndex;
	String	aPath = rURL;

	// First of all see if it is a View-URL

	nIndex = aPath.Search( '#' );
	if ( nIndex != STRING_NOTFOUND )
		aPath.Erase( 0, nIndex + 1 );

	// Search for protocol prefix and delete it

	if ( aPath.ICompare( "file://", 7 ) == COMPARE_EQUAL )
	{
		aPath.Erase( 0, 7 );
		bIsProtocol = TRUE;
	}

	// Convert slashes to backslashes

	nIndex = 0;
	do
	{
		nIndex = aPath.SearchAndReplace( '/', '\\', nIndex );
	} while ( nIndex != STRING_NOTFOUND );

	// Convert pipes to colons

	nIndex = 0;
	do
	{
		nIndex = aPath.SearchAndReplace( '|', ':', nIndex );
	} while ( nIndex != STRING_NOTFOUND );

	// Count leading slashes

	nIndex = 0;
	nLeadingSlashes = 0;
	while ( aPath.GetChar(nIndex++) == '\\' )
		nLeadingSlashes++;

	// Erase leading slashes

	aPath.EraseLeadingChars( '\\' );

	if ( bIsProtocol && nLeadingSlashes == 4 )
		aPath = String("\\\\") + aPath;	// UNC
	else
	{
		if ( nLeadingSlashes == 2 )
			aPath = String("\\\\") + aPath; // UNC
	}

	// At last remove all terminating backslashes if it is not a volume

	if ( aPath.GetChar(1) != ':' )
		aPath.EraseTrailingChars( '\\' );

	return aPath;
}

