/*************************************************************************
 *
 *  $RCSfile: memos2.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// Weil OS2 Warp immer als Minimum 64 KB-Bloecke anlegt
#define USE_MALLOCFORSYSALLOC
#define FORCE_SYSALLOC

#define INCL_DOSSEMAPHORES
#define INCL_DOSMISC
#include <svpm.h>
#ifdef USE_MALLOCFORSYSALLOC
#include <malloc.h>
#endif

// =======================================================================

// Groesse eines Blocks, der fuer die SubAllocation verwendet wird
#define MEMBLOCK_SIZE		0x4000

// Groesse, ab der Speicher direkt angefordert wird
#define MEMBLOCK_MAXSIZE	0x1010

// Anzahl Freispeicherlisten
#if ( __ALIGNMENT8 > 4 )
#define MEM_FREELIST_COUNT	12
#else
#define MEM_FREELIST_COUNT	15
#endif

// =======================================================================

struct FreeBlock;

struct MemData
{
	FreeBlock*		pFirstBlocks[MEM_FREELIST_COUNT];	// Erste Bloecke in Freispeicherlisten
	void*			pNewHandler;						// New-Handler
};

static MemData aMemD;

// =======================================================================

inline MemData* GetMemData()
{
	return &aMemD;
}

// -----------------------------------------------------------------------

#ifdef USE_MALLOCFORSYSALLOC
inline void* AllocMemory( size_t n )
{
	return malloc( n );
}
#else
static void* AllocMemory( size_t n )
{
	PVOID pVoid = 0;

	if ( DosAllocMem( &pVoid, n, PAG_COMMIT | PAG_READ | PAG_WRITE ) )
		return 0;

	return pVoid;
}
#endif

// -----------------------------------------------------------------------

#ifdef USE_MALLOCFORSYSALLOC
inline void FreeMemory( void* p )
{
	free( p );
}
#else
inline void FreeMemory( void* p )
{
	DosFreeMem( p );
}
#endif

// =======================================================================

static HMTX 	hImplCritMemSection = 0;
static int		nImplCritMemSectionCount = 0;
static int		nMultiThread = 0;

// -----------------------------------------------------------------------

void EnterMultiThread( int bEnter )
{
	if ( bEnter )
	{
		if ( !nMultiThread )
		{
			// Falls Semaphore noch nicht existiert, dann anlegen
			if ( !hImplCritMemSection )
				DosCreateMutexSem( NULL, &hImplCritMemSection, 0, FALSE );
			for ( int i = 0; i < nImplCritMemSectionCount; i++ )
				DosRequestMutexSem( hImplCritMemSection, SEM_INDEFINITE_WAIT );
		}

		nMultiThread++;
	}
	else if ( nMultiThread )
	{
		nMultiThread--;

		if ( !nMultiThread )
		{
			for ( int i = 0; i < nImplCritMemSectionCount; i++ )
				DosReleaseMutexSem( hImplCritMemSection );
		}
	}
}

// -----------------------------------------------------------------------

int IsMultiThread()
{
	return (nMultiThread != 0);
}

// -----------------------------------------------------------------------

inline void ImplLockMemSem()
{
	if ( nMultiThread )
		DosRequestMutexSem( hImplCritMemSection, SEM_INDEFINITE_WAIT );
	nImplCritMemSectionCount++;
}

// -----------------------------------------------------------------------

inline void ImplUnlockMemSem()
{
	nImplCritMemSectionCount--;
	if ( nMultiThread )
		DosReleaseMutexSem( hImplCritMemSection );
}

// -----------------------------------------------------------------------

void ImpDeInitOS2Tools()
{
	nMultiThread = 0;
	if ( hImplCritMemSection )
	{
		while( nImplCritMemSectionCount-- )
			DosReleaseMutexSem( hImplCritMemSection );
		DosCloseMutexSem( hImplCritMemSection );
		hImplCritMemSection = 0;
	}
}

// -----------------------------------------------------------------------

class ImplInitMemOS2Class
{
public:
	ImplInitMemOS2Class();
};

ImplInitMemOS2Class::ImplInitMemOS2Class()
{
	EnterMultiThread( TRUE );
}

ImplInitMemOS2Class aImplInitClass;

// -----------------------------------------------------------------------

// Defines fuer MultiThread-Systeme, um Suballocation multithreadfest
// zu machen
#define MEM_SEMSTART()		ImplLockMemSem();
#define MEM_SEMEND()		ImplUnlockMemSem();

