/*************************************************************************
 *
 *  $RCSfile: memmac.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 16:17:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "Mac_Start.h"
#include <LowMem.h>
#include <limits.h>
#include <SegLoad.h>
#include <Dialogs.h>
#include "Mac_end.h"

#include <Memory.h>
#include <solar.h>

#include <algorithm>

#define RESOURCE_USER_ALERT 129
#define MSG_STACKOVERFLOW	"Stack has run into application heap"
#define MAGICVALUE			'HERO'

static long *g_pMagic = NULL;

// -----------------------------------------------------------------------

// Groesse eines Blocks, der fuer die SubAllocation verwendet wird
#define MEMBLOCK_SIZE		0x1000

// Groesse, ab der Speicher direkt angefordert wird
#define MEMBLOCK_MAXSIZE	0x0400

// Anzahl Freispeicherlisten
#if ( __ALIGNMENT8 > 4 )
#define MEM_FREELIST_COUNT	12
#else
#define MEM_FREELIST_COUNT	15
#endif

// Defines fuer MultiThread-Systeme, um Suballocation multithreadfest
// zu machen
#define MEM_SEMSTART()
#define MEM_SEMEND()

// -----------------------------------------------------------------------

#include <SV_Memory.H>

MemData aMemData;

/*************************************************************************
|*
|*	  GetMemData()
|*
|*	  Beschreibung		Daten vom Memory-Manager besorgen
|*	  Ersterstellung	TH 21.07.92
|*	  Letzte Aenderung	DV 28.02.96
|*
*************************************************************************/

inline MemData* GetMemData()
{
	return &aMemData;
}

// -----------------------------------------------------------------------

#ifdef DBG_UTIL

/*************************************************************************
|*
|*	  CheckSysChain()
|*
|*	  Beschreibung		Alle Systempeicherbloecke ueberpruefen
|*	  Ersterstellung	KH 06.07.95
|*	  Letzte Aenderung	KH 06.07.95
|*
*************************************************************************/

void CheckSysChain()
{
	void* pChain = GetMemData()->pSysPtrChain;
	void* pNext;
	THz SysZone = SystemZone();
	while ( pChain )
	{
		pNext = *((void**)pChain);
		if ( PtrZone( (MAC_Ptr) pChain ) != SysZone )
			DebugStr( "\pInvalidSysChain\n" );
		pChain = pNext;
	}
}

#endif

/*************************************************************************
|*
|*	  AllocSysMemory()
|*
|*	  Beschreibung		Fordert Systemspeicherblock an
|*	  Ersterstellung	KH 06.07.95
|*	  Letzte Aenderung	WKC 28.04.1997
|*
*************************************************************************/

void* AllocSysMemory( size_t n )
{
	MAC_Ptr p = NULL;
#ifdef DBG_UTIL
	CheckSysChain();
#endif
	// FreeMemSys liefert gelegentlich falsche Werte
	if ( FreeMemSys() > MINFREE_MEM_SYS + n )
	{
		p = NewPtrSys(n + sizeof(void*));
	}
	else
	{	// versuchs trotzdem, s.o.
		Handle hfree = NewHandleSys( MINFREE_MEM_SYS );
		if ( hfree )
		{
			p = NewPtrSys(n + sizeof(void*));
			DisposeHandle( hfree );
		}
	}
	if ( p )
	{
		// In SysPtrChain einketten
		*((void**)p) = GetMemData()->pSysPtrChain;
		GetMemData()->pSysPtrChain = p;
		return ( p + sizeof(void*) );
	}
	return NULL;
}

/*************************************************************************
|*
|*	  AllocMemory()
|*
|*	  Beschreibung		Fordert Speicherblock an
|*	  Ersterstellung	TH 06.09.92
|*	  Letzte Aenderung	DV 18.12.97
|*
*************************************************************************/

static void* AllocMemory( size_t n )
{
	void* p=0L;
	BOOL  bNewhdlcall = FALSE;

	if ( ! GetMemData()->bIsInitialized )
	{
		// Wir werden das erste Mal aufgerufen

		// Der Stack wird nach unten um 256K vergroessert.

		long newLimit = (long)LMGetCurStackBase() - 0x40000;

		// Das geschieht, indem die Spitze des Heap heruntergesetzt wird
		// falls sie ber dem neu berechneten Limit lag.

		if ((long)GetApplLimit() > newLimit)
			SetApplLimit((MAC_Ptr)newLimit);

		// HRO: An der Grenze zwishcen Heap und Stack legen wir eine MAGICVALUE an,
		// um ueberpruefen zu koennen, dass der Stack in den Heap gerauscht ist.

		g_pMagic = (long *)(newLimit + sizeof(long));

		*g_pMagic = MAGICVALUE;

		// Jetzt wird der Heap auf den maximal moeglichen Wert aufgeblasen
		MaxApplZone();


		THz applZone;
		short oldMoreMast;
		const short callMoreMasters = 44;

		// Here is a trick suggested by Jerome C.--it allocates one
		// large block of master pointers
		applZone = ApplicationZone();
		oldMoreMast = applZone->moreMast;
		long numMasterPointersDesired = oldMoreMast * callMoreMasters;
		do {
			applZone->moreMast = (short) std::min(numMasterPointersDesired, SHRT_MAX);
			MoreMasters();
			numMasterPointersDesired -= applZone->moreMast;
		} while (numMasterPointersDesired > 0);
		applZone->moreMast = oldMoreMast;

		GetMemData()->bIsInitialized = TRUE;
	}


	// HRO
	if ( g_pMagic == NULL || *g_pMagic != MAGICVALUE )
	{
		static Str255	message;
		static Str15	dummy;

		dummy[0] = 0;

		message[0] = strlen(MSG_STACKOVERFLOW);
		memcpy( &message[1], MSG_STACKOVERFLOW, strlen(MSG_STACKOVERFLOW) );

		ParamText( message, dummy, dummy, dummy );
		Alert( RESOURCE_USER_ALERT, nil );
		ExitToShell();
	}

	if ( FreeMem() > (MINFREE_MEM_APP + n))
	{
		if ( GetMemData()->bIsLowMem != TRUE || MaxBlock() >= n )
		{
			p = (void*)NewPtr( n );
			bNewhdlcall = TRUE;
		}
	}
	if ( !p)
	{
		GetMemData()->bIsLowMem = TRUE;
		p = AllocSysMemory( n );
		if ( !p && !bNewhdlcall )
		{
			size_t nReserved = Min((ULONG)MINFREE_MEM_APP/4,(ULONG)MaxBlock());
			Handle hfree = NewHandle( nReserved );
			p = (void*)NewPtr( n );
			if ( hfree )
			{
				DisposeHandle( hfree );
			}
		}
	}
	return p;
}

/*************************************************************************
|*
|*	  FreeSysMemory()
|*
|*	  Beschreibung		Gibt Systempeicherblock frei
|*	  Ersterstellung	TH 06.09.92
|*	  Letzte Aenderung	KH 25.10.95
|*
*************************************************************************/

void FreeSysMemory( void* p )
{
#ifdef DBG_UTIL
	CheckSysChain();
#endif

	p = ((BYTE*)p) - sizeof(void*);
	void* pChain = GetMemData()->pSysPtrChain;

	if ( pChain == p )
	{
		// erstes Element ausketten ...
		GetMemData()->pSysPtrChain = *((void**) pChain);
		DisposePtr((MAC_Ptr) p);
		return;
	}

	// Wo ist dieser Block
	while ( pChain && (*((void**)pChain) != p) )
		pChain = *((void**)pChain);

	if ( !pChain )
	{
#ifdef DBG_UTIL
		DebugStr("\pSysPointer not in SysPtrChain !!!\n");
#endif
		return;
	}
	// aus der Liste ausketten ...
	*((void**)pChain) = *((void**)p);
	DisposePtr((MAC_Ptr) p);

#ifdef DBG_UTIL
	CheckSysChain();
#endif
}

/*************************************************************************
|*
|*	  FreeMemory()
|*
|*	  Beschreibung		Gibt Speicherblock frei
|*	  Ersterstellung	TH 06.09.92
|*	  Letzte Aenderung	DV 18.12.97
|*
*************************************************************************/

static void FreeMemory( void* p )
{
	if ( !GetMemData()->pSysPtrChain)
		 DisposePtr((MAC_Ptr) p);
	else
	{
		THz pHeap = ApplicationZone();

		if ( (((long) p) <= ((long) &pHeap->heapData)) ||
			 (((long) p) >= ((long) pHeap->bkLim)))
			FreeSysMemory(p);
		else
			DisposePtr((MAC_Ptr) p);
	}
}

/*************************************************************************
|*
|*	  FreeSysChain()
|*
|*	  Beschreibung		Alle Systemspeicherbloecke freigeben ...
|*	  Ersterstellung	KH 06.07.95
|*	  Letzte Aenderung	KH 25.10.95
|*
*************************************************************************/

extern "C"
{
void FreeSysChain()
{
#ifdef DBG_UTIL
	CheckSysChain();
#endif

	void* pChain = GetMemData()->pSysPtrChain;
	void* pNext;
	while ( pChain )
	{
		pNext = *((void**)pChain);
		DisposePtr((MAC_Ptr) pChain);
		pChain = pNext;
	}
}
}

/*************************************************************************
|*
|*	  ImpDeInitMemMgr()
|*
|*	  Beschreibung		Muss aufgerufen werden nachdem main() verlassen werden
|*	  Ersterstellung	KH 10.06.95
|*	  Letzte Aenderung	KH 25.10.95
|*
*************************************************************************/

void ImpDeInitMemMgr()
{
	GetMemData()->bOutOfMain = TRUE;
}

