/*************************************************************************
 *
 *  $RCSfile: siclient.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "geninfo.hxx"
#include "iparser.hxx"
#include "stream.hxx"
#include "siclient.hxx"
#include "infocom.hxx"

#ifndef _SASYNCFN_HXX
#include "sasyncfn.hxx"
#endif

/************************************************************************/
SimpleInformationClient::SimpleInformationClient( const ByteString &rInfoServerHost,
				      const ByteString &rRequest,
				      BOOL bRequestList,
				      BOOL bRequestWholeList
					  )
/************************************************************************/
: InformationClient(  rRequest,
				      bRequestList,
				      bRequestWholeList )
{
  pTcpCon = new SimpleTcpCon( rInfoServerHost );
  LateInit();
  pAsyncFuncs = new SimpleAsyncFuncs();
  StartCommunication();
}

/************************************************************************/
SimpleInformationClient::~SimpleInformationClient()
/************************************************************************/
{
}


/************************************************************************/
const GenericInformation *SimpleInformationClient::Send_n_Wait()
/************************************************************************/
{
  // es wurde noch nichts abgesendet
  if ( !bSend ) {
    // bergebene String nicht leer
    //if ( /*pRequest!=0 &&*/ rRequest.Len()!=0 ) {
    //  sRequest = rRequest.GetStr() ;
    //    }
    // ist die Anfrage immer noch leer, weil rRequest im Konstruktor
    // leer war gehe einfach wieder raus..
    if ( sRequest.Len()==0 )
      return NULL;
  }

  SendData();

  // warten auf godot

  while ( !bRecieved ) {
	if ( bConnectionBad )
		return NULL;
	pTcpCon->ReceiveData( GetClientContext()->GetCommunicationLink() );
  }

  return pGenInfo;
}

/************************************************************************/
BOOL SimpleInformationClient::Command_n_Wait()
/************************************************************************/
{
  if ( !bSend ) {
    if ( sRequest.Len()==0 )
      return FALSE; // ..und uebergib einen leeren String
  }
  SendData();

  // warten auf godot
  while ( !bRecieved ) {
	if ( bConnectionBad )
		return FALSE;
	pTcpCon->ReceiveData( GetClientContext()->GetCommunicationLink() );
  }


  return CommandAcknowledged();
}
