/*************************************************************************
 *
 *  $RCSfile: iiclient.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "geninfo.hxx"
#include "iparser.hxx"
#include "stream.hxx"
#include "iiclient.hxx"
#include "infocom.hxx"


/************************************************************************/
InformationClient::InformationClient(
				      const ByteString &rRequest,
				      BOOL bRequestList,
				      BOOL bRequestWholeList)
/************************************************************************/
:   sRequest( rRequest ),
    //    bListReq( bRequestList ),
    //    bWholeListReq( bRequestWholeList ),
    //    sAnswer( ),  // antwort erstmal abwarten, kein string allokieren
    pWholeListStream( 0 ),
    pGenInfo( 0 ),
    nRetries( 10 ),
    bSend ( FALSE ),
    bRecieved( FALSE ),
    nLastPaket( 0 ),
    eErrorCode( none ),
    eSendMode ( bRequestList?(bRequestWholeList?request_whole_list:request_list):request ),
    bConnectionBad( TRUE )
{
  pInfoPack = new InfoDataPack;
}

/************************************************************************/
InformationClient::~InformationClient()
/************************************************************************/
{
  if ( pInfoPack )
    delete pInfoPack;
  if ( pWholeListStream )
    delete pWholeListStream;
  if ( pTcpCon )
  {
		pTcpCon->SetPacketRecievedHdl( Link() );
		pTcpCon->SetConnectionOpenedHdl( Link() );
		pTcpCon->SetConnectionClosedHdl( Link() );
		delete pTcpCon;
  }
}


/************************************************************************/
void InformationClient::LateInit()
/************************************************************************/
{
//	if ( pTcpCon )
	pTcpCon->SetPacketRecievedHdl( LINK( this, InformationClient, PacketRecieved ) );
	pTcpCon->SetConnectionOpenedHdl( LINK( this, InformationClient, ConnectionOpened ) );
	pTcpCon->SetConnectionClosedHdl( LINK( this, InformationClient, ConnectionClosed ) );
}

/************************************************************************/
BOOL InformationClient::CnctIsValid()
/************************************************************************/
{
	return ClientHasCon() && !bConnectionBad;
}

/************************************************************************/
void InformationClient::SetData( InfoDataPack *pData )
/************************************************************************/
{
	delete pInfoPack;
	pInfoPack = pData;
	eSendMode = user;
	sRequest = "user";
}

/************************************************************************/
long int InformationClient::SendData()
/************************************************************************/
{
  DataPack     *pDataPack;

  // mache das Datenpacket fertig

  // je nach anforderung schicke eine Liste oder ein einzelnes Token
  switch (eSendMode) {
  case request:
    // informationsbehaelter mit Request-String fuellen
    *pInfoPack = sRequest.GetBuffer();
    pInfoPack->PutCommand( InfoDataPack::info_request );
    break;
  case request_list:
    // informationsbehaelter mit Request-String fuellen
    *pInfoPack = sRequest;
    pInfoPack->PutCommand( InfoDataPack::info_request_list );
    break;
  case request_whole_list:
    pWholeListStream = new SvMemoryStream( nSvMemoryInitSize,
					   nSvMemoryReSize );
    *pInfoPack = sRequest;
    pInfoPack->PutCommand( InfoDataPack::info_request_whole_list );
    break;
  case infosend:
    pInfoPack->SetKeyValueStr( sRequest, sRequestOptions );
    pInfoPack->PutCommand( InfoDataPack::info_write );
    break;
  case infosend_new:
    pInfoPack->SetKeyValueStr( sRequest, sRequestOptions );
    pInfoPack->PutCommand( InfoDataPack::info_write_new );
    break;
  case command:
    pInfoPack->SetKeyValueStr( sRequest, sRequestOptions );
    pInfoPack->PutCommand( InfoDataPack::command_req );
    break;
  case good_handshake:
    *pInfoPack = "ok";
    pInfoPack->PutCommand( InfoDataPack::handshake );
    break;
  case bad_handshake:
    *pInfoPack = "false";
    pInfoPack->PutCommand( InfoDataPack::handshake );
    break;
  default:
    break;
  }

  // Informationsbehaelter im Datenpacket angeben und NICHT wegschmeissen
  pDataPack = new DataPack;
  pDataPack->pDataBuffer = pInfoPack->DataPackCopy();
  pDataPack->nDataSize = pInfoPack->Size();
  pDataPack->nDataType = TCP_DTYPE_INFOSERVER_DATA;
  pDataPack->pConId = GetClientContext();
  // und abschicken
  bSend = TRUE;
  bRecieved = FALSE;
  if ( pGenInfo )
    delete pGenInfo;
  pGenInfo = 0;
  // pDataPack wird vom TcpCon geloescht => nicht in dieser Klasse loeschen ??
  long int nReturn = pTcpCon->SendData( pDataPack );
  delete pDataPack; // s.o.
  return nReturn;
}

/************************************************************************/
IMPL_LINK( InformationClient, PacketRecieved, DataPack*, pData )
/************************************************************************/
{
  GenericInformation     *pTmpInfo = 0;
  //  GenericInformationList *pTmpInfoList = 0;
  // Antwort abholen
  *pInfoPack = *(InfoDataPack::InfoPack *)(pData->pDataBuffer);

  InfoDataPack::CommandType eInfoCommand = pInfoPack->GetPacketType();
  switch ( eInfoCommand ) {
  // wenn der Server die Antwort nicht verweigert hat..
  case InfoDataPack::info_result:
    bValid = TRUE;

    /*    if ( 1 < pTmpInfoPack->GetMaxPaket() ) { // es kommen mehrere Pakete an
      if ( pTmpInfoPack->GetCurrPaket() == 1 ) { // erstes Packet kommt an
	//	sAnswer = "";
	if ( pMemStream )
	  delete pMemStream;
	pMemStream = new SvMemoryStream( 1024, 1024 ); // neuer Speicher initial 1kB, jede weitere Anforderung 1kB
      }
      /* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
       * ACHTUNG BUG
       * Die Infos muessen in verschiedene Strings oder Listen eingetragen werden,
       * weil die Stringgroesse auf 64kB begrenzt ist
       * funktioniert im Moment nur fuer ein uebertragungpaket!!
       */
    /*    }
    else { // es kommt nur ein Paket an
    */

    pTmpInfo = new GenericInformation( pInfoPack->GetKeyString(),
				       pInfoPack->GetValueString(),
				       0, 0 );
    if ( pInfoPack->HasSubList() )
      pTmpInfo->SetSubList ( new GenericInformationList( pTmpInfo ) );

    // ist schon eine Antwort gekommen ?
    if ( pGenInfo ) { // ein Object ist schon angelegt
      // hole die Subliste von pGenList und setze die Infos ein.
      GenericInformationList *pTmpInfoList = pGenInfo->GetSubList();
      /* ich setze voraus,
       * dass die Liste nicht leer ist */
      pTmpInfoList->InsertInfo( pTmpInfo );
    }
    else {
      // setze das Object als Wurzel
      pGenInfo = pTmpInfo;
    }
    break;
  case InfoDataPack::info_result_whole_list:
    //    bValid = TRUE;
    // !! vorausgesetzt, dass SvMemoryStream initialisiert ist
    pWholeListStream->Write( pInfoPack->GetInfoString(), pInfoPack->InfoSize() );
    SendHandShake();
    break;
  case InfoDataPack::info_ak:
  case InfoDataPack::command_ack:
  case InfoDataPack::dependency_ack:
    if ( pGenInfo )
      delete pGenInfo;
    pGenInfo = 0;
    bValid = TRUE;
    bSend = FALSE;
    bRecieved = TRUE;
    return 0;
    break;
  case InfoDataPack::info_reject:
  case InfoDataPack::command_deny:
  case InfoDataPack::dependency_deny:
    if ( pGenInfo )
      delete pGenInfo;
    pGenInfo = 0;
    bValid = FALSE;
    bSend = FALSE;
    bRecieved = TRUE;
    eErrorCode = no_info;
    return 0;
    break;
  default:
    return 0;
  }

  //  if ( pTmpInfoPack->GetCurrPaket() == pTmpInfoPack->GetMaxPaket() ) {
  if ( pInfoPack->IsLastPaket() ) {
    // letztes Paket kommt an
    if ( InfoDataPack::info_result_whole_list==eInfoCommand ) {
      bValid = TRUE;
      // forme den Memorystream mit dem parser in eine Baumstruktur
      pWholeListStream->Seek( 0 );
      InformationParser aIparser;
      pGenInfo = new GenericInformation( "", "" );
      pGenInfo->SetSubList( aIparser.Execute( *pWholeListStream ));

      //      pWholeListStream->Seek( 0 );
      //      SvFileStream afiletmp( "wholestream.tmp", STREAM_STD_WRITE );
      //      afiletmp << *pWholeListStream;
      //      afiletmp.Close();
      delete pWholeListStream;
      pWholeListStream = 0;
    }
    // Flags setzen
    bSend = FALSE;
    bRecieved = TRUE;

    //    int i;
    //    for (i=0; i<1000; i++)
    //      GetpApp()->Reschedule();

    // eventuell jemand von der neuigkeit benachrichtigen...
    aGotInfoHdl.Call( this );
  }

  return 0;
}

/************************************************************************/
IMPL_LINK( InformationClient, ConnectionOpened, ClientContext*, pCtx )
/************************************************************************/
{
    bConnectionBad = FALSE;
	return 0;
}

/************************************************************************/
IMPL_LINK( InformationClient, ConnectionClosed, ClientContext*, pCtx )
/************************************************************************/
{
    bSend          = FALSE;
    bRecieved      = TRUE;
    bValid         = FALSE;
    bConnectionBad = TRUE;
    eErrorCode = server_shutdown;
    sRequest = "";
    if ( pGenInfo )
      delete pGenInfo;
    pGenInfo = NULL;

	aConnectionClosedHdl.Call( this );

    return 0;
}

/************************************************************************/
void InformationClient::SendHandShake( BOOL bSuccess )
/************************************************************************/
{
  if ( bSuccess )
    eSendMode = good_handshake;
  else
    eSendMode = bad_handshake;

  SendData();
}
