/*************************************************************************
 *
 *  $RCSfile: content.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMISC
#include <svpm.h>

#include <stdlib.h>
#include <string.h>
#include "content.hxx"


/*********************
 *
 * Data structures
 *
 *********************
 */


static const char cBackSlash = '\\';

typedef struct {
    PM_USHORT type;
    PM_USHORT nLen;
    CHAR      value[CCHMAXPATHCOMP];
} EACONTENT, *PEACONTENT;

typedef struct {
    UCHAR    nLen;
    CHAR     value[CCHMAXPATHCOMP];
} FILENAME, *PFILENAME;

// for OS/2 temporary changes any GEA2LIST structure, no static structure can be used:
// this would not be thread-save. so save some work from being done in every call.
static const char   szContentEA[] = ".TYPE";

// the size of the buffer to copy szContentEA to
static const size_t nContentEA    = sizeof( szContentEA ) - 1;

// the  size of the complete structure, alligned to dword boundary
static const size_t nGEA2List      = ( sizeof( GEA2LIST ) + nContentEA + 3 ) & ~3;

// when allocating memory, get a hole page. this is as fast as getting a smaller buffer, but
// you don't have to think about the size every time.
static const size_t nPageSize      = 4096;


/*********************
 *
 * helper functions
 *
 *********************
 */

inline PEAOP2 setEABuffer( const char * pszContent, size_t n )
{
    PFEA2LIST pFEAList;
    PEAOP2    pEAOP;
    
    // allocate Buffer
    pEAOP = (PEAOP2) new PM_BYTE [nPageSize];
    if( !pEAOP ) return NULL;

    // this structure can directly follow the EAOP2
    pFEAList = (PFEA2LIST) &pEAOP[1];

    // setup EAOP2 structure
    pEAOP->oError = 0L;
    pEAOP->fpGEA2List = NULL;
    pEAOP->fpFEA2List = pFEAList;

    // set buffer size of FEA2List
    pFEAList->cbList = sizeof( FEA2LIST );

    pFEAList->list[0].oNextEntryOffset = 0L;  // no more entries;
    pFEAList->list[0].cbName = nContentEA;
    strcpy( pFEAList->list[0].szName, szContentEA );

    if( pszContent )
    {
        // correct buffer sizes
        pFEAList->cbList += sizeof( EACONTENT );
        pFEAList->list[0].cbValue = sizeof( EACONTENT );
        
        PEACONTENT pContentEA = (PEACONTENT)
            ((PBYTE) &pFEAList->list[1] + pFEAList->list[0].cbName);
        
        pContentEA->type  = EAT_ASCII;
        pContentEA->nLen  = n;
        strcpy( pContentEA->value, pszContent );
    }
    else
        pFEAList->list[0].cbValue = 0;

    return pEAOP;
}


/*
 * getEABuffer - allocate buffer ans set up data for getting .CONTENT EAs
 */

inline PEAOP2 getEABuffer( PULONG pulBufSize )
{
    PGEA2LIST pGEAList;
    PFEA2LIST pFEAList;
    PEAOP2    pEAOP;
    
    // first check if enough space for complete operation
    static size_t nMinSize = nGEA2List + sizeof( EAOP2 );

    // allocate Buffer
    pEAOP = (PEAOP2) new PM_BYTE [nPageSize];
    if( !pEAOP ) return NULL;

    // to make it possible to delete the data from outside,
    // put this structure at the end of the of the buffer
    pGEAList = (PGEA2LIST) ( (PBYTE) pEAOP + nPageSize - nGEA2List );

    // this structure can directly follow the EAOP2
    pFEAList = (PFEA2LIST) &pEAOP[1];

    // copy GEA2LIST to the beginning of the buffer
    pGEAList->cbList = nGEA2List;
    
    pGEAList->list[0].oNextEntryOffset = 0L;  // no more entries;
    pGEAList->list[0].cbName = nContentEA;
    strcpy( pGEAList->list[0].szName, szContentEA );

    // setup EAOP2 structure
    pEAOP->oError = 0L;
    pEAOP->fpGEA2List = pGEAList;
    pEAOP->fpFEA2List = pFEAList;

    // set buffer size of FEA2List
    pFEAList->cbList = nPageSize - nMinSize;

    if( pulBufSize )
        *pulBufSize = pFEAList->cbList;

    return pEAOP;
}


/*
 * contentEA - get long name from buffer
 */

inline const char * contentEA( PFEA2LIST pFEAList )
{
    PFEA2       pFEA        = &pFEAList->list[0];
    PEACONTENT pContentEA = (PEACONTENT) ((PBYTE) &pFEAList->list[1] + pFEA->cbName);

    if( pFEA->cbValue != 0 && pContentEA->type == EAT_ASCII )
    {
        pContentEA->value[pContentEA->nLen] = '\0';
        return pContentEA->value;
    }

    return NULL;
}
    



/******************************************************************************************
 *
 * handle .CONTENT extended attributes
 *
 ******************************************************************************************
 */

BOOL createContentEA( const PCSZ pszPath, ULONG ulAttributes, const String& aContent )
{
    APIRET rc;

    // allocate buffer and setup data
    PEAOP2 pEAOP = setEABuffer( aContent, aContent.Len() );
    if( !pEAOP ) return FALSE;

    // destinguish between files and directories here
    if( ulAttributes & FILE_DIRECTORY )
    {
        rc = DosSetPathInfo( pszPath, FIL_QUERYEASIZE, (PVOID) pEAOP,
                               sizeof( EAOP2 ), DSPI_WRTTHRU );
    }
    else
    {
        HFILE		 hfFileHandle = 0L;
        ULONG		 ulAction = 0L;
        
        rc = DosOpen( pszPath, &hfFileHandle, &ulAction, 0L, ulAttributes,
                      OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                      OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE,
                      NULL );

        if( rc != NO_ERROR )
            goto cleanup;

        rc = DosSetFileInfo( hfFileHandle, FIL_QUERYEASIZE,(PVOID) pEAOP,
                               sizeof( EAOP2 ));

        DosClose( hfFileHandle );
    }

cleanup:
    delete [] pEAOP;
    return rc == NO_ERROR;
}


/*
 *  queryContentEA()
 */

BOOL queryContentEA( const PCSZ pszPath, ULONG ulAttributes, String& aContent )
{
    APIRET rc;

    // setup EA Buffer
    PEAOP2 pEAOP = getEABuffer( NULL );
    if( !pEAOP ) return FALSE;

    // must destinguish between directories and files here
    if( ulAttributes & FILE_DIRECTORY )
    {
        rc = DosQueryPathInfo( pszPath, FIL_QUERYEASFROMLIST,
                               (PVOID) pEAOP, sizeof( EAOP2 ));
    }
    else
    {
        HFILE		 hfFileHandle = 0L;
        ULONG		 ulAction = 0L;
        
        rc = DosOpen( pszPath, &hfFileHandle, &ulAction, 0L, ulAttributes,
                      OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                      OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY,
                      NULL );

        if( rc != NO_ERROR )
            goto cleanup;

        rc = DosQueryFileInfo( hfFileHandle, FIL_QUERYEASFROMLIST,
                               (PVOID) pEAOP, sizeof( EAOP2 ));

        DosClose( hfFileHandle );
    }

    if( rc == NO_ERROR )
    {
        aContent = contentEA( pEAOP->fpFEA2List );
        
        if( aContent.Len() == 0 )
            rc = ~rc;
    }

cleanup:
    delete [] pEAOP;
    return rc == NO_ERROR;
}


/*
 * removeContentEA()
 */

BOOL removeContentEA( const PCSZ pszPath, ULONG ulAttributes )
{
    APIRET rc;

    // allocate buffer and setup data
    PEAOP2  pEAOP = setEABuffer( NULL, 0 );
    if( !pEAOP ) return FALSE;

    // destinguish between files and directories here
    if( ulAttributes & FILE_DIRECTORY )
    {
        rc = DosSetPathInfo( pszPath, FIL_QUERYEASIZE, (PVOID) pEAOP,
                               sizeof( EAOP2 ), DSPI_WRTTHRU );
    }
    else
    {
        HFILE		 hfFileHandle = 0L;
        ULONG		 ulAction = 0L;
        
        rc = DosOpen( pszPath, &hfFileHandle, &ulAction, 0L, ulAttributes,
                      OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
                      OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE,
                      NULL );

        if( rc != NO_ERROR )
            goto cleanup;

        rc = DosSetFileInfo( hfFileHandle, FIL_QUERYEASIZE,(PVOID) pEAOP,
                               sizeof( EAOP2 ));

        DosClose( hfFileHandle );
    }
    
cleanup:
    delete [] pEAOP;
    return rc == NO_ERROR;
}


                         


