/*************************************************************************
 *
 *  $RCSfile: bcst.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vs $ $Date: 2001/02/06 13:01:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLS_BCST_HXX
#define _TOOLS_BCST_HXX

#include "simplecm.hxx"

typedef USHORT BroadcastCategory;
typedef USHORT BroadcastCommand;

#define BCST_FIRST_COMMAND	0
#define BCST_FIRST_CATEGORY	0

#define BCST_CMD_ADD_CATEGORY		((BroadcastCommand)( BCST_FIRST_COMMAND +  1 ))
#define BCST_CMD_REMOVE_CATEGORY	((BroadcastCommand)( BCST_FIRST_COMMAND +  2 ))
#define BCST_CMD_BROADCAST			((BroadcastCommand)( BCST_FIRST_COMMAND +  3 ))
#define BCST_CMD_MAKE_PERSISTENT	((BroadcastCommand)( BCST_FIRST_COMMAND +  4 ))
#define BCST_CMD_CLIENT_ID			((BroadcastCommand)( BCST_FIRST_COMMAND +  5 ))

#define BCST_CAT_INVALID   			((BroadcastCategory)( 0xffff ))
/// BCST_ALL ist ein Spechial. Wer es Schickt schlgt zu allen Clients durch
#define BCST_CAT_ALL				((BroadcastCategory)( BCST_FIRST_CATEGORY      ))
#define BCST_CAT_MISC				((BroadcastCategory)( BCST_FIRST_CATEGORY +  1 ))
#define BCST_CAT_PL2X				((BroadcastCategory)( BCST_FIRST_CATEGORY +  2 ))
#define BCST_CAT_MINORCOPY			((BroadcastCategory)( BCST_FIRST_CATEGORY +  3 ))
#define BCST_CAT_DELIVER			((BroadcastCategory)( BCST_FIRST_CATEGORY +  4 ))
#define BCST_CAT_CHAT				((BroadcastCategory)( BCST_FIRST_CATEGORY +  5 ))
#define BCST_CAT_BSTRIGGER			((BroadcastCategory)( BCST_FIRST_CATEGORY +  6 ))
#define BCST_CAT_BSCHAT				((BroadcastCategory)( BCST_FIRST_CATEGORY +  7 ))
#define BCST_CAT_SOURCEACCEPTANCE	((BroadcastCategory)( BCST_FIRST_CATEGORY +  8 ))
#define BCST_CAT_ZIPSTATUS			((BroadcastCategory)( BCST_FIRST_CATEGORY +  9 ))
#define BCST_CAT_ZIPCONFIG			((BroadcastCategory)( BCST_FIRST_CATEGORY + 10 ))
#define BCST_CAT_ZIPPRJ				((BroadcastCategory)( BCST_FIRST_CATEGORY + 11 ))
#define BCST_CAT_BSBUILD			((BroadcastCategory)( BCST_FIRST_CATEGORY + 12 ))
#define BCST_CAT_BUILDMINOR			((BroadcastCategory)( BCST_FIRST_CATEGORY + 13 ))
#define BCST_CAT_PREMINOR			((BroadcastCategory)( BCST_FIRST_CATEGORY + 14 ))
#define BCST_CAT_KILLZIPJOB			((BroadcastCategory)( BCST_FIRST_CATEGORY + 15 ))
#define BCST_CAT_PACKAGERENAMED		((BroadcastCategory)( BCST_FIRST_CATEGORY + 16 ))
#define BCST_CAT_UPD_EVENTS			((BroadcastCategory)( BCST_FIRST_CATEGORY + 17 ))
#define BCST_LAST_CATEGORY			((BroadcastCategory)( BCST_FIRST_CATEGORY + 18 ))

// BuildModi fr BCST_CAT_BSBUILD
// Mit Priotitten:
#define BCST_CAT_BSBUILD_MODE_PRIO				"PRIO"
// Unter Beachtung von Dependencies:
#define BCST_CAT_BSBUILD_MODE_DEPENDENCIES		"DEPENDENCIES"
// Unter Beachtung von Dependencies incl. Deliver
#define BCST_CAT_BSBUILD_MODE_BUILDANDDELIVER	"DEPENDENCIES_AND_DELIVER"
// Ohne Dependecies aber incl. Deliver
#define BCST_CAT_BSBUILD_MODE_DELIVER			"DELIVER"

typedef ULONG ClientID;
#define BCST_CLIENT_UNKNOWN		((ClientID)0)
#define BCST_CLIENT_BROOKER		((ClientID)0xFFFFFFFF)

ByteString GetBroadcastHost();
ULONG GetBroadcastPort();

typedef ULONG BroadcastFilterFlag;
#define BCST_FILTER_NOFILTER			((BroadcastFilterFlag) 0x0000)
#define BCST_FILTER_COUNTER			((BroadcastFilterFlag) 0x0001)

class BroadcastMessage;

DECLARE_LIST( LinkList, Link * );
class InformationBroadcaster
{
	LinkList aMessageArrivedLnkList;
	LinkList aConnectionTerminatedLnkList;

	DECL_LINK( ManagerData, CommunicationLink* );
	DECL_LINK( ManagerClose, CommunicationLink* );
protected:
	/// Wird vor MessageArrived gerufen um Housekeeping zu erledigen
	virtual void IMessageArrived( const BroadcastMessage &aMsg );
	CommunicationManager *mpManager;
private:
	ClientID aThisClientID;				// Speichert die ID dieses Clients

public:
	/** Wird die Instanz zum empfangen in einer Applikation mit UI verwendet, so mu ein
		CommunicationManagerClientViaSockets bergeben werden.
		Dieser wird Eigentum des InformationBroadcaster und wird von diesem destruiert.

		InformationBroadcaster( new CommunicationManagerClientViaSocket( TRUE ) );

		das TRUE ist dabei Wichtig um die multi-channel Fhigkeit zu aktivieren. Ansosten geht nix
	 **/

	InformationBroadcaster( CommunicationManager *pManager = NULL );
	virtual ~InformationBroadcaster();
	BOOL StartCommunicationIfNecessary();

	BOOL AddCategory( const ByteString &aType );
	BOOL AddCategory( BroadcastCategory nType );
	BOOL RemoveCategory( const ByteString &aType );
	BOOL RemoveCategory( BroadcastCategory nType );

	/**
		die Methode ist nur relevant, wenn der Konstruktor mit NULL verwendet wurde
		In diesem Fall mu sie zum Empfang von Nachrichten aufgerufen werden.
	**/
	BOOL WaitForData();		/// mu nur bei Kommandozeilentool aufgerufen werden

	virtual void MessageArrived( const BroadcastMessage &aMsg );
	virtual void ConnectionTerminated();

	/// Der Link wird mit einem Pointer auf eine BroadcastMessage aufgerufen
	void SetMessageArrivedHdl( Link aLink ) { AddMessageArrivedHdl( aLink ); }
	void AddMessageArrivedHdl( Link aLink ) { aMessageArrivedLnkList.Insert( new Link( aLink ), LIST_APPEND ); }
	void RemoveMessageArrivedHdl( Link aLink );

	/// Der Link wird mit einem NULL Pointer aufgerufen
	void SetConnectionTerminatedHdl( Link aLink ) { AddConnectionTerminatedHdl( aLink ); }
	void AddConnectionTerminatedHdl( Link aLink ) { aConnectionTerminatedLnkList.Insert( new Link( aLink ), LIST_APPEND ); }
	void RemoveConnectionTerminatedHdl( Link aLink );



	BOOL Broadcast( const ByteString &aType, const ByteString &aMsg, BroadcastFilterFlag nFlags = BCST_FILTER_NOFILTER );
	BOOL Broadcast( BroadcastCategory nType, const ByteString &aMsg, BroadcastFilterFlag nFlags = BCST_FILTER_NOFILTER );

	BroadcastCategory Name2Id( const ByteString &aType );
	ByteString Id2Name( BroadcastCategory aType );
	ByteString Description( BroadcastCategory aType );
	ClientID GetClientID() { return aThisClientID; }

	void SetApplication( const ByteString& aApp ) { mpManager->SetApplication( aApp ); }
};

class BroadcastMessage : public ByteString
{
public:
	BroadcastMessage( ByteString nMsg, BroadcastCategory nBC, ClientID aCI = BCST_CLIENT_UNKNOWN ): ByteString( nMsg ), nBroadcastCategory( nBC ), aClientID( aCI ){;}
	BroadcastCategory GetBroadcastCategory() const { return nBroadcastCategory; }
	ClientID GetClientID() { return aClientID; }
	BOOL IsSameClient( BroadcastMessage *pBM ) { return pBM->GetClientID() == GetClientID(); }
	BOOL IsSameClient( InformationBroadcaster *pIB ) { return pIB->GetClientID() == GetClientID(); }
private:
	BroadcastCategory nBroadcastCategory;
	ClientID aClientID;
};

#endif
