/*************************************************************************
 *
 *  $RCSfile: vermap.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: nf $ $Date: 2001/04/18 09:13:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _TOOLS_DEBUG_HXX
#include "debug.hxx"
#endif
#include "vermap.hxx"
#include "command.hxx"
#include "fsys.hxx"
#include "appdef.hxx"

//
// class UPDVersionMapper
//

/*****************************************************************************/
UPDVersionMapper::UPDVersionMapper( ByteString &rVer )
/*****************************************************************************/
		: sVersion( rVer ),
		sEnvironment(),
		bL( FALSE )
{
}

/*****************************************************************************/
UPDVersionMapper::UPDVersionMapper(
	ByteString &rVer, ByteString &rEnv, BOOL bMapL )
/*****************************************************************************/
		: sVersion( rVer ),
		sEnvironment( rEnv ),
		bL( bMapL )
{
}

/*****************************************************************************/
void UPDVersionMapper::PrintStatus( const char *cStatus )
/*****************************************************************************/
{
}

/*****************************************************************************/
int UPDVersionMapper::Execute()
/*****************************************************************************/
{
#ifdef WNT
	int nStatus;

	ByteString sOldPath( "PATH=" );
	sOldPath += GetEnv( "PATH" );
	ByteString sPath( "PATH=r:\\etw;" );
	sPath += sOldPath;

	putenv( sPath.GetBuffer());
	
	DirEntry aEntry( String::CreateFromAscii( "r:\\etw\\emerg.btm" ));
	if ( !aEntry.Exists()) {
		ByteString aTmp( GetEnv( "TMP" ));
		if ( !aTmp.Len())
			aTmp = GetEnv( "TEMP" );
		if ( !aTmp.Len())
			aEntry = DirEntry( String::CreateFromAscii( "emerg.btm" ));
		else {
			aEntry = DirEntry( String( aTmp, RTL_TEXTENCODING_ASCII_US ));
			aEntry += DirEntry( String::CreateFromAscii( "emerg.btm" ));
		}
	}
	else {
		ByteString aTmp( GetEnv( "TMP" ));
		if ( !aTmp.Len())
			aTmp = GetEnv( "TEMP" );
		if ( aTmp.Len()) {
			DirEntry aDestination = DirEntry( String( aTmp, RTL_TEXTENCODING_ASCII_US ));
			aDestination += DirEntry( String::CreateFromAscii( "emerg.btm" ));

			aEntry.CopyTo( aDestination );
		}
	}

	ByteString aCommandString( aEntry.GetFull(), RTL_TEXTENCODING_ASCII_US );
	aCommandString += " ";
	aCommandString += sVersion;
	if ( bL )
	{
		aCommandString += " -MAPL ";
		aCommandString += sEnvironment;
	}

	CCommand aCommand( aCommandString );
	nStatus = aCommand;

	putenv( sOldPath.GetBuffer());

	return nStatus;
#else
	DBG_ERROR("Not implemented");
	return 0;
#endif
return 0;
}

