/*************************************************************************
 *
 *  $RCSfile: setsolar.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: svesik $ $Date: 2001/05/04 17:04:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <intn.hxx>
#include "iparser.hxx"
#include "geninfo.hxx"
#include <stdlib.h>
#include "envset.hxx"
#include "vermap.hxx"
#include "appdef.hxx"
#include "inimgr.hxx"

#define SETSOLAR_NO_VERSION			0xFF00
#define SETSOLAR_FILE_WRITTEN		0xFF01
#define SETSOLAR_FILE_NOT_WRITTEN	0xFF02
#define SETSOLAR_NO_ENV				0xFF03

class SetSolar : public EnvironmentSetter
{
protected:
	virtual void PrintStatus( const char *cStatus )
		{ fprintf( stderr, "%s\n", cStatus ); }

public:
	SetSolar( const ByteString &rConfigFile,
		GenericInformationList *pVerList,
		EnvironmentSetter *pEnvSet )
			: EnvironmentSetter( rConfigFile, pVerList, pEnvSet ) {};
};

/****************************************************************************/
void PrintResult( USHORT nResult )
/****************************************************************************/
{
	ByteString sMessage;
	switch ( nResult ) {
	case ENVSET_NO_ERROR :
		break;
	case ENVSET_NO_FILE :
		sMessage = ByteString( "ERROR: The Database could not be found\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - There is no connection to the Server, who" );
		sMessage += ByteString("         holds the Database.\n" );
		sMessage += ByteString("       - The user have no access rights.\n" );
		sMessage += ByteString("       - The database is inconsistent.\n" );
		break;
	case ENVSET_FILE_ERROR :
		sMessage = ByteString( "ERROR: in Database\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - Syntax error in Configfile.\n" );
		sMessage += ByteString("       - There is no Entry in Configfile.\n" );
		break;
	case ENVSET_SWITCHES_ERROR :
		sMessage = ByteString( "ERROR: wrong Commandline\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - unknown switch.\n" );
		sMessage += ByteString("       -switch has been reserved for another\n" );
		sMessage += ByteString("         Environment or Workspace.\n" );
		sMessage += ByteString("       - parameter expected for switch.\n" );
		sMessage += ByteString("       - missing parameter.\n" );
		break;
	case ENVSET_NO_ENVIRONMENT :
		sMessage = ByteString( "ERROR: no such Environment in databas3\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - no such Enviroment.\n" );
		sMessage += ByteString("       - environment only exists only in another workspace.\n" );
		sMessage += ByteString("       - The database is inconsistent.\n" );
		break;
	case ENVSET_NO_SWITCH :
		sMessage = ByteString( "ERROR: unknown switch\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - wrong switch.\n" );
		sMessage += ByteString("       - switch is only valid in another workspace.\n" );
		sMessage += ByteString("       - switch is only valid in another environment.\n" );
		break;
	case ENVSET_MISSING_VALUE :
		sMessage = ByteString( "ERROR: missing parameter\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - parameter expected for switch.\n" );
		break;
	case ENVSET_NO_ORDER :
		sMessage = ByteString( "ERROR: the key \"order\" can no be found \n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - The database is inconsistent.\n" );
		break;
	case ENVSET_UNKNOWN_BLOCK :
		sMessage = ByteString( "ERROR: unknown block in database\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - The database is inconsistent.\n" );
		break;
	case SETSOLAR_NO_VERSION :
		sMessage = ByteString( "ERROR: no such workspace\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - the given UPD is not valid.\n" );
		sMessage += ByteString("       - no such workspace.\n" );
		sMessage += ByteString("       - no default workspace given in database.\n" );
		break;
	case SETSOLAR_FILE_WRITTEN :
		break;
	case SETSOLAR_FILE_NOT_WRITTEN :
		sMessage = ByteString( "ERROR: writing Setsolar-Script \n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - no write permissions for Temp/Tmp-Directory.\n" );
		sMessage += ByteString("       - no access rights for script.\n" );
		break;
	case SETSOLAR_NO_ENV :
		sMessage = ByteString( "ERROR: no such environemt\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - no such environment.\n" );
		sMessage += ByteString("       - no such environment in workspace.\n" );
		break;
	case ENVSET_VERLISTENTRY_NOT_FOUND :
		sMessage = ByteString( "ERROR: no such data in STANDLISTE\n" );
		sMessage += ByteString("       This could have the following reasons:\n" );
		sMessage += ByteString("       - wrong path in configuration.\n" );
		sMessage += ByteString("       - no such data in that path.\n" );
		break;
	}
	fprintf( stderr, "%s\n", sMessage.GetBuffer());

//	if ( nResult != ENVSET_NO_ERROR )
//		fprintf( stderr, "Hilfe fuer SETSOLAR: \\\\PVCS\\DATA7\\DOKU\\SOLAR\\UMGEBUNG\\INHALT.HTML\n\n" );
}

/****************************************************************************/
#if defined( UNX ) || defined( MAC )
int main( int argc, char *argv[] )
#else
int _cdecl main( int argc, char *argv[] )
#endif
/****************************************************************************/
{
	if ( argc < 2 ) {
		PrintResult( ENVSET_SWITCHES_ERROR );
		return 1;
	}

	// get upd and environment out of command line
	ByteString sFileName;
	ByteString sUPD;
	ByteString sVersion;
	ByteString sUPDMinor;
	ByteString sLastParam( argv[ argc - 1 ]);
	if ( sLastParam.Len() == 3 ) {
		sUPD = sLastParam;
		argc--;
	}
	ByteString sEnv( argv[ argc - 1 ]);
	argc --;

	SwitchList aSwitchList;
	BOOL bMap = FALSE;
	BOOL bPro = FALSE;
	BOOL bMapL = FALSE;

	// parse whole command line
	BOOL bError = FALSE;
	int i;
	for ( i = 1; !bError && i < argc; i++ ) {
		ByteString sSwitch( argv[ i ]);
		if ( sSwitch.GetChar( 0 ) != '-' )
			bError = TRUE;
		else {
			sSwitch = sSwitch.GetToken( 1, '-' );
			if ( !sSwitch.Len())
				bError = TRUE;
			else {
				if ( i == argc - 1 ) {
					// must be a switch without value
					ByteString sTmp( "" );
					Switch *pSwitch = new Switch( sSwitch, sTmp);
					aSwitchList.InsertUnique( pSwitch );
					if ( sSwitch.ToUpperAscii() == "MAP" ) {
						bMap = TRUE;
						pSwitch->Valid();
					}
					else if ( sSwitch.ToUpperAscii() == "PRO" ) {
						bPro = TRUE;
						pSwitch->Valid();
					}
					else if ( sSwitch.ToUpperAscii() == "MAPL" )	{
						bMapL = TRUE;
						bMap = TRUE;
						pSwitch->Valid();
					}
				}
				else {
					// could be a switch with value
					ByteString sValue( argv[ i + 1 ]);
					if ( sValue.GetChar( 0 ) != '-' ) {
						// this is a switch with a value
						i++;
						if ( sSwitch.ToUpperAscii() == "FILE" ) {
							sFileName = sValue;
						}
						else {
							Switch *pSwitch = new Switch( sSwitch, sValue );
							aSwitchList.InsertUnique( pSwitch );
							if ( sSwitch.ToUpperAscii() == "VER" ) {
								pSwitch->Valid();
								sUPDMinor = sValue;
							}
						}
					}
					else {
						// this is a switch without a value
						ByteString sTmp( "" );
						Switch *pSwitch = new Switch( sSwitch, sTmp);
						aSwitchList.InsertUnique( pSwitch );
						if ( sSwitch.ToUpperAscii() == "MAP" ) {
							bMap = TRUE;
							pSwitch->Valid();
						}
						else if ( sSwitch.ToUpperAscii() == "PRO" ) {
							bPro = TRUE;
							pSwitch->Valid();
						}
						else if ( sSwitch.ToUpperAscii() == "MAPL" )	{
							bMapL = TRUE;
							bMap = TRUE;
							pSwitch->Valid();
						}
					}
				}
			}
		}
	}

	if ( bError ) {
		PrintResult( ENVSET_SWITCHES_ERROR );
		return 1;
	}

	if ( sUPD.Len()) {
		sVersion = ByteString( "SRC" );
		sVersion += sUPD;
	}

	// get verison database
	fprintf( stderr, "\nUpdate of Configuration-Data ...\n" );
	IniManager aIniManager;
	aIniManager.Update();
	ByteString sDefLst( GetDefStandList());
	ByteString sStandLst( aIniManager.ToLocal( sDefLst ));
	fprintf( stderr, "\nDatabase: %s\n", sStandLst.GetBuffer());

	InformationParser aParser;
	String s = String( sStandLst, gsl_getSystemTextEncoding() );
	GenericInformationList *pVerList = aParser.Execute( s );
	if ( !pVerList ) {
		PrintResult( ENVSET_NO_FILE );
		return 1;
	}

	if ( !sVersion.Len()) {
		// search in command line for version definition
		BOOL bFound = FALSE;
		for ( ULONG i = 0; !bFound && i < aSwitchList.Count(); i++ ) {
			Switch *pSwitch = aSwitchList.GetObject( i );
			for ( ULONG j = 0; !bFound && j < pVerList->Count(); j++ ) {
				GenericInformation *pVersion = pVerList->GetObject( j );
				if ( *pVersion == (*pSwitch).ToUpperAscii()) {
					bFound = TRUE;
					sVersion = *pSwitch;
					pSwitch->Valid();
					sUPD = sVersion.Copy( sVersion.Len() - 3 );
					ByteString sEnvKey( "Environments" );
					sEnvKey += "/";
					sEnvKey += sEnv;
					GenericInformation *pCheckEnv = pVersion->GetSubInfo( sEnvKey, TRUE );
					if ( !pCheckEnv ) {
						PrintResult( SETSOLAR_NO_ENV );
						return 1;
					}
				}
			}
		}
	}

	if ( !sVersion.Len()) {
		// search for defaul version in database
		BOOL bFound = FALSE;
		for ( ULONG j = 0; !bFound && j < pVerList->Count(); j++ ) {
			GenericInformation *pVersion = pVerList->GetObject( j );
			ByteString sPath( "settings/now" );
			GenericInformation *pNow = pVersion->GetSubInfo( sPath, TRUE );
			if ( pNow && ( pNow->GetValue() == "_TRUE" )) {
				bFound = TRUE;
				sVersion = *pVersion;
				sUPD = sVersion.Copy( sVersion.Len() - 3 );
			}
		}
	}

	if ( !sVersion.Len()) {
		PrintResult( SETSOLAR_NO_VERSION );
		return 1;
	}

#ifndef UNX
	if ( bMap ) {
		ByteString sFullEnv( sEnv );
		if ( bPro )
			sFullEnv += ".pro";
		UPDVersionMapper aMapper( sVersion, sFullEnv, bMapL );
		aMapper.Execute();
	}
#endif

	// get setsolar inifile out of database
	ByteString sConfigFile( GetSSolarIni() );
	ByteString sPath( sVersion );
#ifndef UNX
	sPath += ByteString( "/settings/ssolarini" );
#else
	sPath += ByteString( "/settings/unxssolarini" );
#endif
	GenericInformation *pIniFile = pVerList->GetInfo( sPath, TRUE );
	if ( pIniFile ) {
		ByteString aIniRoot( GetIniRoot() );
		DirEntry aIniEntry( String( aIniRoot, RTL_TEXTENCODING_ASCII_US ));
		aIniEntry += DirEntry( String( pIniFile->GetValue(), RTL_TEXTENCODING_ASCII_US )).GetBase( PATH_SEPARATOR );
		sConfigFile = ByteString( aIniEntry.GetFull(), RTL_TEXTENCODING_ASCII_US );
	}

	// common part of init
	ByteString sCmnFile( GetSSCommon() );
	sCmnFile = aIniManager.ToLocal( sCmnFile );
	EnvironmentSetter aEnvSet( sCmnFile, pVerList );
	if ( aEnvSet.GetError() == ENVSET_NO_ERROR ) {
		ByteString sUPDVariable( "UPD" );
		aEnvSet.Insert( sUPDVariable, sUPD );
		ByteString sVersionVariable( "WORK_STAMP" );
		aEnvSet.Insert( sVersionVariable, sVersion );
		if ( sUPDMinor.Len()) {
			aEnvSet.Insert( "UPDMINOR", sUPDMinor );
			ByteString sExt( "." ); sExt += sUPDMinor;
			aEnvSet.Insert( "UPDMINOREXT", sExt );
		}
		else {
			ByteString sEmpty;
			aEnvSet.Insert( "UPDMINOR", sEmpty );
			aEnvSet.Insert( "UPDMINOREXT", sEmpty );
		}

		aEnvSet.Execute( aSwitchList, sEnv );
	}

	sConfigFile = aIniManager.ToLocal( sConfigFile );
	fprintf( stderr, "Setsolar-Initialising: %s\n", sConfigFile.GetBuffer());
	SetSolar aSetSolar( sConfigFile, pVerList, &aEnvSet );

	// at first, insert upd and work_stamp in environment
	ByteString sUPDVariable( "UPD" );
	aSetSolar.Insert( sUPDVariable, sUPD );
	ByteString sVersionVariable( "WORK_STAMP" );
	aSetSolar.Insert( sVersionVariable, sVersion );
	if ( sUPDMinor.Len()) {
		aSetSolar.Insert( "UPDMINOR", sUPDMinor );
		ByteString sExt( "." ); sExt += sUPDMinor;
		aSetSolar.Insert( "UPDMINOREXT", sExt );
	}
	else {
		ByteString sEmpty;
		aSetSolar.Insert( "UPDMINOR", sEmpty );
		aSetSolar.Insert( "UPDMINOREXT", sEmpty );
	}

	USHORT nRet = aSetSolar.Execute( aSwitchList, sEnv );
	PrintResult( nRet );

	delete pVerList;

	if ( nRet == ENVSET_NO_ERROR ) {
		if ( !sFileName.Len()) {
#ifndef UNX
			sFileName = ByteString( getenv( "TMP" ));
			sFileName += ByteString( "\\setsolar" );
#ifndef OS2
			sFileName += ByteString( ".bat" );
#else
			sFileName += ByteString( ".cmd" );
#endif
#else
			sFileName += ByteString( "~/setsolar" );
#endif
		}
		if ( aSetSolar.WriteToFile( sFileName )) {
			PrintResult( SETSOLAR_FILE_WRITTEN );
			fprintf( stderr, "The script \"%s\" has been written.\n",
				sFileName.GetBuffer());
			fprintf( stderr, "Setsolar executed successfully!\n\n" );
		}
		else {
			PrintResult( SETSOLAR_FILE_NOT_WRITTEN );
			return 1;
		}
	}
	else
		return 1;

	// log setsolar call
#ifndef UNX
	ByteString sUser( getenv( "VCSID" ));
#else
	ByteString sUser( getenv( "USER" ));
#endif
	ByteString sUpdater( getenv( "UPDATER" ));
	if ( sUpdater.ToUpperAscii() != "YES" ) {
		ByteString sLogFileName( GetBServerRoot() );
#ifndef UNX
		sLogFileName += "\\sslog\\";
#else
		sLogFileName += "/sslog/";
#endif
		sLogFileName += sVersion.ToUpperAscii();
		sLogFileName += ".SSLOG";
		DirEntry aExistsEntry( String( sLogFileName, gsl_getSystemTextEncoding()));
		if ( !aExistsEntry.Exists()) {
			SvFileStream aTstStream( String( sLogFileName, gsl_getSystemTextEncoding()), STREAM_WRITE );
			aTstStream.Close();
		}
		DirEntry aLogTstEntry( String( sLogFileName, gsl_getSystemTextEncoding()));
		if ( aLogTstEntry.Exists()) {
			ByteString sLogLine( sUser );
			sLogLine += ":";
			for ( i = sLogLine.Len(); i < 8; i++ )
				sLogLine += " ";
			sLogLine += sEnv;
			if ( bPro )
				sLogLine += ".pro";
			for ( i = sLogLine.Len(); i < 24; i++ )
				sLogLine += " ";
			sLogLine += "Minor: ";
			sLogLine += sUPDMinor;
			for ( i = sLogLine.Len(); i < 40; i++ )
				sLogLine += " ";

			International aIntn( LANGUAGE_GERMAN, LANGUAGE_GERMAN );
			sLogLine += ByteString( aIntn.GetDate( Date()), gsl_getSystemTextEncoding());
			sLogLine += " - ";
			sLogLine += ByteString( aIntn.GetTime( Time()), gsl_getSystemTextEncoding());

			SvFileStream aLogStream;
			aLogStream.Open( String( sLogFileName, gsl_getSystemTextEncoding()), STREAM_STD_WRITE );
			while ( !aLogStream.IsOpen())
				aLogStream.Open( String( sLogFileName, gsl_getSystemTextEncoding()), STREAM_STD_WRITE );
			aLogStream.Seek( STREAM_SEEK_TO_END );
			aLogStream.WriteLine( sLogLine );
			aLogStream.Close();
		}
	}

	return 0;
}
