#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.14 $
#
#   last change: $Author: obr $ $Date: 2001/11/26 15:04:04 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=..$/..$/..

PRJNAME=sysui
TARGET=cdeint

give_me_all_languages=yes
no_common_build_zip=yes

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk
.INCLUDE :  locales.tab

# --- Files --------------------------------------------------------

.IF "$(OS)"=="SOLARIS" || "$(OS)"=="LINUX"

UNIXTEXT= \
	$(MISC)$/dtint.sh \
	$(MISC)$/dtappintegrate.sh

LNGFILES= \
    group.lng \
    writer.lng \
    calc.lng \
    draw.lng \
    impress.lng

#    player.lng

# save build time
.IF "$(make_zip_deps)"==""

LANGLIST:=$(locales:s/locale_//)
LANGFLAGFILES:=$(foreach,i,$(LANGLIST) $(foreach,j,$(LNGFILES) $(MISC)$/cde$(j:b).$i))
CONVFILES:=$(foreach,i,$(LANGLIST) $(foreach,j,$(locale_$i) $(foreach,k,$(LNGFILES) $(RES)$/$(k:b).$j)))
    
.ENDIF # "$(make_zip_deps)"==""

ZIPFLAGS= -u

ZIP1TARGET      = cdegroup
ZIP1LIST        = icons/001*.xpm icons/016*.xpm icons/017*.xpm icons/500*.xpm icons/501*.xpm

ZIP2TARGET      = cdewriter
ZIP2LIST        = icons/002*.xpm icons/003*.xpm icons/011*.xpm icons/012*.xpm icons/014*.xpm icons/015*.xpm

ZIP3TARGET      = cdecalc
ZIP3LIST        = icons/004*.xpm icons/005*.xpm icons/013*.xpm 

ZIP4TARGET      = cdedraw
ZIP4LIST        = icons/006*.xpm icons/007*.xpm 

ZIP5TARGET      = cdeimpress
ZIP5LIST        = icons/008*.xpm icons/009*.xpm icons/010*.xpm 

#ZIP6TARGET      = cdeplayer
#ZIP6LIST        = icons/100*.xpm icons/500*.xpm

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

ALLTAR : LNGCONVFILES

.IF "$(CONVFILES)"!=""

LNGCONVFILES : $(CONVFILES)

$(LANGFLAGFILES) : $(LNGFILES) cdeint makefile.mk $(BIN)$/cdegroup.zip $(BIN)$/cdewriter.zip $(BIN)$/cdecalc.zip $(BIN)$/cdedraw.zip $(BIN)$/cdeimpress.zip # $(BIN)$/cdeplayer.zip
    +@$(BIN)$/lngconv -o $(RES) $(@:b:s/cde//).lng $(@:e:s/.//) $(rescharset_$(@:e:s/.//)) $(locale_$(@:e:s/.//))
    +@$(PERL) cdeint $(OUT) $(@:e:s/.//) $(@:b:s/cde//) $(locale_$(@:e:s/.//))
    +@touch $@

$(CONVFILES) : $(LANGFLAGFILES)

.ENDIF # "$(CONVFILES)"!=""
.ELSE          # "$(OS)"=="SOLARIS" || "$(OS)"=="LINUX"

nothing_to_do :
    @+-echo nothing to do here
    
.ENDIF          # "$(OS)"=="SOLARIS" || "$(OS)"=="LINUX"

