/*************************************************************************
 *
 *  $RCSfile: wizgo1.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: os $ $Date: 2001/10/02 12:52:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "hintids.hxx"
#include "uiparam.hxx"

#ifndef _COM_SUN_STAR_UTIL_SEARCHOPTIONS_HPP_
#include <com/sun/star/util/SearchOptions.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
#include <com/sun/star/lang/Locale.hpp>
#endif
#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif

#ifndef _TXTCMP_HXX //autogen
#include <svtools/txtcmp.hxx>
#endif
#ifndef _KEYCOD_HXX //autogen
#include <vcl/keycod.hxx>
#endif
#ifndef _SVX_PAPERINF_HXX //autogen
#include <svx/paperinf.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _SVX_BOXITEM_HXX //autogen
#include <svx/boxitem.hxx>
#endif
#ifndef _SVX_PBINITEM_HXX //autogen
#include <svx/pbinitem.hxx>
#endif
#ifndef _SVX_ULSPITEM_HXX //autogen
#include <svx/ulspitem.hxx>
#endif
#ifndef _SVX_PRNTITEM_HXX //autogen
#include <svx/prntitem.hxx>
#endif
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif

#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _FMTSRND_HXX //autogen
#include <fmtsrnd.hxx>
#endif
#ifndef _FMTFSIZE_HXX //autogen
#include <fmtfsize.hxx>
#endif
#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#ifndef _FMTORNT_HXX //autogen
#include <fmtornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>	 // Writershell
#endif
#ifndef _EXPFLD_HXX
#include <expfld.hxx>	 // Seitenraender,
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>	 // Seitenraender,
#endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>	 // Fussz,Kopfz,FlyHoriOrient
#endif
#ifndef _DOCUFLD_HXX
#include <docufld.hxx>	 // DS_PAGE
#endif
#ifndef _FLDDAT_HXX
#include <flddat.hxx>	 // DATE_FIX
#endif
#ifndef _FLDMGR_HXX
#include <fldmgr.hxx>	 // Datenbankfeld einfuegen
#endif
#ifndef _TABCOL_HXX
#include <tabcol.hxx>  	// SwTabCols
#endif
#ifndef _WIZGO_HXX
#include <wizgo.hxx>
#endif
#ifndef _WIZPAGE_HXX
#include <wizpage.hxx>
#endif

using namespace rtl;
using namespace com::sun::star;
using namespace com::sun::star::lang;
using namespace com::sun::star::util;

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

// Einfuegen eines String
void WizardGo::InsString( const String& rStr )
{
	USHORT n = CountLines( rStr );
	USHORT i;
	for (i=0; i<n; i++)
	{
		pShell->Insert(GetLine(rStr,i));
		if (i<n-1)
			pShell->SplitNode();
	}
}

// Einfuegen eines String bestehend aus Text und DB-Feldern
void WizardGo::InsDBasFldStr(const String& rStr)
{
	USHORT n = CountLines( rStr );
	USHORT i;
	String aStr1,aStr2;
	BOOL   bIsFld;
	USHORT j;
    sal_Unicode c;
	for( i = 0; i < n; ++i )
	{
		aStr1 = GetLine( rStr, i );
		bIsFld = FALSE;
		aStr2 = aEmptyStr;
		for( j = 0; j < aStr1.Len(); ++j )
		{
			c = aStr1.GetChar(j);
			if( c == '<' && !bIsFld )
			{
				bIsFld = TRUE;
				if( aStr2.Len() )
				{
					pShell->Insert( aStr2 );
					aStr2 = aEmptyStr;
				}
			}
			else if (c == '>' && bIsFld)
			{
				bIsFld = FALSE;
				if( aStr2.Len() )
				{
                    ::ReplacePoint(aStr2, TRUE);
					InsDBasFld( aStr2 );
					aStr2 = aEmptyStr;
				}
			}
			else
			   aStr2 += c;

		}
		if( aStr2.Len() )
			pShell->Insert( aStr2 );
		if( i < n - 1 )
			pShell->SplitNode();
	}
}

void WizardGo::InsLogoObj(WizardLogo& rLogo, BOOL bKopz, BOOL bPrintGraf)
{
	if( rLogo.IsTextLogo() )
	{
		// Schriftgroesse aendern
		long tHgt = Twip( rLogo.GetLogoTextHgt() );
		tHgt = tHgt * 9 / 10;  // Sicherheitshalber 10% weg
		if( tHgt < 40 )	// mind. 2 Point
			tHgt = 40;
		pShell->SetAttr( SvxFontHeightItem( (ULONG) tHgt ) );
		InsString( rLogo.GetStr() );
	}
	else
	{
		String aFNam;
		String aFilt;
		if( rLogo.GetGraphic( aFNam, aFilt ) )
		{
			DelFrame();

			SfxItemSet aSet( pShell->GetAttrPool(), aGrfFmtCollSetRange );
			aSet.Put( SwFmtSurround( SURROUND_PARALLEL ));
			aSet.Put( SwFmtFrmSize( ATT_FIX_SIZE, Twip( rLogo.GetWdt() ),
												Twip( rLogo.GetHgt() ) ) );
			if (bKopz)
			{
				aSet.Put( SwFmtAnchor( FLY_AT_CNTNT ));
				SwHoriOrient eOrient = HORI_NONE;
				switch( rLogo.GetAlign() )
				{
					case ALIGN_LiOb:
					case ALIGN_LiUn: eOrient=HORI_LEFT;   break;
					case ALIGN_MiOb: eOrient=HORI_CENTER; break;
					case ALIGN_ReOb:
					case ALIGN_ReUn: eOrient=HORI_RIGHT;  break;
				}
				aSet.Put( SwFmtHoriOrient( 0, eOrient, FRAME ) );
			}
			else
			{
				aSet.Put( SwFmtFrmSize( ATT_FIX_SIZE, Twip( rLogo.GetWdt() ),
												Twip( rLogo.GetHgt() ) ) );

				USHORT nPhyPageNum, nVirtPageNum;
				pShell->GetPageNum( nPhyPageNum, nVirtPageNum );
				aSet.Put( SwFmtAnchor( FLY_PAGE, nPhyPageNum ));

				aSet.Put( SwFmtHoriOrient( Twip( rLogo.GetPosX() ), HORI_NONE, FRAME ) );
				aSet.Put( SwFmtVertOrient( Twip( rLogo.GetPosY() ), VERT_NONE, FRAME ) );
			}

			if( !bPrintGraf )
				aSet.Put( SvxPrintItem( RES_PRINT, bPrintGraf ));

			pShell->SwFEShell::Insert( aFNam, aFilt, 0, &aSet );
			pShell->UnSelectFrm();
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

void WizardGo::SetFusz( WizardFusz& rFusz, const sal_Char* pFusMark,
										   const sal_Char* pNumMark )
{
	BOOL bFusz=rFusz.IsVisible();
	if( pNumMark && GotoBookmark( pNumMark ))
	{
		if (rFusz.IsPgNum())
		{
			USHORT nFmt=rFusz.GetPgNumFmt();
			SwFldMgr aFldMgr;
			String aStr(rFusz.GetPgNumStr());
			if( aStr.Len() )
			{
				aStr+=' ';
				InsString(aStr);
			}
            SwInsertFld_Data aData(TYP_PAGENUMBERFLD, 0, aEmptyStr, aEmptyStr,
                                nFmt, pShell );
            aFldMgr.InsertFld( aData );
			if( rFusz.IsPgNumGes() )
			{
				aStr = rFusz.GetPgNumGesStr();
				if( aStr.Len() )
				{
					aStr.Insert( ' ', 0 );
					aStr += ' ';
					InsString( aStr );
				}
                SwInsertFld_Data aData(TYP_DOCSTATFLD, DS_PAGE, aEmptyStr,
                                    aEmptyStr, nFmt, pShell );
                aFldMgr.InsertFld( aData );
			}
		}
		else
			pShell->DelFullPara();
	}
	if( pFusMark && GotoBookmark( pFusMark ) )
	{
		USHORT nPgDescIdx=pShell->GetCurPageDesc();
		SwPageDesc aPageDesc(pShell->GetPageDesc(nPgDescIdx));
		SwFrmFmt*  pFmt=&aPageDesc.GetMaster();	 //CopyCtor geht hier nicht, da Pointer
		if (rFusz.IsVisible())
		{
			InsString(rFusz.GetStr());
			SwFmtFooter aFooterFmt(pFmt->GetFooter());
			SwFrmFmt* pFooterFmt=aFooterFmt.GetFooterFmt();
			SvxULSpaceItem aULSpace(pFooterFmt->GetULSpace()); // Upper/Lower-Space holen
			aULSpace.SetUpper(USHORT(rFusz.GetTextDst()));	 // Abstand zum Text
			pFooterFmt->SetAttr(aULSpace);

			if (!rFusz.IsTrennlinie())
				// Trennlinie aus
				pFooterFmt->SetAttr( SvxBoxItem() );
			pFmt->SetAttr(aFooterFmt);
		}
		if( !bFusz )
		{
			// Fuzeile entfernen !
			pFmt->SetAttr(SwFmtFooter(BOOL(FALSE)));
			aPageDesc.ChgFooterShare(FALSE);
		}
		pShell->ChgPageDesc(nPgDescIdx,aPageDesc);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WizardGo::GotoBookmark( const sal_Char* pName, const sal_Char cAdd )
{ // Zur Textmarke Springen und den dahinterstehenden Text in eckigen Klammern lschen
	String aStr; aStr.AppendAscii( pName );
	if( cAdd )
		aStr += cAdd;
	if( pShell->GotoBookmark( aStr ) )
	{
		if( '[' == pShell->GetChar() )
		{
			String sTxt( pShell->GetText() );
			xub_StrLen nPos = sTxt.Search( ']' );
			if( nPos != STRING_NOTFOUND )
			{
				pShell->SttSelect();
				pShell->ExtendSelection( TRUE, nPos+1 );
			}
			else
			{
				SearchOptions aSearchOpt;
				aSearchOpt.searchString = OUString::valueOf( sal_Unicode(']'));
				aSearchOpt.algorithmType = SearchAlgorithms_ABSOLUTE;
				aSearchOpt.Locale = CreateLocale( GetAppLanguage() );

				pShell->SearchPattern( aSearchOpt, DOCPOS_CURR, DOCPOS_END );
				pShell->ExtendSelection( TRUE, 1 );
				pShell->SttSelect();
				pShell->GotoBookmark( aStr );
			}
			pShell->EndSelect();
			pShell->DelRight();
		}
		return TRUE;
	}
	ASSERT( !this, "Bookmark not found" );
	return FALSE;
}

void WizardGo::InsertBookmark( const sal_Char* pName )
{
	pShell->SetBookmark( KeyCode(), String::CreateFromAscii( pName ),
						aEmptyStr );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////


void WizardGo::DelFrame()
{
	pShell->WizzardDelFly();
}

void WizardGo::MovFrame(WizardFrame& rFrm, BOOL bPreventHgt, BOOL bPutBack)
{
	MovFrame(rFrm.GetPosX(),rFrm.GetPosY(),rFrm.GetWdt(),rFrm.GetHgt(),bPreventHgt,bPutBack);
}

void WizardGo::MovFrame( long X, long Y, long W, long H, BOOL bPreventHgt,
						BOOL bPutBack )
{
	X=Twip(X);
	Y=Twip(Y);
	W=Twip(W);
	H=Twip(H);

	SwFrmFmt* pFmt = pShell->WizzardGetFly();
	if( pFmt )
	{
		SwFmtFrmSize aSize( pFmt->GetFrmSize() );
		if( !bPreventHgt )
			aSize.SetHeight( Max( H, long( MINFLY ) ) );
		aSize.SetWidth( Max( W, long( MINFLY ) ) );

		pFmt->SetAttr( aSize );
		pFmt->SetAttr( SwFmtVertOrient( Y, VERT_NONE, FRAME ) );
		pFmt->SetAttr( SwFmtHoriOrient( X, HORI_NONE, FRAME ) );

// Hallo MA: wie das ohne Layout ??
//		if( bPutBack )
//			pShell->SelectionToBottom();
	}
}

void WizardGo::SizFrame(long W, long H, BOOL bPreventHgt, BOOL bPutBack )
{
	W=Twip(W);
	H=Twip(H);

	SwFrmFmt* pFmt = pShell->WizzardGetFly();
	if( pFmt )
	{
		SwFmtFrmSize aSize( pFmt->GetFrmSize() );
		if( !bPreventHgt )
			aSize.SetHeight( Max( H, long( MINFLY ) ) );
		aSize.SetWidth( Max( W, long( MINFLY ) ) );

		pFmt->SetAttr( aSize );

// Hallo MA: wie das ohne Layout ??
//		if( bPutBack )
//			pShell->SelectionToBottom();
	}
}

void WizardGo::JstFrame(PageAlign eJst, BOOL bPutBack)
{
	SwHoriOrient eOrient;
	switch( eJst )
	{
		case ALIGN_LiOb:
		case ALIGN_LiUn: eOrient = HORI_LEFT;	 break;
		case ALIGN_MiOb: eOrient = HORI_CENTER; break;
		case ALIGN_ReOb:
		case ALIGN_ReUn: eOrient = HORI_RIGHT;	 break;
		default: return;
	}

	SwFrmFmt* pFmt = pShell->WizzardGetFly();
	if( pFmt )
	{
		SwFmtHoriOrient aHoriOrient( pFmt->GetHoriOrient() );
		if( eOrient != aHoriOrient.GetHoriOrient() )
		{
			aHoriOrient.SetHoriOrient( eOrient );
			pFmt->SetAttr( aHoriOrient );
		}

// Hallo MA: wie das ohne Layout ??
//		if( bPutBack )
//			pShell->SelectionToBottom();
	}

}

void WizardGo::PrnFrame( BOOL bPrn )
{
	SwFrmFmt* pFmt = pShell->WizzardGetFly();
	if( pFmt && pFmt->GetPrint().GetValue() != bPrn )
		pFmt->SetAttr( SvxPrintItem( RES_PRINT, bPrn ) );
}

void WizardGo::SetMarg( const WizardPage& rPage, WizardKopz* pKopz,
						WizardFusz* pFusz )
{
	SvxLRSpaceItem aLR;
	aLR.SetLeft( (USHORT) Twip( rPage.RandL ) );	// 1/EINHEIT mm nach Twip
	aLR.SetRight( (USHORT) Twip( rPage.RandR ) );

	SvxULSpaceItem aOU;
	long nTmp;

	if( pKopz && pKopz->IsVisible() )
		nTmp = pKopz->GetVer();
	else
		nTmp = rPage.RandO;
	aOU.SetUpper( (USHORT)Twip( nTmp ) );

	if( pFusz && pFusz->IsVisible() )
		nTmp = pFusz->GetVer();
	else
		nTmp = rPage.RandU;
	aOU.SetLower( (USHORT)Twip( nTmp ) );

	USHORT nPgDescIdx = pShell->GetCurPageDesc();
	SwPageDesc aPageDesc( pShell->GetPageDesc( nPgDescIdx ) );
	SwFrmFmt* pFmt = &aPageDesc.GetMaster();
	pFmt->SetAttr( aLR );
	pFmt->SetAttr( aOU );

	if( rPage.IsDinA5Q() )
	{
        Size aPSize;
        if ( MEASURE_METRIC == GetAppLocaleData().getMeasurementSystemEnum() )
            aPSize = SvxPaperInfo::GetPaperSize( SVX_PAPER_A5 );
        else
        {
            aPSize = SvxPaperInfo::GetPaperSize( SVX_PAPER_LETTER );
            aPSize.Height() /= 2;
        }
        LandscapeSwap( aPSize );
		pFmt->SetAttr( SwFmtFrmSize( ATT_FIX_SIZE, aPSize.Width(), aPSize.Height() ));
	}
//??	else if( rPage.IsDinA4() )

	pShell->ChgPageDesc( nPgDescIdx, aPageDesc );
}

void WizardGo::SetTray( USHORT nTray )
{
    USHORT nDesc = pShell->GetCurPageDesc();
    SwPageDesc aDesc = pShell->GetPageDesc( nDesc );
    aDesc.GetMaster().SetAttr(SvxPaperBinItem( RES_PAPER_BIN, (BYTE) nTray ) );
    pShell->ChgPageDesc( nDesc, aDesc );
}

void WizardGo::MarkText()
{
	// Die Zeile "[Bitte geben Sie hier Ihren Text ein]" wird markiert
	if( GotoBookmark( "Text" ))
	{
		InsertBookmark("Text");
		pShell->SttSelect();
		if( !pShell->IsEndPara() )
			pShell->MovePara( fnParaCurr, fnParaEnd );
		pShell->EndSelect();
	}
}

void WizardGo::DelText()
{
	// der Text zwischen DelA und DelE wird gelscht
	if (pShell->GotoBookmark(String::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM( "DelA" ))) )
	{
		pShell->Left( FALSE, 1, TRUE );
		pShell->SttSelect();
		String sBookmk( String::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( "DelE" )) );
		if (pShell->GotoBookmark( sBookmk ))
		{
			if( !pShell->IsEndPara() )
				pShell->MovePara( fnParaCurr, fnParaEnd );
			pShell->EndSelect();
			pShell->DelRight();
			pShell->DelBookmark( sBookmk );
		}
		else
			pShell->EndSelect();
	}
}

void WizardGo::SetTabColWidth( SwTabCols& rCols, USHORT nNum, long nNewWidth )
{
	// aktuelle Breite setzen
	// alle folgenden Verschieben
	SwTwips nWidth = 0;

	if( rCols.Count() > 0 )
	{
		nWidth = (nNum == rCols.Count()) ?
				rCols.GetRight() - rCols[nNum-1] :
				nNum == 0 ? rCols[nNum] - rCols.GetLeft() :
							rCols[nNum] - rCols[nNum-1];

		if(nNum < rCols.Count())
			rCols[nNum] += nNewWidth - nWidth;
		else
			rCols[rCols.Count()-1] -= nNewWidth - nWidth;
	}
	else
		rCols.SetRight( Min( nNewWidth, rCols.GetRightMax() ) );
}



