/*************************************************************************
 *
 *  $RCSfile: wizcfg.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: os $ $Date: 2001/09/04 13:52:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _WIZCFG_HXX
#define _WIZCFG_HXX

#endif

#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
//-----------------------------------------------------------------------------
class WizardDokuDlg;
class SwWizardCfgDocInfo
{
	sal_Bool			bValuesRead;
protected:
	rtl::OUString	  	sSaveDocInfoTitle;
	rtl::OUString	  	sSaveDocInfoSubject;
	rtl::OUString	  	sSaveTemplateName;
	rtl::OUString	  	sSaveTemplateInfo;
	sal_Bool		   	bSaveAutoDocName;
	rtl::OUString	  	sSaveAutoPrefix;
	rtl::OUString	  	sSaveAutoPath;
public:
	SwWizardCfgDocInfo() :
		bSaveAutoDocName(sal_False),
		bValuesRead(sal_False){}

	void WriteDocInfo(const WizardDokuDlg&);
	void ReadDocInfo(WizardDokuDlg&);

	sal_Bool 	HasValuesRead() const {return bValuesRead;}
	void 		SetValuesRead() {bValuesRead = sal_True;}
};
//-----------------------------------------------------------------------------
class AgendaArray;
class SwAgendaWizardCfg : public utl::ConfigItem, public SwWizardCfgDocInfo
{
	AgendaArray*    pAgendaArr;
	sal_Int32 		nStyle;
	rtl::OUString	sLogoGrapicName;
	rtl::OUString	sLogoGrapicFilter;
	sal_Bool   		bOccasion;
	sal_Int32 		nNumber;
	sal_Bool		bNotes;
	sal_Int64		nDate;
	sal_Bool		bConvened;
	sal_Bool		bExperts;
	sal_Bool		bGuests;
	sal_Bool		bPresiding;
	sal_Bool		bBringAlong;
	sal_Bool		bPostprocessing;
	rtl::OUString	sLocation;
	sal_Bool		bMinutes;
	sal_Bool		bUseMinutes;
	sal_Bool		bParticipants;
	rtl::OUString	sTitle;
	sal_Bool		bLogoVisible;
	sal_Int64		nTime;
	sal_Bool		bPrepare;

	com::sun::star::uno::Sequence<rtl::OUString> GetPropertyNames();

public:
	SwAgendaWizardCfg();
	~SwAgendaWizardCfg();

	virtual void	Commit();

	sal_Int32 		GetStyle() const {return nStyle;}
	void 			SetStyle(sal_Int32 nSet) {nStyle = nSet;}

	rtl::OUString	GetLogoGrapicName() const {return sLogoGrapicName;}
	void 			SetLogoGrapicName(const rtl::OUString& rSet ) {sLogoGrapicName = rSet;}

	rtl::OUString	GetLogoGraphicFilter() const {return sLogoGrapicFilter;}
	void 			SetLogoGraphicFilter(const rtl::OUString& rSet) {sLogoGrapicFilter = rSet;}

	sal_Bool   		IsOccasion() const {return bOccasion;}
	void 			SetOccasion(sal_Bool bSet) {bOccasion = bSet;}

	sal_Int32 		GetNumber() const {return nNumber;}
	void 			SetNumber(sal_Int32 nSet) {nNumber = nSet;}

	sal_Bool		IsNotes() const {return bNotes;}
	void 			SetNotes(sal_Bool bSet) {bNotes = bSet;}

	sal_Int64		GetDate() const {return nDate;}
	void 			SetDate(sal_Int64 nSet) {nDate = nSet;}

	sal_Bool		IsConvened() const {return bConvened;}
	void 			SetConvened(sal_Bool bSet) {bConvened = bSet;}

	sal_Bool		IsExperts() const {return bExperts;}
	void 			SetExperts(sal_Bool bSet) {bExperts = bSet;}

	sal_Bool		IsGuests() const {return bGuests;}
	void 			SetGuests(sal_Bool bSet) {bGuests = bSet;}

	sal_Bool		IsPresiding() const {return bPresiding;}
	void 			SetPresiding(sal_Bool bSet) {bPresiding = bSet;}

	sal_Bool		IsBringAlong() const {return bBringAlong;}
	void 			SetBringAlong(sal_Bool bSet) {bBringAlong = bSet;}

	sal_Bool		IsPostprocessing() const {return bPostprocessing;}
	void 			SetPostprocessing(sal_Bool bSet) {bPostprocessing = bSet;}

	rtl::OUString	GetLocation() const {return sLocation;}
	void 			SetLocation(const rtl::OUString& rSet) {sLocation = rSet;}

	sal_Bool		IsMinutes() const {return bMinutes;}
	void 			SetMinutes(sal_Bool bSet) {bMinutes = bSet;}

	sal_Bool		IsUseMinutes() const {return bUseMinutes;}
	void 			SetUseMinutes(sal_Bool bSet) {bUseMinutes = bSet;}

	sal_Bool		IsParticipants() const {return bParticipants;}
	void 			SetParticipants(sal_Bool bSet) {bParticipants = bSet;}

	rtl::OUString	GetTitle() const {return sTitle;}
	void 			SetTitle(const rtl::OUString& rSet) {sTitle = rSet;}

	sal_Bool		IsLogoVisible() const {return bLogoVisible;}
	void 			SetLogoVisible(sal_Bool bSet) {bLogoVisible = bSet;}

	sal_Int64 		GetTime() const {return nTime;}
	void			SetTime(sal_Int64 nSet) {nTime = nSet;}

	sal_Bool		IsPrepare() const {return bPrepare;}
	void 			SetPrepare(sal_Bool bSet) {bPrepare = bSet;}

	AgendaArray&	GetAgendaArray();
};
//-----------------------------------------------------------------------------
class LetterDialog;
class SwLetterWizardCfg : public utl::ConfigItem, public SwWizardCfgDocInfo
{
	friend class LetterDialog;
	sal_Bool			bTemplateType;
	sal_Int32 			nTemplateStyleTypePreferredStyle;

	sal_Bool		   	bLogoVisible;
	sal_Bool		   	bLogoIsGraphic;
	rtl::OUString	  	sLogoText;
	rtl::OUString	  	sLogoFileTypeName;
	rtl::OUString	  	sLogoFileTypeFilter;
	sal_Int32			nLogoPositionXYTypeX;
	sal_Int32			nLogoPositionXYTypeY;
	sal_Int32		   	nLogoSizeTypeWidth;
	sal_Int32		   	nLogoSizeTypeHeight;
	sal_Int32		   	nLogoAlignmentAlignmentTypePosition;
	sal_Int32		   	nLogoAlignmentPositionTypeLeft;
	sal_Int32		   	nLogoAlignmentPositionTypeRight;
	sal_Int32		   	nLogoAlignmentPositionTypeTop;
	sal_Int32		   	nLogoAlignmentPositionTypeBottom;

	sal_Bool 			bSenderShow;
	rtl::OUString		sSenderContent;
	sal_Bool			bSenderRepeat;
	sal_Int32			nSenderPositionXYTypeX;
	sal_Int32			nSenderPositionXYTypeY;
	sal_Int32			nSenderSizeTypeWidth;
	sal_Int32			nSenderSizeTypeHeight;
	sal_Int32			nSenderAlignmentTypePosition;
	sal_Int32			nSenderPositionTypeLeft;
	sal_Int32			nSenderPositionTypeRight;
	sal_Int32			nSenderPositionTypeTop;
	sal_Int32			nSenderPositionTypeBottom;

	rtl::OUString		sRecipientDatabase;
    rtl::OUString       sRecipientDataTable;
    rtl::OUString       sRecipientContent;
	rtl::OUString		sRecipientSalutation;
	rtl::OUString		sRecipientSalutationField;
	sal_Int32			nRecipientPositionXYTypeX;
	sal_Int32		   	nRecipientPositionXYTypeY;
	sal_Int32		   	nRecipientSizeTypeWidth;
	sal_Int32		   	nRecipientSizeTypeHeight;
	sal_Int32		   	nRecipientAlignmentAlignmentTypePosition;
	sal_Int32		   	nRecipientAlignmentPositionTypeLeft;
	sal_Int32		   	nRecipientAlignmentPositionTypeRight;
	sal_Int32		   	nRecipientAlignmentPositionTypeTop;
	sal_Int32		   	nRecipientAlignmentPositionTypeBottom;

	sal_Bool			bElementsElement1TextElementTypeVisible;
	rtl::OUString		sElementsElement1TextElementTypeContent;
	sal_Bool			bElementsElement2TextElementTypeVisible;
	rtl::OUString		sElementsElement2TextElementTypeContent;
	sal_Bool			bElementsElement3TextElementTypeVisible;
	rtl::OUString		sElementsElement3TextElementTypeContent;
	sal_Bool			bElementsElement4TextElementTypeVisible;
	rtl::OUString		sElementsElement4TextElementTypeContent;
	sal_Bool			bElementsDateIntElementTypeVisible;
	sal_Int32			nElementsDateIntElementTypeContent;
	sal_Bool		   	bElementsSubjectTextElementTypeVisible;
	rtl::OUString	  	sElementsSubjectTextElementTypeContent;
	sal_Bool		   	bElementsCopy;
	sal_Bool		   	bElementsEnclosure;
	sal_Bool		   	bElementsPageNumberVisible;
	rtl::OUString	  	sElementsPageNumberTextBefore;
	sal_Int32			nElementsPageNumberFormat;
	sal_Bool		   	bElementsPageNumberTotalPageCountVisible;
	rtl::OUString		sElementsPageNumberTotalPageCountTextBefore;

	sal_Int32		   	nHeaderFromTop;
	sal_Int32		   	nHeaderFromText;
	sal_Bool		   	bHeaderSenderVisible;
	sal_Int32		   	nHeaderSenderSizeTypeWidth;
	sal_Int32		   	nHeaderSenderSizeTypeHeight;
	sal_Int32		   	nHeaderSenderAlignmentTypePosition;
	sal_Bool		   	bHeaderLogoVisible;
	sal_Int32		   	nHeaderLogoSizeTypeWidth;
	sal_Int32		   	nHeaderLogoSizeTypeHeight;
	sal_Int32		   	nHeaderLogoAlignmentTypePosition;

	sal_Bool		   	bFooterOnPage1Enable;
	sal_Bool		   	bFooterOnPage1Separator;
	rtl::OUString	  	sFooterOnPage1Text;
	sal_Int32		   	nFooterOnPage1FromBottom;
	sal_Int32		   	nFooterOnPage1FromText;
	sal_Bool		   	bFooterOnContinuationPagesEnable;
	sal_Int32		   	nFooterOnContinuationPagesFromBottom;
	sal_Int32		   	nFooterOnContinuationPagesFromText;

	sal_Int32		   	nPrintSender;
	sal_Int32		 	nPrintLogo;
	rtl::OUString	  	sPrintPrinter;
	rtl::OUString	  	sPrintTrayPage1;
	rtl::OUString	  	sPrintTrayContinuationPage;

	sal_Int32 			nPageMarginLeft;
	sal_Int32 			nPageMarginRight;

	com::sun::star::uno::Sequence<rtl::OUString> GetPropertyNames();
public:
	SwLetterWizardCfg();
	~SwLetterWizardCfg();

	virtual void		Commit();
};
//-----------------------------------------------------------------------------
class MemoDialog;
class SwMemoWizardCfg : public utl::ConfigItem, public SwWizardCfgDocInfo
{
		friend class MemoDialog;
		sal_Int32		nTemplateStylePreferredStyle;
		rtl::OUString	sTemplateTitleText;
		sal_Bool		bTemplateTitleIsGraphic;
		rtl::OUString	sTemplateTitleFileName;
		rtl::OUString	sTitleFileFilter;
		sal_Bool		bElementsElement1TextVisible;
		rtl::OUString	sElementsElement1TextContent;
		sal_Bool		bElementsElement2TextVisible;
		rtl::OUString	sElementsElement2TextContent;
		sal_Bool		bElementsElement3TextVisible;
		rtl::OUString	sElementsElement3TextContent;
		sal_Bool		bElementsElement4TextVisible;
		rtl::OUString	sElementsElement4TextContent;
		sal_Bool		bElementsDateValueVisible;
		sal_Int32		nElementsDateValueContent;
		sal_Bool		bElementsSubjectTextVisible;
		rtl::OUString	sElementsSubjectTextContent;
		sal_Bool		bElementsTo;
		sal_Bool		bElementsCopy;
		sal_Bool		bElementsFrom;
		sal_Bool		bHeaderDate;
		sal_Bool		bHeaderTitle;
		sal_Bool		bHeaderPageNumber;
		sal_Bool		bHeaderSeparator;
		sal_Bool		bFooterDate;
		sal_Bool		bFooterPageNumber;
		sal_Bool		bFooterSeparator;
		sal_Bool		bFooterConfidentialLevelVisible;
		rtl::OUString	sFooterConfidentialLevelContent;

	com::sun::star::uno::Sequence<rtl::OUString> GetPropertyNames();
public:
	SwMemoWizardCfg();
	~SwMemoWizardCfg();

	virtual void		Commit();
};
//-----------------------------------------------------------------------------
class FaxDialog;
class SwFaxWizardCfg : public utl::ConfigItem, public SwWizardCfgDocInfo
{
		friend class FaxDialog;
		sal_Int32 		nTemplateStylePreferredStyle;
		sal_Int32 		nTemplateFormatWidth;
		sal_Int32 		nTemplateFormatHeight;
		rtl::OUString 	sTemplateTitle;
		sal_Bool 		bLogoVisible;
		sal_Bool 		bLogoIsGraphic;
		rtl::OUString 	sLogoText;
		rtl::OUString 	sLogoGraphicFileName;
		rtl::OUString 	sLogoGraphicFileFilter;
		sal_Int32 		nLogoPositionX;
		sal_Int32 		nLogoPositionY;
		sal_Int32 		nLogoSizeWidth;
		sal_Int32 		nLogoSizeHeight;
		sal_Int32 		nLogoAlignmentTypePosition;
		sal_Int32 		nLogoAlignmentPositionLeft;
		sal_Int32 		nLogoAlignmentPositionRight;
		sal_Int32 		nLogoAlignmentPositionTop;
		sal_Int32 		nLogoAlignmentPositionBottom;
		rtl::OUString 	sSenderContent;
		rtl::OUString 	sSenderTelNumber;
		rtl::OUString 	sSenderFaxNumber;
		sal_Int32 		nSenderPositionX;
		sal_Int32 		nSenderPositionY;
		sal_Int32 		nSenderSizeWidth;
		sal_Int32 		nSenderSizeHeight;
		sal_Int32 		nSenderAlignmentTypePosition;
		sal_Int32 		nSenderAlignmentPositionLeft;
		sal_Int32 		nSenderAlignmentPositionRight;
		sal_Int32 		nSenderAlignmentPositionTop;
		sal_Int32 		nSenderAlignmentPositionBottom;
		rtl::OUString 	sRecipientDatabase;
        rtl::OUString   sRecipientDataTable;
		rtl::OUString 	sRecipientTelNumber;
		rtl::OUString 	sRecipientFaxNumber;
		rtl::OUString 	sRecipientContent;
		sal_Int32 		nRecipientPositionX;
		sal_Int32 		nRecipientPositionY;
		sal_Int32 		nRecipientSizeWidth;
		sal_Int32 		nRecipientSizeHeight;
		sal_Int32 		nRecipientAlignmentTypePosition;
		sal_Int32 		nRecipientAlignmentPositionLeft;
		sal_Int32 		nRecipientAlignmentPositionRight;
		sal_Int32 		nRecipientAlignmentPositionTop;
		sal_Int32 		nRecipientAlignmentPositionBottom;
		sal_Bool 		bElementsElement1TextVisible;
		rtl::OUString 	sElementsElement1TextContent;
		sal_Bool 		bElementsElement2TextVisible;
		rtl::OUString 	sElementsElement2TextContent;
		sal_Bool 		bElementsElement3TextVisible;
		rtl::OUString 	sElementsElement3TextContent;
		sal_Bool 		bElementsElement4TextVisible;
		rtl::OUString 	sElementsElement4TextContent;
		sal_Bool 		bElementsDateValueVisible;
		sal_Int32 		nElementsDateValueContent;
		sal_Bool 		bElementsTimeValueVisible;
		sal_Int32 		nElementsTimeValueContent;
		sal_Bool 		bElementsSubjectValueVisible;
		rtl::OUString 	sElementsSubjectValueContent;
		sal_Bool 		bElementsCopy;
		sal_Bool 		bFooterEnable;
		sal_Bool 		bFooterSeparator;
		rtl::OUString 	sFooterText;
		sal_Int32 		nPageMarginLeft;
		sal_Int32 		nPageMarginRight;

	com::sun::star::uno::Sequence<rtl::OUString> GetPropertyNames();
public:
	SwFaxWizardCfg();
	~SwFaxWizardCfg();

	virtual void		Commit();
};

