/*************************************************************************
 *
 *  $RCSfile: conctrl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: tbe $ $Date: 2000/11/10 15:43:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop


#ifndef _SVDVIEW_HXX //autogen
#include <svx/svdview.hxx>
#endif
#ifndef _SVDOBJ_HXX //autogen
#include <svx/svdobj.hxx>
#endif


#include "view.hxx"
#include "edtwin.hxx"
#include "wrtsh.hxx"
#include "drawbase.hxx"
#include "conctrl.hxx"

extern BOOL bNoInterrupt;		// in mainwn.cxx

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/


ConstControl::ConstControl(SwWrtShell* pWrtShell, SwEditWin* pEditWin, SwView* pSwView) :
	SwDrawBase(pWrtShell, pEditWin, pSwView)
{
	bInsCtrl = TRUE;
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/


BOOL ConstControl::MouseButtonDown(const MouseEvent& rMEvt)
{
	BOOL bReturn = FALSE;

	SdrView *pSdrView = pSh->GetDrawView();

	pSdrView->SetOrtho(rMEvt.IsShift());
	pSdrView->SetAngleSnapEnabled(rMEvt.IsShift());

	if (rMEvt.IsMod2())
	{
		pSdrView->SetCreate1stPointAsCenter(TRUE);
		pSdrView->SetResizeAtCenter(TRUE);
	}
	else
	{
		pSdrView->SetCreate1stPointAsCenter(FALSE);
		pSdrView->SetResizeAtCenter(FALSE);
	}

	SdrViewEvent aVEvt;
	SdrHitKind eHit = pSdrView->PickAnything(rMEvt, SDRMOUSEBUTTONDOWN, aVEvt);

	// Nur neues Objekt, wenn nicht im Basismode (bzw reinem Selektionsmode)
	if (rMEvt.IsLeft() && !pWin->IsDrawAction() &&
		(eHit == SDRHIT_UNMARKEDOBJECT || eHit == SDRHIT_NONE || pSh->IsDrawCreate()))
	{
		bNoInterrupt = TRUE;
		pWin->CaptureMouse();

		pWin->SetPointer(Pointer(POINTER_CROSS));

		aStartPos = pWin->PixelToLogic(rMEvt.GetPosPixel());
		bReturn = pSh->BeginCreate(pWin->GetDrawMode(), VCSbxInventor, aStartPos);

		if (bReturn)
			pWin->SetDrawAction(TRUE);
	}
	else
		bReturn = SwDrawBase::MouseButtonDown(rMEvt);

	return (bReturn);
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/


void ConstControl::Activate(const USHORT nSlotId)
{
	switch (nSlotId)
	{
		case SVX_SNAP_PUSHBUTTON:
			pWin->SetDrawMode(OBJ_PUSHBUTTON);
			break;
		case SVX_SNAP_RADIOBUTTON:
			pWin->SetDrawMode(OBJ_RADIOBUTTON);
			break;
		case SVX_SNAP_CHECKBOX:
			pWin->SetDrawMode(OBJ_CHECKBOX);
			break;
		case SVX_SNAP_SPINBUTTON:
			pWin->SetDrawMode(OBJ_SPINBUTTON);
			break;
		case SVX_SNAP_FIXEDTEXT:
			pWin->SetDrawMode(OBJ_FIXEDTEXT);
			break;
		case SVX_SNAP_GROUPBOX:
			pWin->SetDrawMode(OBJ_GROUPBOX);
			break;
		case SVX_SNAP_LISTBOX:
			pWin->SetDrawMode(OBJ_LISTBOX);
			break;
		case SVX_SNAP_COMBOBOX:
			pWin->SetDrawMode(OBJ_COMBOBOX);
			break;
		case SVX_SNAP_EDIT:
			pWin->SetDrawMode(OBJ_EDIT);
			break;
		case SVX_SNAP_HSCROLLBAR:
			pWin->SetDrawMode(OBJ_HSCROLLBAR);
			break;
		case SVX_SNAP_VSCROLLBAR:
			pWin->SetDrawMode(OBJ_VSCROLLBAR);
			break;
		case SVX_SNAP_PREVIEW:
			pWin->SetDrawMode(OBJ_DLG_PREVIEW);
			break;
		case SVX_SNAP_URLBUTTON:
			pWin->SetDrawMode(OBJ_URLBUTTON);
			break;
		default:
			pWin->SetDrawMode(OBJ_NONE);
			break;
	}

	SwDrawBase::Activate(nSlotId);

	pSh->GetDrawView()->SetCurrentObj(OBJ_NONE);

	SetDrawPointer();
}

/*************************************************************************

	  Source Code Control System - History

	  $Log: conctrl.cxx,v $
	  Revision 1.3  2000/11/10 15:43:43  tbe
	  removed outcommented svx include files vcsbxdef.hxx idetemp.hxx
	
	  Revision 1.2  2000/10/23 10:12:19  tbe
	  vcsbxdef.hxx include removed
	
	  Revision 1.1.1.1  2000/09/18 17:14:46  hr
	  initial import
	
	  Revision 1.37  2000/09/18 16:06:00  willem.vandorp
	  OpenOffice header added.
	
	  Revision 1.36  1997/11/28 19:11:30  MA
	  includes
	

	  Rev 1.35   28 Nov 1997 20:11:30   MA
   includes

	  Rev 1.34   24 Nov 1997 14:53:58   MA
   includes

	  Rev 1.33   03 Nov 1997 13:24:20   MA
   precomp entfernt

	  Rev 1.32   05 Sep 1997 11:56:22   MH
   chg: header

	  Rev 1.31   13 Aug 1997 12:36:34   OM
   #42383# Selektion von Punkten im Konstruktionsmode

	  Rev 1.30   13 Aug 1997 12:22:00   OM
   #42383# Selektion von Punkten im Konstruktionsmode

	  Rev 1.29   13 May 1997 12:50:00   OM
   #39898# Resizen von Controls im Create-Mode

	  Rev 1.28   29 Apr 1997 10:18:52   MH
   chg: header

	  Rev 1.27   20 Mar 1997 11:34:00   OM
   Insert und CreateMode merken

	  Rev 1.26   08 Nov 1996 11:47:26   HJS
   includes

	  Rev 1.25   28 Aug 1996 13:39:22   OS
   includes

	  Rev 1.24   13 Jun 1996 12:47:00   MA
   splitt sihxx

	  Rev 1.23   06 Jun 1996 15:16:26   HJS
   clooks

	  Rev 1.22   15 May 1996 09:50:46   OM
   #27776#Haenger beim Einfuegen von Controls beseitigt

	  Rev 1.21   18 Mar 1996 15:11:58   HJS
   clooks

	  Rev 1.20   07 Mar 1996 21:01:10   HJS
   clooks

	  Rev 1.19   07 Mar 1996 14:27:30   HJS
   2 defines zu viel

	  Rev 1.18   26 Feb 1996 09:15:34   OV
   Anbindung URL-Button

	  Rev 1.17   24 Nov 1995 16:58:06   OM
   PCH->PRECOMPILED

	  Rev 1.16   15 Nov 1995 18:35:28   OM
   Virtuelle Fkt rausgeworfen

	  Rev 1.15   08 Nov 1995 14:15:52   OS
   Change => Set

	  Rev 1.14   27 Sep 1995 17:32:44   OM
   Preview-Button ausser Funktion gesetzt

*************************************************************************/

