/*************************************************************************
 *
 *  $RCSfile: ww8par.hxx,v $
 *
 *  $Revision: 1.37.6.1.2.4 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 13:40:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WW8PAR_HXX
#define _WW8PAR_HXX


//#ifndef _COM_SUN_STAR_DRAWING_XSHAPE_HPP_
//#include <com/sun/star/drawing/XShape.hpp>
//#endif
//#ifndef _COM_SUN_STAR_FORM_XFORMCOMPONENT_HPP_
//#include <com/sun/star/form/XFormComponent.hpp>
//#endif
//#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
//#include <com/sun/star/beans/XPropertySet.hpp>
//#endif

#ifndef __SGI_STL_VECTOR
#include <vector>
#endif
#ifndef __SGI_STL_STACK
#include <stack>
#endif
#ifndef __SGI_STL_MAP
#include <map>
#endif


#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _VCL_COLOR_HXX
#include <vcl/color.hxx>
#endif
#ifndef _SV_FONTTYPE_HXX //autogen
#include <vcl/fonttype.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif

#ifndef _FLTSHELL_HXX
#include <fltshell.hxx>			// fuer den Attribut Stack
#endif
#ifndef _WW8STRUC_HXX
#include <ww8struc.hxx>		// WW8_BRC ( Forward-Declaration mit anschliessender
#endif						// Benutzung von WW8_BRC[4] in Deklaration will der
							// doofe Os2Blci nicht )
#ifndef _WW8SCAN_HXX
#include <ww8scan.hxx>	// WW8Fib
#endif

#ifndef _WW8GLSY_HXX
#include <ww8glsy.hxx>
#endif

#ifndef _MSDFFIMP_HXX
#include <svx/msdffimp.hxx>
#endif

#ifndef _MSOCXIMEX_HXX
#include <svx/msocximex.hxx>
#endif

#define WW8_ASCII2STR(s) String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(s))

class SvStringsDtor;
class SwDoc;
class SwPaM;
class SfxPoolItem;
class SwTxtFmtColl;
class SwPageDesc;
class SvxBoxItem;
class SwFmt;
class SwNodeIndex;
class SwFlyFrmFmt;
class SvxTabStopItem;
class SwAttrSet;
class SwNumRule;
class SwFrmFmt;

//class WW8CtrlStack;
class SwFltControlStack;
//class WW8EndStack;
class SwFltEndStack;
class SwWW8StyInf;
class WW8Fib;
class WW8PLCFMan;
struct WW8PLCFManResult;
class WW8Fonts;
class WW8RStyle;
class WW8PLCF_HdFt;
class Plcx_Fkp;
class WW8PLCFx_SEPX;
class WW8Dop;
class WW8ScannerBase;
struct WW8FieldDesc;
struct WW8FlyPara;
struct WW8SwFlyPara;
struct WmfFileHd;
struct WW8_PIC;
class WW8TabDesc;
struct WW8_SHD;
struct WW8_OLST;
class SwNumFmt;
struct WW8_ANLD;
struct WW8_ANLV;
struct WW8_DO;
struct WW8_DPHEAD;
struct WW8_FSPA;
class Plc1;
class SwDrawFrmFmt;
class SdrModel;
class SdrPage;
class SdrObjList;
class SdrObject;
class SdrTextObj;
class Size;
class EditEngine;
struct SwPosition;
class SvShorts;
class WW8ReaderSave;
struct WW8PicDesc;
class Graphic;
//class String;
class SwFieldType;
class SvStorage;
// alt: class SvStorageRef;
class SwFlyFrmFmt;
class SwAttrSet;
class GDIMetaFile;
struct ESelection;
class SfxItemSet;
struct WW8PLCFxDesc;

struct WW8ULSpaceData;
class SdrAttrObj;
struct WW8ULSpaceData;
class _ReadFieldParams;

namespace com{namespace sun {namespace star{
	namespace beans{ class XPropertySet;}
	namespace form { class XFormComponent;}
	namespace drawing{class XShape;}
	namespace lang{class XMultiServiceFactory;}
}}}

//#define WW8_CHARBUF_SIZE 1040	// Lese-Puffer fuer nackten Text

// defines nur fuer die WW8-variable der INI-Datei

#define WW8FL_NO_TEXT        1
#define WW8FL_NO_STYLES      2
#define WW8FL_NO_ZSTYLES     4	// keine Zeichenstyles importieren
#define WW8FL_NO_APO         8
#define WW8FL_NO_HDFT     0x10
#define WW8FL_NO_FTN      0x20
#define WW8FL_NO_FLD      0x40  // keine Felder
#define WW8FL_NO_GRAF     0x80
#define WW8FL_NO_DEFTABS 0x100  // keine impliziten Tabs
#define WW8FL_NO_LRUL    0x200


#define WW8FL_NO_DEFSTYLES        0x400 // falls gestetzt, werden fuer Writer-Def-Styles
										// neue Styles mit den WW8-Def-Style-Eigenschaften
										// erzeugt, statt die Writer-Standards zu ueberschreiben

#define WW8FL_NO_TABLE            0x800
#define WW8FL_NO_OUTLINE         0x1000
#define WW8FL_NO_NUMRULE         0x2000
#define WW8FL_NO_IMPLPASP        0x4000  // no implicit para space
#define WW8FL_NO_GRAFLAYER       0x8000
#define WW8FL_NO_COMPLEX        0x10000
#define WW8FL_NO_OLE            0x20000
#define WW8FL_OLE_TO_GRAF       0x40000
#define WW8FL_NO_VCCONTROLS     0x80000
#define WW8FL_NO_STD_STY_DYA   0x100000
#define WW8FL_NO_COLS          0x200000
#define WW8FL_NO_TOX           0x400000
#define WW8FL_NO_IMPORT      0x20000000
#define WW8FL_WRITE_TO_FILE  0x40000000
#define WW8FL_NOWARN_COMPLEX 0x80000000

// Zusatz-Filter-Flags, gueltig ab Winword 8
#define WW8FL_NO_FLY_FOR_TXBX         1
#define EQUAL_TAB_BORDERDISTS         2


//-----------------------------------------
//            Listen-Manager (ab Ver8)
//-----------------------------------------

struct WW8LFOInfo;
typedef WW8LFOInfo* WW8LFOInfo_Ptr;
// Zeichenattribute aus GrpprlChpx
typedef SfxItemSet* WW8aISet[nWW8MaxListLevel ];
// Zeichen Style Pointer
typedef SwCharFmt* WW8aCFmt[ nWW8MaxListLevel ];
// Redlining: match WinWord author ids to StarWriter author ids
struct WW8AuthorInfo;
typedef WW8AuthorInfo* WW8AuthorInfo_Ptr;

SV_DECL_PTRARR_DEL(		WW8LFOInfos,	WW8LFOInfo_Ptr,		16,16);
SV_DECL_PTRARR_SORT_DEL(WW8AuthorInfos,	WW8AuthorInfo_Ptr,	16,16);
SV_DECL_PTRARR(SwCharFmtPtrArray, SwCharFmt*,4,16);

class SwWW8ImplReader;
class WW8LSTInfo;
class WW8ListManager
{
	SwWW8ImplReader& rReader;
	SwDoc&           rDoc;
	const WW8Fib&    rFib;
	SvStream&        rSt;
    std::vector<WW8LSTInfo* > maLSTInfos;
    std::multimap<const SwNumRule *, SwWW8StyInf*> maStyleNumberingMap;
    typedef std::map<const SwNumRule *, SwWW8StyInf*>::iterator myMapIter;
	WW8LFOInfos* pLFOInfos;// D. aus PLF LFO, sortiert genau wie im WW8 Stream
    USHORT       nUniqueList; // current number for creating unique list names
	BYTE* GrpprlHasSprm(USHORT nId, BYTE& rSprms, BYTE nLen);
	WW8LSTInfo* GetLSTByListId(    ULONG  nIdLst     ) const;
	BOOL ReadLVL(	BYTE nLevel,
					SwNumFmt& rNumFmt,
					SfxItemSet*& rpItemSet,
					USHORT nLevelStyle,
					BOOL bSetStartNo );
	void AdjustLVL( BYTE       nLevel,
					SwNumRule& rNumRule,
					WW8aISet&  rListItemSet,
					WW8aCFmt&  aCharFmt,
					BOOL&      bNewCharFmtCreated,	// Ausgabe-Parameter
					String     aPrefix = aEmptyStr );
	BOOL LFOequaltoLST(WW8LFOInfo& rLFOInfo);
public:
	WW8ListManager(SvStream& rSt_, SwWW8ImplReader& rReader_);
	~WW8ListManager();
	SwNumRule* GetNumRuleForActivation(USHORT nLFOPosition, BYTE nLevel) const;
	BOOL IsSimpleList(USHORT nLFOPosition) const;
    SwNumRule* CreateNextRule(BOOL bSimple);
    	void MapStyleToOrigList(const SwNumRule &rNmRule, SwWW8StyInf& rStyleInf);
	void StrengthReduceListStyles();
};



//-----------------------------------------
//            Stack
//-----------------------------------------
class SwWW8FltControlStack : public SwFltControlStack
{
	SwWW8ImplReader& rReader;
	USHORT nToggleAttrFlags;
protected:
	virtual void SetAttrInDoc(const SwPosition& rTmpPos, SwFltStackEntry* pEntry);

public:
	SwWW8FltControlStack( SwDoc* pDo, ULONG nFieldFl, SwWW8ImplReader& rReader_ ) :
		SwFltControlStack( pDo, nFieldFl ),
		rReader( rReader_ ),
		nToggleAttrFlags( 0 )
	{}

	BOOL IsFtnEdnBkmField(SwFmtFld& rFmtFld, USHORT& nBkmNo);
	void NewAttr(const SwPosition& rPos, const SfxPoolItem& rAttr);
	void SetAttr(const SwPosition& rPos, USHORT nAttrId=0, BOOL bTstEnde=TRUE,
        long nHand=LONG_MAX);
	void SetToggleAttr( BYTE nId, BOOL bOn )
	{
		if( bOn )
			nToggleAttrFlags |= (1 << nId);
		else
			nToggleAttrFlags &= ~(1 << nId);
	}
	USHORT GetToggleAttrFlags() const { return nToggleAttrFlags; }
};



//-----------------------------------------
//     Redlining Authors
//-----------------------------------------
struct WW8AuthorInfo
{
	USHORT nWWAuthorId;
	USHORT nOurId;

	WW8AuthorInfo(USHORT nWWAuthorId_, USHORT nOurId_ = 0):
		nWWAuthorId( nWWAuthorId_ ),
		nOurId(      nOurId_ )
		{}
	BOOL operator==( const WW8AuthorInfo& rEntry ) const
	{
		return (nWWAuthorId == rEntry.nWWAuthorId);
	}
	BOOL operator<( const WW8AuthorInfo& rEntry ) const
	{
		return (nWWAuthorId < rEntry.nWWAuthorId);
	}
};

class wwRedlineStack
{
private:
    std::vector<SwFltStackEntry *> maStack;
    typedef std::vector<SwFltStackEntry *>::reverse_iterator myriter;
    SwDoc &mrDoc;
public:
    explicit wwRedlineStack(SwDoc &rDoc) : mrDoc(rDoc) {}
    void open(const SwPosition& rPos, const SfxPoolItem& rAttr);
    void close(const SwPosition& rPos, SwRedlineType eType);
    void closeall(const SwPosition& rPos);
    ~wwRedlineStack();
private:
    //No copying
    wwRedlineStack(const wwRedlineStack&);
    wwRedlineStack& operator=(const wwRedlineStack&);
};

//-----------------------------------------
//    Mini-Merker fuer einige Flags
//-----------------------------------------
class WW8ReaderSave
{
	SwPosition aTmpPos;
	SwWW8FltControlStack* pOldStck;
    wwRedlineStack *mpOldRedlines;
	WW8PLCFxSaveAll aPLCFxSave;
	WW8PLCFMan* pOldPlcxMan;

	WW8FlyPara* pWFlyPara;
	WW8SwFlyPara* pSFlyPara;
	WW8TabDesc* pTableDesc;
	USHORT nAktColl;
	USHORT nNoAttrScan;
	sal_Unicode cSymbol;
	BOOL bIgnoreText	: 1;
	BOOL bDontCreateSep : 1;
	BOOL bSymbol		: 1;
	BOOL bHdFtFtnEdn	: 1;
	BOOL bApo			: 1;
	BOOL bTxbxFlySection: 1;
	BOOL bTable			: 1;
	BOOL bTableInApo	: 1;
	BOOL bAnl			: 1;
	BOOL bInHyperlink : 1;
    BOOL bVerticalEnviron :1;
    BOOL bWasParaEnd :1;
public:
	WW8ReaderSave( SwWW8ImplReader* pRdr, WW8_CP nStart=-1 );
	void Restore( SwWW8ImplReader* pRdr );
};



enum eF_ResT{ FLD_OK, FLD_TEXT, FLD_TAGIGN, FLD_TAGTXT, FLD_READ_FSPA };

struct SwWW8Shade{
	Color aColor;
#if 0
	//With auto colour, no longer need this.
	BOOL  bWhiteText;
#endif
	SwWW8Shade( BOOL bVer67, const WW8_SHD& rSHD );
};


//-----------------------------------------
//    Formulas
//-----------------------------------------
enum SwWw8ControlType
{
	WW8_CT_EDIT,
	WW8_CT_CHECKBOX,
	WW8_CT_COMBOBOX
};


class WW8FormulaControl : public OCX_Control
{
public:
	WW8FormulaControl(const UniString& sN,SwWW8ImplReader &rR)
		: OCX_Control(sN), rRdr(rR) {}
	void WW8FormulaControl::SetOthersFromDoc(com::sun::star::uno::Reference <
		com::sun::star::form::XFormComponent> &rFComp,
		com::sun::star::awt::Size &rSz,
		com::sun::star::uno::Reference <
		com::sun::star::beans::XPropertySet> &rPropSet);

	UINT8	fToolTip:1;
	UINT8	fNoMark:1;
	UINT8	fUseSize:1;
	UINT8	fNumbersOnly:1;
	UINT8	fDateOnly:1;
	UINT8	fUnused:3;
	UINT16  nSize;

	UINT16	hpsCheckBox;
	UINT16 nChecked;

	UniString sTitle;
	UniString sDefault;
	UniString sFormatting;
	UniString sHelp;
	UniString sToolTip;

	void Read(SwWw8ControlType nWhich,SvStream *pD);
private:
	SwWW8ImplReader &rRdr;
};

class WW8FormulaCheckBox: public WW8FormulaControl
{
public:
	WW8FormulaCheckBox(SwWW8ImplReader &rR)
		: WW8FormulaControl( WW8_ASCII2STR( "CheckBox" ), rR)
		{}
	BOOL Import(const com::sun::star::uno::Reference <
		com::sun::star::lang::XMultiServiceFactory> &rServiceFactory,
		com::sun::star::uno::Reference <
		com::sun::star::form::XFormComponent> &rFComp,
		com::sun::star::awt::Size &rSz);
};

class WW8FormulaEditBox: public WW8FormulaControl
{
public:
	WW8FormulaEditBox(SwWW8ImplReader &rR)
		: WW8FormulaControl( WW8_ASCII2STR( "TextField" ) ,rR)
		{}
	BOOL Import(const com::sun::star::uno::Reference <
		com::sun::star::lang::XMultiServiceFactory> &rServiceFactory,
		com::sun::star::uno::Reference <
		com::sun::star::form::XFormComponent> &rFComp,
		com::sun::star::awt::Size &rSz);
};

class SwMSConvertControls: public SvxMSConvertOCXControls
{
public:
	SwMSConvertControls( SfxObjectShell *pDSh,SwPaM *pP ) :
		SvxMSConvertOCXControls( pDSh,pP ) {}
	BOOL InsertFormula( WW8FormulaControl &rFormula,
		com::sun::star::uno::Reference <
		com::sun::star::drawing::XShape> *pShapeRef=0 );
    BOOL InsertControl(const com::sun::star::uno::Reference<
		com::sun::star::form::XFormComponent >& rFComp,
		const ::com::sun::star::awt::Size& rSize,
		com::sun::star::uno::Reference <
		com::sun::star::drawing::XShape > *pShape,BOOL bFloatingCtrl);
    BOOL SwMSConvertControls::ExportControl(Writer &rWrt,const SdrObject *pObj);
};

class SwMSDffManager : public SvxMSDffManager
{
	SwWW8ImplReader& rReader;
	virtual BOOL GetOLEStorageName( long nOLEId, String& rStorageName,
									SvStorageRef& rSrcStorage,
									SvStorageRef& rDestStorage ) const;
	virtual BOOL ShapeHasText( ULONG nShapeId, ULONG nFilePos ) const;
	virtual SdrObject* ImportOLE( long nOLEId, const Graphic& rGrf,
									const Rectangle& rBoundRect ) const;

//	virtual void ProcessClientAnchor2( SvStream& rStData, DffRecordHeader& rHd, void* pData, DffObjData& );

    SvStream *pFallbackStream;
    List *pOldEscherBlipCache;
public:
	static UINT32 GetFilterFlags();
    static USHORT GetEscherLineMatch(MSO_LineStyle eStyle, MSO_SPT eShapeType,
        USHORT &rThick);
	SwMSDffManager( SwWW8ImplReader& rRdr );
	SwFrmFmt *GetLastOCXShapeFrm() const;
	void DisableFallbackStream();
	void EnableFallbackStream();

private:
// If we convert an OCX through this manager we will store the uno XShape
// reference created through the conversion
	mutable com::sun::star::uno::Reference<
		com::sun::star::drawing::XShape > xShape;
};

//-----------------------------------------
//            Storage-Reader
//-----------------------------------------
class SwWW8ImplReader
{
friend class WW8RStyle;
friend class WW8TabDesc;
friend class WW8ReaderSave;
friend struct WW8FlyPara;
friend struct WW8SwFlyPara;
friend class WW8FlySet;
friend class SwMSDffManager;
friend class SwWW8FltControlStack;
friend class WW8FormulaControl;

	SvStorage* pStg;				// Input-Storage
	SvStream* pStrm;				// Input-(Storage)Stream
	SvStream* pTableStream;			// Input-(Storage)Stream
	SvStream* pDataStream;	  		// Input-(Storage)Stream

// allgemeines
	SwDoc& rDoc;
	SwPaM* pPaM;

	SwWW8FltControlStack* pCtrlStck;	// Stack fuer die Attribute

	wwRedlineStack *mpRedlineStack;

	SwFltEndStack*		  pEndStck;		// End-Stack fuer die Attribute
	SwWW8FltControlStack* pRefFldStck;	// for Reference Fields

//	BYTE* pCharBuf;				// Puffer fuer nackten Text
	SwMSConvertControls *pFormImpl;	// Control-Implementierung

	SwFlyFrmFmt* pFlyFmtOfJustInsertedGraphic;
	SwFrmFmt* pFmtOfJustInsertedGraphicOrOLE;
	//Keep track of generated Ruby character formats
	SwCharFmtPtrArray aRubyCharFmts;

    /*
    Stack of textencoding being used as we progress through the document text
    */
    ::std::stack<rtl_TextEncoding> maFontSrcCharSets;

	WW8Fib* pWwFib;
	WW8Fonts* pFonts;
	WW8Dop* pWDop;
	WW8ListManager* pLstManager;
	WW8ScannerBase* pSBase;
	WW8PLCFMan* pPlcxMan;

	WW8RStyle* pStyles;				// Pointer auf die Style-Einleseklasse
	SwFmt* pAktColl;				// gerade zu erzeugende Collection
									// ( ist ausserhalb einer Style-Def immer 0 )
	SfxItemSet* pAktItemSet;		// gerade einzulesende Zeichenattribute
									// ( ausserhalb des WW8ListManager Ctor's immer 0 )
	SwWW8StyInf* pCollA;			// UEbersetzungs-Array der Styles
	const SwTxtFmtColl* pDfltTxtFmtColl;	// Default
	SwFmt* pStandardFmtColl;		// "Standard"

	SwPageDesc* pPageDesc;		// fuer uebernommene KF-Zeilen
	WW8PLCF_HdFt* pHdFt;		// Pointer auf Header / Footer - Scannerklasse

	WW8FlyPara* pWFlyPara;		// WW-Parameter
	WW8SwFlyPara* pSFlyPara;	// daraus erzeugte Sw-Parameter

	WW8TabDesc* pTableDesc;		// Beschreibung der Tabelleneigenschaften

	SwNumRule* pNumRule;		// fuer Nummerierung / Aufzaehlungen im Text
	WW8_OLST* pNumOlst;			// Gliederung im Text
	SwNodeIndex* pBehindSection;// Node-Index zum Zuruecksetzen des PaM nach einem Bereich
	SwSection*   pNewSection;	// last Section that was inserted into the doc

	SwNode*      pNode_FLY_AT_CNTNT; // set: WW8SwFlyPara()   read: CreateSwTable()

	SwDrawFrmFmt *pDrawFmt;		// wie FlyFrmFmt
	SdrModel* pDrawModel;
	SdrPage* pDrawPg;
	SdrObjList* pDrawGroup;
	SvShorts* pDrawHeight;		// Welches Objekt ueberdeckt welches ?
	EditEngine* pDrawEditEngine;

	SwFieldType* pNumFldType;	// fuer Nummernkreis

	SwMSDffManager* pMSDffManager;

	SvStringsDtor* pAtnNames;

	WW8AuthorInfos*	pAuthorInfos;

	SwNodeIndex* pLastPgDeskIdx;// for inserting a section when Ft-/End-Note
								// with flag 'on end of section' set

								// Ini-Flags:
	ULONG nIniFlags;			// Flags aus der writer.ini
	ULONG nIniFlags1;			// dito ( zusaetzliche Flags )
//	ULONG nIniHdSiz;			// dito fuer Header
	ULONG nIniFtSiz;			// dito fuer Default-Size Footer
	ULONG nFieldFlags;			// dito fuer Feldern
	ULONG nFieldTagAlways[3];	// dito fuers Taggen von Feldern
	ULONG nFieldTagBad[3];		// dito fuers Taggen von nicht importierbaren F.

	ULONG nLastFlyNode;			// Node number of last imported Fly

	ULONG nImportedGraphicsCount;	// benoetigt fuer MakeUniqueGraphName()

	ULONG nHdTextHeight;		// Hoehe des eingelesenen Headers
	ULONG nFtTextHeight;		// Hoehe des eingelesenen Footers

	ULONG nDrawObjOfs;
	long nDrawCpO;				// Anfang der Txbx-SubDocs

	long nPicLocFc;				// Picture Location in File (FC)
	long nObjLocFc;				// Object Location in File (FC)

	INT32 nIniFlyDx;			// X-Verschiebung von Flys
	INT32 nIniFlyDy;			// Y-Verschiebung von Flys

	rtl_TextEncoding eTextCharSet;		// Default-Charset fuer Text
	rtl_TextEncoding eStructCharSet;		// rtl_TextEncoding fuer interne Strukturen
	rtl_TextEncoding eHardCharSet;       // Hartes rtl_TextEncoding-Attribut

	USHORT nProgress;			// %-Angabe fuer Progressbar
	USHORT nColls;				// Groesse des Arrays
	USHORT nAktColl;			// gemaess WW-Zaehlung
	USHORT nPageDescOffset;		// fuer UpdatePageDescs
	USHORT nDrawTxbx;			// Nummer der Textbox ( noetig ?? )
	USHORT nFldNum;				// laufende Nummer dafuer
	USHORT nLFOPosition;

	short nActSectionNo;		// aktuelle Abschnitts-Nummer (in CreateSep() gesetzt)
	short nCharFmt;				// gemaess WW-Zaehlung, <0 fuer keine
	short nAlign2;
	short nPgWidth;
	short nPgTop;				// fuer APOs
	short nPgLeft;				// Seitenraender, z.B. fuer APOs, Tabellen
	short nPgRight;				// dito

	short nLeftParaMgn;			// Absatz L-Space
	short nTxtFirstLineOfst;	// Absatz 1st line ofset

	short nDrawXOfs, nDrawYOfs;
	short nDrawXOfs2, nDrawYOfs2;

	sal_Unicode cSymbol;		// aktuell einzulesendes Symbolzeichen


	BYTE nWantedVersion;		// urspruenglich vom Writer
								// angeforderte WW-Doc-Version


	BYTE nSwNumLevel;			// LevelNummer fuer Outline / Nummerierung
	BYTE nWwNumType;			// Gliederung / Nummerg / Aufzaehlg
	BYTE nDrawHeaven, nDrawHell;
	BYTE nListLevel;

	BYTE nNfcPgn;				// Formatting of PageNum
	BYTE nPgChpDelim;			// ChapterDelim from PageNum
	BYTE nPgChpLevel;			// ChapterLevel of Heading from PageNum

	BYTE nCorrIhdt;				// used in CreateSep()
	BOOL bSectionHasATitlePage;	// used in CreateSep()

	BOOL bNew;				// Neues Dokument ?
	BOOL bReadNoTbl;		// Keine Tabellen
	BOOL bPgSecBreak;		// Page- oder Sectionbreak ist noch einzufuegen
	BOOL bSpec;				// Special-Char im Text folgt
	BOOL bObj;				// Obj im Text
	BOOL bApo;				// FlyFrame, der wegen Winword APO eingefuegt wurde
	BOOL bTxbxFlySection;	// FlyFrame, der als Ersatz fuer Winword Textbox eingefuegt wurde
	BOOL bHasBorder;		// fuer Buendelung der Border
	BOOL bSymbol;			// z.B. Symbol statt Times
	BOOL bIgnoreText;		// z.B. fuer FieldVanish
	BOOL bDontCreateSep;	// e.g. when skipping result of multi-column index-field
 	BOOL bTable;			// wird gerade eine Tabelle eingelesen
	BOOL bTableInApo;		// Table is contained in Apo
	BOOL bWasTabRowEnd;		// Tabelle : Row End Mark
	BOOL bTxtCol;			// TextFarbe direkt gesetzt
	BOOL bShdTxtCol;		// Textfarbe indirekt gesetzt ( Hintergrund sw )
	BOOL bCharShdTxtCol;	// Textfarbe indirekt gesetzt ( Zeichenhintergrund sw )
	BOOL bAnl;				// Nummerierung in Bearbeitung
								// Anl heisst Autonumber level

	BOOL bHdFtFtnEdn;		// Spezialtext: Kopf- Fuss- usw.
	BOOL bFtnEdn;			// Fussnote oder Endnote
	BOOL bIsHeader;			// Text aus Header wird gelesen ( Zeilenhoehe )
	BOOL bIsFooter;			// Text aus Footer wird gelesen ( Zeilenhoehe )

	BOOL bIsUnicode;			// aktuelles Text-Stueck ist als 2-Bytiger-Unicode kodiert
								// bitte NICHT als Bitfeld kodieren!

	BOOL bCpxStyle;			// Style im Complex Part
	BOOL bStyNormal;		// Style mit Id 0 wird gelesen
	BOOL bWWBugNormal;		// WW-Version nit Bug Dya in Style Normal
	BOOL bNoAttrImport;		// Attribute ignorieren zum Ignorieren v. Styles
	BOOL bInHyperlink;      // Sonderfall zum einlesen eines 0x01
								   // siehe: SwWW8ImplReader::Read_F_Hyperlink()
    BOOL bVerticalEnviron;
    BOOL bWasParaEnd;

	// praktische Hilfsvariablen:
	BOOL bVer67;			// ( (6 == nVersion) || (7 == nVersion) );
	BOOL bVer6;				//   (6 == nVersion);
	BOOL bVer7;				//   (7 == nVersion);
	BOOL bVer8;				//   (8 == nVersion);

	BOOL bPgChpLevel;		// ChapterLevel of Heading from PageNum
	BOOL bEmbeddObj;		// EmbeddField gelesen
	BOOL bFloatingCtrl;		// Whether to anchor imported controls as char or para

	BOOL bAktAND_fNumberAcross;	// current active Annotated List Deskriptor - ROW flag

	BOOL bNoLnNumYet;		// no Line Numbering has been activated yet (we import
							//     the very 1st Line Numbering and ignore the rest)
	BOOL bRestartLnNumPerSection;




//---------------------------------------------

	void SetLastPgDeskIdx();

	SwPageDesc* CreatePageDesc( SwPageDesc* pFirstPageDesc,
								SwPaM** ppPaMWanted = 0 );
	void RemoveCols( SwPageDesc& rPageDesc, SwFmtCol*& rpCol );
	BOOL SetCols( SwFrmFmt* pFmt, const WW8PLCFx_SEPX* pSep, USHORT nNettoWidth,
		BOOL bTestOnly = FALSE );
	void SetPage1( SwPageDesc* pPageDesc, SwFrmFmt &rFmt,
				   const WW8PLCFx_SEPX* pSep, USHORT nLIdx,
				   BOOL bIgnoreCols );
	void SetHdFt( SwPageDesc* pPageDesc0, SwPageDesc* pPageDesc1,
				  const WW8PLCFx_SEPX* pSep, BYTE nIPara );
	void GetPageULData( const  WW8PLCFx_SEPX* pSep,
						USHORT nLIdx,
						BOOL   bFirst,
						WW8ULSpaceData& rData );
	void SetPageULSpaceItems( SwFrmFmt &rFmt, WW8ULSpaceData& rData );
    void SetDocumentGrid(SwFrmFmt &rFmt,const WW8PLCFx_SEPX* pSep);

	void SetPageBorder( SwPageDesc* pPageDesc0, SwPageDesc* pPageDesc1,
						const WW8PLCFx_SEPX* pSep, USHORT nLIdx );
	void SetUseOn( SwPageDesc* pPageDesc0, SwPageDesc* pPageDesc1,
				   const WW8PLCFx_SEPX* pSep, BYTE nHdFt );
	void InsertSectionWithWithoutCols( SwPaM& rMyPaM, const SwFmtCol* pCol );
	void CreateSep( const long nTxtPos, BOOL bMustHaveBreak );

	void CopyPageDescHdFt( const SwPageDesc* pOrgPageDesc,
						   SwPageDesc* pNewPageDesc, BYTE nCode );

	void UpdatePageDescs( USHORT nPageDescOffset );

	void DeleteStk(SwFltControlStack* prStck);
	void DeleteCtrlStk()	{ DeleteStk( pCtrlStck	); pCtrlStck   = 0; }
	void DeleteEndStk()		{ DeleteStk( pEndStck	); pEndStck    = 0; }
	void DeleteRefFldStk()	{ DeleteStk( pRefFldStck); pRefFldStck = 0; }

	BOOL ReadChar( long nPosCp, long nCpOfs );
	BOOL ReadPlainChars( long& rPos, long nEnd, long nCpOfs );
	BOOL ReadChars( long& rPos, long nNextAttr, long nTextEnd, long nCpOfs );


	void ReadPlainText( long nStartCp, long nTextLen );
	void ProcessAktCollChange(	WW8PLCFManResult& rRes,
								BOOL* pStartAttr,
								BOOL bCallProcessSpecial );
	long ReadTextAttr( long& rTxtPos, BOOL& rbStartLine );
	void ReadAttrs( long& rNext, long& rTxtPos, BOOL& rbStartLine );
	void ReadAttrEnds( long& rNext, long& rTxtPos );
	void ReadText( long nStartCp, long nTextLen, short nType );

	void ReadRevMarkAuthorStrTabl( SvStream& rStrm, INT32 nTblPos, INT32 nTblSiz, SwDoc& rDoc );

	void Read_HdFtFtnText( const SwNodeIndex* pSttIdx, long nStartCp,
						   long nLen, short nType );
	void Read_HdFt1( BYTE nPara, BYTE nWhichItems, SwPageDesc* pPD );
	void Read_HdFtText( long nStartCp, long nLen, SwPageDesc* pPD,
							 BOOL bUseLeft, BOOL bFooter );

	BYTE* ReadUntilToken( USHORT& rStrLen, USHORT nMaxLen, BYTE nToken );
	void ImportTox( int nFldId, String aStr );

	void EndSprm( USHORT nId );
	void NewAttr( const SfxPoolItem& rAttr );

	BOOL GetFontParams( USHORT, FontFamily&, String&, FontPitch&, rtl_TextEncoding& );
	BOOL SetNewFontAttr( USHORT nFCode, BOOL bSetEnums, USHORT nWhich );
	void ResetCharSetVars();

	const SfxPoolItem* GetFmtAttr( USHORT nWhich );
	BYTE HdFtCorrectPara( BYTE nPara );
	BOOL JoinNode( SwPaM* pPam, BOOL bStealAttr = FALSE );

	BOOL IsBorder( const WW8_BRC* pbrc, BOOL bChkBtwn=FALSE );

    //Set closest writer border equivalent into rBox from pbrc, optionally
    //recording true winword dimensions in pSizeArray. nSetBorders to mark a
    //border which has been previously set to a value and for which becoming
    //empty is valid. Set bCheBtwn to work with paragraphs that have a special
    //between paragraphs border
	BOOL SetBorder( SvxBoxItem& rBox, const WW8_BRC* pbrc, short *pSizeArray=0,
		BYTE nSetBorders=0xFF, BOOL bChkBtwn=FALSE );

	void GetBorderDistance( WW8_BRC* pbrc, Rectangle& rInnerDist );

	BOOL SetShadow( SvxShadowItem& rShadow, const SvxBoxItem& rBox,
        const WW8_BRC pbrc[4] );

    //returns true is a shadow was set
	BOOL SetFlyBordersShadow( SfxItemSet& rFlySet, const WW8_BRC pbrc[4],
        USHORT nInnerMgn, short *SizeArray=0 );

	USHORT MatchSdrBoxIntoFlyBoxItem( const Color& rLineColor,
        MSO_LineStyle eLineStyle, MSO_SPT eShapeType, USHORT &rLineWidth,
        SvxBoxItem& rBox );
	void MatchSdrItemsIntoFlySet( SdrObject*    pSdrObj, SfxItemSet &aFlySet,
        MSO_LineStyle eLineStyle, MSO_SPT eShapeType, Rectangle &rInnerDist,
        BOOL bFixSize );
	void MatchWrapDistancesIntoFlyFmt( SvxMSDffImportRec* pRecord,
									   SwFrmFmt*          pFlyFmt );

	void SetAttributesAtGrfNode( SvxMSDffImportRec* pRecord, SwFrmFmt *pFlyFmt,
		WW8_FSPA *pF );

	BOOL StartApo(const BYTE* pSprm29, const WW8FlyPara *pNowStyleApo,
        WW8_TablePos *pTabPos);
	void StopApo();
	BOOL TestSameApo( const BYTE* pSprm29, const WW8FlyPara *pNowStyleApo,
        WW8_TablePos *pTabPos);
	const BYTE* TestApo( BOOL& rbStartApo, BOOL& rbStopApo, 
        WW8FlyPara* &rpNowStyleApo, BOOL bInTable, BOOL bTableRowEnd, 
        WW8_TablePos *pTabPos);

	BOOL ProcessSpecial( BOOL bAllEnd, BOOL* pbReSync, WW8_CP nStartCp );

	ULONG ReadWmfHeader( WmfFileHd* pHd, long nPos );
	BOOL ReadGrafFile( String& rFileName, Graphic*& rpGraphic,
	   const WW8_PIC& rPic, SvStream* pSt, ULONG nFilePos, BOOL* pDelIt );

	SwFrmFmt* MakeGrafByFlyFmt( SdrTextObj* pReplaceTextObj,
        const SwFrmFmt& rOldFmt,const WW8PicDesc& rPD, const Graphic* pGraph,
        const String& rFileName, const String& rGrName, 
        const SfxItemSet& rGrfSet, const BOOL  bSetToBackground );

	SwFrmFmt* MakeGrafNotInCntnt(const WW8PicDesc& rPD, const Graphic* pGraph,
        const String& rFileName, const String& rGrName, 
        const SfxItemSet& rGrfSet );

	SwFrmFmt* MakeGrafInCntnt(const WW8_PIC& rPic,	 const WW8PicDesc& rPD,
        const Graphic* pGraph, const String& rFileName, const String& rGrName,
        const SfxItemSet& rGrfSet );

	SwFrmFmt* ImportGraf1( WW8_PIC& rPic, SvStream* pSt, ULONG nFilePos );
	SwFrmFmt* ImportGraf(  SdrTextObj* pTextObj = 0, SwFrmFmt* pFlyFmt = 0,
        BOOL bSetToBackground = FALSE );
	BOOL ImportURL(String &sURL,String &sMark,WW8_CP nStart);

	SdrObject* ImportOleBase( Graphic& rGraph,
								BOOL bTstOCXControls,
								const Graphic* pGrf,
								const SfxItemSet* pFlySet );
	SwFrmFmt* ImportOle( const Graphic* = 0, const SfxItemSet* pFlySet = 0 );

	BOOL ImportFormulaControl(WW8FormulaControl &rBox,WW8_CP nStart,
		SwWw8ControlType nWhich);

	void ImportDop( BOOL bNewDoc );

	//This converts MS Asian Typography information into OOo's
	void ImportDopTypography(const WW8DopTypography &rTypo);

	void SetImplicitTab();
	ULONG LoadDoc1( SwPaM& rPaM ,WW8Glossary *pGloss);

	BOOL StartTable(WW8_CP nStartCp);
	void TabCellEnd();
	void StopTable();
	short GetTableLeft();
	BOOL IsInvalidOrToBeMergedTabCell() const;

//	Brush* Shade1( SwWW8Shade& rRet, WW8_SHD* pS );

	ColorData GetCol( BYTE nIco );

// Nummerierungen / Aufzaehlungen ( Autonumbered List Data Descriptor )
// Liste:        ANLD ( Autonumbered List Data Descriptor )
//   eine Ebene: ANLV ( Autonumber Level Descriptor )
//
// Chg7-8:
// Listen sind in WW8 eigene Strukturen, die ueber folgende drei Tabellen
// verwaltet werden: rglst, hpllfo und hsttbListNames
// die Strukturen hierfuer sind: LSTF, LVLF, LFO LFOLVL

	void SetAnlvStrings( SwNumFmt* pNum, WW8_ANLV* pAV, const BYTE* pTxt,
							BOOL bOutline );
	void SetAnld( SwNumRule* pNumR, WW8_ANLD* pAD, BYTE nSwLevel, BOOL bOutLine );
	void SetNumOlst( SwNumRule* pNumR, WW8_OLST* pO, BYTE nSwLevel );
	SwNumRule* GetStyRule();

	void StartAnl( const BYTE* pSprm13 );
	void NextAnlLine( const BYTE* pSprm13, const BYTE* pS12 = 0 );
	void StopAnl( BOOL bGoBack = TRUE );

// GrafikLayer

	BOOL MakeUniqueGraphName(String& rName, const String& rFixedPart);

	BOOL ReadGrafStart( void* pData, short nDataSiz, WW8_DPHEAD* pHd,
						WW8_DO* pDo );
	void InsertObj( SdrObject* pObj, short nWwHeight );
	void ReadLine( WW8_DPHEAD* pHd, WW8_DO* pDo );
	void ReadRect( WW8_DPHEAD* pHd, WW8_DO* pDo );
	void ReadElipse( WW8_DPHEAD* pHd, WW8_DO* pDo );
	void ReadArc( WW8_DPHEAD* pHd, WW8_DO* pDo );
	void ReadPolyLine( WW8_DPHEAD* pHd, WW8_DO* pDo );
	ESelection GetESelection( long nCpStart, long nCpEnd );
	void InsertTxbxStyAttrs( SfxItemSet& rS, USHORT nColl );
	void InsertTxbxAttrs( long nStartCp, long nEndCp, BOOL bONLYnPicLocFc );

	BOOL GetTxbxTextSttEndCp( long& rStartCp, long& rEndCp,
								USHORT nTxBxS, USHORT nSequence );
	BOOL GetTxbxText( String& rString, long StartCp, long nEndCp );
	SwFrmFmt* InsertTxbxText(SdrTextObj*	pTextObj,
						Size*		pObjSiz,
						USHORT		nTxBxS,
						USHORT		nSequence,
						long		nPosCp,
						SwFrmFmt*	pFlyFmt,
						BOOL		bMakeSdrGrafObj,
						BOOL&		rbEraseTextObj,
						BOOL*		pbTestTxbxContainsText = 0,
						long*		pnStartCp      = 0,
						long*		pnEndCp        = 0,
                        BOOL*       pbContainsGraphics = 0,
						SvxMSDffImportRec* pRecord = 0);
	BOOL TxbxChainContainsRealText(	USHORT nTxBxS,
									long&  rStartCp,
									long&  rEndCp );
	void ReadTxtBox( WW8_DPHEAD* pHd, WW8_DO* pDo );
	void ReadCaptionBox( WW8_DPHEAD* pHd, WW8_DO* pDo );
	void ReadGroup( WW8_DPHEAD* pHd, WW8_DO* pDo );
	void ReadGrafPrimitive( short& rLeft, WW8_DO* pDo );
	void ReadGrafLayer1( WW8PLCFspecial* pPF, long nGrafAnchorCp );
	SdrObject* CreateContactObject( SwFlyFrmFmt* pFlyFmt );
	void ProcessEscherAlign( SvxMSDffImportRec* pRecord, WW8_FSPA *pFSPA,
		SfxItemSet &rFlySet, BOOL bOrgObjectWasReplace );
	SwFrmFmt* Read_GrafLayer( long nGrafAnchorCp );
    SwFrmFmt* ImportReplaceableDrawables( SdrObject* &rpObject,
        SdrObject* &rpOurNewObject, SvxMSDffImportRec* pRecord, WW8_FSPA *pF,
        SfxItemSet &rFlySet );
    SwFrmFmt *ConvertDrawTextToFly( SdrObject* &rpObject,
        SdrObject* &rpOurNewObject, SvxMSDffImportRec* pRecord,
        RndStdIds eAnchor, WW8_FSPA *pF, SfxItemSet &rFlySet );
    void MungeTextIntoDrawBox(SdrObject* pTrueObject,
        SvxMSDffImportRec *pRecord, long nGrafAnchorCp, SwFrmFmt *pRetFrmFmt);

	void EmbeddedFlyFrameSizeLock(SwNodeIndex &rStart,SwFrmFmt *pFrmFmt);
	void GrafikCtor();
	void GrafikDtor();

// anderes
	String GetFieldResult( WW8FieldDesc* pF );
	void MakeTagString( String& rStr, const String& rOrg );
	void UpdateFields();
//	void ConvertFName( String& rName );
	void ConvertFFileName( String& rName, const String& rRaw );
	long Read_F_Tag( WW8FieldDesc* pF );
	void InsertTagField( const USHORT nId, const String& rTagText );
	long ImportExtSprm( WW8PLCFManResult* pRes, BOOL bStart );
	void ReadDocInfo();

// Ver8-Listen

	void RegisterNumFmtOnTxtNode(	USHORT nActLFO,
									BYTE   nActLevel,
									BOOL   bSetAttr = TRUE );
    void RegisterNumFmtOnStyle(USHORT nStyle,
        USHORT nActLFO   = USHRT_MAX,
        BYTE   nActLevel = nWW8MaxListLevel );
	void RegisterNumFmt(USHORT nActLFO, BYTE nActLevel);

    SwNumRule* SyncStyleIndentWithList(SwWW8StyInf &rStyleInfo,
        SwNumRule* pRule, BYTE nLevel);

#if 0
// Pictures mit Kode 100, die ueber MsoftbSpContainer abgespeichert sind.
	int WW8QuickHackForMSDFF_DirectBLIPImport( SvStream&	rSt,
												WW8PicDesc*	pPic,
												Graphic&	rData,
												String&		rGraphName);
#endif

// spaeter zu ersetzen durch Aufruf in entsprechend erweiterten SvxMSDffManager


	const String* GetAnnotationAuthor( short nId );

	// Schnittstellen fuer die Toggle-Attribute
	void SetToggleAttr( BYTE nAttrId, BOOL bOn );
	void _ChkToggleAttr( USHORT nOldStyle81Mask, USHORT nNewStyle81Mask );

	void ChkToggleAttr( USHORT nOldStyle81Mask, USHORT nNewStyle81Mask )
	{
		if( nOldStyle81Mask != nNewStyle81Mask &&
			pCtrlStck->GetToggleAttrFlags() )
			_ChkToggleAttr( nOldStyle81Mask, nNewStyle81Mask );
	}

public:		// eigentlich private, geht aber leider nur public
	void ConvertUFName( String& rName );

	long Read_Ftn( WW8PLCFManResult* pRes, BOOL );
	long Read_Field( WW8PLCFManResult* pRes, BOOL );
	long Read_Book( WW8PLCFManResult* pRes, BOOL bStartAttr );
	long Read_Piece( WW8PLCFManResult* pRes, BOOL bStartAttr );
	long Read_And( WW8PLCFManResult* pRes, BOOL bStartAttr );

										// Attribute

	void Read_Special(			USHORT, const BYTE*, short nLen );
	void Read_Obj(				USHORT, const BYTE*, short nLen );
	void Read_PicLoc(			USHORT nId, const BYTE* pData, short nLen );
	void Read_BoldUsw(			USHORT nId, const BYTE*, short nLen );
	void Read_SubSuper(			USHORT, const BYTE*, short nLen );
    BOOL ConvertSubToGraphicPlacement();
	void Read_SubSuperProp(		USHORT, const BYTE*, short nLen );
	void Read_Underline(		USHORT, const BYTE*, short nLen );
	void Read_TxtColor(			USHORT, const BYTE*, short nLen );
	void Read_FontCode(			USHORT, const BYTE*, short nLen );
	void Read_FontSize(			USHORT, const BYTE*, short nLen );
	void Read_CharSet(			USHORT nId, const BYTE* pData, short nLen );
	void Read_Language(			USHORT, const BYTE*, short nLen );
	void Read_CColl(			USHORT, const BYTE*, short nLen );
	void Read_Kern(				USHORT, const BYTE* pData, short nLen );
	void Read_FontKern(			USHORT, const BYTE* pData, short nLen );
	void Read_Invisible(		USHORT, const BYTE* pData, short nLen );
	void Read_Emphasis(			USHORT, const BYTE* pData, short nLen );
	void Read_ScaleWidth(		USHORT, const BYTE* pData, short nLen );
	void Read_Relief( 			USHORT, const BYTE* pData, short nLen);

	void Read_NoLineNumb(		USHORT nId, const BYTE* pData, short nLen );

	void Read_LR(				USHORT nId, const BYTE*, short nLen );
	void Read_UL(				USHORT nId, const BYTE*, short nLen );
	void Read_LineSpace(		USHORT, const BYTE*, short nLen );
	void Read_Justify(			USHORT, const BYTE*, short nLen );
	void Read_Hyphenation(		USHORT, const BYTE* pData, short nLen );
	void Read_WidowControl(		USHORT, const BYTE* pData, short nLen );
	void Read_AlignFont(		USHORT, const BYTE* pData, short nLen );
	void Read_UsePgsuSettings(	USHORT, const BYTE* pData, short nLen );
	void Read_KeepLines(		USHORT, const BYTE* pData, short nLen );
	void Read_KeepParas(		USHORT, const BYTE* pData, short nLen );
	void Read_BreakBefore(		USHORT, const BYTE* pData, short nLen );
	void Read_ApoPPC(			USHORT, const BYTE* pData, short nLen );

	void Read_BoolItem(			USHORT nId, const BYTE*, short nLen );

	void Read_Border(			USHORT nId, const BYTE* pData, short nLen );
	void Read_Tab(				USHORT nId, const BYTE* pData, short nLen );
	void Read_Symbol(			USHORT nId, const BYTE* pData, short nLen );
	void Read_FldVanish(		USHORT nId, const BYTE* pData, short nLen );

	// Revision Marks ( == Redlining )

	// insert or delete content (change char attributes resp.)
	void Read_CRevisionMark(SwRedlineType eType, USHORT nId,
        const BYTE* pData, short nLen );
	// insert new content
	void Read_CFRMark(			USHORT nId, const BYTE* pData, short nLen );
	// delete old content
	void Read_CFRMarkDel(		USHORT nId, const BYTE* pData, short nLen );
	// change properties of content (e.g. char formating)
	void Read_CPropRMark(		USHORT nId, const BYTE* pData, short nLen ); // complex!


	void Read_TabRowEnd(		USHORT, const BYTE* pData, short nLen );
    static BOOL ParseTabPos(WW8_TablePos *aTabPos, const BYTE *pParams);
	void Read_Shade(			USHORT, const BYTE* pData, short nLen );
	void Read_ANLevelNo(		USHORT, const BYTE* pData, short nLen );
	void Read_ANLevelDesc(		USHORT, const BYTE* pData, short nLen );

	void Read_POutLvl( USHORT nId, const BYTE* pData, short nLen ); // Gliederungsebene Ver8

	void Read_OLST(				USHORT, const BYTE* pData, short nLen );

	void Read_CharShadow(		USHORT, const BYTE* pData, short nLen );
	void Read_CharHighlight(	USHORT, const BYTE* pData, short nLen );
										// Ver8-Listen

	void Read_ListLevel( 		USHORT nId, const sal_uInt8* pData, short nLen);
	void Read_LFOPosition( 		USHORT nId, const sal_uInt8* pData, short nLen);
	BOOL SetTxtFmtCollAndListLevel( const SwPaM& rRg,
									SwWW8StyInf& rStyleInfo,
									BOOL         bReset = TRUE );

										// FastSave-Attribute

	void Read_StyleCode( 		USHORT, const BYTE* pData, short nLen );
	void Read_Majority(	 		USHORT, const BYTE* pData, short nLen );
	void Read_DoubleLine_Rotate( USHORT, const BYTE* pDATA, short nLen);

										// Felder

	eF_ResT Read_F_Nul( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_Input( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_InputVar( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_ANumber( WW8FieldDesc*, String& );
	eF_ResT Read_F_DocInfo( WW8FieldDesc* pF, String& rStr );
	eF_ResT Read_F_Author( WW8FieldDesc*, String& );
	eF_ResT Read_F_TemplName( WW8FieldDesc*, String& );
	eF_ResT Read_F_DateTime( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_FileName( WW8FieldDesc*, String& );
	eF_ResT Read_F_Anz( WW8FieldDesc* pF, String& );
	eF_ResT Read_F_CurPage( WW8FieldDesc*, String& );
	eF_ResT Read_F_Ref( WW8FieldDesc* pF, String& );

	eF_ResT Read_F_Set( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_PgRef( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_NoteReference( WW8FieldDesc* pF, String& rStr );

	eF_ResT Read_F_Tox( WW8FieldDesc* pF, String& rStr );
	eF_ResT Read_F_Symbol( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_Embedd( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_FormTextBox( WW8FieldDesc* pF, String& rStr );
	eF_ResT Read_F_FormCheckBox( WW8FieldDesc* pF, String& rStr );
	eF_ResT Read_F_FormListBox( WW8FieldDesc* pF, String& rStr );
	eF_ResT Read_F_Macro( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_DBField( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_DBNext( WW8FieldDesc*, String& );
	eF_ResT Read_F_DBNum( WW8FieldDesc*, String& );
	eF_ResT Read_F_Equation( WW8FieldDesc*, String& );
	void Read_SubF_Ruby( _ReadFieldParams& rReadParam);
	void Read_SubF_Combined( _ReadFieldParams& rReadParam);
	eF_ResT Read_F_IncludePicture( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_IncludeText(    WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_Seq( WW8FieldDesc*, String& rStr );

	eF_ResT Read_F_OCX( WW8FieldDesc*, String& rStr );
	eF_ResT Read_F_Hyperlink( WW8FieldDesc*, String& rStr );

    BOOL InsertControl(const com::sun::star::uno::Reference<
		com::sun::star::form::XFormComponent>& rFComp,
        const ::com::sun::star::awt::Size& rSize,
        com::sun::star::uno::Reference<
        com::sun::star::drawing::XShape> *pShape=NULL,
        BOOL bFloatingCtrl = FALSE );

	void BuildInputField( USHORT eType, const String& rParam );
	void DeleteFormImpl();

								// Ver8: Listen Manager
	short ImportSprm( const BYTE* pPos, short nSprmsLen, USHORT nId = 0 );

    static BOOL SearchRowEnd(BOOL bVer67, BOOL bComplex, WW8PLCFx_Cp_FKP* pPap,
        WW8_CP &rStartCp );

	const WW8Fib& GetFib() const	{ return *pWwFib; }
	SwDoc& GetDoc() const			{ return rDoc;			}
	USHORT GetNAktColl()  const		{ return nAktColl;	}
	void SetNAktColl( USHORT nColl ) { nAktColl = nColl;	}
	//SfxItemSet* GetAktItemSet()	{ return pAktItemSet;	}
	void SetAktItemSet( SfxItemSet* pItemSet ) { pAktItemSet = pItemSet;	}
	const USHORT StyleUsingLFO(      USHORT nLFOIndex ) const ;
	const SwFmt* GetStyleWithOrgWWName( String& rName    ) const ;

	static BOOL GetPictGrafFromStream( Graphic& rGraphic, SvStream& rSrc,
        ULONG nLen = ULONG_MAX );
    static void PicRead( SvStream *pDataStream, WW8_PIC *pPic, BOOL bVer67);

	SwWW8ImplReader( BYTE nVersionPara, SvStorage* pStorage,
					 SvStream* pSt, SwDoc& rD, BOOL bNewDoc );

	const ULONG GetFieldFlags() const{ return nFieldFlags; }
	const ULONG GetIniFlags()   const{ return nIniFlags; }
	const ULONG GetIniFlags1()  const{ return nIniFlags1; }

	// Laden eines kompletten DocFiles
	ULONG LoadDoc( SwPaM&,WW8Glossary *pGloss=0);
	CharSet GetCurrentCharSet() const;
	void StrengthReduceListStyles()
	{
		ASSERT(pLstManager, "impossible");
		if (pLstManager)
			pLstManager->StrengthReduceListStyles();
	}
};


#endif

