/*************************************************************************
 *
 *  $RCSfile: dmphnt.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _DMPHNT_CXX

#pragma hdrstop

 #include <iostream.h>
 #include <limits.h>

 #include <solar.h>
 #include "rdr.hxx"

 #include "oldhntid.hxx"

extern ostream& indent( ostream& );
extern ostream& begin( ostream& );

extern ostream& end( ostream& );

/////////////////////////////////////////////////////////////////////////////

void SwgDumper::InColor()
{
	USHORT red, green, blue;
	r >> red >> green >> blue;
	list << red << "-" << green << "-" << blue;

}

void SwgDumper::InPen()
{
	char nStyle;
	short nWidth;
	r >> nStyle >> nWidth;
	list << indent << "Pen: Style = " << (int) nStyle
				   << ", Width = " << nWidth
				   << ", Color = ";
	InColor();
	list << endl;

}

void SwgDumper::InBrush( char* pText )
{
	BYTE cStyle, cTransparent;
	r >> cStyle >> cTransparent;
	list << begin << pText << " brush" << endl;
	list << indent
		 << "Style = " << cStyle
		 << ", Transparent = " << (cTransparent ? "TRUE" : "FALSE")
		 << endl << indent
		 << "Color = ";
	InColor();
	list << endl << indent << "Fill color = ";
	InColor();
	list << endl << end;

}

/////////////////////////////////////////////////////////////////////////////

static void InSWG_SwFont( SwgDumper& rPar )
{
	long nNext = rPar.r.getskip();
	char eFamily, eFontPitch, eFontCharSet;
	char* pFamilyName;
	rPar.r >> eFamily
		   >> eFontPitch
		   >> eFontCharSet;
	pFamilyName = rPar.GetText( FALSE );
	list
		 << "Font: Name = " << pFamilyName
		 << ", Family = " << (int) eFamily
		 << ", Pitch = " << (int) eFontPitch
		 << ", CharSet = " << (int) eFontCharSet;
	const char* pStyle = "";
	if( rPar.r.tell() < nNext )
		pStyle = rPar.GetText( FALSE );
	if( *pStyle )
		list << ", Style = " << pStyle;
	list << endl;

}

static void InSWG_SwPosture( SwgDumper& rPar )
{
	char nPosture;
	rPar.r >> nPosture;
	list << "Posture: " << (int) nPosture << endl;

}

static void InSWG_SwWeight( SwgDumper& rPar )
{
	char nWeight;
	rPar.r >> nWeight;
	list << "Weight: " << (int) nWeight << endl;

}

static void InSWG_SwWritingDirection( SwgDumper& rPar )
{
	short nWritingDirection;
	rPar.r >> nWritingDirection;
	list << "WritingDirection: " << nWritingDirection << endl;

}

static void InSWG_SwCharWidth( SwgDumper& rPar )
{
	long frCPIZ, frCPIN;
	rPar.r >> frCPIZ
		   >> frCPIN;
	list << "CharWidth: " << frCPIZ << '/' << frCPIN << endl;

}

static void InSWG_SwInverted( SwgDumper& rPar )
{
	char nState;
	rPar.r >> nState;
	list << "Inverted: " << (nState ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwShadowed( SwgDumper& rPar )
{
	char nState;
	rPar.r >> nState;
	list << "Shadowed: " << (nState ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwContour( SwgDumper& rPar )
{
	char nState;
	rPar.r >> nState;
	list << "Contour: " << (nState ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwKerning( SwgDumper& rPar )
{
	BYTE nState; short nKern;
	long frKernZ, frKernN;
	rPar.r >> nState;
	if( rPar.aHdr.nVersion >= SWG_VER_KERNING )
		rPar.r >> frKernZ >> frKernN;
	else
	{
		// vorher: Prozentangabe
		rPar.r >> nKern;
		frKernZ = nKern;
		frKernN = 100;
	}
	list
		 << "Kerning: State = " << (int) nState
		 << ", Width = " << frKernZ << "/" << frKernN << endl;

}

static void InSWG_SwMirrored( SwgDumper& rPar )
{
	char nAxis;
	rPar.r >> nAxis;
	list << "Mirrored: Axis = " << (int) nAxis << endl;

}

static void InSWG_SwCrossedOut( SwgDumper& rPar )
{
	char chCross, bCrossOutSpaces, nState;
	rPar.r >> chCross >> bCrossOutSpaces >> nState;
	list
		 << "CrossedOut: char = " << chCross
		 << ", Spaces = " << (bCrossOutSpaces ? "TRUE" : "FALSE")
		 << ", Mode = " << (int) nState << endl;

}

static void InSWG_SwCaseMap( SwgDumper& rPar )
{
	char nCaseMap;
	rPar.r >> nCaseMap;
	list << "CaseMap: " << (int) nCaseMap << endl;

}

static void InSWG_SwUnderline( SwgDumper& rPar )
{
	char nState, bUnderlineSpaces;
	rPar.r >> nState >> bUnderlineSpaces;
	list << "Underline: Mode = " << (int) nState
		 << ", Spaces = " << (bUnderlineSpaces ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwLanguage( SwgDumper& rPar )
{
	short nLanguage;
	rPar.r >> nLanguage;
	list << "Language: 0x" << hex << nLanguage << dec << endl;

}

static void InSWG_SwEscapement( SwgDumper& rPar )
{
	char eEscape;
	long frEscapementZ, frEscapementN, frProportionZ, frProportionN;
	rPar.r >> eEscape >> frEscapementZ >> frEscapementN
		   >> frProportionZ >> frProportionN;
	list
		 << "Escapement: Escape = " << (int) eEscape
		 << ", Escapement = " << frEscapementZ << '/' << frEscapementN
		 << ", Proportion = " << frProportionZ << '/' << frProportionN
		 << endl;

}

static void InSWG_SwSize( SwgDumper& rPar )
{
	long nSize;
	rPar.r >> nSize;
	list << "SSize: " << nSize << endl;

}

static void InSWG_SwPropSize( SwgDumper& rPar )
{
	long frPropSizeZ, frPropSizeN;
	rPar.r >> frPropSizeZ >> frPropSizeN;
	list << "PropSize: " << frPropSizeZ << '/' << frPropSizeN << endl;

}

static void InSWG_SwColor( SwgDumper& rPar )
{
	list << "Color: ";
	rPar.InColor();
	list << endl;

}

static void InSWG_SwNoLinebreakHere( SwgDumper& rPar )
{
	BYTE bOn;
	rPar.r >> bOn;
	list << "NoLineBreakHere: " << (bOn ? "TRUE" : "FALSE" ) << endl;

}

static void InSWG_SwNoHyphenHere( SwgDumper& rPar )
{
	BYTE bOn;
	rPar.r >> bOn;
	list << "NoHyphenHere: " << (bOn ? "TRUE" : "FALSE" ) << endl;

}

static void InSWG_SwSoftHyphen( SwgDumper& rPar )
{
	BYTE bOn;
	rPar.r >> bOn;
	list << "SoftHyphen: " << (bOn ? "TRUE" : "FALSE" ) << endl;

}

static void InSWG_SwHardBlank( SwgDumper& rPar )
{
	BYTE bOn;
	rPar.r >> bOn;
	list << "HardBlank: " << (bOn ? "TRUE" : "FALSE" ) << endl;

}

static void InSWG_SwRefMark( SwgDumper& rPar )
{
	USHORT nMark;
	char* pName;
	rPar.r >> nMark; // wird ignoriert
	pName = rPar.GetText( FALSE );
	list << "RefMark: Text = " << pName << endl;

}

static void InSWG_SwField( SwgDumper& rPar )
{
	rPar.InField();

}

static void InSWG_SwFlyCnt( SwgDumper& rPar )
{
	list << "FlyCnt:" << endl;
	if( rPar.r.peek() == SWG_FLYFMT )
	{
		rPar.r.next();
		rPar.InFormat( "flyframe " );
		// Den bereits geholten Record fuer das next() in SwgDumper::InHint()
		// wieder ungueltig machen
		rPar.r.undonext();
	}

}

static void InSWG_SwTOXMark( SwgDumper& rPar )
{
	// Flags:
	// 0x01 - hat eigenen Verz.-Namen (z.Zt. immer)
	// 0x02 - hat alternate Text
	// 0x04 - hat Primaeren Key
	// 0x08 - hat Sekundaeren Key
	BYTE nType, bFlags;
	short nLevel;
	char* p;
	rPar.r >> nType >> bFlags;
	list << "TOXMark: Type = " << nType << ", Flags = " << bFlags;
	if( bFlags & 0x01 )
		list << ", Name = \"" << rPar.GetText( FALSE ) << "\"";
	if( bFlags & 0x02 )
		list << ", AltText = \"" << rPar.GetText( FALSE ) << "\"";
	switch( nType )
	{
		case 0:	// TOX_INDEX
			if( bFlags & 0x04 )
				list << ", Prim = \"" << rPar.GetText( FALSE ) << "\"";
			if( bFlags & 0x08 )
				list << ", Sec = \"" << rPar.GetText( FALSE ) << "\"";
			break;
		case 1:	// TOX_USER
		case 2:	// TOX_CONTENT
			rPar.r >> nLevel;
			list << ", Level = " << nLevel;
			break;
		default:
			rPar.r.skip();
	}
	list << endl;

}

static void InSWG_SwCharFmt( SwgDumper& rPar )
{
	USHORT nIdx;
	rPar.r >> nIdx;
	list << "CharFormat: Index = ";
	rPar.FmtNumber( nIdx );
	list << endl;

}

static void InSWG_SwFtn( SwgDumper& rPar )
{
	char* pText = rPar.GetText( FALSE );
	short nNumber;
	rPar.r >> (short) nNumber;
	list << "Footnote: Mark = " << pText
		 << ", Number = " << nNumber << endl;
	rPar.r.next();
	if( rPar.r.cur() == SWG_CONTENTS )
		rPar.InContents();
	// den zuletzt eingelesenen Record zuruecksetzen,
	// da InSWG_Hint ja einen next() ausfuehrt
	rPar.r.undonext();

}

/////////////////////////////// PARATR.HXX ////////////////////////////////

static void InSWG_SwLineSpacing( SwgDumper& rPar )
{
	long frPropLineSpaceZ, frPropLineSpaceN;
	char nLineSpaceRule, nInterLineSpaceRule;
	short nInterLineSpace, nLineHeight;
	rPar.r >> frPropLineSpaceZ >> frPropLineSpaceN
		   >> nLineSpaceRule   >> nInterLineSpaceRule
		   >> nInterLineSpace  >> nLineHeight;
	list
		 << "LineSpacing: Prop = " << frPropLineSpaceZ << '/' << frPropLineSpaceN
		 << ", LineSpaceRule = " << (int) nLineSpaceRule
		 << endl << indent
		 << "             InterLineSpaceRule = " << (int) nInterLineSpaceRule
		 << ", InterLineSpace = " << nInterLineSpace
		 << ", LineHeight = " << nLineHeight << endl;

}

static void InSWG_SwAdjust( SwgDumper& rPar )
{
	char eAdjustment;
	rPar.r >> eAdjustment;
	list << "Adjust: " << (int) eAdjustment << endl;

}

static void InSWG_SwSplit( SwgDumper& rPar )
{
	char bSplit;
	rPar.r >> bSplit;
	list << "Split: " << (bSplit ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwWidows( SwgDumper& rPar )
{
	long nTwips;
	short nLines;
	rPar.r >> nLines >> nTwips;
	list << "Widows: Lines = " << nLines
		 << ", Twips = " << nTwips << endl;

}

static void InSWG_SwOrphans( SwgDumper& rPar )
{
	long nTwips;
	short nLines;
	rPar.r >> nLines >> nTwips;
	list << "Orphans: Lines = " << nLines
		 << ", Twips = " << nTwips << endl;

}

static void InSWG_SwTabStop( SwgDumper& rPar )
{
	short nTabs;
	rPar.r >> nTabs;
	list << "TabStops" << endl;
	list << begin << endl;
	for( int i = 0; i < nTabs; i++ )
	{
		long nPos;
		BYTE eAdjust, cDecimal, cFill;
		rPar.r >> nPos >> eAdjust >> cDecimal >> cFill;
		list << indent << "Pos = " << nPos
			 << ", Adjust = " << (int) eAdjust
			 << ", Decimal = '" << (char) cDecimal << "'"
			 << ", Fill = '" << (char) cFill << "'"
			 << endl;
	}
	list << end;

}

static void InSWG_SwHyphenZone( SwgDumper& rPar )
{
	BYTE bHyphen, bHyphenPageEnd;
	USHORT nMinLead, nMinTrail, nMaxHyphens;
	rPar.r >> bHyphen >> bHyphenPageEnd >> nMinLead >> nMinTrail >> nMaxHyphens;
	list << "HyphenZone: bHyphen = " << (bHyphen ? "TRUE" : "FALSE")
		 << ", PageEnd = " << (bHyphenPageEnd ? "TRUE" : "FALSE")
		 << endl << indent
		 << "            MinLead = " << nMinLead
		 << ", MinTrail = " << nMinTrail
		 << ", Max = " << nMaxHyphens
		 << endl;
}

static void InSWG_SwDropCaps( SwgDumper& rPar )
{
	USHORT nLines, nChars, nDistance, nX, nY, nFmt;
	rPar.r >> nLines >> nChars >> nDistance >> nX >> nY >> nFmt;
	list << "DropCaps: Lines = " << nLines
		 << ", Chars = " << nChars
		 << ", Dist = " << nDistance
		 << ", X = " << nX
		 << ", Y = " << nY;
	if( nFmt != IDX_NO_VALUE )
	{
		list << ", CharFmt = ";
		rPar.FmtNumber( nFmt );
	}
	list << endl;
}

//////////////////////////////// SWWHEN.HXX ////////////////////////////////

static void InSWG_SwWhen( SwgDumper& rPar )
{
	char day, mon, year, hr, min, sec;
	rPar.r >> day >> mon >> year >> hr >> min >> sec;
	list.width( 2 );
	list
		 << "When: " << day << '.' << mon << '.' << year
		 << ' ' << hr << ':' << min << ':' << sec << endl;
	list.width( 0 );

}

/////////////////////////////// FRMATR.HXX ///////////////////////////////

static void InSWG_SwBox( SwgDumper& rPar )
{
	static char* out[] = { "Top", "Left", "Right", "Bottom" };
	short nDistance;
	rPar.r >> nDistance;
	list << "Box: Distance = " << nDistance << endl;
	BOOL bDone = FALSE;
	while( !bDone )
	{
		short idx;
		switch( rPar.r.next() )
		{
			case SWG_TOP:	idx = 0; break;
			case SWG_LEFT:	idx = 1; break;
			case SWG_RIGHT:	idx = 2; break;
			case SWG_BOTTOM:idx = 3; break;
			default:		bDone = TRUE;
		}
		if( !bDone )
		{
			list << begin << out[ idx ] << endl;
			USHORT red, green, blue;
			short nOutline, nInline, nDistance;
			rPar.r >> red >> green >> blue;
			rPar.r >> nOutline >> nInline >> nDistance;
			list << indent
				 << "Color = " << red << '-' << green << '-' << blue
				 << ", Outline = " << nOutline
				 << ", InLine = " << nInline
				 << ", Distance = " << nDistance
				 << endl;
			list << end;
		}
	}
	// Den bereits geholten Record fuer das next() in SwgDumper::InHint()
	// wieder ungueltig machen
	rPar.r.undonext();

}

static void InSWG_SwFmtShadow( SwgDumper& rPar )
{
	BYTE cLoc;
	USHORT nWidth;
	rPar.r >> cLoc >> nWidth;
	list << "Shadow: Location = " << (int) cLoc
		 << ", Width = " << nWidth
		 << endl;
	rPar.InBrush( "fill" );

}

static void InSWG_SwFmtPageDesc( SwgDumper& rPar )
{
	list << "PageDesc: Name = ";
	char* pName = rPar.GetText( FALSE );
	USHORT nOff = 0;
	if( rPar.aHdr.nVersion >= SWG_VER_FRAMES )
		rPar.r >> nOff;
	list << pName << ", Offset = " << ( nOff & 0x7FFF )
		 << ", Auto = " << ( ( nOff & 0x8000 ) ? "TRUE" : "FALSE" ) << endl;

}

static void InSWG_SwFmtFrmMacro( SwgDumper& rPar )
{
	list << "MacroTbl:";
	if( rPar.r.peek() == SWG_MACROTBL )
	{
		list << endl;
		rPar.r.next();
		rPar.InMacroTbl();
	} else list << " none" << endl;

}

static void InSWG_SwFmtCol( SwgDumper& rPar )
{
	list << "Columns:" << endl << begin << endl;
	char nLineAdj, bOrtho;
	short nGutterWidth;
	long  nHeightNum, nHeightDenom, nWishWidth;
	if( rPar.aHdr.nVersion >= SWG_VER_FMTCOL )
		rPar.r.long4();
	rPar.r >> nLineAdj
		   >> bOrtho
		   >> nGutterWidth
		   >> nWishWidth
		   >> nHeightNum
		   >> nHeightDenom;
	// WishWidth evtl. umwandeln:
	if( rPar.aHdr.nVersion < SWG_VER_FMTCOL && nWishWidth == -1 )
		nWishWidth = LONG_MAX;
	list << indent << "LineAdj = " << (int) nLineAdj
				   << ", Ortho = " << (bOrtho ? "TRUE" : "FALSE")
				   << ", Gutter = " << nGutterWidth << endl;
	list << indent << "Wish = " << nWishWidth
				   << ", Height = " << nHeightNum << "/" << nHeightDenom << endl;
	rPar.InPen();
	USHORT nCol;
	rPar.r >> nCol;
	if( nCol )
	{
		list << begin << "Columns" << endl;
		for( USHORT i = 0; i < nCol; i++ )
		{
			long nWishWidth;
			short nLeft, nUpper, nRight, nLower;
			rPar.r >> nWishWidth >> nLeft >> nUpper >> nRight >> nLower;
			// WishWidth evtl. umwandeln:
			if( rPar.aHdr.nVersion < SWG_VER_FMTCOL && nWishWidth == -1 )
				nWishWidth = LONG_MAX;
			list << indent << "Width = " << nWishWidth
						   << ", From (" << nLeft << "," << nUpper
						   << ") to (" << nRight << "," << nLower << ")" << endl;
		}
		list << end;
	}
	list << end;
	rPar.r.long3();

}

static void InSWG_SwFrmSize( SwgDumper& rPar )
{
	char nSizeType;
	long nFixSize, nVarSize;
	rPar.r >> nSizeType;
	if( rPar.aHdr.nVersion >= SWG_VER_FRMSIZE ) rPar.r.long4();
	rPar.r >> nFixSize >> nVarSize;
	rPar.r.long3();
	list << "FrmSize: Type = " << (int) nSizeType
		 << ", FixSize = " << nFixSize
		 << ", VarSize = " << nVarSize << endl;

}

static void InSWG_SwFillOrder( SwgDumper& rPar )
{
	char nFillOrder;
	rPar.r >> nFillOrder;
	list << "FillOrder: " << (int) nFillOrder << endl;

}

static void InSWG_SwPageBreak( SwgDumper& rPar )
{
	char nPageBreak, nIsAuto;
	rPar.r >> nPageBreak >> nIsAuto;
	list
		 << "PageBreak: Mode = " << (int) nPageBreak
		 << ", Auto = " << (nIsAuto ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwColBreak( SwgDumper& rPar )
{
	char nColBreak, nIsAuto;
	rPar.r >> nColBreak >> nIsAuto;
	list
		 << "ColBreak: Mode = " << (int) nColBreak
		 << ", Auto = " << (nIsAuto ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwSelectPage( SwgDumper& rPar )
{
	char nSelectPage;
	rPar.r >> nSelectPage;
	list << "SelectPage: " << (int) nSelectPage << endl;

}

static void InSWG_SwPaperTray( SwgDumper& rPar )
{
	short nTray;
	rPar.r >> nTray;
	list << "PaperTray: " << nTray << endl;

}

static void InSWG_SwRndRequest( SwgDumper& rPar )
{
	short nId;
	const char* pComment;
	rPar.r >> nId;
	pComment = rPar.GetText( FALSE );
	list << "RndRequest: ID = " << nId;
	if( *pComment ) list << ", Comment = " << pComment;
	list << endl;

}

static void InSWG_SwRndSupply( SwgDumper& rPar )
{
	char cFlags;
	short nId;
	const char* pComment;
	rPar.r >> cFlags >> nId;
	pComment = rPar.GetText( FALSE );
	list << "RndSupply: ID = " << nId
		 << ", Flags = " << (int) cFlags;
	if( *pComment ) list << ", Comment = " << pComment;
	list << endl;

}

static void InSWG_SwLRSpace( SwgDumper& rPar )
{
	long left, right;
	rPar.r >> left >> right;
	list << "LRSpace: " << left << '/' << right;
	if( rPar.aHdr.nVersion >= SWG_VER_LRSPACE )
	{
		long firstline;
		rPar.r >> firstline;
		list << ", first line = " << firstline;
	}
	list << endl;

}

static void InSWG_SwULSpace( SwgDumper& rPar )
{
	long upper, lower;
	rPar.r >> upper >> lower;
	list << "ULSpace: " << upper << '/' << lower << endl;

}

static void InSWG_SwFmtHeader( SwgDumper& rPar )
{
	BYTE bActive;
	rPar.r >> bActive;
	list << "Header: Active = " << ( bActive ? "TRUE" : "FALSE" ) << endl;
	if( rPar.r.peek() == SWG_FREEFMT )
	{
		rPar.r.next();
		rPar.InFormat( "freeframe " );
		// Den bereits geholten Record fuer das next() in SwgDumper::InHint()
		// wieder ungueltig machen
		rPar.r.undonext();
	}

}

static void InSWG_SwFmtFooter( SwgDumper& rPar )
{
	BYTE bActive;
	rPar.r >> bActive;
	list << "Footer: Active = " << ( bActive ? "TRUE" : "FALSE" ) << endl;
	if( rPar.r.peek() == SWG_FREEFMT )
	{
		rPar.r.next();
		rPar.InFormat( "freeframe " );
		// Den bereits geholten Record fuer das next() in SwgDumper::InHint()
		// wieder ungueltig machen
		rPar.r.undonext();
	}

}

static void InSWG_SwFmtCntnt( SwgDumper& rPar )
{
	list << "Contents:" << endl;
	rPar.r.next();
	rPar.InContents();
	// den zuletzt eingelesenen Record zuruecksetzen,
	// da InSWG_Hint ja einen next() ausfuehrt
	rPar.r.undonext();

}

static void InSWG_SwFlyPrint( SwgDumper& rPar )
{
	BYTE bActive;
	rPar.r >> bActive;
	list << "FlyPrint: " << (bActive ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwFlyOpaque( SwgDumper& rPar )
{
	BYTE bActive;
	rPar.r >> bActive;
	list << "FlyOpaque: " << (bActive ? "TRUE" : "FALSE") << endl;

}

static void InSWG_SwFlyProtect( SwgDumper& rPar )
{
	BYTE bProtFrame, bProtCntnt;
	rPar.r >> bProtFrame >> bProtCntnt;
	list << "FlyProtect: Frame = " << (bProtFrame ? "TRUE" : "FALSE")
		 << ", Contents = " << (bProtCntnt ? "TRUE" : "FALSE")
		 << endl;

}

static void InSWG_SwFlyMainCntnt( SwgDumper& rPar )
{
	BYTE nType, bGold;
	rPar.r >> nType >> bGold;
	list << "FlyMainCntnt: Type = " << (int) nType
		 << ", GoldCut = " << (bGold ? "TRUE" : "FALSE")
		 << endl;

}

static void InSWG_SwFlyVertOrient( SwgDumper& rPar )
{
	long nPos;
	BYTE nOrient, nRelation;
	rPar.r >> nPos >> nOrient >> nRelation;
	list << "FlyVertOrient: Pos = " << nPos
		 << ", Orientation = " << (int) nOrient
		 << ", Relation = " << (int) nRelation
		 << endl;

}

static void InSWG_SwFlyHoriOrient( SwgDumper& rPar )
{
	long nPos;
	BYTE nOrient, nRelation;
	BYTE nAnchor;
	short nColumn;
	rPar.r >> nPos >> nOrient >> nRelation;
	rPar.r >> nAnchor >> nColumn;
	list << "FlyHoriOrient: Pos = " << nPos
		 << ", Orientation = " << (int) nOrient
		 << endl << indent
		 << "               Relation = " << (int) nRelation
		 << ", Anchor = " << (int) nAnchor
		 << ", Column = " << nColumn
		 << endl;

}

static void InSWG_SwFlyGeneric( SwgDumper& rPar )
{
	BYTE bGen, bCntntGen;
	rPar.r >> bGen >> bCntntGen;
	list << "FlyGeneric: Mode = " << (bGen ? "TRUE" : "FALSE")
		 << ", Contents = " << (bCntntGen ? "TRUE" : "FALSE")
		 << endl;

}

static void InSWG_SwFlyAnchor( SwgDumper& rPar )
{
	BYTE cType;
	USHORT nPage, nCol, nCntntCol;
	rPar.r >> cType >> nPage >> nCol >> nCntntCol;
	list << "FlyAnchor: Type = " << (int) cType
		 << ", Page = " << nPage
		 << ", Column = " << nCol
		 << ", Cntnt Column = " << nCntntCol
		 << endl;

}

static void InSWG_SwFmtBackground( SwgDumper& rPar )
{
	BYTE bActive;
	rPar.r >> bActive;
	list << "Background: Active = " << (bActive ? "TRUE" : "FALSE")
		 << endl;
	rPar.InBrush( "fill" );

}

/////////////////////////////// GRFATR.HXX /////////////////////////////////

static void InSWG_SwGrfSize( SwgDumper& rPar )
{
	char nSize;
	long nWidth, nHeight;
	long nPropWidthZ, nPropWidthN;
	long nPropHeightZ, nPropHeightN;
	rPar.r >> nSize >> nWidth >> nHeight
		   >> nPropWidthZ >> nPropWidthN >> nPropHeightZ >> nPropHeightN;
	list << "GrfSize: SSize = " << (int) nSize
		 << ", Width = " << nWidth
		 << ", Height = " << nHeight
		 << endl << indent
		 << "         PropWidth = " << nPropWidthZ << '/' << nPropWidthN
		 << ", PropHeight = " << nPropHeightZ << '/' << nPropHeightN
		 << endl;

}

static void InSWG_SwMirrorGrf( SwgDumper& rPar )
{
	char nState;
	rPar.r >> nState;
	list << "MirrorGrf: " << (int) nState << endl;

}

static void InSWG_SwGrfOffset( SwgDumper& rPar )
{
	short x, y;
	rPar.r >> x >> y;
	list << "GrfOffset: X = " << x << ", Y = " << y << endl;

}

static void InSWG_SwAlignGrf( SwgDumper& rPar )
{
	BYTE nHor, nVert;
	rPar.r >> nHor >> nVert;
	list << "AlignGrf: Horizontal = " << (int) nHor
		 << ", Vertical = " << (int) nVert
		 << endl;

}

static void InSWG_SwCropGrf( SwgDumper& rPar )
{
	long top, left, right, bottom;
	rPar.r >> top >> left >> right >> bottom;
	list << "CropGrf: Top = " << top
		 << ", left = " << left
		 << ", right = " << right
		 << ", bottom = " << bottom
		 << endl;

}

static void dummy_attr( SwgDumper& rPar )
{
	rPar.r.skip();
}

typedef void ( *SwHintFn ) ( SwgDumper& );

static SwHintFn aChrAttrs[] = {
/* RES_CHRATR_CASEMAP	*/			InSWG_SwCaseMap,
/* RES_CHRATR_CHARWIDTH */			InSWG_SwCharWidth,
/* RES_CHRATR_COLOR */				InSWG_SwColor,
/* RES_CHRATR_CONTOUR	*/			InSWG_SwContour,
/* RES_CHRATR_CROSSEDOUT	*/		InSWG_SwCrossedOut,
/* RES_CHRATR_ESCAPEMENT	*/		InSWG_SwEscapement,
/* RES_CHRATR_FONT	*/				InSWG_SwFont,
/* RES_CHRATR_FONTSIZE	*/			InSWG_SwSize,
/* RES_CHRATR_INVERTED	*/			InSWG_SwInverted,
/* RES_CHRATR_KERNING	*/			InSWG_SwKerning,
/* RES_CHRATR_LANGUAGE	*/			InSWG_SwLanguage,
/* RES_CHRATR_MIRRORED	*/			InSWG_SwMirrored,
/* RES_CHRATR_POSTURE	*/			InSWG_SwPosture,
/* RES_CHRATR_PROPORTIONALFONTSIZE*/InSWG_SwPropSize,
/* RES_CHRATR_SHADOWED	*/			InSWG_SwShadowed,
/* RES_CHRATR_UNDERLINE */			InSWG_SwUnderline,
/* RES_CHRATR_WEIGHT	*/			InSWG_SwWeight,
/* RES_CHRATR_WRITINGDIRECTION	*/	InSWG_SwWritingDirection,
/* RES_CHRATR_FIELD 			*/	InSWG_SwField,
/* RES_CHRATR_NOLINEBREAK		*/	InSWG_SwNoLinebreakHere,
/* RES_CHRATR_NOHYPHEN			*/	InSWG_SwNoHyphenHere,
/* RES_CHRATR_SOFTHYPH			*/	InSWG_SwSoftHyphen,
/* RES_CHRATR_FTN				*/	dummy_attr,
/* RES_CHRATR_HARDBLANK			*/	InSWG_SwHardBlank,
};

static SwHintFn aFontAttrs[] = {
/* RES_TXTATR_CHARWIDTH */			InSWG_SwCharWidth,
/* RES_TXTATR_COLOR */				InSWG_SwColor,
/* RES_TXTATR_CONTOUR	*/			InSWG_SwContour,
/* RES_TXTATR_CROSSEDOUT	*/		InSWG_SwCrossedOut,
/* RES_TXTATR_FONT	*/				InSWG_SwFont,
/* RES_TXTATR_FONTSIZE	*/			InSWG_SwSize,
/* RES_TXTATR_INVERTED	*/			InSWG_SwInverted,
/* RES_TXTATR_LANGUAGE	*/			InSWG_SwLanguage,
/* RES_TXTATR_MIRRORED	*/			InSWG_SwMirrored,
/* RES_TXTATR_POSTURE	*/			InSWG_SwPosture,
/* RES_TXTATR_PROPORTIONALFONTSIZE*/InSWG_SwPropSize,
/* RES_TXTATR_SHADOWED	*/			InSWG_SwShadowed,
/* RES_TXTATR_UNDERLINE */			InSWG_SwUnderline,
/* RES_TXTATR_WEIGHT	*/			InSWG_SwWeight,
/* RES_TXTATR_CHARFMT	*/			InSWG_SwCharFmt,
};

static SwHintFn aEtcAttrs[] = {
/* RES_TXTATR_WRITINGDIRECTION	*/	InSWG_SwWritingDirection,
/* RES_TXTATR_KERNING	*/			InSWG_SwKerning,
/* RES_TXTATR_NOLINEBREAK	*/		InSWG_SwNoLinebreakHere,
/* RES_TXTATR_NOHYPHEN	*/			InSWG_SwNoHyphenHere,
/* RES_TXTATR_INSERTED	*/			dummy_attr,
/* RES_TXTATR_DELETED	*/			dummy_attr,
/* RES_TXTATR_ESCAPEMENT	*/		InSWG_SwEscapement,
/* RES_TXTATR_CASEMAP	*/			InSWG_SwCaseMap,
/* RES_TXTATR_FIELD */				InSWG_SwField,
/* RES_TXTATR_FLYCNT */ 			InSWG_SwFlyCnt,
/* RES_TXTATR_TOXMARK */ 			InSWG_SwTOXMark,
/* RES_TXTATR_SOFTHYPH			*/	InSWG_SwSoftHyphen,
/* RES_TXTATR_FTN				*/	InSWG_SwFtn,
/* RES_TXTATR_HARDBLANK			*/	InSWG_SwHardBlank,
/* RES_TXTATR_REFMARK			*/	InSWG_SwRefMark
};

static SwHintFn aParAttrs[] = {
/* RES_PARATR_LINESPACING	*/		InSWG_SwLineSpacing,
/* RES_PARATR_FIRSTLINEOFFSET	*/	dummy_attr,		// nicht mehr da
/* RES_PARATR_ADJUST	*/			InSWG_SwAdjust,
/* RES_PARATR_SPLIT		*/			InSWG_SwSplit,
/* RES_PARATR_WIDOWS	*/			InSWG_SwWidows,
/* RES_PARATR_ORPHANS	*/			InSWG_SwOrphans,
/* RES_PARATR_TABSTOP	*/			InSWG_SwTabStop,
/* RES_PARATR_HYPHENZONE */			InSWG_SwHyphenZone,
/* RES_PARATR_DROP      */			InSWG_SwDropCaps,
};

static SwHintFn aAddAttrs[] = {
/* RES_ADD_POSTIT	*/				dummy_attr,
/* RES_ADD_INSERTS	*/				dummy_attr,
/* RES_ADD_AUTOTEXT */				dummy_attr,
/* RES_ADD_OTHERCONTENT */			dummy_attr,
};

static SwHintFn aFrmAttrs[] = {
/* RES_FILL_ORDER	*/				InSWG_SwFillOrder,
/* RES_FRM_SIZE */					InSWG_SwFrmSize,
/* RES_PAGE_BREAK */				InSWG_SwPageBreak,
/* RES_SEL_PAGE */					InSWG_SwSelectPage,
/* RES_PAPER_TRAY	*/				InSWG_SwPaperTray,
/* RES_FRM_RNDREQUEST */			InSWG_SwRndRequest,
/* RES_FRM_RNDSUPPLY */ 			InSWG_SwRndSupply,
/* RES_LR_SPACE */					InSWG_SwLRSpace,
/* RES_UL_SPACE */					InSWG_SwULSpace,
/* RES_CNTNT */						InSWG_SwFmtCntnt,
/* RES_HEADER */					InSWG_SwFmtHeader,
/* RES_FOOTER */					InSWG_SwFmtFooter,
/* RES_FLY_PRINT */					InSWG_SwFlyPrint,
/* RES_FLY_OPAQUE */				InSWG_SwFlyOpaque,
/* RES_FLY_PROTECT */				InSWG_SwFlyProtect,
/* RES_FLY_MAINCNTNT */				InSWG_SwFlyMainCntnt,
/* RES_FLY_VERT_ORIENT */			InSWG_SwFlyVertOrient,
/* RES_FLY_HORI_ORIENT */			InSWG_SwFlyHoriOrient,
/* RES_FLY_GENERIC */				InSWG_SwFlyGeneric,
/* RES_FLY_ANCHOR */				InSWG_SwFlyAnchor,
/* RES_BACKGROUND */				InSWG_SwFmtBackground,
/* RES_BOX	*/						InSWG_SwBox,
/* RES_SHADOW */					InSWG_SwFmtShadow,
/* RES_PAGEDESC */					InSWG_SwFmtPageDesc,
/* RES_FRMMACRO */					InSWG_SwFmtFrmMacro,
/* RES_COL_BREAK */					InSWG_SwColBreak,
/* RES_COL */						InSWG_SwFmtCol
};

static SwHintFn aGrfAttrs[] = {
/* RES_GRFATR_GRFSIZE	*/			InSWG_SwGrfSize,
/* RES_GRFATR_MIRRORGRF */			InSWG_SwMirrorGrf,
/* RES_GRFATR_GRFOFFSET */			InSWG_SwGrfOffset,
/* RES_GRFATR_ALIGNGRF	*/			InSWG_SwAlignGrf,
/* RES_GRFATR_CROPGRF	*/			InSWG_SwCropGrf
};


static struct {
	SwHintFn* pHintTab;
	short	  nHintId1;
} aHintFns[] = {
	{ aChrAttrs,	OLDRES_CHRATR_BEGIN 	},
	{ aFontAttrs,	OLDFONT_TXTATR_BEGIN	},
	{ aEtcAttrs,	OLDETC_TXTATR_BEGIN	},
	{ aParAttrs,	OLDRES_PARATR_BEGIN	},
	{ aAddAttrs,	OLDRES_ADD_BEGIN		},
	{ aFrmAttrs,	OLDRES_FRMATR_BEGIN	},
	{ aGrfAttrs,	OLDRES_GRFATR_BEGIN	}

};

void SwgDumper::InHint()
{
	USHORT id1, nId = r.cur();
	SwHintFn pFn = NULL;

	for( short i = 6; i >= 0; i-- )
	{
		id1 = aHdr.cAttrTab[ i ];
		if( nId >= id1 )
		{
			pFn = aHintFns[ i ].pHintTab[ nId - id1 ];
			break;
		}
	}
	if( pFn )
		(*pFn ) ( *this );
	else
		list << "Unknown ID: " << (nId - id1) << ", grp = " << i << endl;
}

