/*************************************************************************
 *
 *  $RCSfile: dmpfld.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _DMPFLD_CXX

#pragma hdrstop

 #include <stdio.h>
 #include <solar.h>
 #include "rdr.hxx"

#define FIELDIDS_ONLY
 #include "fldbas.hxx"

#define MAXFLD 31

static USHORT nStatCnt[ MAXFLD ];

static char* pName[] = {
		"database",
		"user defined",
		"file name",
		"data base name",
		"date",
		"time",
		"page number",
		"author",
		"chapter",
		"docstat",
		"get expr",
		"set expr",
		"reference",
		"hidden text",
		"postit",
		"fixed date",
		"fixed time",
		"reginfo fixed",
		"reginfo variable",
		"set reference",
		"input",
		"macro",
		"DDE",
		"table",
		"hidden para",
		"docinfo",
		"template name",
		"db next set",
		"db num set",
		"db set num",
		"extended user"
};

extern ostream& indent( ostream& );
extern ostream& begin( ostream& );
extern ostream& end( ostream& );

//////////////////////////////////////////////////////////////////////////////

static void In_SwDBFieldType( SwgDumper& rPar )
{
	list << ", Name = \"" << rPar.GetText() << "\"";
	// altes Expand weg
	rPar.GetText( FALSE );
}

static void In_SwUserFieldType( SwgDumper& rPar )
{
	list << ", Name = \"" << rPar.GetText() << "\"";
	list << ", Text = \"" << rPar.GetText() << "\"";
	if( rPar.aHdr.nVersion >= SWG_VER_HIDPARA )
		list << ", Value = " << rPar.GetText();
	if( rPar.aHdr.nVersion >= SWG_VER_POOLIDS ) {
		USHORT nSubType;
		rPar.r >> nSubType;
		list << ", SubType = " << nSubType;
	}
}

static void In_SwRegFieldType( SwgDumper& rPar )
{
	BYTE nCount;
	if( rPar.aHdr.nVersion < SWG_VER_FRAMES )
	{
		list << "(old style, not interpreted)" << endl;
		rPar.r.skip();
		return;
	}
	rPar.r.long4();
	long nEditTime;
	rPar.r >> nCount;
	list << ", Title = \"" << rPar.GetText() << "\"";
	rPar.r >> nEditTime;
	list << ", Time = " << nEditTime << endl;
	list << begin << "RegInfo" << endl;
	for( BYTE i = 0; i < nCount; i++ )
	{
		char* pAuthor = rPar.GetText();
		long nDate, nTime;
		rPar.r >> nDate >> nTime;
		list << indent << "Author = \"" << pAuthor << "\""
					   << ", Date = " << nDate
					   << ", Time = " << nTime << endl;
	}
	list << end;
	rPar.r.long3();
}

static void In_SwVarRegFieldType( SwgDumper& rPar )
{
	USHORT nType;
	rPar.r >> nType;
	list << ", Type = " << nType << ", Name = \"" << rPar.GetText() << "\"";
	list << ", Text = \"" << rPar.GetText() << "\"";

}

static void In_SwDDEFieldType( SwgDumper& rPar )
{
	USHORT nType;
	rPar.r >> nType;
	list << ", Type = " << nType << ", Name = \"" << rPar.GetText() << "\"";
	list << ", Cmd = \"" << rPar.GetText() << "\"";
}

static void In_SwSetExpFieldType( SwgDumper& rPar )
{
	USHORT nType;
	rPar.r >> nType;
	list << ", Type = " << nType;
	list << ", Name = \"" << rPar.GetText() << "\"";
}

//////////////////////////////////////////////////////////////////////////////

static void In_SwDBField( SwgDumper& rPar )
{
	In_SwDBFieldType( rPar );
}

static void In_SwUserField( SwgDumper& rPar )
{
	In_SwUserFieldType( rPar );
}

static void In_SwFileNameField( SwgDumper& rPar )
{
	// keine eigenen Daten
}

static void In_SwDBNameField( SwgDumper& rPar )
{
	// keine eigenen Daten
}

static void In_SwDateField( SwgDumper& rPar )
{
	// keine eigenen Daten
}

static void In_SwTimeField( SwgDumper& rPar )
{
	// keine eigenen Daten
}

static void In_SwPageNumberField( SwgDumper& rPar )
{
	USHORT nOff = 0, nSub = 0;
	if( rPar.aHdr.nVersion >= SWG_VER_POOLIDS )
		rPar.r >> nOff;
	if( rPar.aHdr.nVersion >= SWG_VER_GETEXP )
		rPar.r >> nSub;
	list << ", Offset = " << nOff << ", SubType = " << nSub;
}

static void In_SwAuthorField( SwgDumper& rPar )
{
	// keine eigenen Daten
}

static void In_SwChapterField( SwgDumper& rPar )
{
	if( rPar.aHdr.nVersion >= SWG_VER_NEWALIGN )
	{
		USHORT nLevel;
		rPar.r >> nLevel;
		list << ", Level = " << nLevel;
	}
}

static void In_SwDocStatField( SwgDumper& rPar )
{
	if( rPar.aHdr.nVersion >= SWG_VER_POOLIDS ) {
		USHORT nSubType;
		rPar.r >> nSubType;
		list << ", SubType= " << nSubType;
	}
}

static void In_SwHiddenTxtField( SwgDumper& rPar )
{
	char cFlags;
	rPar.r >> cFlags;
	list << ", Flags = " << (int) cFlags
		 << ", Text = \"" << rPar.GetText() << "\"";
	if( rPar.aHdr.nVersion >= SWG_VER_HIDPARA )
		list << ", Cond = \"" << rPar.GetText() << "\"";
	if( rPar.aHdr.nVersion >= SWG_VER_FRAMES3 )
	{
		USHORT nSubType;
		rPar.r >> nSubType;
		list << ", Subtype = " << nSubType;
	}
}

static void In_SwGetRefField( SwgDumper& rPar )
{
	list << ", Name = \"" << rPar.GetText() << "\"";
	list << ", Text = \"" << rPar.GetText( FALSE ) << "\"";
}

static void In_SwPostItField( SwgDumper& rPar )
{
	long nDate;
	rPar.r.long4();
	rPar.r >> nDate;
	rPar.r.long3();
	list << ", Date = " << nDate
		 << ", Author = \"" << rPar.GetText() << "\"";
	list << ", Text = \"" << rPar.GetText() << "\"";
}

static void In_SwFixDateField( SwgDumper& rPar )
{
	long nVal;
	rPar.r.long4();
	rPar.r >> nVal;
	rPar.r.long3();
	list << ", Date = " << nVal;
}

static void In_SwFixTimeField( SwgDumper& rPar )
{
	long nVal;
	rPar.r.long4();
	rPar.r >> nVal;
	rPar.r.long3();
	list << ", Time = " << nVal;
}

static void In_SwRegField( SwgDumper& rPar )
{
	if( rPar.aHdr.nVersion < SWG_VER_FRAMES )
	{
		list << "(old style, not interpreted)" << endl;
		rPar.r.skip();
		return;
	}
	In_SwRegFieldType( rPar );
	USHORT nType;
	rPar.r >> nType;
	list << indent << "Type = " << nType;
}

static void In_SwVarRegField( SwgDumper& rPar )
{
	In_SwVarRegFieldType( rPar );
}

static void In_SwDDEField( SwgDumper& rPar )
{
	In_SwDDEFieldType( rPar );
}

static void In_SwInputField( SwgDumper& rPar )
{
	if( rPar.aHdr.nVersion >= SWG_VER_FMTNAME )
		list << ", Prompt = \"" << rPar.GetText() << "\"";
	list << ", Text = \"" << rPar.GetText() << "\"";
	if( rPar.aHdr.nVersion >= SWG_VER_POOLIDS ) {
		USHORT nSubType;
		rPar.r >> nSubType;
		list << ", SubType = " << nSubType;
	}
}

static void In_SwMacroField( SwgDumper& rPar )
{
	if( rPar.aHdr.nVersion < SWG_VER_POOLIDS ) {
		list << ", Name = " << rPar.GetText();
		list << ", Lib = " << rPar.GetText();
	} else {
		list << ", Name = " << rPar.GetText();
		list << ", text = " << rPar.GetText();
	}
}

static void In_SwTableField( SwgDumper& rPar )
{
	if( rPar.aHdr.nVersion < SWG_VER_FRAMES )
	{
		list << "(old style, not interpreted)" << endl;
		rPar.r.skip();
		return;
	}
	BYTE bInTbl; // ignoriert
	rPar.r >> bInTbl;
	list << ", Formula = \"" << rPar.GetText() << "\"";
	list << ", Expand = \"" << rPar.GetText( FALSE ) << "\"";
	if( rPar.aHdr.nVersion >= SWG_VER_POOLIDS ) {
		USHORT nSubType;
		rPar.r >> nSubType;
		list << ", SubType = " << nSubType;
	}
}

static void In_SwGetExpField( SwgDumper& rPar )
{
	list << ", Formula = \"" << rPar.GetText() << "\"";
	if( rPar.aHdr.nVersion >= SWG_VER_POOLIDS )
		list << ", Expand = \"" << rPar.GetText() << "\"";
	if( rPar.aHdr.nVersion >= SWG_VER_GETEXP )
	{
		USHORT nSub;
		rPar.r >> nSub;
		list << ", Subtype = " << nSub;
	}
}

static void In_SwSetExpField( SwgDumper& rPar )
{
	In_SwSetExpFieldType( rPar );
	BYTE cFlags;
	rPar.r >> cFlags;
	list << ", Inter = " << ((cFlags & 0x01) ? "TRUE" : "FALSE");
	list << ", Formula = \"" << rPar.GetText() << "\"";
	if( cFlags & 0x02 )
		list << ", Expand = \"" << rPar.GetText() << "\"";
}

static void In_SwHiddenParaField( SwgDumper& rPar )
{
	char bHidden;
	rPar.r >> bHidden;
	list << ", Hidden = " << (bHidden ? "TRUE" : "FALSE");
	list << ", Cond = " << rPar.GetText();
}

static void In_SwDocInfoField( SwgDumper& rPar )
{
	char nType;
	rPar.r >> nType;
	list << ", Type = " << (int) nType;
}

static void In_SwTemplNameField( SwgDumper& rPar )
{
	// keine eigenen Daten
}

static void In_SwDBNextSetField( SwgDumper& rPar )
{
	list << ", Cond = " << rPar.GetText();
	list << ", Name = " << rPar.GetText();
}

static void In_SwDBNumSetField( SwgDumper& rPar )
{
	list << ", Cond = " << rPar.GetText();
	list << ", Name = " << rPar.GetText();
}

static void In_SwDBSetNumberField( SwgDumper& rPar )
{
	if( rPar.aHdr.nVersion >= SWG_VER_FRAMES3 )
	{
		long n;
		rPar.r.long4();
		rPar.r >> n;
		rPar.r.long3();
		list << ", Rec = " << n;
	}
}

static void In_SwExtUserField( SwgDumper& rPar )
{
	list << ", Text = \"" << rPar.GetText() << "\", Subtype = ";
	USHORT nSubType;
	rPar.r >> nSubType;
	list << nSubType;
}

//////////////////////////////////////////////////////////////////////////////

void SwgDumper::InField()
{
	short nFld, nFmt;
	r >> nFld >> nFmt;
	if( nFld == -1 )
	{
		// war unbekanntes Feld, ignorieren
		r.skip(); return;
	}
	nStatCnt[ nFld ]++;
	// Offset-Korrektur fuer alte Felder:
	nFld += RES_FIELDS_BEGIN;
	list << "Field: Type = " << nFld
		 << " (" << pName[ nFld - RES_FIELDS_BEGIN ]
		 << "), Format = " << nFmt;
	switch( nFld )
	{
		case RES_DBFLD:
			In_SwDBField( *this );
			break;
		case RES_USERFLD:
			In_SwUserField( *this );
			break;
		case RES_FILENAMEFLD:
			In_SwFileNameField( *this );
			break;
		case RES_DBNAMEFLD:
			In_SwDBNameField( *this );
			break;
		case RES_DATEFLD:
			In_SwDateField( *this );
			break;
		case RES_TIMEFLD:
			In_SwTimeField( *this );
			break;
		case RES_PAGENUMBERFLD:
			In_SwPageNumberField( *this );
			break;
		case RES_AUTHORFLD:
			In_SwAuthorField( *this );
			break;
		case RES_CHAPTERFLD:
			In_SwChapterField( *this );
			break;
		case RES_DOCSTATFLD:
			In_SwDocStatField( *this );
			break;
		case RES_GETREFFLD:
			In_SwGetRefField( *this );
			break;
		case RES_HIDDENTXTFLD:
			In_SwHiddenTxtField( *this );
			break;
		case RES_POSTITFLD:
			In_SwPostItField( *this );
			break;
		case RES_FIXDATEFLD:
			In_SwFixDateField( *this );
			break;
		case RES_FIXTIMEFLD:
			In_SwFixTimeField( *this );
			break;
		case RES_REGFLD:
			In_SwRegField( *this );
			break;
		case RES_VARREGFLD:
			In_SwVarRegField( *this );
			break;
		case RES_DDEFLD:
			In_SwDDEField( *this );
			break;
		case RES_INPUTFLD:
			In_SwInputField( *this );
			break;
		case RES_MACROFLD:
			In_SwMacroField( *this );
			break;
		case RES_TABLEFLD:
			In_SwTableField( *this );
			break;
		case RES_GETEXPFLD:
			In_SwGetExpField( *this );
			break;
		case RES_SETEXPFLD:
			In_SwSetExpField( *this );
			break;
		case RES_HIDDENPARAFLD:
			In_SwHiddenParaField( *this );
			break;
		case RES_DOCINFOFLD:
			In_SwDocInfoField( *this );
			break;
		case RES_TEMPLNAMEFLD:
			In_SwTemplNameField( *this );
			break;
		case RES_DBNEXTSETFLD:
			In_SwDBNextSetField( *this );
			break;
		case RES_DBNUMSETFLD:
			In_SwDBNumSetField( *this );
			break;
		case RES_DBSETNUMBERFLD:
			In_SwDBSetNumberField( *this );
			break;
		case RES_EXTUSERFLD:
			In_SwExtUserField( *this );
			break;
	}
	list << endl;
}

// Einlesen aller Feldtypen, die keine Systemtypen sind

void SwgDumper::InFieldTypes()
{
	list << begin << "FieldTypes" << endl;
	USHORT nFields;
	r >> nFields;
	for( USHORT i = 0; i < nFields && r.good(); i++ )
	{
		if( aHdr.nVersion >= SWG_VER_POOLIDS )
			if( r.next() != SWG_DATA ) Error( "SWG_DATA" );
		InFieldType();
	}
	if( r.good() )
		r.next();
	list << end;
}

void SwgDumper::InFieldType()
{
	BYTE ch;
	r >> ch;
	list << indent << "Type = " << (int) ch
	 << " (" << pName[ ch ] << ")";
	ch += RES_FIELDS_BEGIN;
	switch( ch )
	{
		case RES_DBFLD:
			In_SwDBFieldType( *this );
			break;
		case RES_USERFLD:
			In_SwUserFieldType( *this );
			break;
		case RES_REGFLD:
			In_SwRegFieldType( *this );
			break;
		case RES_VARREGFLD:
			In_SwVarRegFieldType( *this );
			break;
		case RES_DDEFLD:
			In_SwDDEFieldType( *this );
			break;
		case RES_SETEXPFLD:
			In_SwSetExpFieldType( *this );
			break;
		default:
			Error( "Field type" );
	}
	list << endl;
}

void SwgDumper::FieldStatistics()
{
	char buf[ 80 ];
	BOOL bHdr = FALSE;
	USHORT sum = 0;
	for( short i = 0; i < MAXFLD; i++ ) {
		USHORT n = nStatCnt[ i ];
		sum += n;
		if( n ) {
			if( !bHdr ) {
				bHdr = TRUE;
				list << endl << "Felder-Statistik:" << endl << endl;
				list << "Feldname             Gre" << endl << endl;
			}
			sprintf( buf, "%-20s %5u", pName[ i ], n );
			list << buf << endl;
		}
	}
	if( bHdr ) {
		list << "                    ------" << endl;
		sprintf( buf, "%-20s %5u", "", sum );
		list << buf << endl;
	}
}

