/*************************************************************************
 *
 *  $RCSfile: sw3fmts.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: mib $ $Date: 2001/12/07 13:21:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "core_pch.hxx"
#endif

#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SVDMODEL_HXX //autogen
#include <svx/svdmodel.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _SVX_CSCOITEM_HXX
#include <svx/cscoitem.hxx>
#endif

#ifndef _FMTFSIZE_HXX //autogen
#include <fmtfsize.hxx>
#endif
#ifndef _FMTORNT_HXX //autogen
#include <fmtornt.hxx>
#endif
#ifndef _FMTCNTNT_HXX //autogen
#include <fmtcntnt.hxx>
#endif
#ifndef _FMTSRND_HXX //autogen
#include <fmtsrnd.hxx>
#endif
#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _FMTCNCT_HXX //autogen
#include <fmtcnct.hxx>
#endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>
#endif
#ifndef _SWTBLFMT_HXX
#include <swtblfmt.hxx>
#endif

#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#include "swerror.h"
#include "doc.hxx"
#include "docary.hxx"
#include "pagefrm.hxx"
#include "cntfrm.hxx"
#include "pam.hxx"
#include "section.hxx"
#include "flypos.hxx"
#include "sw3imp.hxx"
#include "poolfmt.hxx"
#include "dcontact.hxx"
#include "dflyobj.hxx"
#include "flyfrm.hxx"
#include "hints.hxx"
#include "ndnotxt.hxx"

//////////////////////////////////////////////////////////////////////////////

// Finden eines AttrSets nach Index

SwFmt* lcl_sw3io__GetUserPoolFmt( USHORT nId, const SvPtrarr* pFmtArr )
{
	SwFmt* pFmt;
	for( USHORT n = 0; n < pFmtArr->Count(); ++n )
		if( nId == (pFmt = (SwFmt*)(*pFmtArr)[n])->GetPoolFmtId() )
			return pFmt;
	return 0;
}

// Whichwerte werden nach Gruppen gespreizt, so dass die einzelnen
// Gruppen getrennt um neue Attribute erweitert werden koennen.

// Umwandeln eines normalen Whichwertes in einen gespreizten Wert

USHORT lcl_sw3io__ExpandWhich( USHORT nWhich )
{
	// #95500#: There is no seperate range for box attributes in the file
	// format, but they are treated as graphic attributes!
	// Since we have extended the range of graphic attributes, we have
	// to move them back to RES_GRFATR_ROTATION, because that's where the
	// box attributes reange started in the 5.2..
	if( nWhich >= RES_BOXATR_BEGIN )
		return (nWhich <= RES_BOXATR_VALUE) ? (nWhich - RES_BOXATR_BEGIN + RES_GRFATR_ROTATION - RES_GRFATR_BEGIN + 0x6000) : 0;
	if( nWhich >= RES_GRFATR_BEGIN )
		return (nWhich <= RES_GRFATR_CROPGRF) ? (nWhich - RES_GRFATR_BEGIN + 0x6000) : 0;
	if( nWhich >= RES_FRMATR_BEGIN )
		return (nWhich <= RES_COLUMNBALANCE) ? (nWhich - RES_FRMATR_BEGIN + 0x5000) : 0;
	if( nWhich >= RES_PARATR_BEGIN )
		return (nWhich <= RES_PARATR_NUMRULE) ? (nWhich - RES_PARATR_BEGIN + 0x4000) : 0;
	if( nWhich >= RES_TXTATR_NOEND_BEGIN )
		return (nWhich <= RES_TXTATR_HARDBLANK) ? (nWhich - RES_TXTATR_NOEND_BEGIN + 0x3000) : 0;
	if( nWhich >= RES_TXTATR_WITHEND_BEGIN )
		return (nWhich <= RES_TXTATR_CHARFMT) ? (nWhich - RES_TXTATR_WITHEND_BEGIN + 0x2000) : 0;
	return (nWhich <= RES_CHRATR_BACKGROUND) ? (nWhich - RES_CHRATR_BEGIN + 0x1000) : 0;
}

// Umwandeln eines gespreizten Whichwertes in den normalen Wert

USHORT lcl_sw3io__CompressWhich( USHORT nWhich, USHORT nVersion )
{
	if( nWhich >= 0x6000 )
	{
		// #95500#: Files written with the SWG_NEWGRFATTR version have the
		// extended grapic attribute range, but didn't correct it while
		// saving: File before that version didn't have the extended graphic
		// attribute range and need a correction. Files written with later
		// version did correct the range while saving and therfor need a
		// correction while loading, too.that version didn't have the extended graphic
		// attribute range and need a correction. Files written with later
		// version did correct the range while saving and therfor need a
		// correction while loading, too.

		(nWhich -= 0x6000 ) += RES_GRFATR_BEGIN;
		if( SWG_NEWGRFATTR != nVersion && nWhich > RES_GRFATR_CROPGRF )
			nWhich += RES_GRFATR_END - RES_GRFATR_CROPGRF - 1;
		return nWhich;
	}
	if( nWhich >= 0x5000 )
		return nWhich - 0x5000 + RES_FRMATR_BEGIN;
	if( nWhich >= 0x4000 )
		return nWhich - 0x4000 + RES_PARATR_BEGIN;
	if( nWhich >= 0x3000 )
		return nWhich - 0x3000 + RES_TXTATR_NOEND_BEGIN;
	if( nWhich >= 0x2000 )
		return nWhich - 0x2000 + RES_TXTATR_WITHEND_BEGIN;
	if( nWhich >= 0x1000 )
		return nWhich - 0x1000 + RES_CHRATR_BEGIN;
	// Alte Dokumente vor dem 21.04.95
	return nWhich;
}

sal_Bool lcl_sw3io_insFtn( const SwTxtNode *pTxtNd )
{
	ASSERT( pTxtNd, "There is the text node?" );
	if( !pTxtNd )
		return FALSE;

	const SwStartNode *pSttNd = pTxtNd->FindStartNode();
	while( pSttNd && 
		   (pSttNd->IsTableNode() || pSttNd->IsSectionNode() ||
		    SwTableBoxStartNode == pSttNd->GetStartNodeType() ) )
		pSttNd = pSttNd->FindStartNode();
	return !pSttNd || SwNormalStartNode == pSttNd->GetStartNodeType();
}

//////////////////////////////////////////////////////////////////////////////

// Einlesen eines Attributs
// Falls Bgn und End nicht besetzt sind, wird STRING_LEN zurueckgeliefert.
// Fall nur Bgn besetzt ist, ist End == Bgn

// BYTE		Flags
//			0x10 - Beginn ist gueltig
//			0x20 - Ende ist gueltig
// UINT16	Which
// UINT16	Attributversion
// UINT16	Beginn (opt)
// UINT16	Ende (opt)
// Attribut

SfxPoolItem* Sw3IoImp::InAttr( xub_StrLen& nBgn, xub_StrLen& nEnd,
							   const SwTxtNode *pTxtNd )
{
	nBgn = nEnd = STRING_LEN;
	OpenRec( SWG_ATTRIBUTE );
	BYTE cFlags = OpenFlagRec();
	UINT16 nWhich, nVer;
	*pStrm >> nWhich >> nVer;
	nWhich = lcl_sw3io__CompressWhich( nWhich, nVersion );
	if( cFlags & 0x10 )
	{
		USHORT nBgn16;
		*pStrm >> nBgn16;
		nBgn = nBgn16;
	}
	if( cFlags & 0x20 )
	{
		USHORT nEnd16;
		*pStrm >> nEnd16;
		nEnd = nEnd16;
	}
	else
		nEnd = nBgn;
	CloseFlagRec();

	SfxPoolItem* pItem = 0;
	// MIB 1.9.97: In der 3.0 geschriebene Crop-Attribute sind inkompatibel,
	// also ignorieren wir sie.
	if( POOLATTR_BEGIN <= nWhich && nWhich < POOLATTR_END &&
		( nWhich!=RES_GRFATR_CROPGRF || IsVersion(SWG_NONUMLEVEL) )  )
	{
		if( nWhich != RES_TXTATR_FTN || 
			(nFlyLevel == 0 && (!bInsert || lcl_sw3io_insFtn(pTxtNd)) ) )
		{
			const SfxPoolItem& rDflt = pDoc->GetAttrPool().GetDefaultItem( nWhich );
			pItem = rDflt.Create( *pStrm, nVer );

			// Don't insert charset color items that have the system charset
//			if( RES_CHRATR_CHARSETCOLOR == nWhich &&
//				((SvxCharSetColorItem *)pItem)->GetCharSet() == eSysSet )
//			{
//				delete pItem;
//				pItem = 0;
//			}
		}
		else
		{
			ASSERT( nFlyLevel == 0, "Fussnoten im Fly sind nicht erlaubt" );
		}
	}
	CloseRec( SWG_ATTRIBUTE );
	return pItem;
}

// Schreiben eines Attributs

void Sw3IoImp::OutAttr( const SfxPoolItem& rAttr, xub_StrLen nBgn,
						xub_StrLen nEnd )
{
	USHORT nWhich = rAttr.Which();

	// Items, die als Version USHRT_MAX zurueckgeben, wollen nicht
	// geschrieben werden
	long nFFVersion = pStrm->GetVersion();
	ASSERT( IsSw31Export() ? nFFVersion==SOFFICE_FILEFORMAT_31
						   : (nFFVersion==SOFFICE_FILEFORMAT_40 ||
							  nFFVersion==SOFFICE_FILEFORMAT_50),
			"FF-Version am Stream stimmt nicht" );
	USHORT nIVer = rAttr.GetVersion( (USHORT)nFFVersion );
	if( USHRT_MAX == nIVer )
		return;

	// Das Zeichen-Hintergrund-Attribut gab es in der 3.1 auch noch nicht
	if( IsSw31Export() && RES_CHRATR_BACKGROUND==nWhich)
		return;

	// Hints that start behind the maximum string length of version 5.2
	// don't have to be exported.
	if( nBgn != STRING_LEN && nBgn > STRING_MAXLEN52 )
		return;
	if( nEnd != STRING_LEN && nEnd > STRING_MAXLEN52 )
		nEnd = STRING_MAXLEN52;

	if( nWhich != RES_TXTATR_FTN || nFlyLevel == 0 )
	{
		nWhich = lcl_sw3io__ExpandWhich( nWhich );
		if( nWhich )
		{
				
			OpenRec( SWG_ATTRIBUTE );
			BYTE cFlags = 0x04;			// Which + Version
			if( nBgn != STRING_LEN )
				cFlags += 0x12;			// Begin
			if( nEnd != nBgn && nBgn != STRING_LEN )
				cFlags += 0x22;			// End
			*pStrm << (BYTE) cFlags
				   << (UINT16) nWhich
				   << (UINT16) nIVer;
			if( cFlags & 0x10 )
				*pStrm << (UINT16) nBgn;
			if( cFlags & 0x20 )
				*pStrm << (UINT16) nEnd;
			rAttr.Store( *pStrm, nIVer );
			CloseRec( SWG_ATTRIBUTE );
		}
	}
#ifndef PRODUCT
	else
		ASSERT( !this, "Fussnoten im Fly sind nicht erlaubt" );
#endif
}

// Einlesen eines AttrSets

void Sw3IoImp::InAttrSet( SwAttrSet& rSet )
{
	OpenRec( SWG_ATTRSET );
	while( BytesLeft() )
	{
		xub_StrLen n1, n2;
		SfxPoolItem* pItem = InAttr( n1, n2 );
		if( pItem )
			rSet.Put( *pItem ), delete pItem;
	}
	CloseRec( SWG_ATTRSET );
}

void Sw3IoImp::OutAttrSet( const SfxItemSet& rSet, BOOL bSectionFmt )
{
	if( rSet.Count() )
	{
		// Beim 3.1 Export den aktuellen Attrset merken
		const SfxItemSet *pOldExportItemSet;
		if( pExportInfo )
		{
			pOldExportItemSet = pExportInfo->pItemSet;
			pExportInfo->pItemSet = &rSet;
		}

		OpenRec( SWG_ATTRSET );
		SfxItemIter aIter( rSet );
		const SfxPoolItem* pAttr = aIter.GetCurItem();
		const SfxItemPool *pTmp = SfxItemPool::GetStoringPool();
		SfxItemPool::SetStoringPool( &pDoc->GetAttrPool() );
		for( USHORT i = 0; i < rSet.Count() && Good(); i++ )
		{
			// Header- und Footer- Attribute werden u.U. nicht rausgeschrieben,
			// wenn sie im Leftformat einer Seitenvorlage mit HdrShared
			// oder FtrShared vorliegen. Dann wird nur das Attribut im
			// MAsterformat gespeichert (siehe auch SW3PAGE.CXX, OutPageDesc())
			USHORT nWhich = pAttr->Which();
			BOOL bNoHdr =  RES_HEADER == nWhich &&
						   ( nGblFlags & SW3F_NOHDRFMT ) != 0;
			BOOL bNoFtr = RES_FOOTER == nWhich &&
						  ( nGblFlags & SW3F_NOFTRFMT ) != 0;
			BOOL bNoCntnt = bSectionFmt && RES_CNTNT == nWhich;
			if( !( bNoHdr || bNoFtr || bNoCntnt) )
				OutAttr( *pAttr, STRING_LEN, STRING_LEN );
			pAttr = aIter.NextItem();
		}
		if( IsSw31Export() && pExportInfo && pExportInfo->bFlyFrmFmt )
		{
			// Wenn ein FlyFrm-Format exportiert wird, muss beruecksichtigt
			// werden, dass die Raender jetzt nicht mehr Bestandteil der
			// Rahmengroesse sind. Weil die Vorlagen nicht angepasst werden,
			// wird ggf. hart attributiert
			const SvxLRSpaceItem& rLRSpace =
						(const SvxLRSpaceItem&)rSet.Get( RES_LR_SPACE );
			const SvxULSpaceItem& rULSpace =
						(const SvxULSpaceItem&)rSet.Get( RES_UL_SPACE );

			if( SFX_ITEM_SET != rSet.GetItemState( RES_FRM_SIZE, FALSE ) )
			{
				const SwFmtFrmSize& rFrmSize =
							(const SwFmtFrmSize&)rSet.Get( RES_FRM_SIZE );
				Size aConvSize(
					rFrmSize.GetSizeConvertedToSw31( &rLRSpace, &rULSpace ) );

				if( rFrmSize.GetSize() != aConvSize )
				{
					SwFmtFrmSize aFrmSize( rFrmSize );
					aFrmSize.SetSize( aConvSize );
					OutAttr( aFrmSize, STRING_LEN, STRING_LEN );
				}
			}

			if( SFX_ITEM_SET != rSet.GetItemState( RES_HORI_ORIENT, FALSE ) )
			{
				const SwFmtHoriOrient rHori =
					(const SwFmtHoriOrient&)rSet.Get( RES_HORI_ORIENT );

				if( rHori.GetRelationOrient() > PRTAREA ||
					rHori.GetPos() != rHori.GetPosConvertedToSw31( &rLRSpace ) )
					OutAttr( rHori, STRING_LEN, STRING_LEN );
			}

			if( SFX_ITEM_SET != rSet.GetItemState( RES_VERT_ORIENT, FALSE ) )
			{
				const SwFmtVertOrient rVert =
					(const SwFmtVertOrient&)rSet.Get( RES_VERT_ORIENT );

				SwTwips nConvPos = rVert.GetPosConvertedToSw31( &rULSpace );
				if( rVert.GetPos() != nConvPos )
				{
					SwFmtVertOrient aVert( rVert );
					aVert.SetPos( nConvPos );
					OutAttr( aVert, STRING_LEN, STRING_LEN );
				}
			}
		}

		SfxItemPool::SetStoringPool( pTmp );
		CloseRec( SWG_ATTRSET );

		// Beim 3.1 Export den alten Attrset zuruecksetzen
		if( pExportInfo )
			pExportInfo->pItemSet = pOldExportItemSet;
	}
}

// Ein Format einlesen
// Hier wird das Format auch erzeugt, falls es nicht uebergeben wurde.

SwFmt* Sw3IoImp::InFormat( BYTE cKind, SwFmt* pFmt )
{
	if( !OpenRec( cKind ) )
	{
		CloseRec( SWG_EOF );
		return NULL;
	}

	// Ist der Drawing Layer korrekt geladen?
	if( cKind == SWG_SDRFMT && ( nGblFlags & SW3F_NODRAWING ) )
	{
		Warning();
		CloseRec( cKind );
		return NULL;
	}
	if( cKind == SWG_FLYFMT || cKind == SWG_SDRFMT ) nFlyLevel++;
	BYTE cFlags = OpenFlagRec();
	BYTE cMoreFlags = 0;
	USHORT nDerived, nPoolId, nStrIdx = IDX_NO_VALUE;
	SdrObject* pSdrObj = NULL;
	*pStrm >> nDerived >> nPoolId;
	// 0x0L - Laenge der Daten
	// 0x10 - Namensindex des Formats folgt
	// 0x20 - SdrObject-Referenz folgt
	if( cFlags & 0x10 )
		*pStrm >> nStrIdx;
	if( cFlags & 0x20 )
	{
		// Sdr-Objekt aus SdrModel auslesen
		UINT32 nObjRef;
		*pStrm >> nObjRef;
		nObjRef += nZOrderOff;
		SdrPage* pPg = pDoc->MakeDrawModel()->GetPage( 0 );
		switch( cKind )
		{
			case SWG_FLYFMT:
				if( ( nVersion < SWG_ZORDER )
				 || ( nGblFlags & SW3F_NODRAWING ) )
				{
					pSdrObj = new SwFlyDrawObj;
					pPg->InsertObject( pSdrObj, nObjRef );
					break;
				}
				// sonst kann durchgerauscht werden, da
				// LoadDrawingLayer() die Objekte schon angelegt hat
			case SWG_SDRFMT:
				if( nObjRef >= pPg->GetObjCount() )
				{
					ASSERT( !this, "Ungueltige SdrObject-Nummer" );
					nObjRef = 0;
					Error();
				}
				pSdrObj = pPg->GetObj( nObjRef );
				break;
		}
	}

	BOOL bMoreFlags;
	if( IsVersion(SWG_LONGIDX) )
		bMoreFlags = (cFlags & 0x80) != 0;
	else
		bMoreFlags = (cFlags & 0x40) != 0;

	if( bMoreFlags )
		*pStrm >> cMoreFlags;
	CloseFlagRec();

	BOOL bReadName;
	if( IsVersion(SWG_LONGIDX) )
		bReadName = (cMoreFlags & 0x20) != 0;
	else
		bReadName = nStrIdx == IDX_NO_VALUE;

	String aName;
	if( bReadName )
	{
		InString( *pStrm, aName );
	}
	else
	{
		aName = aStringPool.Find( nStrIdx );
	}

	// Line und Box-Formate habe keinen Namen mehr.
	if( !IsVersion(SWG_LONGIDX) && pFmt &&
		( pFmt->IsA(TYPE(SwTableLineFmt)) || pFmt->IsA(TYPE(SwTableBoxFmt)) ) )
	{
		aName = aEmptyStr;
	}

	// Format erzeugen
	if( !pFmt )
	{
		switch( cKind )
		{
			case SWG_FREEFMT:
				// Freifliegende Frameformate werden von Headers
				// und Footers verwendet.
				pFmt = new SwFrmFmt( pDoc->GetAttrPool(), aName,
									 pDoc->GetDfltFrmFmt() );
				break;
			case SWG_FRAMEFMT:
				if( IDX_NO_VALUE != nPoolId )
				{
					if( IsPoolUserFmt( nPoolId ) )
					{
						// wir suchen uns das richtige Format
						if( 0 == ( pFmt = lcl_sw3io__GetUserPoolFmt( nPoolId,
												pDoc->GetFrmFmts() )) )
							pFmt = lcl_sw3io__GetUserPoolFmt( nPoolId,
												pDoc->GetSpzFrmFmts() );
						ASSERT( pFmt, "Format not found." );
					}
					else
						pFmt = pDoc->GetFrmFmtFromPool( nPoolId );
				}
				if( !pFmt )
					pFmt = pDoc->MakeFrmFmt( aName,
						(SwFrmFmt*) FindFmt( nDerived, cKind ) );
				else
					pFmt->ResetAllAttr();

				break;
			case SWG_FLYFMT:
				if( pSdrObj && pSdrObj->GetUserCall() )
				{
					//s.u., und auch bugdoc 28336.sdw beim schliessen nach laden.
					ASSERT( !this, "More than one Format" );
					CloseRec( cKind );
					nFlyLevel--;
					return NULL;
				}
				pFmt = pDoc->MakeFlyFrmFmt( aName,
						(SwFlyFrmFmt*) FindFmt( nDerived, cKind ) );
				if ( pSdrObj )
					new SwFlyDrawContact( (SwFrmFmt*) pFmt, pSdrObj );
				break;
			case SWG_SDRFMT:
				if ( pSdrObj && (pSdrObj->ISA(SwFlyDrawObj) ||
								 pSdrObj->GetUserCall()) )
				{
					// Pruefen, ob das Draw-Objekt nicht etwa zu einem
					// Fly-Frame-Format gehoert oder schon verwendet wurde.
					// Kann passieren, weil sich manche Draw-Objekte selber
					// zerstoeren, ohne dass das Format geloescht wird. Leider
					// wurden solche Format bisher auch rausgeschreiben.
					// (bug fix #25354# fuer alte Doks)
					CloseRec( cKind );
					nFlyLevel--;
					return NULL;
				}
				pFmt = pDoc->MakeDrawFrmFmt( aName,
						(SwFrmFmt*) FindFmt( nDerived, cKind ) );
				if( pSdrObj )
					new SwDrawContact( (SwFrmFmt*) pFmt, pSdrObj );
				break;
			case SWG_SECTFMT:
				pFmt = pDoc->MakeSectionFmt(
						(SwSectionFmt*) FindFmt( nDerived, cKind ) );
				break;
		}
	}
	else
	{
		// Fuellen eines vorhandenen Formats
		pFmt->ResetAllAttr();
		if( nDerived != IDX_NO_VALUE )
			pFmt->SetDerivedFrom( FindFmt( nDerived, cKind ) );
	}

	if( nPoolId != IDX_NO_VALUE )
		pFmt->SetPoolFmtId( nPoolId );

	if( cMoreFlags & 0x01 )
		pFmt->SetAutoUpdateFmt();

	while( BytesLeft() )
	{
		BYTE cSubtype = Peek();
		switch( cSubtype )
		{
			case SWG_ATTRSET:
				InAttrSet( (SwAttrSet&) pFmt->GetAttrSet() );
				((SwAttrSet&)pFmt->GetAttrSet()).SetModifyAtAttr( pFmt );

				if( cKind == SWG_FLYFMT &&
					!IsVersion( SWG_URLANDMAP, SWG_EXPORT31, SWG_DESKTOP40 ) )
				{
					// In 31-FFohne URL-Attribut muss das Attribut noch vom
					// Node in das Format verschoben werden
					SwNoTxtNode *pNd = pDoc->GetNodes()[
						pFmt->GetCntnt().GetCntntIdx()->GetIndex()+1 ]->GetNoTxtNode();

					const SfxPoolItem *pItem;
					if ( pNd && SFX_ITEM_SET == pNd->GetSwAttrSet().
										GetItemState( RES_URL, FALSE, &pItem))
					{
						pFmt->SetAttr( *pItem );
						pNd->ResetAttr( RES_URL );
					}
				}

				if( nVersion < SWG_DESKTOP40 && cKind == SWG_FLYFMT )
				{
					// In SW31-FlyFrm-Formaten muessen ein par Attrs
					// korregiert werden. Sie werden immer gesetzt, da sie
					// in den Vorlagen nicht korregiert wurden.
					const SvxLRSpaceItem& rLRSpace = pFmt->GetLRSpace();
					const SvxULSpaceItem& rULSpace = pFmt->GetULSpace();

					const SwFmtFrmSize& rFrmSize = pFmt->GetFrmSize();
					Size aConvSize(
						rFrmSize.GetSizeConvertedFromSw31( &rLRSpace,
														   &rULSpace ) );
					if( rFrmSize.GetSize() != aConvSize )
					{
						SwFmtFrmSize aFrmSize( rFrmSize );
						aFrmSize.SetSize( aConvSize );
						pFmt->SetAttr( aFrmSize );
					}

					const SwFmtHoriOrient& rHori = pFmt->GetHoriOrient();
					SwTwips nConvPos =
						rHori.GetPosConvertedFromSw31( &rLRSpace );
					if( rHori.GetPos() != nConvPos )
					{
						SwFmtHoriOrient aHori( rHori );
						aHori.SetPos( nConvPos );
						pFmt->SetAttr( aHori );
					}

					const SwFmtVertOrient& rVert = pFmt->GetVertOrient();
					nConvPos = rVert.GetPosConvertedFromSw31( &rULSpace );
					if( rVert.GetPos() != nConvPos )
					{
						SwFmtVertOrient aVert( rVert );
						aVert.SetPos( nConvPos );
						pFmt->SetAttr( aVert );
					}
				}

				if( cKind == SWG_FLYFMT && IsVersion( SWG_LONGIDX ) )
				{
					const SfxPoolItem *pItem;
					if( SFX_ITEM_SET == pFmt->GetAttrSet().
								GetItemState( RES_CHAIN, FALSE, &pItem) )
					{
						const SwFmtChain *pChain =
							(const SwFmtChain *)pItem;

						// Den Next des Prev richtig setzen.
						SwFlyFrmFmt *pFlyFmt = pChain->GetPrev();
						if( pFlyFmt )
						{
							SwFmtChain aChain( pFlyFmt->GetChain() );
							ASSERT( !aChain.GetNext(),
									"Next ist bereits verkettet" );
							aChain.SetNext( (SwFlyFrmFmt *)pFmt );
							pFlyFmt->SetAttr( aChain );
						}

						// Den Prev des Next richtig setzen.
						pFlyFmt = pChain->GetNext();
						if( pFlyFmt )
						{
							SwFmtChain aChain( pFlyFmt->GetChain() );
							ASSERT( !aChain.GetPrev(),
									"Prev ist bereits verkettet" );
							aChain.SetPrev( (SwFlyFrmFmt *)pFmt );
							pFlyFmt->SetAttr( aChain );
						}
					}
				}

				if( bInsert )
				{
					// das Format hat sich geaendert!
					SwFmtChg aHint( pFmt );
					pFmt->Modify( &aHint, &aHint );
				}
				break;
			default:
				SkipRec();
		}
	}
	CloseRec( cKind );

	if( cKind == SWG_SDRFMT &&
		!IsVersion( SWG_WRAPDRAWOBJ, SWG_EXPORT31, SWG_DESKTOP40 ) )
		pFmt->SetAttr( SwFmtSurround( SURROUND_THROUGHT ) );

	// beim Einfuegen eines Dokuments muessen Rahmen, Grafiken und
	// OLE-Nodes noch einen eindeutigen Namen bekommen
	// This must happen always, because there are lots of documents
	// that contain frames with the same name.
	if( cKind == SWG_FLYFMT )
	{
		const SwNode* pNd =
			pDoc->GetNodes()[ pFmt->GetCntnt().GetCntntIdx()->GetIndex()+1 ];
		BYTE nNdTyp = !pNd->IsNoTxtNode() ? ND_TEXTNODE : pNd->GetNodeType();

		pFmt->SetName( aEmptyStr );

		// If the name is not changed, its extension must be kept to be able
		// to load the layout.
		String aSrchName( aName );
		aStringPool.RemoveExtension( aSrchName );
		if( bInsert )
			aName = aSrchName;

		if( pDoc->FindFlyByName( aSrchName, nNdTyp ) )
		{
			switch( nNdTyp )
			{
			case ND_TEXTNODE:
				aName = pDoc->GetUniqueFrameName();
				break;
			case ND_GRFNODE:
				aName = pDoc->GetUniqueGrfName();
				break;
			case ND_OLENODE:
				aName = pDoc->GetUniqueOLEName();
				break;
			}
		}
	}

	pFmt->SetName( aName );
	if( cKind == SWG_FLYFMT || cKind == SWG_SDRFMT )
		nFlyLevel--;

// OPT: Cache fuer Formate im StringPool
	if( nStrIdx != IDX_NO_VALUE )
		aStringPool.SetCachedFmt( nStrIdx, pFmt );
// /OPT: Cache fuer Formate im StringPool

	return pFmt;
}

// Ausgabe eines Formats:
// BYTE	   		Flags
// 				0x10 - Namensindex des Formats folgt
// 				0x20 - SdrObject-Referenz folgt
// UINT16		String-ID des Parents (IDX_NO_VALUE: Formatname folgt)
// UINT16		Pool-ID
// UINT16		String-ID des Formatnamens (opt.)
// INT32		Z-Order des Drawing-Objekts (opt.)
// String       Name des Formats, falls nicht im Pool gefunden (opt.)
// SWG_ATTRSET	Attribute (opt.)

void Sw3IoImp::OutFormat( BYTE cType, const SwFmt& rFmt )
{
	// Freifliegende Formate werden immer geschrieben, da sie niemals
	// mehrfach referenziert werden!
	if( cType != SWG_FREEFMT && cType != SWG_SECTFMT && rFmt.IsWritten() )
		return;

	OpenRec( cType );
	// Von welchem Format isses abgeleitet?
	USHORT nDerived = IDX_NO_VALUE;
	SwFmt* pDerived = rFmt.DerivedFrom();
	if( pDerived && SWG_SECTFMT == cType )
	{
		// The parent format of TOX content sections must not to be stored,
		// because the parent format will not exist if the document is read
		// again. In fact, this format is copied to a newly created one only.
		// The parent format of TOX header sections has not to be stored,
		// because the section is inserted into the newly created TOX content
		// section and that for will be replaced always.
		const SwSectionFmt* pSectFmt = PTR_CAST( SwSectionFmt, &rFmt );
		ASSERT( pSectFmt, "no section format?" );
		if( pSectFmt )
		{
			const SwSection* pSect = pSectFmt->GetSection();
			if( pSect && (TOX_CONTENT_SECTION == pSect->GetType() ||
						  TOX_HEADER_SECTION == pSect->GetType()) )
			{
				pDerived = 0;
			}
		}
	}

	if( pDerived )
	{
		if( pDerived->IsDefault() )
			nDerived = IDX_DFLT_VALUE;
		else
			nDerived = aStringPool.Find( pDerived->GetName(),
										 pDerived->GetPoolFmtId() );
	}
	// Flag Bits:
	// SW3.1/4.0: Byte 1
	// 0x0L - Laenge der Daten
	// 0x10 - Namensindex des Formats folgt
	// 0x20 - SdrObject-Referenz folgt
	// 0x40 - zusaetzliches Flag-Byte folgt (nur 4.0)
	// SW3.1/40: Byte 2
	// 0x01 - Auto-Update-Fmt (nur 4.0)
	// SW5.0
	// 0x0L - Laenge der Daten
	// 0x10 - Namensindex des Formats folgt
	// 0x20 - SdrObject-Referenz folgt
	// 0x40 - frei (fuer ein haeufig benutztes Flag gedacht)
	// 0x80 - zusaetzliches Flag-Byte folgt
	// SW5.0: Byte 2
	// 0x01 - Auto-Update-Fmt
	// 0x02 - Name des Formats ist als String enthalten
	BYTE cFlags = 0x04;		// Derived, PoolId
	BYTE cMoreFlags = 0x00;

	const SwFlyFrm* pExportFlyFrm = NULL;

	if( rFmt.IsAutoUpdateFmt() && !IsSw31Export() )
		cMoreFlags += 0x01;

	ULONG nSdrRef = 0;
	USHORT nStrIdx = IDX_NO_VALUE;
	BOOL bWriteName = FALSE;
	if( IsSw31Or40Export() )
	{
		if( SWG_FRAMEFMT==cType && ( rFmt.IsA(TYPE(SwTableLineFmt)) ||
									 rFmt.IsA(TYPE(SwTableBoxFmt)) ) )
		{
			nStrIdx = GetTblLineBoxFmtStrPoolId40( (SwFrmFmt *)&rFmt );
		}
		else
		{
			nStrIdx = aStringPool.Find( rFmt.GetName(), rFmt.GetPoolFmtId() );
		}
		if( nStrIdx != IDX_NO_VALUE )
			cFlags += 0x12;
		else
			bWriteName = TRUE;

		if( cMoreFlags != 0 )
			cFlags += 0x41;
	}
	else
	{
		if( rFmt.GetName().Len() )
		{
			nStrIdx = aStringPool.Find( rFmt.GetName(), rFmt.GetPoolFmtId() );
			if( nStrIdx != IDX_NO_VALUE )
			{
				cFlags += 0x12;
			}
			else
			{
				cMoreFlags += 0x20;
				bWriteName = TRUE;
			}
		}

		if( cMoreFlags != 0 )
			cFlags += 0x81;
	}

	// #72785#: In organizer mode, no drawing layer will be written. That for
	// no sdr object references must be written.
	if( !bOrganizer )
	{
		// Gibt es ein SdrObject?
		// Zur Zeit nur fuer SDR-Formate!!!
		if( cType == SWG_SDRFMT )
		{
			// Schauen, ob es ein SdrObject dafuer gibt
			SwClientIter aIter( (SwFmt&) rFmt );
			if( aIter.First( TYPE(SwDrawContact) ) )
			{
				nSdrRef = ((SwDrawContact*)aIter())->GetMaster()->GetOrdNum();
				cFlags += 0x24;
			}
		}
		else if( cType == SWG_FLYFMT )
		{
			// Schauen, ob es ein SdrObject dafuer gibt
			SwClientIter aIter( (SwFmt&) rFmt );
			if( aIter.First( TYPE( SwFlyFrm) ) )
			{
				pExportFlyFrm = (SwFlyFrm*)aIter();
				nSdrRef = pExportFlyFrm->GetVirtDrawObj()->GetOrdNum();
				cFlags += 0x24;
			}
			else if( aIter.First( TYPE( SwFlyDrawContact) ) )
			{
				// fix #45256#: Wenn Seitenvorlagen eines Doks importiert werden,
				// werden dafuer u.U. Master-Objekte in die Page eingetragen.
				// Wenn diese jetzt noch in der Page stehen, muss dafuer gesorgt
				// werden, dass beim Laden des Dokuments wieder an der gleichen
				// Stelle Master-Objekte angelegt werden, weil sonst die Indizes
				// der Zeichen-Objekte in der Page nicht stimmen.
				const SdrObject *pMaster =
					((SwFlyDrawContact*)aIter())->GetMaster();
				if( pMaster->GetPage() )
				{
					nSdrRef = pMaster->GetOrdNum();
					cFlags += 0x24;
				}
			}
		}
	}

#ifndef PRODUCT
	if( (cFlags & 0x20) && pRefSdrObjects )
	{
		size_t nPos = nSdrRef / 8;
		BYTE nByte = 1 << (nSdrRef % 8);
		ASSERT( (pRefSdrObjects[nPos] & nByte) == 0,
				"Zeichen-Object doppelt referenziert" );

		pRefSdrObjects[nPos] |= nByte;
	}
#endif

	USHORT nPoolId = rFmt.GetPoolFmtId();
	// In Colls darf nur das FrmFmt einen PoolId haben
	if( nPoolId == USHRT_MAX )
		nPoolId = IDX_NO_VALUE;
	*pStrm << (BYTE)   cFlags
		   << (UINT16) nDerived
		   << (UINT16) nPoolId;
	if( cFlags & 0x10 )
		*pStrm << (UINT16) nStrIdx;
	if( cFlags & 0x20 )
		*pStrm << (INT32) nSdrRef;
	if( cMoreFlags != 0 )
		*pStrm << (BYTE) cMoreFlags;

	// Falls der Name nicht im Pool ist, direkt raus damit!
	if( bWriteName )
		OutString( *pStrm, rFmt.GetName() );

	BOOL bOldExportFlyFrmFmt;
	const SwFlyFrm* pOldExportFlyFrm;
	if( pExportInfo )
	{
		bOldExportFlyFrmFmt = pExportInfo->bFlyFrmFmt;
		pOldExportFlyFrm = pExportInfo->pFlyFrm;
		pExportInfo->bFlyFrmFmt = (cType == SWG_FLYFMT);
		pExportInfo->pFlyFrm = pExportFlyFrm;
	}
	OutAttrSet( rFmt.GetAttrSet(), SWG_SECTFMT == cType );
	if( pExportInfo )
	{
		pExportInfo->bFlyFrmFmt = bOldExportFlyFrmFmt;
		pExportInfo->pFlyFrm = pOldExportFlyFrm;
	}
	CloseRec( cType );
	if( cType != SWG_FREEFMT && cType != SWG_SECTFMT )
		((SwFmt&)rFmt).SetWritten();
}

////////////////////////////////////////////////////////////////////////////

// globale FlyFrames

void Sw3IoImp::InFlyFrames()
{
	BOOL bInsIntoHdrFtrSave = bInsIntoHdrFtr;	// In seitengebundenen sind
	bInsIntoHdrFtr = FALSE;						// Draw-Objekte immer erlaubt

	USHORT nPageNumOff = 0;
	if( bInsert )		// im einfuege Modus?
	{
		// dann binde die Seitengebundenen an die akt. Seite + Nummer
		// Dazu stelle erstmal fest, ob es ueberhaupt einen entsprechen
		// Offset gibt.
		SwFrm* pFrm;
		SwCntntNode* pCNd = pDoc->GetNodes()[ pCurPaM->GetPoint()->nNode ]->GetCntntNode();
		if( pCNd && 0 != ( pFrm = pCNd->GetFrm() ))
			nPageNumOff = pFrm->FindPageFrm()->GetPhyPageNum() - 1;
	}

	USHORT eSave_StartNodeType = eStartNodeType;
	eStartNodeType = SwFlyStartNode;

	OpenRec( SWG_FLYFRAMES );
	while( BytesLeft() )
	{
		BYTE cType = Peek();
		if( cType == SWG_FLYFMT || cType == SWG_SDRFMT )
		{
			SwFmt* pFmt = InFormat( cType, NULL );
			ASSERT( !pFmt || FLY_PAGE >= pFmt->GetAnchor().GetAnchorId(),
						"Rahmen ist ungueltig gebunden" );
			if( pFmt && nPageNumOff )
			{
				const SwFmtAnchor& rOld = pFmt->GetAnchor();
				if( FLY_PAGE == rOld.GetAnchorId() )
				{
					pFmt->SetAttr( SwFmtAnchor( FLY_PAGE,
								nPageNumOff + rOld.GetPageNum() ) );
				}
			}
		}
		else
			Error();
	}
	CloseRec( SWG_FLYFRAMES );
	eStartNodeType = eSave_StartNodeType;
	bInsIntoHdrFtr = bInsIntoHdrFtrSave;
}

// Ausgabe von FlyFrames, die nicht an einem Node kleben

void Sw3IoImp::OutFlyFrames( SwPaM& rPaM )
{
	if( bSaveAll )
	{
		// Alle Frames: ueber das Array gehen
		const SwSpzFrmFmts* pFlys = pDoc->GetSpzFrmFmts();
		USHORT nArrLen = pFlys->Count();
		if( nArrLen )
		{
			OpenRec( SWG_FLYFRAMES );
			for( USHORT i = 0; i < nArrLen; i++ )
			{
				const SwFrmFmt* pFmt = (*pFlys)[ i ];
				const SwFmtAnchor& rAnchor = pFmt->GetAnchor();
				switch( rAnchor.GetAnchorId() )
				{
					case FLY_AT_CNTNT:
					case FLY_AUTO_CNTNT:
					case FLY_IN_CNTNT:
						break;	// nicht die, die am Node kleben
					case FLY_AT_FLY:
						// Rahmengebunde Rahmen werden als seitengebunde
						// Rahmen ins 3.1/4.0-Format exportiert. Sonst
						// werden sie in der Section exportiert.
						if( SOFFICE_FILEFORMAT_40 < pStrm->GetVersion() )
							break;
					default:
						ASSERT( FLY_PAGE==rAnchor.GetAnchorId() ||
								FLY_AT_FLY==rAnchor.GetAnchorId(),
								"Rahmen ist nicht Seitengebunden" );
						if( !pFmt->IsDefault() )
						{
							BYTE cType = SWG_FLYFMT;
							if( RES_DRAWFRMFMT == pFmt->Which() )
								cType = SWG_SDRFMT;
							OutFormat( cType, *pFmt );
						}
				}
			}
			CloseRec( SWG_FLYFRAMES );
		}
	}
	else
	{
		// Selektion: Frames absammeln
		USHORT nArrLen = pDoc->GetSpzFrmFmts()->Count();
		if( nArrLen > 255 )
			nArrLen = 255;
		SwPosFlyFrms aFlys( (BYTE)nArrLen, 50 );
		pDoc->GetAllFlyFmts( aFlys, &rPaM, TRUE );
		nArrLen = aFlys.Count();
		if( nArrLen )
		{
			OpenRec( SWG_FLYFRAMES );
			for( USHORT i = 0; i < nArrLen; i++ )
			{
				const SwFrmFmt& rFmt = aFlys[ i ]->GetFmt();
				const SwFmtAnchor& rAnchor = rFmt.GetAnchor();
				switch( rAnchor.GetAnchorId() )
				{
					case FLY_AT_CNTNT:
					case FLY_IN_CNTNT:
					case FLY_AUTO_CNTNT:
						break;	// nicht die, die am Node kleben
					case FLY_AT_FLY:
						// Rahmengebunde Rahmen werden als seitengebunde
						// Rahmen ins 3.1/4.0-Format exportiert. Sonst
						// werden sie in der Section exportiert.
						if( SOFFICE_FILEFORMAT_40 < pStrm->GetVersion() )
							break;
					default:
						ASSERT( FLY_PAGE==rAnchor.GetAnchorId() ||
								FLY_AT_FLY==rAnchor.GetAnchorId(),
								"Rahmen ist nicht Seitengebunden" );
						if( !rFmt.IsDefault() )
						{
							BYTE cType = SWG_FLYFMT;
							if( RES_DRAWFRMFMT == rFmt.Which() )
								cType = SWG_SDRFMT;
							OutFormat( cType, rFmt );
						}
				}
			}
			CloseRec( SWG_FLYFRAMES );
		}
	}
}

// in FLYPOS.CXX

extern BOOL TstFlyRange( const SwPaM* pPam, const SwIndex& rFlyPos );

void Sw3IoImp::CollectFlyFrms( const SwPaM* pPaM )
{
	if( !pFlyFrms )
	{
		pFlyFrms = new SwPosFlyFrms;
		SwPosFlyFrm *pFPos = 0;
		const SwPosition* pAPos;

		// alle absatzgebundenen Flys einsammeln
		for( USHORT n = 0; n < pDoc->GetSpzFrmFmts()->Count(); ++n )
		{
			SwFrmFmt *pFly = (*pDoc->GetSpzFrmFmts())[ n ];
			if( RES_DRAWFRMFMT == pFly->Which() ||
				RES_FLYFRMFMT  == pFly->Which() )
			{
				const SwFmtAnchor& rAnchor = pFly->GetAnchor();
				if( ( FLY_AT_CNTNT == rAnchor.GetAnchorId() ||
					  FLY_AT_FLY == rAnchor.GetAnchorId() ||
					  FLY_AUTO_CNTNT == rAnchor.GetAnchorId() ) &&
					NULL != ( pAPos = rAnchor.GetCntntAnchor()) )
				{
					pFPos = new SwPosFlyFrm( pAPos->nNode, pFly,
												pFlyFrms->Count() );
					pFlyFrms->Insert( pFPos );
				}
			}
		}
		if( !pFlyFrms->Count() )
			delete pFlyFrms, pFlyFrms = NULL;
	}
}

// Freigabe der gesammelten FlyFrame-Infos nach dem Schreiben

void Sw3IoImp::FreeFlyFrms()
{
	if( pFlyFrms )
	{
		for( USHORT i = 0; i < pFlyFrms->Count(); i++ )
			delete (*pFlyFrms)[ i ];
		delete pFlyFrms;
		pFlyFrms = NULL;
	}
}

// Suchen eines absatzgebundenen Flys. Wenn gefunden, wird der Fly
// zurueckgeliefert und das Element aus dem Array entfernt.

SwFmt* Sw3IoImp::FindFlyFrm( ULONG nNodeId )
{
	SwFmt* pFmt = NULL;
	if( pFlyFrms )
	{
		for( USHORT i = 0; i < pFlyFrms->Count(); i++ )
		{
			ULONG nId = (*pFlyFrms)[ i ]->GetNdIndex().GetIndex();
			if( nNodeId == nId )
			{
				pFmt = (SwFmt*) &(*pFlyFrms)[ i ]->GetFmt();
				pFlyFrms->DeleteAndDestroy( i );
				break;
			}
			if( nId > nNodeId )
				break;
		}
	}
	return pFmt;
}

////////////////////////////////////////////////////////////////////////////

void Sw3IoImp::ScanAttr( SvStrings& rSecList,
						 SvStringsDtor& rBookmarks )
{
	UINT16 nWhich, nVer, nDummy16;

	OpenRec( SWG_ATTRIBUTE );

	BYTE cFlags = OpenFlagRec();
	*pStrm >> nWhich >> nVer;
	nWhich = lcl_sw3io__CompressWhich( nWhich, nVersion );
	if( cFlags & 0x10 )
		*pStrm >> nDummy16;
	if( cFlags & 0x20 )
		*pStrm >> nDummy16;
	CloseFlagRec();

	switch( nWhich )
	{
	case RES_TXTATR_FLYCNT:
		// ein zeichengebundener Rahmen
		ScanFormat( SWG_FLYFMT, rSecList, rBookmarks );
		break;
	case RES_TXTATR_FTN:
		{
			// eine Fussnote
			String aDummy;
			*pStrm >> nDummy16;
			InString( *pStrm, aDummy );
			ScanContents( rSecList, rBookmarks );
		}
		break;
	case RES_HEADER:
	case RES_FOOTER:
		{
			// eine Kopf- oder Fusszeile
			BYTE nDummy8;
			*pStrm >> nDummy8;
			if( SWG_FREEFMT==Peek() )
				ScanFormat( SWG_FREEFMT, rSecList, rBookmarks );
		}
		break;
	case RES_CNTNT:
		// der Inhalt eines Fly-Frames
		ScanContents( rSecList, rBookmarks );
		break;
	default:
		// hier gibt's erstmal eine Warnung
		break;
	}

	CloseRec( SWG_ATTRIBUTE );
}

/*  */


