/*************************************************************************
 *
 *  $RCSfile: _xfont.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: aw $ $Date: 2001/02/19 13:40:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include <vcl/poly.hxx>
#include <vcl/metric.hxx>
#include <vcl/virdev.hxx>
#include <math.h>
#include "xpoly.hxx"
#include "xattr.hxx"
#include "xoutx.hxx"

#define GLOBALOVERFLOW


/*************************************************************************
|*
|*	  XOutGetCharOutline()
|*
|*	  Ein Zeichen eines Outlinefonts in ein Bezier-PolyPolygon umwandeln
|*	  Wenn keine Umwandlung moeglich ist, wird ein leeres PolyPolygon
|*	  zurueckgegeben
|*	  Ersterstellung	12.01.95 ESO
|*	  Letzte Aenderung	09.05.95 ESO
|*
*************************************************************************/

XPolyPolygon XOutGetCharOutline( USHORT nChar, OutputDevice& rOut, BOOL bOptimizeSize )
{
	PolyPolygon aPolyPoly;

	if( !rOut.GetGlyphOutline( (xub_Unicode) nChar, aPolyPoly, bOptimizeSize ) &&
		rOut.GetOutDevType() == OUTDEV_PRINTER )
	{
		VirtualDevice aVDev;
		aVDev.SetMapMode( rOut.GetMapMode() );
		aVDev.SetFont( rOut.GetFont() );
		aVDev.SetTextAlign( rOut.GetTextAlign() );
		aVDev.GetGlyphOutline( (xub_Unicode) nChar, aPolyPoly, FALSE );
	}

	return XPolyPolygon( aPolyPoly );
}


/*************************************************************************
|*
|*	  XOutputDevice::DrawFormText(String, Polygon, Font, nAbsStart)
|*
|*	  Einen String entlang eines Polygons ausgeben; nAbsStart
|*	  ueberschreibt den XFormTextStartItem-Wert und wird fuer die
|*	  Ausgabe mehrerer Strings entlang des gleichen Polygons benoetigt.
|*	  Rueckgabewert ist die Endposition des ausgegebenen Textes in
|*	  Bezug auf den Linienanfang.
|*
|*	  nAbsStart <  0: Die Gesamtlaenge aller Strings, notwendig fuer
|*					  alle Formatierungen ausser Linksbuendig
|*				<= 0: Item-Startwert verwenden
|*				>  0: Text an dieser absoluten Position ausgeben; ist
|*					  normalerweise der Rueckgabewert eines vorigen
|*					  DrawFormText-Aufrufs
|*
|*	  bToLastPoint: alle Linien einschliesslich der letzten Zeichnen,
|*					sonst die letzte Linie auslassen
|*
|*	  bDraw: wenn FALSE, wird nichts ausgegeben, sondern nur das BoundRect
|*			 berechnet
|*
|*	  pDXArray: wenn vorhanden, enthaelt dieses Array die horizontalen
|*				Positionen der einzelnen Zeichen, beginnend beim ersten
|*				und endend hinter dem letzten Zeichen; es mu also
|*				rText.Len()-1 long-Werte enthalten
|*
|*
|*	  Ersterstellung	02.02.95 ESO
|*	  Letzte Aenderung	11.10.95 ESO
|*
*************************************************************************/

long XOutputDevice::ImpDrawFormText(const XubString& rText, const Polygon& rPoly,
									Font aFont, long nAbsStart, BOOL bIsShadow,
									BOOL bToLastPoint, BOOL bDraw,
									const long* pDXArray)
{
	long	nXMin = LONG_MAX, nYMin = LONG_MAX;
	long	nXMax = LONG_MIN, nYMax = LONG_MIN;
	long	nMaxCharExtent;
	long	nPolyLen = 0;
	long	nTextLen = 0;
	long	nTotal = 0;
	long	nTextWidth;
	long	nStart;
	long	nShadowX;
	USHORT	nPntCnt = rPoly.GetSize();
	USHORT	nLastPnt;
	USHORT	nPnt;
	xub_StrLen nChar = 0;
	xub_StrLen nCharCnt = rText.Len();
	short	nDirection;

	if ( nPntCnt < 2 || !nCharCnt)
		return 0;

	BOOL bIsSlantShadow = ( bIsShadow && eFormTextShadow == XFTSHADOW_SLANT );
	BOOL bDrawAsPoly = ( bFormTextOutline || bIsSlantShadow );

	if ( nAbsStart > 0 )	nStart = nAbsStart;
	else					nStart = nFormTextStart;

	aFont.SetTransparent(TRUE);

	// Attribute sichern
	XLineStyle eOldLineStyle = eLineStyle;
	XFillStyle eOldFillStyle = eFillStyle;

	Color aOldLineColor( pOut->GetLineColor() );

	pOut->SetFillColor( aFont.GetColor() );

	if ( !(bFormTextOutline && bHair) || bIsShadow )
		pOut->SetLineColor();

	if ( !bFormTextOutline || bIsShadow )
		eLineStyle = XLINE_NONE;

	eFillStyle = XFILL_SOLID;

	if ( eFormTextAdjust == XFT_AUTOSIZE && nAbsStart > 0 )
		aFont.SetSize(Size(0, nFtAutoHeightSave));

	Font aOldFont = pOut->GetFont();
	pOut->SetFont(aFont);
	long nAscent = pOut->GetFontMetric().GetAscent();

	// #78478# outline text in FontWork
	if(bFormTextOutline)
	{
		eLineStyle = XLINE_SOLID;
		pOut->SetLineColor(aLineColor);
	}

	if ( eFormTextAdjust == XFT_AUTOSIZE )
	{
		// bei Autosize den Arrayinhalt immer ignorieren
		pDXArray = NULL;
	}

	if(aFont.IsVertical())
	{
		xub_StrLen nTxtLen = rText.Len();
		nTextWidth = pOut->GetTextHeight() * (sal_Int32)nTxtLen;
	}
	else
	{
		nTextWidth = pOut->GetTextArray(rText, (long*) pDXArray);
	}

	if ( eFormTextAdjust != XFT_LEFT && nAbsStart <= 0 )
	{
		// Gesamtlaenge des Polygons berechnen
		USHORT nMax = nPntCnt;
		nPnt = 1;

		if ( !bToLastPoint )
			nMax--;

		for ( ; nPnt < nMax; nPnt++)
		{
			double	fDx = rPoly[nPnt].X() - rPoly[nPnt-1].X();
			double	fDy = rPoly[nPnt].Y() - rPoly[nPnt-1].Y();
			nPolyLen += (long) (sqrt(fDx * fDx + fDy * fDy) + 0.5);
		}

		if ( nAbsStart == 0 )
			nAbsStart = - nTextWidth;

		if ( eFormTextAdjust == XFT_AUTOSIZE )
		{
			nFtAutoHeightSave = aFont.GetSize().Height();
			nFtAutoHeightSave = - (nPolyLen * nFtAutoHeightSave / nAbsStart);
			aFont.SetSize(Size(0, nFtAutoHeightSave));
			pOut->SetFont(aFont);
			nFtAutoHeightSave = aFont.GetSize().Height();
			nTextWidth = pOut->GetTextWidth(rText);
			nAscent = pOut->GetFontMetric().GetAscent();
			nAbsStart = - nPolyLen;
		}
		// Bei rechtsbuendiger Ausgabe auch Startposition beruecksichtigen
		if ( eFormTextAdjust == XFT_RIGHT )
			nAbsStart -= nStart;
		nStart = nPolyLen + nAbsStart;

		if ( eFormTextAdjust != XFT_RIGHT )
			nStart /= 2;
	}
	if ( nStart < 0 )
		nStart = 0;

	if ( bIsShadow && eFormTextShadow != XFTSHADOW_SLANT )
		nShadowX = nFormTextShdwXVal;
	else
		nShadowX = 0;

	nTotal = nStart + nTextWidth;

	if ( bIsShadow && eFormTextShadow == XFTSHADOW_SLANT &&
		 nFormTextShdwYVal && nFormTextShdwYVal != 100 )
		nAscent = nAscent * nFormTextShdwYVal / 100;

	// Maximaler Zeichenbereich ca. 1,4 (sqrt(2)) * Ascent fuer BoundRect
	nMaxCharExtent = nAscent * 7 / 5;

	// Laufrichtung des Polygons ggf. spiegeln
	if ( bFormTextMirror )
	{
		nDirection = -1;
		nLastPnt = (USHORT) -1;
		nPnt = nPntCnt - 2;
		if ( !bToLastPoint )
			nPnt--;
	}
	else
	{
		nDirection = 1;
		nLastPnt = nPntCnt - 1;
		nPnt = 1;
		if ( bToLastPoint )
			nLastPnt++;
	}

	while ( nChar < nCharCnt && nPnt != nLastPnt )
	{
		Point	aPos = rPoly[nPnt];
		double	fDx, fDy, fLen;
		long	nLen, nChar1Len;

		fDx = aPos.X() - rPoly[nPnt-nDirection].X();
		fDy = aPos.Y() - rPoly[nPnt-nDirection].Y();
		fLen = sqrt(fDx * fDx + fDy * fDy);
		nLen = (long) (fLen + 0.5);

		if(aFont.IsVertical())
		{
			nChar1Len = pOut->GetTextHeight();
		}
		else
		{
			nChar1Len = pOut->GetTextArray(rText, (long*) pDXArray, nChar, 1);
		}

		double fXDist, fYDist;
		double fCos = fDx;
		double fSin = fDy;
		double fPartLen = fLen;
		double fLenSum = fLen - nTextLen;
		USHORT nSumPnt = nPnt + nDirection;

		// Laenge halbieren, um Zeichenmitte als Referenzpunkt zu verwenden
		nChar1Len /= 2;

		while ( nSumPnt != nLastPnt && fLenSum < nChar1Len )
		{
			fCos = rPoly[nSumPnt].X() - rPoly[nSumPnt-nDirection].X();
			fSin = rPoly[nSumPnt].Y() - rPoly[nSumPnt-nDirection].Y();
			fPartLen = sqrt(fSin * fSin + fCos * fCos);
			fLenSum += fPartLen;
			nSumPnt += nDirection;
		}
		fSin /= - fPartLen;
		fCos /=   fPartLen;

		fXDist = fSin * nFormTextDistance;
		fYDist = fCos * nFormTextDistance;

		if ( nStart > 0 )
			nStart -= nLen;
		else
		{
			nLen -= nTextLen;
			nTextLen = - nLen;
		}

		if ( nLen > 0 && nStart <= 0 )
		{
			xub_StrLen nCnt = 0;

			if ( nStart < 0 )
			{
				nLen = - nStart;
				nStart = 0;
			}
			do
			{
				if(aFont.IsVertical())
				{
					nTextLen = pOut->GetTextHeight() * (nCnt+1);
				}
				else
				{
					nTextLen = pOut->GetTextArray(rText, (long*) pDXArray, nChar, nCnt+1);
				}

				nCnt++;
			}
			while ( nChar + nCnt < nCharCnt && nTextLen < nLen );

			aPos.X() -= (long) (fDx * (nLen - nShadowX) / fLen + fXDist);
			aPos.Y() -= (long) (fDy * (nLen - nShadowX) / fLen + fYDist);
//			aPos.X() -= (long) ((fDx * nLen - fDy * nFormTextDistance) / fLen);
//			aPos.Y() -= (long) ((fDy * nLen + fDx * nFormTextDistance) / fLen);

			// BoundRect-Approximation
			nXMin = Min(nXMin, aPos.X() - nMaxCharExtent);
			nYMin = Min(nYMin, aPos.Y() - nMaxCharExtent);
			nXMax = Max(nXMax, aPos.X() + nMaxCharExtent);
			nYMax = Max(nYMax, aPos.Y() + nMaxCharExtent);

			if ( eFormTextStyle == XFT_ROTATE )
			{
				if ( bDrawAsPoly )
				{
					for (xub_StrLen i = 0; i < nCnt; i++)
					{
						XPolyPolygon aChar = XOutGetCharOutline(
									rText.GetChar(nChar+i), *pOut);
						Point aPolyPos = aPos;

						if ( i > 0 )
						{
							long nW;

							if(aFont.IsVertical())
							{
								nW = pOut->GetTextHeight() * i;
							}
							else
							{
								nW = pOut->GetTextArray(rText, (long*) pDXArray, nChar, i);
							}

							aPolyPos.X() += (long) (fDx * nW / fLen);
							aPolyPos.Y() += (long) (fDy * nW / fLen);
						}
						Point aCenter = aPolyPos;

						if ( bIsSlantShadow )
						{
							if ( nFormTextShdwYVal && nFormTextShdwYVal != 100 )
								aChar.Scale(1.0, (double)nFormTextShdwYVal/100);

							aChar.SlantX(nAscent,
										 sin(- F_PI * nFormTextShdwXVal / 1800),
										 cos(- F_PI * nFormTextShdwXVal / 1800));
						}
						aPolyPos.Y() -= nAscent;
						aChar.Translate(aPolyPos);
						aChar.Rotate(aCenter, fSin, fCos);
						if ( bDraw )
							DrawXPolyPolygon(aChar);
					}
				}
				else
				{
					// #83801# vertical writing for contour
					if(aFont.IsVertical())
					{
						short nAngle = (short) (acos(fCos) * 1800 / F_PI + 0.5);
						if(fSin < 0)
							nAngle = 3600 - nAngle;
						nAngle += 2700;
						aFont.SetOrientation(nAngle);
						pOut->SetFont(aFont);
						if(bDraw)
							pOut->DrawTextArray(aPos, rText, pDXArray, nChar, nCnt);
					}
					else
					{
						short nAngle = (short) (acos(fCos) * 1800 / F_PI + 0.5);
						if(fSin < 0)
							nAngle = 3600 - nAngle;
						aFont.SetOrientation(nAngle);
						pOut->SetFont(aFont);
						if(bDraw)
							pOut->DrawTextArray(aPos, rText, pDXArray, nChar, nCnt);
					}
				}
			}
			else
			{
				bDrawAsPoly = ( bDrawAsPoly || eFormTextStyle != XFT_UPRIGHT);

				for (xub_StrLen i = 0; i < nCnt; i++)
				{
					XPolyPolygon aChar(0);
					Point aPolyPos = aPos;

					if ( i > 0 )
					{
						long nW;

						if(aFont.IsVertical())
						{
							nW = pOut->GetTextHeight() * i;
						}
						else
						{
							nW = pOut->GetTextArray(rText, (long*) pDXArray, nChar, i);
						}

						aPolyPos.X() += (long) (fDx * nW / fLen);
						aPolyPos.Y() += (long) (fDy * nW / fLen);
					}
					if ( bDrawAsPoly )
					{
						aChar = XOutGetCharOutline(
										rText.GetChar(nChar+i), *pOut);

						if ( bIsSlantShadow )
						{
							if ( nFormTextShdwYVal && nFormTextShdwYVal != 100 )
								aChar.Scale(1.0, (double)nFormTextShdwYVal/100);

							aChar.SlantX(nAscent,
										 sin(- F_PI * nFormTextShdwXVal / 1800),
										 cos(- F_PI * nFormTextShdwXVal / 1800));
						}
					}

					if ( eFormTextStyle == XFT_SLANTY )
					{
						aPolyPos.Y() -= nAscent;
						aChar.SlantY(0, fSin, fCos);
					}
					else
					{
						long nW;

						if(aFont.IsVertical())
						{
							nW = pOut->GetTextHeight();
						}
						else
						{
							nW = pOut->GetTextArray(rText, (long*) pDXArray, nChar+i, 1);
						}

						aPolyPos.X() -= nW / 2;

						if ( eFormTextStyle == XFT_SLANTX )
						{
							aPolyPos.X() += (long) (fDy * nAscent / fLen);
							aPolyPos.Y() -= (long) (fDx * nAscent / fLen);
							aChar.SlantX(0, fSin, fCos);
						}
						else if ( bDrawAsPoly )
							aPolyPos.Y() -= nAscent;
					}
					aChar.Translate(aPolyPos);

					if ( bDraw )
					{
						if ( bDrawAsPoly )
							DrawXPolyPolygon(aChar);
						else
							pOut->DrawTextArray(aPolyPos, rText, pDXArray,
												nChar+i, 1);
//							pOut->DrawText(aPolyPos, rText, nChar+i, 1);
					}
				}
			}
			nChar += nCnt;
			nTextLen -= nLen;
		}
		nPnt += nDirection;
	}
	// auch letzten Punkt fuer BoundRect-Approximation beruecksichtigen
	Point aPos = rPoly[nPnt - nDirection];
	nXMin = Min(nXMin, aPos.X() - nMaxCharExtent);
	nYMin = Min(nYMin, aPos.Y() - nMaxCharExtent);
	nXMax = Max(nXMax, aPos.X() + nMaxCharExtent);
	nYMax = Max(nYMax, aPos.Y() + nMaxCharExtent);

	aFormTextBoundRect.Union(Rectangle(nXMin, nYMin, nXMax, nYMax));

	pOut->SetFont(aOldFont);
	pOut->SetLineColor( aOldLineColor );
	eLineStyle = eOldLineStyle;
	eFillStyle = eOldFillStyle;

	return nTotal;
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawFormTextShadow(String, Polygon, Font, nAbsStart)
|*
|*	  Schatten fuer FormText ausgeben
|*
|*	  Ersterstellung	28.06.95 ESO
|*	  Letzte Aenderung	11.10.95 ESO
|*
*************************************************************************/

void XOutputDevice::DrawFormTextShadow(const XubString& rText,
									   const Polygon& rPoly,
									   const Font& rFont, long nAbsStart,
									   BOOL bToLastPoint, BOOL bDraw,
									   const long* pDXArray)
{
	if ( eFormTextShadow != XFTSHADOW_NONE )
	{
		BOOL bOutline = bFormTextOutline;

		if ( eFormTextShadow != XFTSHADOW_SLANT )
			nFormTextDistance += nFormTextShdwYVal;

		Font aShadowFont(rFont);
		aShadowFont.SetColor(aFormTextShdwColor);

		ImpDrawFormText(rText, rPoly, aShadowFont, nAbsStart, TRUE,
						bToLastPoint, bDraw, pDXArray);

		if ( eFormTextShadow != XFTSHADOW_SLANT )
			nFormTextDistance -= nFormTextShdwYVal;
		bFormTextOutline = bOutline;
	}
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawFormText(String, Polygon, Font, nAbsStart)
|*
|*	  Einen String entlang eines Polygons ausgeben
|*
|*	  Ersterstellung	28.06.95 ESO
|*	  Letzte Aenderung	11.10.95 ESO
|*
*************************************************************************/

long XOutputDevice::DrawFormText(const XubString& rText, const Polygon& rPoly,
								 Font aFont, long nAbsStart,
								 BOOL bToLastPoint, BOOL bDraw,
								 const long* pDXArray)
{
	// Beim erstn Aufruf BoundRect leeren
	if ( nAbsStart <= 0 )
		aFormTextBoundRect = Rectangle();

	DrawFormTextShadow(rText, rPoly, aFont, nAbsStart, bToLastPoint, bDraw,
						pDXArray);
	return ImpDrawFormText(rText, rPoly, aFont, nAbsStart, FALSE,
						   bToLastPoint, bDraw, pDXArray);
}

/*************************************************************************
|*
|*	  XOutputDevice::DrawFormText(String, XPolygon, Font, nAbsStart)
|*
|*	  Einen String entlang eines Bezier-Polygons ausgeben
|*
|*	  Ersterstellung	03.02.95 ESO
|*	  Letzte Aenderung	11.10.95 ESO
|*
*************************************************************************/

long XOutputDevice::DrawFormText(const XubString& rText, const XPolygon& rXPoly,
								 Font aFont, long nAbsStart,
								 BOOL bToLastPoint, BOOL bDraw,
								 const long* pDXArray)
{
	// Beim ersten Aufruf BoundRect leeren
	if ( nAbsStart <= 0 )
		aFormTextBoundRect = Rectangle();

	Polygon aPoly = XOutCreatePolygon(rXPoly, pOut);

	DrawFormTextShadow(rText, aPoly, aFont, nAbsStart, bToLastPoint, bDraw,
						pDXArray);
	return ImpDrawFormText(rText, aPoly, aFont, nAbsStart, FALSE,
						   bToLastPoint, bDraw, pDXArray);
}
